#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>
//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------
static void _in_ep(WSCbase* object);
static void _out_ep(WSCbase* object);

void hlight(WSCbase* object){
  //do something...
  //MOUSE-IN トリガで起動されるイベントプロシージャをオブジェクトに
  //張り付けます。
  WSCprocedure* ep0 = new WSCprocedure("ハイライトON",WSEV_MOUSE_IN);
  ep0->setFunction(_in_ep,"_in_ep");
  object->addProcedure(ep0);

  //MOUSE-OUT トリガで起動されるイベントプロシージャをオブジェクトに
  //張り付けます。
  WSCprocedure* ep1 = new WSCprocedure("ハイライトOFF",WSEV_MOUSE_OUT);
  ep1->setFunction(_out_ep,"_out_ep");
  object->addProcedure(ep1);

}

void _in_ep(WSCbase* object){
  //オリジナルの背景色を取得します。
  WSCvariant col = object->getProperty(WSNbackColor);
  //取得した色をプロパティWSNuserString に覚えておきます。
  object->setProperty(WSNuserString,col);
  //背景色をハイライト色に設定します。
  object->setProperty(WSNbackColor,"gray90");
}
void _out_ep(WSCbase* object){
  //覚えておいたオリジナルの背景色を取得します。
  WSCvariant col = object->getProperty(WSNuserString);
  //背景色を元にもどします。
  object->setProperty(WSNbackColor,col);
}

static WSCfunctionRegister  op("hlight",(void*)hlight);
