//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCworkingDialog.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSCdevice.h>
#include <WSCform.h>
#include <WSCvbtn.h>
#include <WSDappDev.h>
#include <WSCvmeter.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCworkingDialog,WSCbaseDialog);
WSMFversion(WSCworkingDialog,WSCbaseDialog);

#define D_BTN_WIDTH 80
WSMFpropertyValueChange(WSCworkingDialog,WSNno,WSCbool,False);
WSMFpropertyValueChange(WSCworkingDialog,WSNok,WSCbool,False);

WSCworkingDialog::WSCworkingDialog(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){

  _label_string = WSGFstrdup("Working...");
  _meter = NULL;
  _form = NULL;
  _title = NULL;
  _value_label = NULL;
  _area1 = NULL;
  _wbg_no = WS_DF_DARKBACKCOLOR;
  _lw = 2;
  _lt = 0;
  _stippled = True;
  _hatch_pattern = 0;
  _hatch_color = WS_DF_NWFORECOLOR;
  _value = 0;
  _no = False;
  _ok = False;
  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCworkingDialog);
    WSMFpropertyCreate(WSNvalue,   WSCushort, _value,WSSvalue);
    WSMFpropertyCreate(WSNlabelString,   char*, _label_string,WSSlabelString);
    WSMFpropertyCreate(WSNworkBackColor,  short, _wbg_no,WSSworkBackColor );
    WSMFpropertyCreate(WSNlineWidth, WSCushort, _lw,WSSlineWidth);
    WSMFpropertyCreate(WSNlineType,  WSCuchar, _lt,WSSlineType);
      WSMFpropertySetSelection(WSRlineType, WSRlineTypeD);
    WSMFpropertyCreate(WSNstippled,WSCbool,_stippled,WSSstippled );
      WSMFpropertySetSelection(WSRbool4, WSRbool4D);
    WSMFpropertyCreate(WSNhatchPattern,WSCuchar,_hatch_pattern,WSShatchPattern);
      WSMFpropertySetSelection(WSRhatchPattern, WSRhatchPatternD);
    WSMFpropertyCreate(WSNhatchColor,short,_hatch_color,WSShatchColor);

    WSMFpropertyValueChangeDef(WSCworkingDialog,WSNno,WSCbool);
    WSMFpropertyValueChangeDef(WSCworkingDialog,WSNok,WSCbool);
    WSMFpropertyDelete(WSNshadowThickness);

  WSMFpropertyCreateEnd
}

WSCworkingDialog::~WSCworkingDialog(){
  if (_label_string != NULL){
    delete _label_string;
    _label_string = NULL;
  }
}
WSMFproperty(WSCworkingDialog, WSNlineWidth, WSCushort, _lw, 2);
WSMFproperty(WSCworkingDialog, WSNlineType,  WSCuchar,      _lt, 0);
WSMFproperty(WSCworkingDialog, WSNstippled,  WSCbool,_stippled,     True);
WSMFproperty(WSCworkingDialog, WSNhatchPattern, WSCuchar,   _hatch_pattern,0    );
WSMFproperty(WSCworkingDialog, WSNhatchColor,  short,  _hatch_color,WS_DF_NWFORECOLOR);

WSMFproperty( WSCworkingDialog, WSNvalue,WSCushort, _value,0);
WSMFproperty( WSCworkingDialog, WSNlabelString, char*, _label_string,WSGFstrdup("Working...") );
WSMFproperty( WSCworkingDialog, WSNworkBackColor,short, _wbg_no ,WS_DF_DARKBACKCOLOR);

void WSCworkingDialog::setWorkWSNlineWidth(WSCushort lw){
  if (_meter != NULL){
    _meter->setProperty(WSNlineWidth,lw);
  }
}
void WSCworkingDialog::getWorkWSNlineWidth(WSCushort*){ }

void WSCworkingDialog::setWorkWSNlineType(WSCuchar lt){
  if (_meter != NULL){
    _meter->setProperty(WSNlineType,lt);
  }
}
void WSCworkingDialog::getWorkWSNlineType(WSCuchar*){ }

void WSCworkingDialog::setWorkWSNstippled(WSCbool fl){
  if (_meter != NULL){
    _meter->setProperty(WSNstippled,fl);
  }
}
void WSCworkingDialog::getWorkWSNstippled(WSCbool*){ }

void WSCworkingDialog::setWorkWSNhatchPattern(WSCuchar fl){
  if (_meter != NULL){
    _meter->setProperty(WSNhatchPattern,fl);
  }
}
void WSCworkingDialog::getWorkWSNhatchPattern(WSCuchar*){ }

void WSCworkingDialog::setWorkWSNhatchColor(short fl){
  if (_meter != NULL){
    _meter->setProperty(WSNhatchColor,fl);
  }
}
void WSCworkingDialog::getWorkWSNhatchColor(short*){ }


void WSCworkingDialog::setWorkWSNvalue(WSCushort val){
  if (_meter != NULL){
    _meter->setProperty(WSNvalue1,val);
    WSCstring tmp;
    tmp << WSGFltoa(val) << "%";
    _value_label->setProperty(WSNlabelString,tmp);
  }
}
void WSCworkingDialog::getWorkWSNvalue(WSCushort* val){
}
void WSCworkingDialog::setWorkWSNlabelString(char* str){
  if (_title != NULL){
    _title->setPropertyV(WSNlabelString,str);
  }
}

void WSCworkingDialog::getWorkWSNlabelString(char**){ }

void WSCworkingDialog::setWorkWSNforeColor(short no){
  if (_title != NULL){
    _title->setProperty(WSNforeColor,no);
  }
  if (_value_label != NULL){
    _value_label->setProperty(WSNforeColor,no);
  }
  if (_meter != NULL){
    _meter->setProperty(WSNforeColor,no);
  }
  if (_value_label != NULL){
    _value_label->setProperty(WSNforeColor,no);
  }
  WSCbaseDialog::setWorkWSNforeColor(no);
}
void WSCworkingDialog::setWorkWSNworkBackColor(short no){
  if (_area1 != NULL){
    _area1->setProperty(WSNbackColor,no);
  }
}
void WSCworkingDialog::getWorkWSNworkBackColor(short* ){}

long WSCworkingDialog::initialize(){
  WSCbaseDialog::initialize();

  _area1 = new WSCform(this,"md-label");
  _area1->setInternalObject(True);
  _area1->initialize();
//  _area1->setPropertyV(WSNx,     (short)5 );
  _area1->setPropertyV(WSNx,     (short)0 );
  _area1->setPropertyV(WSNy,     (short)5 );
//  _area1->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//  _area1->setPropertyV(WSNbackColor,WSGFcolor("gray80"));
  _area1->setProperty(WSNbackColor,_wbg_no);
//  _area1->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
  _area1->setVisible(True);

  _form = new WSCform(_area1,"md-if");
  _form->setInternalObject(True);
  _form->initialize();
  _form->setPropertyV(WSNx,     (short)10 );
  _form->setPropertyV(WSNy,     (short)30 );
  _form->setPropertyV(WSNheight,(WSCushort)(20));
  _form->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _form->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  _form->setVisible(True);

  _meter = new WSCvmeter(_form,"wd-meter");
  _meter->setInternalObject(True);
  _meter->initialize();
  _meter->setProperty(WSNx,     (short)1 );
  _meter->setProperty(WSNy,     (short)1 );
  _meter->setProperty(WSNheight,(WSCushort)(18));
  _meter->setProperty(WSNwidth,(WSCushort)(0));
  _meter->setProperty(WSNvalue1,(WSCushort)(0));
  _meter->setProperty(WSNvalue2,(WSCushort)(0));
  _meter->setProperty(WSNorientation,WS_HORIZONTAL);
  _meter->setProperty(WSNhatchColor, _hatch_color);
  _meter->setProperty(WSNstippled,True);
  _meter->setVisible(True);

 
  _title = new WSCvlabel(_area1,"md-if");
  _title->setInternalObject(True);
  _title->initialize();
  _title->setProperty(WSNx,     (short)10 );
  _title->setProperty(WSNy,     (short)1 );
  _title->setProperty(WSNheight,(WSCushort)(30));
  _title->setProperty(WSNshadowThickness,(WSCuchar)0);
  _title->setProperty(WSNshadowType,(WSCuchar)WS_SHADOW_TRANS);
  _title->setProperty(WSNlabelString,_label_string );
  _title->setProperty(WSNalignmentH,WS_LEFT);
  _title->setVisible(True);
 
  _value_label = new WSCvlabel(_area1,"md-if");
  _value_label->setInternalObject(True);
  _value_label->initialize();
  _value_label->setProperty(WSNx,     (short)10 );
  _value_label->setProperty(WSNy,     (short)1 );
  _value_label->setProperty(WSNheight,(WSCushort)(30));
  _value_label->setProperty(WSNshadowThickness,(WSCuchar)0);
  _value_label->setProperty(WSNshadowType,(WSCuchar)WS_SHADOW_TRANS);
  _value_label->setProperty(WSNlabelString,"0%");
  _value_label->setVisible(True);
 

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
 
  return WS_NO_ERR;
}
void WSCworkingDialog::onVisibleChange(WSCbool fl){
  WSCbaseDialog::onVisibleChange(fl);
  if (fl != False){
    _status = WS_DIALOG_OK;
  }
}

void WSCworkingDialog::adjustForm(){
  WSCbaseDialog::adjustForm();
  if(_area1 != NULL){
    long diff = 0;
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      diff = 0;
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      diff = 5;
    }
    if (_w > 2){
//      _area1->setPropertyV(WSNwidth, (WSCushort)(_w - 10));
      _area1->setPropertyV(WSNwidth, (WSCushort)(_w));
    }else{
//      _area1->setPropertyV(WSNwidth, (WSCushort)(1));
    }
    if (_h+diff > 45){
      _area1->setPropertyV(WSNheight,(WSCushort)(_h+diff - 45));
      _form->setPropertyV(WSNy,(short)((_h+diff - 45 -20)/2));
      _title->setPropertyV(WSNy,(short)((_h+diff - 45 -20)/2-30));
      _value_label->setPropertyV(WSNy,(short)((_h+diff - 45 -20)/2+20));
    }else{
      _area1->setPropertyV(WSNheight,(WSCushort)(1));
      _form->setPropertyV(WSNy,(short)1);
      _title->setPropertyV(WSNy,(short)1);
      _value_label->setPropertyV(WSNy,(short)1);
    }
    if (_w > 20){
      _form->setPropertyV(WSNwidth,(WSCushort)(_w - 22));
      _title->setPropertyV(WSNwidth,(WSCushort)(_w - 22));
      _value_label->setPropertyV(WSNwidth,(WSCushort)(_w - 22));
      _meter->setPropertyV(WSNwidth,(WSCushort)(_w - 24));
    }else{
      _form->setPropertyV(WSNwidth,(WSCushort)(1));
      _title->setPropertyV(WSNwidth,(WSCushort)(1));
      _value_label->setPropertyV(WSNwidth,(WSCushort)(1));
      _meter->setPropertyV(WSNwidth,(WSCushort)(1));
    }
  }  
}
void WSCworkingDialog::onActivate(){
  WSCbaseDialog::onActivate();
  if (getStatus() != WS_DIALOG_CANCEL){
    _popuped = 0;
    setVisible(False);
  }
}
long WSCworkingDialog::popup(){
  setVisible(True);

  if (getVisible() == False){
    return WS_ERR;
  }
  _popuped = 1;

  if (_ok != False){
    _ok_btn->setSpecialFocus(True);
  }else
  if (_no != False){
    _no_btn->setSpecialFocus(True);
  }else{
    _end_btn->setSpecialFocus(True);
  }

  while(1){
    if (_popuped == 0){
      break;
    }
    WSGIappDev()->dispatchEvent();
  }
  setVisible(False);
  return _status;
}
void WSCworkingDialog::onGuiPolicyChange(long policy){
  if (_area1 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      _area1->setProperty(WSNy,5);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else{
      _area1->setProperty(WSNy,0);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)0);
    }
    adjustForm();
  }
}
void WSCworkingDialog::update(){
  _form->update();
  _title->update();
  _value_label->update();
  _meter->update();
  WSCbaseDialog::update();
}
void WSCworkingDialog::setValue(WSCushort value){
  setProperty(WSNvalue,value);
  if (getVisible() != False){
    update();
    WSGIappDev()->update();
  }
}
char* WSCworkingDialog::getDefaultProperty(){
  return WSNvalue;
}
