//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvthread.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCvthread, WSCngbase);
WSMFversion(WSCvthread, WSCngbase);

WSCvthread::WSCvthread(WSCbase* base, char* objname):
			WSCngbase(base, objname){
  _thread = WSDthread::getNewInstance();

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvthread);

    WSMFaddTrigger(WSEV_ACTIVATE  );
    WSMFaddExtTrigger(WSEV_THREAD_STARTED,"THREAD-STARTED");

  WSMFpropertyCreateEnd

}

long WSCvthread::executeThread(){
  _thread->setCallbackFunction(_callback_proc);
  _thread->setFunction(_thread_proc);
  return _thread->createThread(this);
}

void WSCvthread::_callback_proc(WSDthread*,void* ptr){
  WSCvthread* _this = (WSCvthread*)ptr;
  _this->onActivate();
}
void* WSCvthread::_thread_proc(WSDthread*,void* ptr){
  WSCvthread* _this = (WSCvthread*)ptr;
  _this->onThreadStarted();
  return NULL;
}
void WSCvthread::onThreadStarted(){
  execProcedure(WSEV_THREAD_STARTED);
}
void WSCvthread::onActivate(){
  execProcedure(WSEV_ACTIVATE);
}
WSCvthread::~WSCvthread() {
  if (_thread != NULL){
    delete _thread;
    _thread = NULL;
  }
}
long WSCvthread::sendActivateEvent(){
  return _thread->execCallback(this);
}
