//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <win/WSDwinExternal.h>
#include <stdio.h>
#include <WSDappDev.h>

WSMFclassInit(WSDwinExternal,WSDexternal);

WSDexternal* _win_external_create(){
  return new WSDwinExternal;
}

class _win_external_init {
  public: _win_external_init(){
    WSDexternal::setCreateInstanceHandler((void*)_win_external_create);
  };
};

_win_external_init  _win_external_init_execute;

WSDwinExternal::WSDwinExternal(){
  _dlp = NULL;
}

WSDwinExternal::~WSDwinExternal(){
  if (_dlp != NULL){
    close();
  }
}

long WSDwinExternal::open(char* name){
  _ptr = NULL;
  WSDexternal::setTempData(NULL); 

  _dll_name.setString(name);
  _dlp = LoadLibrary(name);
  if (_dlp != NULL){
    _ptr = WSDexternal::getTempData();
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDwinExternal::close(){
  if (_dlp != NULL){
    FreeLibrary((HMODULE)_dlp);
    _dlp = NULL;
    _ptr = NULL;
  }
  return WS_NO_ERR;
}

WSCstring* WSDwinExternal::getObjectSymbols(){
//printf("WSDwinExternal::getObjectSymbols() WSGIappDev()=0x%x\n",WSGIappDev());
//printf("WSDwinExternal::getObjectSymbols() _ptr=0x%x\n",_ptr);
//fflush(stdout);
  if (_ptr != NULL){
    WSCstring* str = new WSCstring;
    char** sym = (char**) _ptr;
    long i=0;
    while(1){
//printf("WSDwinExternal::getObjectSymbols() i=%d\n",i);
//fflush(stdout);
      if (sym[i] == NULL){
        break;
      }
      str->addString(sym[i]);
      str->addString(" ");
      i++;
      str->addString(sym[i]);
      str->addString("\n");
      i++;
      str->addString(sym[i]);
      str->addString("\n");
      i++;
    }
    return str;
  }
  return NULL;
}
