//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <basic.h>
#include <unix/unistd.h>
//#include <pthread.h>
#include <btron/hmi.h>
#include <btron/proctask.h>
#include <btron/WSDbtronPrivateTimer.h>
#include <btron/WSDbtronAppDev.h>

WSMFclassInit(WSDbtronPrivateTimer,WSDprivateTimer);

WSDprivateTimer* _btronPrivatetimer_create(){
  return new WSDbtronPrivateTimer;
}

class _btronPrivatetimer_init {
  public: _btronPrivatetimer_init(){
    WSDprivateTimer::setCreateInstanceHandler((void*)_btronPrivatetimer_create);
  };
};

_btronPrivatetimer_init  _btronPrivatetimer_init_execute;

void WSDbtronPrivateTimer::_timer_process(W ptr){
  WSDbtronPrivateTimer* _this = (WSDbtronPrivateTimer*)ptr;
  while(1){

    long rate = _this->_timer_rate;
//printf("WSDbtronPrivateTimer::_timer_process before sleep!!!!!\n");
//dbprintf("WSDbtronPrivateTimer::_timer_process before sleep!!!!!\n");
//    slp_tsk(rate);
      wai_prc(rate);

//    wai_prc(rate);
//printf("WSDbtronPrivateTimer::_timer_process after sleep!!!!!\n");
//dbprintf("WSDbtronPrivateTimer::_timer_process after sleep!!!!!\n");

    W tid = get_tid();
    MESSAGE* msg;
    char buffer[128];
    msg = (MESSAGE*)buffer;
    msg->msg_type = MS_TYPE2;
    msg->msg_size = sizeof(W)*2;
    memcpy(msg->msg_body.ANYMSG.msg_str,&_this,sizeof(W));
    memcpy(&(msg->msg_body.ANYMSG.msg_str[4]),&tid,sizeof(W));
    W ret = snd_msg(0,msg,WAIT);

//printf("WSDbtronPrivateTimer::_timer_process send done!!!!!\n");
//printf("tid=%d interval_id=%d\n",tid,_this->_interval_id);
//dbprintf("WSDbtronPrivateTimer::_timer_process done!!!!!\n");
//printf("_cont=%d timer_on=%d\n",_this->_cont,_this->_timer_on);
    if (_this->_cont != False && _this->_timer_on != False){
      if (tid != _this->_interval_id){
        ext_tsk();
      }
    }else{
      ext_tsk();
    }

  }
  return;
}
WSClistData WSDbtronPrivateTimer::_instance_list;
WSDbtronPrivateTimer::WSDbtronPrivateTimer(){
  _interval_id =0;
  _instance_list.add((void*)this);
}
WSDbtronPrivateTimer::~WSDbtronPrivateTimer(){
  stopTimer();
  _instance_list.del((void*)this);
}
WSCbool WSDbtronPrivateTimer::isValid(WSDbtronPrivateTimer* inst){
  long i;
  long num = _instance_list.getNum();
  for(i=0; i<num; i++){
    WSDbtronPrivateTimer* item =(WSDbtronPrivateTimer*)_instance_list[i];
    if (item == inst){
      return True;
    }
  }
  return False;
}
void WSDbtronPrivateTimer::startTimer(){
  _timer_on = True;
  _timer_set();
}

void WSDbtronPrivateTimer::stopTimer(){
  _timer_on = False;
  if (_interval_id != 0){
    _interval_id = 0;
  }
}

void WSDbtronPrivateTimer::_timer_set(){
  if (_interval_id == 0){
    int ret = cre_tsk(_timer_process,-1,(int)this);
    if (ret < 0){
dbprintf("Error. WSDbtronPrivateTimer can not create thread...\n");
WSMFtrace("Error. WSDbtronPrivateTimer can not create thread...\n");
      return;
    }

    _interval_id = (long)ret;
  }
  if ( _interval_id ==  0 ) {
dbprintf("Error. WSDbtronPrivateTimer is no effective...\n");
WSMFtrace("Error. WSDbtronPrivateTimer is no effective...\n");
  }
}
void WSDbtronPrivateTimer::_timer_callback(WSCulong id){
//printf("WSDbtronPrivateTimer::_timer_callback start!!!!!\n");
  if (id != (WSCulong)_interval_id){
    return;
  }
//  _interval_id = 0;
  if (_work_proc != NULL){
    _work_proc(_data);
  }
  if (_cont != False && _timer_on == True){
//printf("WSDbtronPrivateTimer::_timer_callback cont!!!!!\n");
//    _timer_set();
  }else{
    _timer_on = False;
  }
  return;
}
