//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <Carbon/Carbon.h>
#include <unistd.h>
#include <mach-o/dyld.h>

#define RTLD_LAZY 0
void* dlopen(char* fname,long){
  int ret;
  NSObjectFileImage obj_file;
  ret = NSCreateObjectFileImageFromFile(fname,&obj_file);
  if (ret != NSObjectFileImageSuccess){
    return NULL;
  }
  NSLinkModule(obj_file,fname,TRUE);
  return obj_file;
};
void* dlsym(void*,char* procn){
  if (NSIsSymbolNameDefined(procn)){
    return NULL;
  } 
  void* fn = NSAddressOfSymbol(NSLookupAndBindSymbol(procn));
  return fn;
}

#include <WScom.h>
#include <WSCimageSet.h>
#include <WSDfileSystem.h>
#include <WStcpcom.h>

#include <mac/WSDmacImage.h>
#include <mac/WSDmacAppDev.h>
#include <mac/WSDmacColor.h>

#if 0
long WSGFmacBufToPixmap(unsigned char *buf,PicHandle* pixmap,PicHandle* pixmap2,long width,long height,long* vw,long* vh);
long WSGFxBmpReadFpToPixmap(Display* display,Window window,GC gc,FILE* ifile,Pixmap* pixmap,long* w,long* h);
#endif
long WSGFmacBmpReadFileToPixmap(char* filename,PicHandle* pixmap,PicHandle* pixmap2,long* w,long* h);

WSMFclassInit(WSDmacImage,WSDimage);

WSDimage* _macImage_create_handler(){
  WSDimage* image = new WSDmacImage();
  return image;
};

void  _macImage_init(){
    WSGIappImageSet()->setCreateHandler(_macImage_create_handler);
};

WSDmacImage::WSDmacImage(){
}

WSDmacImage::~WSDmacImage(){
  destroy();
}

long WSDmacImage::initialize(){
//printf("WSDmacImage::initialize D19..\n");
  if (_value1 > 0){
//printf("WSDmacImage::initialize D19 return1\n");
    return WS_NO_ERR;
  }
  char* iname = getSrc();
  if (iname == NULL || !strcmp(iname,"") ){
//printf("WSDmacImage::initialize D19 return2\n");
    return WS_NO_ERR;
  }

  WSCstring in;
  in.setString( WSGIappFileSystem()->adjustFileName(iname) );


#if 0   
  if (in.isExist(".xpm") != -1 || in.isExist(".XPM") != -1){
#ifndef MacOS
     static void* dl = NULL;
     static long dl_init = 0;
     static long (*fn)(Display*,Window,Colormap,char*,Pixmap*,Pixmap*,
                       long*,long*) = NULL;
     static long (*fn2)(Display*,Window,Colormap,char**,Pixmap*,Pixmap*,
                       long*,long*) = NULL;

     if (dl_init == 0){
       dl = dlopen("xpm.so",RTLD_LAZY);
       dl_init = 1;
       if (dl == NULL){
WSMFtrace("ERROR. in WSDmacImage::initialize(). Library libXpm.so open error. \nso, Xpm image can not support...\n");
       }else{
         fn = (long (*)(Display*,Window,Colormap,char*,
                        Pixmap*,Pixmap*,long*,long*))
                dlsym(dl,"ReadXpm");
         fn2 = (long (*)(Display*,Window,Colormap,char**,
                        Pixmap*,Pixmap*,long*,long*))
                dlsym(dl,"CreateXpmFromData");
         if (fn == NULL){
WSMFtrace("ERROR. in WSDmacImage::initialize(). Library libXpm.so is invalid. \nso, Xpm image can not support...\n");
         }
       }
     }
     if (fn == NULL){
       return WS_NO_ERR;
     }
#else //MacOS
     static long (*fn)(Display*,Window,Colormap,char*,Pixmap*,Pixmap*,
                       long*,long*) = ReadXpm;
     static long (*fn2)(Display*,Window,Colormap,char**,Pixmap*,Pixmap*,
                       long*,long*) = CreateXpmFromData;

#endif //MacOS

     Pixmap pixmap_file;
     Pixmap pixmap_file2;
     int reti;
     long width = _w,height = _h;

     char* load_file_name = in.getString();
     WSDxappDev* app   = WSGIxwinAppDev(); 
     in.delHeadSpace();
     if (strncmp("http://",in.getString(),7)){
       reti = fn( app->display(),XtWindow(app->appWidget()),
                  WSDxcolor::getColormap(),
                  load_file_name,&pixmap_file, &pixmap_file2,&width,&height);

       if (reti != 0 && fn2 != NULL){
         void* data = WSGIappImageSet()->getDefaultImageHandle(iname);
         if (data != NULL){
           reti = fn2( app->display(),XtWindow(app->appWidget()),
                  WSDxcolor::getColormap(),
                  (char**)data,&pixmap_file, &pixmap_file2,&width,&height);
         }
       }
     }else{
       char*  pbuf = NULL;
       char*  ctype = NULL;
       long  size = 0;
       long  ishtml = 0;
       WSGFloadRemoteFile(in.getString(),&pbuf,&ctype,&size,&ishtml,1);
       if (pbuf != NULL){
         reti = fn( app->display(),XtWindow(app->appWidget()),
                    WSDxcolor::getColormap(),
                    pbuf, &pixmap_file, &pixmap_file2,&width,&height);
         free(pbuf);
       }else{
         reti = 1;
       }
     }

     if (reti == 0){
       setImageWidth(width);
       setImageHeight(height);
       setValue1((long)pixmap_file);
       setValue2((long)pixmap_file2);
     }else{
//WSMFtrace("ERROR. WSDmacImage::initialize() file open error. file=%s\n",load_file_name);
     }

  }else if (in.isExist(".jpg") != -1 || in.isExist(".JPG") != -1){
//WSMFtrace("WSDmacImage::initialize %s\n",in.getString());
     Pixmap pixmap_file;
     long width = _w;
     long height = _h;
     char* load_file_name = in.getString();
     WSDxappDev* app   = WSGIxwinAppDev(); 
     in.delHeadSpace();
     GC gc = WSGIxwinAppDev()->appGC2();
#ifndef MacOS
     static void* dl = NULL;
     static long dl_init = 0;
     static long (*fn)(Display*,Window,GC,char*,Pixmap*,long*,long*) = NULL;

     if (dl_init == 0){
       dl = dlopen("jpg.so",RTLD_LAZY);
       dl_init = 1;
       if (dl == NULL){
WSMFtrace("ERROR. in WSDmacImage::initialize(). Library jpg.so open error. \nso, jpeg image can not support...\n");
       }else{
         fn = (long (*)(Display*,Window,GC,char*,Pixmap*,long*,long*))
                dlsym(dl,"JpegReadFileToPixmap");
         if (fn == NULL){
WSMFtrace("ERROR. in WSDmacImage::initialize(). Library jpg.so is invalid. \nso, jpeg image can not support...\n");
         }
       }
     }
#else //MacOS
     static long (*fn)(Display*,Window,GC,char*,Pixmap*,long*,long*) = 
                JpegReadFileToPixmap;
#endif //MacOS
     if (fn != NULL){
       long reti = fn( app->display(), XtWindow(app->appWidget()),gc,
                       load_file_name, &pixmap_file, &width,&height);

       if (reti == 0){
         setImageWidth(width);
         setImageHeight(height);
         setValue1((long)pixmap_file);
         setValue2((long)0);
       }else{
//WSMFtrace("ERROR. WSDmacImage::initialize file open error. file=%s\n",load_file_name);
       }
     }
  }else if (in.isExist(".png") != -1 || in.isExist(".PNG") != -1){
//WSMFtrace("WSDmacImage::initialize %s\n",in.getString());
     Pixmap pixmap_file;
     long width = _w;
     long height = _h;
     char* load_file_name = in.getString();
     WSDxappDev* app   = WSGIxwinAppDev(); 
     in.delHeadSpace();
     GC gc = WSGIxwinAppDev()->appGC2();
#ifndef MacOS
     static void* dl = NULL;
     static long dl_init = 0;
     static long (*fn)(Display*,Window,GC,char*,Pixmap*,long*,long*) = NULL;

     if (dl_init == 0){
       dl = dlopen("png.so",RTLD_LAZY);
       dl_init = 1;
       if (dl == NULL){
WSMFtrace("ERROR. in WSDmacImage::initialize(). Library png.so open error. \nso, jpeg image can not support...\n");
       }else{
         fn = (long (*)(Display*,Window,GC,char*,Pixmap*,long*,long*))
                dlsym(dl,"PngReadFileToPixmap");
         if (fn == NULL){
WSMFtrace("ERROR. in WSDmacImage::initialize(). Library png.so is invalid. \nso, jpeg image can not support...\n");
         }
       }
     }
#else //MacOS
     static long (*fn)(Display*,Window,GC,char*,Pixmap*,long*,long*) = 
            PngReadFileToPixmap;
#endif //MacOS
     if (fn != NULL){
       long reti = fn( app->display(), XtWindow(app->appWidget()),gc,
                       load_file_name, &pixmap_file, &width,&height);

       if (reti == 0){
         setImageWidth(width);
         setImageHeight(height);
         setValue1((long)pixmap_file);
         setValue2((long)0);
       }else{
//WSMFtrace("ERROR. WSDmacImage::initialize file open error. file=%s\n",load_file_name);
       }
     }

  }else if (in.isExist(".bmp") != -1 || in.isExist(".BMP") != -1){
//WSMFtrace("WSDmacImage::initialize %s\n",in.getString());
     char* buffer = NULL;
     long width = _w;
     long height = _h;
     char* load_file_name = in.getString();
     WSDxappDev* app   = WSGIxwinAppDev(); 
     in.delHeadSpace();
     GC gc = WSGIxwinAppDev()->appGC2();


     if (reti == 0){
       setImageWidth(width);
       setImageHeight(height);
       setValue1((long)pixmap_file);
       setValue2((long)0);
     }else{
//WSMFtrace("ERROR. WSDmacImage::initialize file open error. file=%s\n",load_file_name);
     }
  }
#endif

  if (in.isExist(".xpm") != -1 || in.isExist(".XPM") != -1){
    in.replaceString(".xpm",".bmp",1);
  }

  if (in.isExist(".bmp") != -1 || in.isExist(".BMP") != -1){
WSMFtrace("WSDmacImage::initialize %s\n",in.getString());
     PicHandle pixm;
     PicHandle pixm2;
     long width = _w;
     long height = _h;
     char* load_file_name = in.getString();
     in.delHeadSpace();
     long reti = WSGFmacBmpReadFileToPixmap( load_file_name,
                                             &pixm, &pixm2,&width,&height);

//printf("WSDmacImage::initialize D19 ret=0x%x\n",reti);
     if (reti == 0){
       setImageWidth(width);
       setImageHeight(height);
       setValue1((long)pixm);
       setValue2((long)pixm2);
//printf("WSDmacImage::initialize D19 buf=0x%x buf2=0x%x val=0x%x\n",getValue1(),pixm,pixm2);
     }else{
     }
  }
  return WS_NO_ERR;
}

long WSDmacImage::destroy(){
//Need Relase..

  setValue1(-1);
  setValue2(-1);
  return WS_NO_ERR;
}

int WSGFxgetbyte(FILE *fp) {
  int c;
  if ((c = fgetc(fp)) == EOF){
    return -1;
  }
  return c;
}

int WSGFxreadLittleShort(FILE *fp, short *d) {
  int c;
  if ((c = fgetc(fp)) == EOF){
    return -1;
  }
  *d = c & 0xff;
  if ((c = fgetc(fp)) == EOF){
    return -1;
  }
  *d |= (c & 0xff) << 8;
  return 0;
}

int WSGFxreadLittleLong(FILE *fp, long *d) {
  int c;

  if ((c = fgetc(fp)) == EOF){
    return -1;
  }
  *d = c & 0xff;
  if ((c = fgetc(fp)) == EOF){
    return -1;
  }
  *d |= ((c & 0xff) << 8);
  if ((c = fgetc(fp)) == EOF){
    return -1;
  }
  *d |= ((c & 0xff) << 16);
  if ((c = fgetc(fp)) == EOF){
    return -1;
  }
  *d |= ((c & 0xff) << 24);
  return 0;
}

long WSGFmacBmpReadFpToPixmap(FILE* ifile,PicHandle* pixmap,PicHandle* pixmap2,long* w,long* h){

  // bmp (Windows 3.x) header
  //       implemented
  //            1. uncompressed 1bit black & white
  //            2. uncompressed 4bit  16 color
  //            3. uncompressed 8bit 256 color
  //            4. uncompressed 24bit true color
  //            5. RLE 4bit  16 color
  //            6. RLE 8bit 256 color

  unsigned char red[256], green[256], blue[256];
  if ((WSGFxgetbyte(ifile) != 'B') || (WSGFxgetbyte(ifile) != 'M')){  //  0
    // not a .bmp file
//printf("err1\n");
    return -1;
  }
  long width, height, long_tmp, fsize, foffs, cmapsize, cmptype;
  short bit_cnt, short_tmp;
  if (WSGFxreadLittleLong(ifile, &fsize) == -1){                //  2
//printf("err2\n");
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &long_tmp) == -1){             //  6
//printf("err3\n");
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &foffs) == -1){                 // 10
//printf("err4\n");
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &long_tmp) == -1){             // 14
//printf("err5\n");
    return -1;
  }
  if (long_tmp != 40){
    // not a Windows 3.x bmp file
//printf("err6\n");
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &width) == -1){                 // 18
//printf("err7\n");
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &height) == -1){                // 22
//printf("err8\n");
    return -1;
  }
  if (WSGFxreadLittleShort(ifile, &short_tmp) == -1){            // 26
//printf("err9\n");
    return -1;
  }
  if (short_tmp != 1){
    // plane != 1 is not supported
//printf("err10\n");
    return -1;
  }
  if (WSGFxreadLittleShort(ifile, &bit_cnt) == -1){              // 28
//printf("err11\n");
    return -1;
  }
  if ((bit_cnt != 1) && (bit_cnt != 4) && (bit_cnt != 8) && (bit_cnt != 24) &&
      (bit_cnt != 32)){
    // bit_cnt=16 is not supported
//printf("err12 bit_cnt=%d\n",bit_cnt);
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &cmptype) == -1){              // 30
//printf("err13\n");
    return -1;
  }
  if (cmptype > 2){
    // compressed file is not supported
//printf("err14\n");
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &long_tmp) == -1){              // 34
//printf("err15\n");
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &long_tmp) == -1){              // 38
//printf("err16\n");
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &long_tmp) == -1){              // 42
//printf("err17\n");
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &cmapsize) == -1){              // 46
//printf("err18\n");
    return -1;
  }
  if (WSGFxreadLittleLong(ifile, &long_tmp) == -1){              // 50
//printf("err19\n");
    return -1;
  }
  int n, c;
  for (n = 0; n < cmapsize; n++) {
    if ((c = WSGFxgetbyte(ifile)) == -1){
      return -1;
    }
    blue[n] = (unsigned char)c;
    if ((c = WSGFxgetbyte(ifile)) == -1){
      return -1;
    }
    green[n] = (unsigned char)c;
    if ((c = WSGFxgetbyte(ifile)) == -1){
      return -1;
    }
    red[n] = (unsigned char)c;
    if (WSGFxgetbyte(ifile) == -1){
        return -1;
    }
  }
  if (fseek(ifile, foffs, SEEK_SET) != 0){
    return -1;
  }
  unsigned char* fbuf = new unsigned char[fsize - foffs];
  if (fread(fbuf, fsize - foffs, 1, ifile) != 1) {
    delete fbuf;
    return -1;
  }
  unsigned char* buf = new unsigned char[width * height * 3];
  unsigned char* buf2 = NULL;
  unsigned char *tmp, *ftmp,*tmp2;
  tmp2 = NULL;
  int line, dat, x, y;

  if (cmptype) {
    for (y = 0; y < height; y++) {
      tmp = buf + (height - 1 - y) * width * 3;
      for (x = 0; x < width; x++) {
        *(tmp++) = red[0];        // red
        *(tmp++) = green[0];      // green
        *(tmp++) = blue[0];       // blue
      }
    }
  }


  if (cmptype == 1) {
    // BI_RLE8
    x = 0;
    y = 0;
    ftmp = fbuf;
    while (1) {
      if (*ftmp) {
        // copy N times
        tmp = buf + (((height - 1 - y) * width) + x) * 3;
        for (n = 0; n < *ftmp; n++, x++) {
          *(tmp++) = red[*(ftmp + 1)];        // red
          *(tmp++) = green[*(ftmp + 1)];      // green
          *(tmp++) = blue[*(ftmp + 1)];       // blue
        }
        ftmp += 2;
      } else {
        if (*(ftmp + 1) == 0) {
          // newline
          x = 0;
          y++;
          ftmp += 2;
        } else if (*(ftmp + 1) == 1) {
          // end
          break;
        } else if (*(ftmp + 1) == 2) {
          // jump
          x += *(ftmp + 2);
          y += *(ftmp + 3);
          ftmp += 4;
        } else {
          // copy
          tmp = buf + (((height - 1 - y) * width) + x) * 3;
          for (n = 0; n < *(ftmp + 1); n++, x++) {
            *(tmp++) = red[*(ftmp + n + 2)];        // red
            *(tmp++) = green[*(ftmp + n + 2)];      // green
            *(tmp++) = blue[*(ftmp + n + 2)];       // blue
          }
          ftmp += (*(ftmp + 1) + 2 + (*(ftmp + 1) % 2)?1:0);
        }
      }
    }
  } else if (cmptype == 2) {
    // BI_RLE4
    int m;
    x = 0;
    y = 0;
    ftmp = fbuf;
    while (1) {
      if (*ftmp) {
        // copy N times
        tmp = buf + (((height - 1 - y) * width) + x) * 3;
        for (n = 0; n < *ftmp; n++, x++) {
          if (x % 2)
            dat = *(ftmp + 1) & 0x0f;         // left
          else
            dat = (*(ftmp + 1) & 0xf0) >> 4;  // right
          *(tmp++) = red[dat];        // red
          *(tmp++) = green[dat];      // green
          *(tmp++) = blue[dat];       // blue
        }
        ftmp += 2;
      } else {
        if (*(ftmp + 1) == 0) {
          // newline
          x = 0;
          y++;
          ftmp += 2;
        } else if (*(ftmp + 1) == 1) {
          // end
          break;
        } else if (*(ftmp + 1) == 2) {
          // jump
          x += *(ftmp + 2);
          y += *(ftmp + 3);
          ftmp += 4;
        } else {
          // copy
          m = 0;
          tmp = buf + (((height - 1 - y) * width) + x) * 3;
          for (n = 0; n < *(ftmp + 1); n++, x++) {
            if (x % 2) {
              dat = *(ftmp + m + 2) & 0x0f;         // left
              m++;
            } else
              dat = (*(ftmp + m + 2) & 0xf0) >> 4;  // right
            *(tmp++) = red[dat];        // red
            *(tmp++) = green[dat];      // green
            *(tmp++) = blue[dat];       // blue
          }
          m = (*(ftmp + 1) + 1) / 2;
          ftmp += (m + 2 + ((m % 2)?1:0));
        }
      }
    }
  } else {
    // uncompress
    switch(bit_cnt) {
      case 1:
        line = ((width + 31) / 32) * 4;
        tmp = buf;
        for (y = 0; y < height; y++){
          ftmp = fbuf + ((height - 1 - y) * line);
          for (x = 0; x < width; x++){
            dat = (*ftmp >> (7 - (x % 8))) & 0x01;
            if ((x % 8) == 7){
              ftmp++;
            }
            *(tmp++) = red[dat];          // red
            *(tmp++) = green[dat];        // green
            *(tmp++) = blue[dat];         // blue
          }
        }
        break;
      case 4:
        line = ((width + 7) / 8) * 4;
        tmp = buf;
        for (y = 0; y < height; y++){
          ftmp = fbuf + ((height - 1 - y) * line);
          for (x = 0; x < width; x++){
            if (x % 2) {
              dat = *ftmp & 0x0f;         // left
              ftmp++;
            }else{
              dat = (*ftmp & 0xf0) >> 4;  // right
            }
            *(tmp++) = red[dat];          // red
            *(tmp++) = green[dat];        // green
            *(tmp++) = blue[dat];         // blue
          }
        }
        break;
      case 8:
        line = ((width + 3) / 4) * 4;
        tmp = buf;
        for (y = 0; y < height; y++){
          ftmp = fbuf + ((height - 1 - y) * line);
          for (x = 0; x < width; x++){
            *(tmp++) = red[*ftmp];        // red
            *(tmp++) = green[*ftmp];      // green
            *(tmp++) = blue[*ftmp];       // blue
            ftmp++;
          }
        }
        break;
      case 24:
        tmp = buf;
        for (y = 0; y < height; y++){
          ftmp = fbuf + ((height - y) * width * 3);
          for (x = 0; x < width; x++){
            *(tmp++) = *(ftmp + 2);       // red
            *(tmp++) = *(ftmp + 1);       // green
            *(tmp++) = *(ftmp + 0);       // blue
            ftmp += 3;
          }
        }
        break;
      case 32:
        buf2 = new unsigned char[width * height];
        tmp = buf;
        tmp2 = buf2;
        for (y = 0; y < height; y++){
          ftmp = fbuf + ((height -1 -y) * width * 4);
//          ftmp = fbuf + ((y) * width * 3);
          for (x = 0; x < width; x++){
//printf("WSDmacImage::init D21 ptr=0x%x xy=%d,%d %x,%x,%x,%x\n",(tmp - buf)/3,x,y,*(unsigned char*)(ftmp+2),*(unsigned char*)(ftmp+1),*(unsigned char*)(ftmp),*(WSCuchar*)(ftmp+3));
            *(tmp2++) = *(ftmp + 3);       // mask
            *(tmp++) = *(ftmp + 2);       // red
            *(tmp++) = *(ftmp + 1);       // green
            *(tmp++) = *(ftmp + 0);       // blue
            ftmp += 4;
          }
        }
        break;
    }
  }
  delete fbuf;
#if 0
  OpenCPicParams picp;
  Rect r;
  SetRect(&r,0,0,width,height);
  picp.srcRect = r;
  picp.hRes = 0x00480000;
  picp.vRes = 0x00480000;
  picp.version = -2;

  *pixmap = OpenCPicture(&picp);
  ClipRect(&r);
//printf("WSDmacImage::initialize D18 pic=0x%x %d,%d\n",*pixmap,width,height);

  RGBColor col;
  long p =0;
  for(y=0; y<height; y++){
    for(x=0; x<width; x++){
      col.red = buf[p++]<<16;
      col.green = buf[p++]<<16;
      col.blue = buf[p++]<<16;
      SetCPixel(x,y,&col);
    }
  }
  ClosePicture();
  delete buf;
#endif
  *pixmap = (PicHandle)buf;
  *pixmap2 = (PicHandle)buf2;
//printf("WSDmacImage::initialize D18 pic=0x%x %d,%d\n",*pixmap,width,height);
  *w = width;
  *h = height;
  return WS_NO_ERR;
}
long WSGFmacBmpReadFileToPixmap(char* filename,PicHandle* pixmap,PicHandle* pixmap2,long* w,long* h){

//printf("WSDmacImage::init D22 fopen=%s\n",filename);
  FILE* ifile = fopen(filename,"r");
  if (ifile == NULL){
//printf("WSGFmacBmpReadFileToPixmap D19 file not found:%s\n",filename);
    return -1;
  }

  long reti = WSGFmacBmpReadFpToPixmap(ifile, pixmap,pixmap2, w, h);
  fclose(ifile);
  return reti;
}     

