//
// Copyright (C) 1999-2003 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <nx/WSDnxKeyboard.h>
#include <nx/WSDnxAppDev.h>
#include <nx/WSDnxFormDev.h>
#include <WSCdevice.h>
#include <WSDcolor.h>
#include <WSDmouse.h>
#include <WSCbase.h>
#include <WSCcolorSet.h>
#include <WSCfontSet.h>
#include <WSClocaleSet.h>

WSMFclassInit(WSDnxKeyboard,WSDkeyboard);

WSDnxKeyboard* WSGInxKeyboard(){
  WSDkeyboard* keybd = WSGIappKeyboard();
  if (keybd == NULL){
    return NULL;
  }
  WSDnxKeyboard* nxKeybd =(WSDnxKeyboard*)keybd->cast("WSDnxKeyboard");
  return nxKeybd;
}

WSDkeyboard* _nxKeyboard_create_handler(){
  WSDkeyboard* keybd =  new WSDnxKeyboard();
  keybd->initialize();
  return keybd;
}
void* _fep_popup = NULL;

WSDnxKeyboard::WSDnxKeyboard(){
  _dev = NULL;
  _focused = False;
  _wait_for_receive_data = False;
  // TODO initialize keyboard resource..
}

WSDnxKeyboard::~WSDnxKeyboard(){}


long WSDnxKeyboard::initialize(){
  // TODO initialize keyboard resource..
  return WS_NO_ERR;
}

long WSDnxKeyboard::startKanji(WSDdev* dev,short x,short y,short fontno,short fgno,short bgno){
  _dev = dev;
  _x = x;  
  _y = y;  
  _fno = fontno;
  _fg = fgno;
  _bg = bgno;
  _fep_on = True;
  // TODO create fep resource _fep_popup if needed.
  // TODO set value to fep resource..

  return WS_NO_ERR;
}
long WSDnxKeyboard::startAscii(WSDdev* dev,short ,short ,short ,short ,short ){
  _fep_on = False;
  // TODO set value to fep resource..
  return WS_NO_ERR;
}

long WSDnxKeyboard::resetFep(WSDdev* dev){
  // TODO set value to fep resource..
  return WS_NO_ERR;
}

long WSDnxKeyboard::setFepPos(WSDdev* dev,short x,short y,short fontno,short fgno,short bgno){
  _dev = dev;
  _x = x;
  _y = y;
  _fno = fontno;
  _fg = fgno;
  _bg = bgno;
  // TODO set value to fep resource..

  return WS_NO_ERR;
}

WSCbool WSDnxKeyboard::deliverKeyEvent(void* ev,WSCbool fl){
  WSCbool press = fl;
  setIsPressed(press);

  // TODO set key code with setKey()
  long key = 0;
  setKey(key);

  // TODO set input string with setText()
  char buffer[1024];
  buffer[0] = 0;
  setText(buffer,WS_EN_UTF8);

  // TODO set _with_shift variable
  _with_shift = 0;

  // TODO set _with_lock variable
  _with_lock = 0;

  // TODO set _with_cntl variable
  _with_cntl = 0;

  // TODO set _with_alt variable
  _with_alt = 0;

  // TODO set press variable and call executeHandler
  WSCbool executed = executeHandler(press);
  if (executed == True){
    return False;
  }else{
    return True;
  }
}

void WSDnxKeyboard::setSelectedString(char* str,long encode){
  _selected_string.setString(str);
}

char* WSDnxKeyboard::getSelectedString(long encoding){
  return _selected_string.getString();
}

