//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE. 
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#ifndef WSCBASEDIALOG_H
#define WSCBASEDIALOG_H

#include <WScom.h>
#include <WSCwindow.h>

class WSCvbtn;
class WSCvlabel;
class WSCform;

#define WSCbaseDialog_VER  1000

class WSCbaseDialog :public WSCwindow{

  private:
  protected:
    WSCvbtn*  _end_btn;
    WSCvbtn*  _ok_btn;
    WSCvbtn*  _no_btn;
    WSCform*  _cmd_form;
    WSCvlabel* _title_label;
    WSCvlabel* _title_labels1;
    WSCvlabel* _title_labels2;
    void*     _rep;
    char*     _ok_str;
    char*     _no_str;
    char*     _cancel_str;
    short     _title_pixmap;
    unsigned  _ok:1;
    unsigned  _no:1;
    unsigned  _cancel:1;
    unsigned  _status:2;
    unsigned  _modal:1;
    unsigned  _default_pos:1;
    unsigned  _popuped:1;

    WSMFpropertyDef(WSNok,              WSCbool, _ok);
    WSMFpropertyDef(WSNno,              WSCbool, _no);
    WSMFpropertyDef(WSNcancel,              WSCbool, _cancel);
    WSMFpropertyDef(WSNlabelPixmap,     short,   _title_pixmap);
    WSMFpropertyDef(WSNokString,        char*,   _ok_str);
    WSMFpropertyDef(WSNnoString,        char*,   _no_str);
    WSMFpropertyDef(WSNcancelString,        char*,   _cancel_str);
    WSMFpropertyDef(WSNreplyHandler,    void*,   _rep);
    WSMFpropertyDef(WSNmodal,           WSCbool, _modal);
    WSMFpropertyDef(WSNdefaultPosition, WSCbool, _default_pos);

    WSDLEX32 virtual void setWorkWSNwidth(WSCushort);
    WSDLEX32 virtual void setWorkWSNheight(WSCushort);
    WSDLEX32 virtual void setWorkWSNtitleString(char*);

    WSDLEX32 static void _ok_btn_work(WSCbase*);
    WSDLEX32 static void _no_btn_work(WSCbase*);
    WSDLEX32 static void _end_btn_work(WSCbase*);

     WSDLEX32 virtual long _device_initialize();

  public:
    WSDLEX32 WSCbaseDialog(WSCbase*,char*);
    WSDLEX32 virtual  ~WSCbaseDialog();
    WSDLEX32 virtual  long initialize();

    WSDLEX32 virtual void onResize(WSCrect*);
    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onParentVisibleChange(WSCbool);
    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onGuiPolicyChange(long);
    WSDLEX32 virtual void onFocusChange(WSCbool);

    WSDLEX32 WSCbase* getFormObject();
    WSDLEX32 WSCbase* getCmdFormObject();
    WSDLEX32 long     getStatus();
    WSDLEX32 virtual  long popup();

    WSMFguiClassDef(WSCbaseDialog,WSCwindow);
    WSMFversionDef(WSCbaseDialog);
};
#endif
