//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSPROPERTY_H
#define WSPROPERTY_H

#include <WScom.h>
#include <WSCstring.h>
class WSCbase;

class WSCproperty{

  public:
    char* property_name;
    char* owner_class_name;
    void (*_get_proc_addr)(void*,void*);
    void (*_set_proc_addr)(void*,void*);
    void (*_def_proc_addr)(void*);
    char** _data_labels;
    char** _data;
    WSCstring  _builder_title;

    unsigned _prop_type:4;
    unsigned _builder_visible:1;
    unsigned _not_use:1;
    unsigned _is_pixmap:1;
    unsigned _is_color:1;
    unsigned _default_value_change:1;
    unsigned _ignore:1;
	unsigned _init_execute:1;
	unsigned _file_select:1;

    WSDLEX32 WSCproperty(char* prop_name,char* owner_class_name);

    WSDLEX32 long execSetHandler(void*);

    WSDLEX32 void setType(char* type, void(*)(void*,void*), void(*)(void*,void*),
                              void(*)(void*));

    WSDLEX32 long setValue(WSCbase* ,void* ptr);
    WSDLEX32 void setDefaultValue(WSCbase* obj);
    WSDLEX32 void setBuilderSelectValues(char* labels[],char* data[]);
    WSDLEX32 void setGetDefaultValueHandler(void (*)(void*));

    WSDLEX32 long    getValue(WSCbase* ,void* ptr);
    WSDLEX32 long    getDefaultValue(void*);
    WSDLEX32 WSCbool getDefaultValueChange();
    WSDLEX32 WSCbool getNotUse();
    WSDLEX32 WSCbool getBuilderVisible();
    WSDLEX32 WSCbool getFileSelect();
    WSDLEX32 void    getBuilderSelectValues(char*** labels,char*** data);
    WSDLEX32 char*   getBuilderTitle();
    WSDLEX32 char    getPropObjType();
    WSDLEX32 char*   getPropObjName();
    WSDLEX32 char*   getPropObjTypeName();
    WSDLEX32 void*   getGetDefaultValueHandler();

    WSDLEX32 WSCbool isPixmapPropObj();
    WSDLEX32 WSCbool isColorPropObj();
    WSDLEX32 WSCbool isDefaultValue(WSCbase* obj);
};
#endif
