//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCVIMAGE_H
#define WSCVIMAGE_H

#include <WScom.h>
#include <WSCnwbase.h>
#define WSCvimage_VER  1000

#define WS_VIMAGE_MAXLEN_DEFAULT 64

class WSCvimage   :public WSCnwbase{

  protected:
    short     _ts_color;
    short     _bs_color;
    short     _back_color;
    short     _label_pixmap;
    WSCuchar  _grad_no;
    WSCuchar  _grad_margin;
    unsigned  _margin_top:4;
    unsigned  _margin_bottom:4;
    unsigned  _margin_left:4;
    unsigned  _margin_right:4;
    unsigned  _shadow_thick:4;
    signed    _shadow_type:4;
    signed    _fit:1;

    WSMFpropertyDef(WSNtopShadowColor,    short,     _ts_color);
    WSMFpropertyDef(WSNbottomShadowColor, short,     _bs_color);
    WSMFpropertyDef(WSNshadowType,        char,      _shadow_type);
    WSMFpropertyDef(WSNshadowThickness,   WSCuchar, _shadow_thick);
    WSMFpropertyDef(WSNbackColor,         short,     _back_color);
    WSMFpropertyDef(WSNmarginTop,    WSCuchar,   _margin_top   );
    WSMFpropertyDef(WSNmarginBottom, WSCuchar,   _margin_bottom);
    WSMFpropertyDef(WSNmarginLeft,   WSCuchar,   _margin_left  );
    WSMFpropertyDef(WSNmarginRight,  WSCuchar,   _margin_right );
    WSMFpropertyDef(WSNlabelPixmap,  short,      _label_pixmap );
    WSMFpropertyDef(WSNgradation,    WSCuchar,   _grad_no );
    WSMFpropertyDef(WSNgradationMargin,    WSCuchar,   _grad_margin );
    WSMFpropertyDef(WSNfit,    WSCbool,   _fit );

    WSDLEX32 virtual long _device_initialize();
  public:

    WSDLEX32 WSCvimage(WSCbase* base, char* name);
    WSDLEX32 virtual ~WSCvimage();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual void update();
    WSDLEX32 virtual char* getDefaultProperty();

    WSMFguiClassDef(WSCvimage,WSCnwbase);
    WSMFversionDef(WSCvimage);
};
#endif //WSCVIMAGE_H
