//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDAPPDEV_H
#define WSDAPPDEV_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSDdev.h>
#include <WSClistData.h>
#include <WSCindexData.h>
#include <WSCstring.h>
class WSCbase;

class WSDappDev   :public WSDdev{

  protected:
    WSCbase*  _modal_client;
    void*     _modal_proc;
    WSCstring _name;
    int       _iprm;
    char**    _cprm;
    WSCbase*  _selection_owner;
    long      _policy;
    WSCbase*  _focus_dialog;
    WSClistData _pld_menu_list;
    long      _mode; 
    void*     _alt_context; 
    void*     _alt_context2; 
    WSCindexData _ext_policy_list;
    WSCstring _ext_policy_name;
    WSCindexData* _current_policy_fn_list;
    WSCbool   _under_exec_init;

    WSDLEX32 static WSDappDev*   _instance;
    WSDLEX32 static WSClistData* _init_handler;
    WSDLEX32 static WSCbool _init_executed;
    WSDLEX32 static WSCbool _trace_output;
    WSDLEX32 static WSClistData* getInitHandler(); 
    WSDLEX32 static WSCbool getInstanceExist();
    WSDLEX32 static void setInstance(WSDappDev*);
    WSDLEX32 static void _trace_msg(char* data);

  public:
    WSDLEX32 WSDappDev();
    WSDLEX32 virtual ~WSDappDev();

    WSDLEX32 virtual long initialize();
    WSDLEX32 long   execInitHandler();

    WSDLEX32 virtual WSCushort getWidth();
    WSDLEX32 virtual WSCushort getHeight();
    WSDLEX32 virtual void update();

    WSDLEX32 WSCbool getTraceMode();
    WSDLEX32 void    setTraceMode(WSCbool fl);
    WSDLEX32 void    setInstanceName(char*);
    WSDLEX32 char*   getInstanceName();
//DEVELOP
    WSDLEX32 void setModalClient(WSCbase*);
    WSDLEX32 WSCbase* getModalClient();
//    WSCbase* getModal();
    WSDLEX32 void setFocusDialog(WSCbase*,WSCbool fl);
    WSDLEX32 WSCbase* getFocusDialog();

    WSDLEX32 void addMenu(WSCbase*);
    WSDLEX32 void delMenu(WSCbase*);
    WSDLEX32 WSClistData& getMenuList();

    WSDLEX32 void setSelectionOwner(WSCbase*);
    WSDLEX32 WSCbase* getSelectionOwner();

    WSDLEX32 void setModalProc(void(*)(WSDdev*,long,void*));
    WSDLEX32 void* getModalProc();

    WSDLEX32 static  void setInitHandler( void(*)() );
    WSDLEX32 static  void setCreateInstanceHandler( WSDappDev* (*hd)() );
    WSDLEX32 virtual long dispatchEvent()=0;
    WSDLEX32 virtual long processEvent()=0;
    WSDLEX32 virtual long handleEvents()=0;

    WSDLEX32 void setGuiPolicy(long val,WSCbool create_event);
    WSDLEX32 long getGuiPolicy();
    WSDLEX32 virtual long loadGuiPolicy() = 0;
    WSDLEX32 virtual long saveGuiPolicy() = 0;

    WSDLEX32 int getArgc();
    WSDLEX32 char** getArgv();
    WSDLEX32 void exit(long);
    WSDLEX32 void setMode(long);
    WSDLEX32 long getMode();
    WSDLEX32 void setContext(void*);
    WSDLEX32 void* getContext();
    WSDLEX32 void setContext2(void*);
    WSDLEX32 void* getContext2();

    WSDLEX32 WSCstring getExtGuiPolicyName();
    WSDLEX32 WSCbool getExtGuiPolicySelected();
    WSDLEX32 void setExtGuiPolicy(char* policy_name,WSCbool create_event);
    WSDLEX32 void setExtGuiPolicyProc(char* policy_name,char* procname,void(*)(void*));
    WSDLEX32 void* getExtGuiPolicyProc(char* procname);
    WSDLEX32 WSCindexData* getExtGuiPolicyList();
    WSDLEX32 WSCbool getUnderExecInitialize();
    WSDLEX32 WSCbool getInitializeExecuted();
    WSMFclassDef(WSDappDev,WSDdev);
};
extern WSDLEX WSDappDev*  WSGIappDev();
#endif
