//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.


#ifndef WSDWINSCRDEV_H
#define WSDWINSCRDEV_H

#include <win/WSDwinformDev.h>

class WSDwinScrFrameDev               :public WSDwinformDev {

  private:
  protected:
    HWND      _scr_wnd;
    short     _h_scr_pos;
    short     _v_scr_pos;
    WSCushort  _work_width;
    WSCushort  _work_height;
    WSCushort  _title_height;

    WSDLEX32 virtual long createWindow();
    WSDLEX32 virtual long createPixmap();
    WSDLEX32 virtual long destroyWindow();
WSDLEX32 virtual void _evh_delete(WinEvent*);
WSDLEX32 virtual void _evh_resize(WinEvent*);
WSDLEX32 virtual void _evh_expose(WinEvent*);
    WSDLEX32 void _expose_children(int x,int y,unsigned long w,unsigned long h);

  public:
    WSDLEX32 WSDwinScrFrameDev();
    WSDLEX32 virtual ~WSDwinScrFrameDev();
    WSDLEX32 virtual long setVisible(WSCbool fl);
    WSDLEX32 virtual long setValue(long kind,void*);
    WSDLEX32 virtual void getDispAddr(short*,short*);
    WSDLEX32 virtual void _clear_and_expose();
    WSMFclassDef(WSDwinScrFrameDev,WSDwinformDev);
};

#endif
