//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDWINMWINDEV_H
#define WSDWINMWINDEV_H

#include <WSDmwindowDev.h>
#include <windows.h>

class WSDwinmwinDev   :public WSDmwindowDev{
 protected:
  WSCuchar*  _bmi;
  HBITMAP    _hBitmap;
  HDC        _mdc;

 public:
  WSDLEX32 WSDwinmwinDev();
  WSDLEX32 virtual ~WSDwinmwinDev();

  WSDLEX32 virtual long createPixmap(WSCushort w,WSCushort h);
  WSDLEX32 virtual long destroyPixmap();
  WSDLEX32 long createContext();
  WSDLEX32 long destroyContext();

  WSDLEX32 virtual long beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool absolute,
                         WSCbool scaling);

  WSDLEX32 virtual long copyToWindow(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short);
  WSDLEX32 virtual long copyFromWindow(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short);
  WSDLEX32 virtual long copyToWindowWithMask(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short,WSDimage*);
  WSDLEX32 virtual long copyToWindowWithMask(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short,WSDmwindowDev*);
  WSDLEX32 virtual long getWindowResource();
  WSDLEX32 virtual long getDeviceResource();
  WSDLEX32 virtual long getSpecialResource();
  WSDLEX32 virtual long getContextResource();

  WSDLEX32 virtual long initBuffer();
  WSDLEX32 virtual long setBufferRGB(WSCushort x,WSCushort y,
                            WSCuchar r,WSCuchar g,WSCuchar b);
  WSDLEX32 virtual long getBufferRGB(WSCushort x,WSCushort y,
                            WSCuchar* r,WSCuchar* g,WSCuchar* b);
  WSDLEX32 virtual long putBufferToPixmap();
  WSDLEX32 virtual long saveFile(char*,long);

  WSMFclassDef(WSDwinmwinDev,WSDmwindowDev);
};
#endif
