//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSXCOM_H
#define WSXCOM_H

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <WScom.h>
#include <pthread.h>

#define WS_JOIN JoinMiter
#define UNSPECIFIED_PIXMAP 2

extern void WSGFxdrawTextString( Display* disp,Window win,
         GC gc,XFontStruct* efs,XFontStruct* kfs,XFontStruct* gf,
         WSCulong fg,WSCulong bg,
         long x,long y,char* str,WSCushort kwidth,WSCushort ewidth,
         WSCushort kheight,WSCushort eheight,
         long cur_pos,WSCbool inter_cur,WSCushort linew,
         long spos1 = 0,long spos2 = 0);

extern Pixmap WSGFxGetPixmap(WSCushort w,WSCushort h);
extern void   WSGFxReleasePixmap(Pixmap);

typedef struct pthread_sem_struct{
//  int locked;
  int value;
  pthread_mutex_t mutex;
  pthread_cond_t lock_free;
} pthread_sem_t;

extern int pthread_sem_init_np(pthread_sem_t* semp);
extern int pthread_sem_lock_np(pthread_sem_t* semp);
extern int pthread_sem_unlock_np(pthread_sem_t* semp);
extern int pthread_sem_destroy_np(pthread_sem_t* semp);

#endif //WSXCOM_H
