//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <advance/WSCclassUTrgEditor.h>
#include <advance/WSadcom.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCscrForm.h>
#include <WSCvlabel.h>
#include <WSCoption.h>
#include <WSCvlabel.h>
#include <WSCvifield.h>
#include <WSCvbtn.h>
#include <WSCvfbtn.h>
#include <WSDkeyboard.h>
#include <WSCimageSet.h>
#include <WSCcolorSet.h>
#include <WSCmessageDialog.h>
#include <WSCfileSelect.h>
#include <WSCvtoggle.h>
#include <WSDfile.h>
#include <WSCballoonHelp.h>
#include <WSClist.h>
#include <WSCpopupMenu.h>
#include <WSDappDev.h>

#define WS_WARNING_STR  WSGFgettext("L3:WSSTR Warning")

#define WS_DIALOG_PIX1  WS_PIXMAP_DIR "bi23.xpm"
#define WS_DIALOG_PIX2  WS_PIXMAP_DIR "ope.xpm"
#define WS_CREATE_PIX   WS_PIXMAP_DIR "wcreate.xpm"
#define WS_TRASH_PIX    WS_PIXMAP_DIR "wtrash.xpm"
#define WS_EDIT_PIX     WS_PIXMAP_DIR "edit.xpm"


#define WS_PEDBGCOLOR1 "#C5C5D5"
#define WS_PEDTITLE2   "Class:"

#define WS_PEDLB_W      500
#define WS_PEDLB_HEIGHT 250
#define WS_PEDLB_COL    16
#define WS_PEDLB_COL2   7


#define WS_PEDLD_WIDTH     350
#define WS_PEDLD_HEIGHT    185
#define WS_PEDLD_TWIDTH  170
#define WS_PEDLD_T       25
#define WS_PEDLD_LX      190
#define WS_PEDLD_LWIDTH  140

#define WS_PEDLD_TGRMENU    WSGFgettext("k3:WSSTR Normal Def.:0:,Delete Def.:1:")

#define WS_PEDLDTITLE1   WSGFgettext("l3:WSSTR Target class:")
#define WS_PEDLDTITLE2   WSGFgettext("m3:WSSTR Trigger name:")
#define WS_PEDLDTITLE3   WSGFgettext("n3:WSSTR Define name:")
#define WS_PEDLDTITLE4   WSGFgettext("o3:WSSTR Define value:")
#define WS_PEDLDTITLE5   WSGFgettext("p3:WSSTR Define type:")

WSMFguiClassInitialize(WSCclassUTrgEditor,WSCbaseDialog);

WSCclassUTrgEditor::WSCclassUTrgEditor(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){

  _client = NULL;
  _end_btn = NULL;
  _cmd_area1 = NULL;
  _tlbs4 = NULL;
  _oname = NULL;
  _msg = NULL;
  _voidp_client = NULL;
  _darea1 = NULL;
//  _darea2 = NULL;
  _pmenu = NULL;
  _opt1 = NULL;
//  _opt2 = NULL;
  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNclient, void*, _voidp_client,WSSclient );
    WSMFaddTrigger(WSEV_VALUE_CH);
  WSMFpropertyCreateEnd
}

//ץѥƥѥץκ
WSMFproperty( WSCclassUTrgEditor, WSNclient, void*,   _voidp_client,   NULL);

void WSCclassUTrgEditor::setWorkWSNclient(void* data){
  WSCbase* client = (WSCbase*)data;
  setUserData("PCLIENT",client);
  setEditClient(client);
}

void WSCclassUTrgEditor::getWorkWSNclient(void** data){
  WSCbase* client = getEditClient();
  *data = (void*)client;
}

void WSCclassUTrgEditor::_end_btn_work(WSCbase* obj){
  WSCclassUTrgEditor* op_edit = (WSCclassUTrgEditor*)obj->getUserData("WIN EDIT");
  op_edit->setVisible(False);
}

void WSCclassUTrgEditor::_dialog_set_work(WSCbase* obj){
  WSCclassUTrgEditor* op_edit = (WSCclassUTrgEditor*)obj->getUserData("WIN EDIT");
  if (op_edit->_dialog1->getStatus() != WS_DIALOG_OK){
    return;
  }
  long no = (long)op_edit->_dialog1->getUserData("UTRG NO");
  WSCstring opname;
  opname.setString(op_edit->_if2->getProperty(WSNlabelString));
  opname.delLineFeed();
  opname.delHeadSpace();
  opname.delTailSpace();
  opname.to_upper();

  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
  op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)320);

  if (opname.getWords() != 1 ||
      WSGFcheckNameString(opname.getString()) != True){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("q3:WSSTR Invalid trigger name."));
    op_edit->_msg->setVisible(True);
    return;
  }

  long type;
  op_edit->_opt1->getPropertyV(WSNvalue,&type);

  WSCstring varname;
  varname.setString(op_edit->_var_if->getProperty(WSNlabelString));
  varname.delLineFeed();
  varname.delHeadSpace();
  varname.delTailSpace();
  varname.to_upper();
  if (strncmp(varname.getString(),"WSEV_",5)){
    WSCstring tmp;
    tmp << "WSEV_" << varname;
    varname = tmp;
  }
  if (WSGFcheckNameString(varname.getString()) != True){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("r3:WSSTR Invalid define string..."));
    op_edit->_msg->setVisible(True);
    return;
  }

  if (varname.getWords() != 1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("r3:WSSTR Invalid define string..."));
    op_edit->_msg->setVisible(True);
    return;
  }
  long value = (long)op_edit->_value_if->getProperty(WSNlabelString);
  if (value < 32){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("s3:WSSTR Please specify the define value > 31."));
    op_edit->_msg->setVisible(True);
    return;
  }
  op_edit->_dialog1->setVisible(False);

  if (no == -1 && op_edit->_client != NULL){ //ɲ
    WSClistData* utrg_list = (WSClistData*)op_edit->_client->getUserData(WS_UTRG_LIST);
    if (utrg_list == NULL){
      utrg_list = new WSClistData();
      op_edit->_client->setUserData(WS_UTRG_LIST,(void*)utrg_list);
    }

    long i;
    long num = utrg_list->getNum();
    for(i=0; i<num; i++){
      utrg_data* utrgdata =  (utrg_data*)(*utrg_list)[i];
      if ( !strcmp(utrgdata->name.getString(),opname.getString())){
        op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("t3:WSSTR This trigger name is already used by another one."));
        op_edit->_msg->setVisible(True);
        return;
      }
      if (!strcmp(utrgdata->vname.getString(),varname.getString())){
        op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("u3:WSSTR The define string is already used."));
        op_edit->_msg->setVisible(True);
        return;
      }
      if (utrgdata->value == value){
        op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("v3:WSSTR The value is already used."));
        op_edit->_msg->setVisible(True);
        return;
      }
    }

    utrg_data* utrgdata = new utrg_data();
    utrg_list->add((void*)utrgdata);

    utrgdata->name.setString( opname.getString() );
    utrgdata->vname.setString( varname.getString() );
    utrgdata->value = value;
    utrgdata->type = type;

    WSGFmarkChanged(op_edit->_client);
    op_edit->updateTriggers();
  }else if (op_edit->_client != NULL){
    WSClistData* utrg_list = (WSClistData*)op_edit->_client->getUserData(WS_UTRG_LIST);
    if (utrg_list == NULL){
        utrg_list = new WSClistData();
        op_edit->_client->setUserData(WS_UTRG_LIST,(void*)utrg_list);
    }
    if (utrg_list->getNum() > no){
      long i;
      long num = utrg_list->getNum();
      for(i=0; i<num; i++){
        if (i== no){
          continue;
        }
        utrg_data* utrgdata =  (utrg_data*)(*utrg_list)[i];
        if (!strcmp(utrgdata->name.getString(),opname.getString())){
          op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("t3:WSSTR This trigger name is already used by another one."));
          op_edit->_msg->setVisible(True);
          return;
        }
        if (!strcmp(utrgdata->vname.getString(),varname.getString())){
          op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("u3:WSSTR The define string is already used."));
          op_edit->_msg->setVisible(True);
          return;
        }
        if (utrgdata->value == value){
          op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("v3:WSSTR The value is already used."));
          op_edit->_msg->setVisible(True);
          return;
        }
      }
      utrg_data* utrgdata =  (utrg_data*)(*utrg_list)[no];
      utrgdata->name.setString( opname.getString() );
      utrgdata->vname.setString( varname.getString() );
      utrgdata->value = value;
      utrgdata->type = type;

      WSGFmarkChanged(op_edit->_client);
      op_edit->updateTriggers();
    }
  }
  op_edit->onValueChange();
}

void WSCclassUTrgEditor::setSrcPath(char* path){
  _src_path.setString(path);
}

void WSCclassUTrgEditor::_ibtn1_work(WSCbase* obj){
  WSCclassUTrgEditor* op_edit = (WSCclassUTrgEditor*)obj->getUserData("WIN EDIT");

  if (op_edit->_client != NULL){
    op_edit->_if2->setPropertyV(WSNlabelString,"TRIGGER");
    op_edit->_var_if->setPropertyV(WSNlabelString,"WSEV_TRIGGER");
    op_edit->_value_if->setPropertyV(WSNlabelString,"32");
    op_edit->_opt1->setPropertyV(WSNvalue,(long)0);
    op_edit->_dialog1->setPropertyV(WSNokString,WSGFgettext("T3:WSSTR Create"));
    op_edit->_dialog1->setUserData("UTRG NO",(void*)-1);
    op_edit->_dialog1->setVisible(True);

  }else{
    op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
    op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
    op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
    op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)300);
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }
  
}

void WSCclassUTrgEditor::_ibtn3_work(WSCbase* obj){
  WSCclassUTrgEditor* op_edit = (WSCclassUTrgEditor*)obj->getUserData("WIN EDIT");
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
  op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)300);
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }
 
  if ( op_edit->getSelectedPropObj() == -1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("w3:WSSTR Please select the trigger."));
    op_edit->_msg->setVisible(True);
    return;
  }else{
    op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX2);
    op_edit->_msg->setPropertyV(WSNtitleString,WSGFgettext("W3:WSSTR Question"));
    op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)350);
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("x3:WSSTR Is it OK to delete the trigger?"));
    op_edit->_msg->setPropertyV(WSNuserValue,(long)op_edit);
    if (op_edit->_msg->popup() == WS_DIALOG_OK){
      WSCbase* client = op_edit->_client;
      if (client != NULL){
        WSClistData* utrg_list = (WSClistData*)client->getUserData(WS_UTRG_LIST);
        if (utrg_list != NULL){
          long num = utrg_list->getNum();
          long no = op_edit->getSelectedPropObj();
          if (no < num){
            utrg_data* utrgdata = (utrg_data*)(*utrg_list)[no];
            utrg_list->del((void*)utrgdata);
            delete utrgdata;
          }
          WSGFmarkChanged(client);
          op_edit->updateTriggers();
        }
      }
    }
  }
}

void WSCclassUTrgEditor::_ibtn2_work(WSCbase* obj){
  WSCclassUTrgEditor* op_edit = (WSCclassUTrgEditor*)obj->getUserData("WIN EDIT");
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
  op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)300);
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }
 
  if ( op_edit->getSelectedPropObj() == -1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("w3:WSSTR Please select the trigger."));
    op_edit->_msg->setVisible(True);
    return;
  }
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }

  WSClistData* utrg_list = (WSClistData*)op_edit->_client->getUserData(WS_UTRG_LIST);

  utrg_data* utrgdata = (utrg_data*)(*utrg_list)[op_edit->getSelectedPropObj()];
  op_edit->_if2->setPropertyV(WSNlabelString,utrgdata->name.getString());
  op_edit->_var_if->setPropertyV(WSNlabelString,utrgdata->vname.getString());
  op_edit->_value_if->setProperty(WSNlabelString,utrgdata->value);
  op_edit->_opt1->setProperty(WSNvalue,utrgdata->type);
  op_edit->_dialog1->setPropertyV(WSNokString,WSGFgettext("Y3:WSSTR Update"));

  //-1 is create mode,the other is edit mode
  op_edit->_dialog1->setUserData("UTRG NO",(void*)op_edit->getSelectedPropObj());
  op_edit->_dialog1->setVisible(True);
}

long WSCclassUTrgEditor::getSelectedPropObj(){
  return _list->getSelectedPos();
}

long WSCclassUTrgEditor::initialize(){
  WSCbaseDialog::initialize();

  setPropertyV(WSNwidth,(WSCushort)WS_PEDLB_W);
  setPropertyV(WSNheight,(WSCushort)WS_PEDLB_HEIGHT);
  setPropertyV(WSNshadowThickness,(WSCuchar)1);
  setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
//  setPropertyV(WSNtitleBar,(char)WS_ONLY_TITLE);
  setPropertyV(WSNok,(WSCbool)False);
  setPropertyV(WSNno,(WSCbool)False);
  setPropertyV(WSNtitleString,"User Trigger Setup");

  _cmd_area1 = new WSCform(this,"pe-area1");
  _cmd_area1->initialize();
  _cmd_area1->setInternalObject(True);
  _cmd_area1->setPropertyV(WSNx,     (short)1 );
  _cmd_area1->setPropertyV(WSNy,     (short)5 );
  _cmd_area1->setPropertyV(WSNwidth, (WSCushort)(_w));
  _cmd_area1->setPropertyV(WSNheight,(WSCushort)30);
  _cmd_area1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _cmd_area1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _cmd_area1->setVisible(True);

  WSCvlabel* sp2 = new WSCvlabel(_cmd_area1,"pe-tlb");
  sp2->initialize();
  sp2->setInternalObject(True);
  sp2->setPropertyV(WSNx,     (short)0 );
  sp2->setPropertyV(WSNy,     (short)30 );
  sp2->setPropertyV(WSNwidth, (WSCushort)1280 );
  sp2->setPropertyV(WSNheight,(WSCushort)2 );
  sp2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  sp2->setVisible(True);


  WSCvfbtn* ibtn1 = new WSCvfbtn(_cmd_area1,"pe-ibtn1");
  ibtn1->initialize();
  ibtn1->setInternalObject(True);
  ibtn1->setPropertyV(WSNx,         (short)1                  );
  ibtn1->setPropertyV(WSNy,         (short)1                  );
  ibtn1->setPropertyV(WSNwidth,     (WSCushort)28        );
  ibtn1->setPropertyV(WSNheight,    (WSCushort)28        );
  ibtn1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  ibtn1->setPropertyV(WSNlabelPixmap,WSGFimage(WS_CREATE_PIX));
  ibtn1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  ibtn1->setUserData("WIN EDIT",(void*)this); 
  WSGFsetMargin(ibtn1,0);
  WSGIappBalloonHelp()->registerClient(ibtn1,WSGFgettext("y3:WSSTR Create new trigger"));

  WSCprocedure* iop1 = new WSCprocedure("iop1",WSEV_ACTIVATE);
  iop1->setFunction(_ibtn1_work,"_ibtn1_work");
  ibtn1->addProcedure(iop1);
  ibtn1->setVisible(True);

  WSCvfbtn* ibtn2 = new WSCvfbtn(_cmd_area1,"pe-ibtn1");
  ibtn2->initialize();
  ibtn2->setInternalObject(True);
  ibtn2->setPropertyV(WSNx,         (short)31                 );
  ibtn2->setPropertyV(WSNy,         (short)1                  );
  ibtn2->setPropertyV(WSNwidth,     (WSCushort)28        );
  ibtn2->setPropertyV(WSNheight,    (WSCushort)28        );
  ibtn2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  ibtn2->setPropertyV(WSNlabelPixmap,WSGFimage(WS_EDIT_PIX));
  ibtn2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  ibtn2->setUserData("WIN EDIT",(void*)this); 
  WSGFsetMargin(ibtn2,0);
  WSGIappBalloonHelp()->registerClient(ibtn2,WSGFgettext("z3:WSSTR Edit trigger"));

  WSCprocedure* iop2 = new WSCprocedure("iop2",WSEV_ACTIVATE);
  iop2->setFunction(_ibtn2_work,"_ibtn2_work");
  ibtn2->addProcedure(iop2);
  ibtn2->setVisible(True);

  WSCvfbtn* ibtn3 = new WSCvfbtn(_cmd_area1,"pe-ibtn1");
  ibtn3->initialize();
  ibtn3->setInternalObject(True);
  ibtn3->setPropertyV(WSNx,         (short)61                 );
  ibtn3->setPropertyV(WSNy,         (short)1                  );
  ibtn3->setPropertyV(WSNwidth,     (WSCushort)28        );
  ibtn3->setPropertyV(WSNheight,    (WSCushort)28        );
  ibtn3->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  ibtn3->setPropertyV(WSNlabelPixmap,WSGFimage(WS_TRASH_PIX));
  ibtn3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  ibtn3->setUserData("WIN EDIT",(void*)this); 
  WSGFsetMargin(ibtn3,0);
  WSGIappBalloonHelp()->registerClient(ibtn3,WSGFgettext("A3:WSSTR Delete trigger"));

  WSCprocedure* iop3 = new WSCprocedure("iop3",WSEV_ACTIVATE);
  iop3->setFunction(_ibtn3_work,"_ibtn3_work");
  ibtn3->addProcedure(iop3);
  ibtn3->setVisible(True);

  _tlbs4 = new WSCvlabel(_cmd_area1,"pe-tlbs4");
  _tlbs4->initialize();
  _tlbs4->setPropertyV(WSNx,     (short)135 );
  _tlbs4->setPropertyV(WSNy,     (short)5 );
  _tlbs4->setPropertyV(WSNwidth, (WSCushort)60 );
  _tlbs4->setPropertyV(WSNheight,(WSCushort)20 );
  _tlbs4->setPropertyV(WSNforeColor,"black" );
  _tlbs4->setPropertyV(WSNlabelString,WS_PEDTITLE2);
  _tlbs4->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _tlbs4->setVisible(True);

  _oname = new WSCvlabel(_cmd_area1,"pe-tlb");
  _oname->initialize();
  _oname->setPropertyV(WSNx,     (short)200 );
  _oname->setPropertyV(WSNy,     (short)4 );
  _oname->setPropertyV(WSNwidth, (WSCushort)100 );
  _oname->setPropertyV(WSNheight,(WSCushort)21 );
  _oname->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _oname->setPropertyV(WSNforeColor,"blue4");
  _oname->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _oname->setVisible(True);

  _list = new WSClist(_cmd_area1,"pe-area2");
  _list->initialize();
  _list->setInternalObject(True);
  _list->setPropertyV(WSNx,     (short)5 );
  _list->setPropertyV(WSNy,     (short)35 );
  _list->setPropertyV(WSNwidth, (WSCushort)(_w - 10));
  _list->setPropertyV(WSNheight,(WSCushort)(_h -35));
//  _list->setPropertyV(WSNworkWidth, (WSCushort)(_w));
//  _list->setPropertyV(WSNworkHeight,(WSCushort)(_h));
  _list->setPropertyV(WSNscrollHeight,(WSCushort)5);
  _list->setPropertyV(WSNhbarVisible,(WSCbool)False);
  _list->setPropertyV(WSNtype,(WSCuchar)WS_VERBOSE);
  _list->setPropertyV(WSNbarValue,"100,250,350");
  _list->setPropertyV(WSNtitleHeight,(WSCuchar)20);
  _list->setPropertyV(WSNtitleString,WSGFgettext("B3:WSSTR Trigger Name,Trigger def,Trigger value,Attribute"));
  _list->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _list->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _list->setPropertyV(WSNreverseSelect,(WSCbool)False);
  _list->setVisible(True);

  _pmenu = new WSCpopupMenu(NULL,"menu");
  _pmenu->initialize();
  _pmenu->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
  _pmenu->setPropertyV(WSNmenuItems,WSGFgettext("C3:WSSTR New:NEW:,Edit:EDIT:,Delete:DEL:"));
  _pmenu->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _pmenu->setEmboss(True);
  _pmenu->setUserData("WIN EDIT",(void*)this); 

  WSCprocedure* pmop = new WSCprocedure("NEW",WSEV_NONE);
  pmop->setFunction(_ibtn1_work,"_ibtn1_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("EDIT",WSEV_NONE);
  pmop->setFunction(_ibtn2_work,"_ibtn2_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("DEL",WSEV_NONE);
  pmop->setFunction(_ibtn3_work,"_ibtn3_work");
  _pmenu->addProcedure(pmop);

  _pmenu->registerClient(_list->getScrFrame());

  _msg = new WSCmessageDialog(NULL,"wl-md");
  _msg->initialize();
  _msg->setPropertyV(WSNx,(short)300);
  _msg->setPropertyV(WSNy,(short)300);
  _msg->setPropertyV(WSNwidth,(WSCushort)300);
  _msg->setPropertyV(WSNheight,(WSCushort)100);
  _msg->setPropertyV(WSNtitleString,"Warring");
  _msg->setPropertyV(WSNmodal,(WSCbool)True);

  //---------- PROCEDURE CREATE DIALOG -------------------- 
  _dialog1 = new WSCbaseDialog(this,"dlg_base");
  _dialog1->initialize();
  _dialog1->setInternalObject(True);
  _dialog1->setPropertyV(WSNx,(short)300);
  _dialog1->setPropertyV(WSNy,(short)300);
  _dialog1->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_WIDTH);
  _dialog1->setPropertyV(WSNheight,(WSCushort)WS_PEDLD_HEIGHT);
  _dialog1->setPropertyV(WSNtitleString,"TriggerCreate");
  _dialog1->setPropertyV(WSNno,(WSCbool)False);
  _dialog1->setUserData("WIN EDIT",(void*)this); 
  WSCprocedure* dop1 = new WSCprocedure("dop1",WSEV_ACTIVATE);
  dop1->setFunction(_dialog_set_work,"_dialog_set_work");
  _dialog1->addProcedure(dop1);
  WSCprocedure* dop11 = new WSCprocedure("dop11",WSEV_RESIZE);
  dop11->setFunction(_dialog1_resize_work,"_dialog1_resize_work");
  _dialog1->addProcedure(dop11);


  _darea1 = new WSCform(_dialog1->getFormObject(),"pe-_darea1");
  _darea1->initialize();
  _darea1->setInternalObject(True);
  _darea1->setPropertyV(WSNx,     (short)1 );
  _darea1->setPropertyV(WSNy,     (short)35 );
  _darea1->setPropertyV(WSNwidth, (WSCushort)(WS_PEDLD_WIDTH -2));
  _darea1->setPropertyV(WSNheight,(WSCushort)(WS_PEDLD_HEIGHT -75));
  _darea1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _darea1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _darea1->setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
  _darea1->setVisible(True);

  WSCvlabel* sp1 = new WSCvlabel(_darea1,"pe-tlb");
  sp1->initialize();
  sp1->setInternalObject(True);
  sp1->setPropertyV(WSNx,     (short)0 );
  sp1->setPropertyV(WSNy,     (short)30 );
  sp1->setPropertyV(WSNwidth, (WSCushort)1280 );
  sp1->setPropertyV(WSNheight,(WSCushort)2 );
  sp1->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  sp1->setVisible(True);

  _if1 = new WSCvlabel(_darea1,"pe-tlb");
  _if1->initialize();
  _if1->setInternalObject(True);
  _if1->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _if1->setPropertyV(WSNy,     (short)5 );
  _if1->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _if1->setPropertyV(WSNheight,(WSCushort)20 );
  _if1->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _if1->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _if1->setVisible(True);

  _if2 = new WSCvifield(_darea1,"pe-tlb");
  _if2->initialize();
  _if2->setInternalObject(True);
  _if2->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _if2->setPropertyV(WSNy,     (short)35 );
  _if2->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _if2->setPropertyV(WSNheight,(WSCushort)20 );
  _if2->setPropertyV(WSNcolumns,(WSCushort)18 );
  _if2->setPropertyV(WSNmaxLength,(WSCushort)32 );
  _if2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _if2->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _if2->setPropertyV(WSNfillSpace,(WSCbool)False);
  _if2->setPropertyV(WSNinterCur,(WSCbool)True);
  _if2->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _if2->setVisible(True);

  _var_if = new WSCvifield(_darea1,"pe-tlb");
  _var_if->initialize();
  _var_if->setInternalObject(True);
  _var_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _var_if->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*1) );
  _var_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _var_if->setPropertyV(WSNheight,(WSCushort)20 );
  _var_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _var_if->setPropertyV(WSNmaxLength,(WSCushort)16 );
  _var_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _var_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _var_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _var_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _var_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _var_if->setVisible(True);

  _value_if = new WSCvifield(_darea1,"pe-tlb");
  _value_if->initialize();
  _value_if->setInternalObject(True);
  _value_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _value_if->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*2) );
  _value_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _value_if->setPropertyV(WSNheight,(WSCushort)20 );
  _value_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _value_if->setPropertyV(WSNmaxLength,(WSCushort)512 );
  _value_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _value_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _value_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _value_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _value_if->setPropertyV(WSNlabelString,"");
  _value_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _value_if->setVisible(True);

  _opt1 = new WSCoption(_darea1,"typeopt");
  _opt1->initialize();
  _opt1->setInternalObject(True);
  _opt1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _opt1->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _opt1->setPropertyV(WSNy,(short)(35 + WS_PEDLD_T*3));
  _opt1->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _opt1->setPropertyV(WSNheight,(WSCushort)20);
  _opt1->setPropertyV(WSNmenuItems,WS_PEDLD_TGRMENU);
  _opt1->setPropertyV(WSNemboss,(WSCbool)True);
  _opt1->setVisible(True);

  WSCvlabel* tlbs1 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs1->initialize();
  tlbs1->setPropertyV(WSNx,     (short)5 );
  tlbs1->setPropertyV(WSNy,     (short)5 );
  tlbs1->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs1->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs1->setPropertyV(WSNforeColor,"black" );
  tlbs1->setPropertyV(WSNlabelString,WS_PEDLDTITLE1);
  tlbs1->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs1->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs1,0);
  tlbs1->setVisible(True);
 
  WSCvlabel* tlbs2 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs2->initialize();
  tlbs2->setPropertyV(WSNx,     (short)5 );
  tlbs2->setPropertyV(WSNy,     (short)35 );
  tlbs2->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs2->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs2->setPropertyV(WSNforeColor,"black" );
  tlbs2->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs2->setPropertyV(WSNlabelString,WS_PEDLDTITLE2);
  tlbs2->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs2,0);
  tlbs2->setVisible(True);
 
  WSCvlabel* tlbs3 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs3->initialize();
  tlbs3->setPropertyV(WSNx,     (short)5 );
  tlbs3->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T) );
  tlbs3->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs3->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs3->setPropertyV(WSNforeColor,"black" );
  tlbs3->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs3->setPropertyV(WSNlabelString,WS_PEDLDTITLE3);
  tlbs3->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs3,0);
  tlbs3->setVisible(True);
 
  WSCvlabel* tlbs4 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs4->initialize();
  tlbs4->setPropertyV(WSNx,     (short)5 );
  tlbs4->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*2) );
  tlbs4->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs4->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs4->setPropertyV(WSNforeColor,"black" );
  tlbs4->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs4->setPropertyV(WSNlabelString,WS_PEDLDTITLE4);
  tlbs4->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs4,0);
  tlbs4->setVisible(True);

  WSCvlabel* tlbs5 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs5->initialize();
  tlbs5->setPropertyV(WSNx,     (short)5 );
  tlbs5->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*3) );
  tlbs5->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs5->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs5->setPropertyV(WSNforeColor,"black" );
  tlbs5->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs5->setPropertyV(WSNlabelString,WS_PEDLDTITLE5);
  tlbs5->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs5,0);
  tlbs5->setVisible(True);

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());

  _adjust(); 
  return WS_NO_ERR;
}

void WSCclassUTrgEditor::setEditClient(WSCbase* client){
//WSMFtrace("WSCclassUTrgEditor::setEditClient\n");
  if (_client != client){
     _client = client;
//WSMFtrace("WSCclassUTrgEditor::setEditClient  dialgo1->setVisible(False)\n");
     _dialog1->setVisible(False);
     updateTriggers();
  }
}

WSCbase* WSCclassUTrgEditor::getEditClient(){
  return _client;
}

void WSCclassUTrgEditor::updateTriggers(){
  _list->delAll();


  WSCbase* client = getEditClient();

  if (client == NULL){
    _oname->setPropertyV(WSNlabelString,"");
    _oname->update();
    _if1->setPropertyV(WSNlabelString,"");
    _if1->update();
    _var_if->setPropertyV(WSNlabelString,"");
    _var_if->update();
    _value_if->setPropertyV(WSNlabelString,"");
    _value_if->update();
    _opt1->setPropertyV(WSNvalue,(long)0);
    _dialog1->setVisible(False);
    return;
  }

  _oname->setPropertyV(WSNlabelString,client->getInstanceName());
  _oname->update();
  _if1->setPropertyV(WSNlabelString,client->getInstanceName());
  _if1->update();
  _dialog1->setVisible(False);


  WSClistData* utrg_list = (WSClistData*)client->getUserData(WS_UTRG_LIST);
  if (utrg_list == NULL){
    utrg_list = new WSClistData();
    client->setUserData(WS_UTRG_LIST,(void*)utrg_list);
  }
  _list->setLabelHeight(20);

  long num = utrg_list->getNum();
  long i;
  for(i=0; i< num; i++){
     utrg_data* utrgdata = (utrg_data*)(*utrg_list)[i];
     WSCstring str;
     str << utrgdata->name.getString() << "," ;
     
     str << utrgdata->vname.getString() << "," << utrgdata->value;
     if (utrgdata->type == 0){
       str << "," << WSGFgettext("f3:WSSTR (Normal)");
     }else{
       str << "," << WSGFgettext("g3:WSSTR (Delete)");
     }
     _list->addItem((char*)str);
     WSCbase* lb = _list->getLabel(-1);
     lb->setPropertyV(WSNmarginLeft,(WSCuchar)5);
  }
  _list->updateList();
  _list->redraw();
}

void WSCclassUTrgEditor::onValueChange(){
  execProcedure(WSEV_VALUE_CH);
}

void WSCclassUTrgEditor::onResize(WSCrect* rect){
  WSCbaseDialog::onResize(rect);
  _adjust();
}

void WSCclassUTrgEditor::_adjust(){
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }
  if (_w > 2){
    _cmd_area1->setPropertyV(WSNwidth,(WSCushort)(_w -2));
  }else{
    _cmd_area1->setPropertyV(WSNwidth,(WSCushort)(1));
  }
  if (_w > 12){
    _list->setPropertyV(WSNwidth,(WSCushort)(_w -12));
  }else{
    _list->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  if (_h +diff > 45){
    _cmd_area1->setPropertyV(WSNheight,(WSCushort)(_h +diff -45));
  }else{
    _cmd_area1->setPropertyV(WSNheight,(WSCushort)(1));
  }

  if (_h +diff > 85){
    _list->setPropertyV(WSNheight,(WSCushort)(_h +diff -85));
  }else{
    _list->setPropertyV(WSNheight,(WSCushort)(1));
  }
}
void WSCclassUTrgEditor::_dialog1_resize_work(WSCbase* obj){
  WSCclassUTrgEditor* op_edit = (WSCclassUTrgEditor*)obj->getUserData("WIN EDIT");

  WSCushort w,h;
  op_edit->_dialog1->getPropertyV(WSNwidth,&w);
  op_edit->_dialog1->getPropertyV(WSNheight,&h);
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }

  if (w > 2){
    op_edit->_darea1->setPropertyV(WSNwidth,(WSCushort)(w -2));
  }else{
    op_edit->_darea1->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  if (h+diff > 45){
    op_edit->_darea1->setPropertyV(WSNheight,(WSCushort)(h+diff -45));
  }else{
    op_edit->_darea1->setPropertyV(WSNheight,(WSCushort)(1));
  }

}

void WSCclassUTrgEditor::onGuiPolicyChange(long policy){
  if (_cmd_area1 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_GRADATION){
      _opt1->setProperty(WSNgradation,WS_GR_LT_RB);
    }else{
      _opt1->setProperty(WSNgradation,WS_GR_NONE);
    }
    if (policy & WS_POLICY_ORIGINAL){
      _cmd_area1->setProperty(WSNy,5);
      _cmd_area1->setProperty(WSNshadowThickness,1);
      _darea1->setProperty(WSNy,5);
      _darea1->setProperty(WSNshadowThickness,1);
      _list->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else
    if (policy & WS_POLICY_WINDOWS){
      _cmd_area1->setProperty(WSNy,0);
      _cmd_area1->setProperty(WSNshadowThickness,0);
      _darea1->setProperty(WSNy,0);
      _darea1->setProperty(WSNshadowThickness,0);
      _list->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    }
    
    _adjust();
  }
}

