//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <advance/WSCprocessBox.h>
#include <WSCclassInformation.h>
#include <WSCscrForm.h>
#include <WSCvlabel.h>
#include <WSCvifield.h>
#include <WSDmessage.h>
#include <WSDfileSystem.h>
#include <WSCfontSet.h>
#ifndef _WSWINCE
#include <signal.h>
#endif
#include <WSCtextField.h>
#include <WSCbaseList.h>
#include <WSDexecute.h>
#include <WSClocaleSet.h>

WSMFguiClassInitialize(WSCprocessBox,WSCmessageBox);

WSCprocessBox::WSCprocessBox(WSCbase* base,char* objname):
                WSCmessageBox(base,objname){

  _file_name = WSGFstrdup("");
  _dir_name = WSGFstrdup("");
#if 0
  _pid = 0;
#endif
  _execute = WSDexecute::getNewInstance();
  _execute->setReceiveProc(_receive_proc,this);
  _started = 0;

  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNfileName,char*,_file_name,WSSfileName);
    WSMFpropertyCreate(WSNdirName,char*,_dir_name,WSSdirName);
  WSMFpropertyCreateEnd
}

WSMFproperty( WSCprocessBox, WSNfileName, char*, _file_name, WSGFstrdup(""));
WSMFproperty( WSCprocessBox, WSNdirName, char*, _dir_name, WSGFstrdup(""));

void WSCprocessBox::setWorkWSNfileName(char* /*data*/){ }
void WSCprocessBox::getWorkWSNfileName(char** /*data*/){ }
void WSCprocessBox::setWorkWSNdirName(char* /*data*/){ }
void WSCprocessBox::getWorkWSNdirName(char** /*data*/){ }

WSCprocessBox::~WSCprocessBox(){
#if 0
  delete _m1;
  delete _m2;
  delete _m3;
  delete _m4;
#endif
  delete _execute;
  delete _file_name;
  delete _dir_name;
}
long WSCprocessBox::initialize(){
#if 0
  _m1 = WSDmessage::getNewInstance();
  _m1->setupMessage("WL-SBYTES",_cb1,(void*)this);
  _m2 = WSDmessage::getNewInstance();
  _m2->setupMessage("WL-LINE",_cb2,(void*)this);
  _m3 = WSDmessage::getNewInstance();
  _m3->setupMessage("WL-LINE-END",_cb3,(void*)this);
  _m4 = WSDmessage::getNewInstance();
  _m4->setupMessage("WL-END",_cb4,(void*)this);
#endif
  return WSCmessageBox::initialize();
}
void WSCprocessBox::_receive_proc(WSDexecute* exec){
  WSCprocessBox* _this = (WSCprocessBox*)exec->getUserData(); 
  char data[2048];
  char* ret = exec->gets(data,sizeof(data));
  WSCstring tmp;
  tmp.setString(data,WSGIappLocaleSet()->getSystemLocaleEncoding());
//printf("WSCprocessBox::_receive_proc #%s#\n",data);

  if (ret > 0){
    WSCstring str(_this->_textf->getString());
    str << tmp.getString();
    _this->_textf->addString(tmp.getString());
    delete _this->_label_string;
    _this->_label_string = WSGFstrdup((char*)str);
    long lines = _this->_textf->getLines();
    _this->_textf->setBottomLine(lines);
  }else{
    WSCstring str(_this->_textf->getProperty(WSNlabelString));
    str << WSGFgettext("B3:WSSTR done.\n");
    _this->_textf->getTextFrame()->setPropertyV(WSNlabelString,(char*)str);
    long lines = _this->_textf->getLines();
    _this->_textf->setBottomLine(lines);

    delete _this->_label_string;
    _this->_label_string = WSGFstrdup((char*)str);
    _this->_started = 0;
    _this->setPropertyV(WSNokString,"OK");
    _this->_execute->killProcess();
  }
}

long WSCprocessBox::start(){
  if (_started != 0){
    return WS_OK;
  }
  if (_execute->getHandle() != NULL){
    stop();
  }
  if (!strcmp(_file_name,"")){
    return WS_ERR;
  }
  _textf->setProperty(WSNhbarValue,0);
  _textf->setProperty(WSNvbarValue,0);
  _execute->setCurrentDir((char*)_dir_name);
  _execute->execute((char*)_file_name,WS_EXEC_RD);
  _started = 1;
  setPropertyV(WSNokString,WSGFgettext("C3:WSSTR Break"));
  return WS_OK;
}
long WSCprocessBox::stop(){
  if (_execute->getHandle() != NULL){
    _execute->killProcess();
    WSCstring str(_textf->getProperty(WSNlabelString));
    str << WSGFgettext("N3:WSSTR broken.");
    _textf->getTextFrame()->setPropertyV(WSNlabelString,(char*)str);
    delete _label_string;
    _label_string = WSGFstrdup((char*)str);
  }
  if (_started == 0){
    return WS_OK;
  }
  _started = 0;
  setPropertyV(WSNokString,"OK");
  return WS_OK;
}
void WSCprocessBox::onActivate(){
  if (getStatus() == WS_DIALOG_OK){
    if (_started == 0){
      _popuped = 0;
      setVisible(False);
    }else{
      stop();
    }
  }
}
void* WSCprocessBox::getHandle(){
  if (_execute == NULL){
    return NULL;
  }
  return _execute->getHandle();
}
