//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <advance/WSCpropertyEditor.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCscrForm.h>
#include <WSCvlabel.h>
#include <WSCoption.h>
#include <WSCvlabel.h>
#include <WSCvifield.h>
#include <WSCvbtn.h>
#include <WSDkeyboard.h>
#include <WSCimageSet.h>
#include <WSCvlabel.h>
#include <WSCcolorSet.h>
#include <WSCvtoggle.h>
#include <WSCmessageDialog.h>
#include <WSCballoonHelp.h>
#include <WSCbaseList.h>
#include <WSCscrFrame.h>
#include <advance/WSCcolorSelect.h>
#include <WSCfileSelect.h>
#include <WSDappDev.h>
#include <WSClocaleSet.h>
#include <WSCvfbtn.h>
#include <WSCdialog.h>
#include <WSCtextField.h>
#include <WSCvkslabel.h>
#include <WSDtimer.h>

#define WS_WARNING_STR  WSGFgettext("L3:WSSTR Warning")

//#define WS_PROP_PIX    WS_PIXMAP_DIR  "bi4.xpm"
#define WS_DIALOG_PIX1  WS_PIXMAP_DIR "bi23.xpm"


#define WS_PEBGCOLOR1 "#CCD5CC"
//#define WS_PETITLE    "PropObjEdit"
//#define WS_PETITLE2   "NAME:"
//#define WS_PETITLE3   "CLASS:"
//#define WS_PELB_X1     3
//#define WS_PELB_W1     160
//#define WS_PELB_X2     165
//#define WS_PELB_W2     120
//#define WS_PELB_W2C    60
//#define WS_PELB_X3     225
//#define WS_PELB_W3     60
#define WS_PELB_OFY    5
#define WS_PELB_H      17
#define WS_PELB_T      18
//#define WS_PELB_W      335
//#define WS_PELB_HEIGHT 380
//#define WS_PELB_COL    0
//#define WS_PELB_COL2   0

#define WS_COLOR_PROP 1
#define WS_TOP_SHADOW_COLOR 2
#define WS_BACK_COLOR 3
#define WS_BOTTOM_SHADOW_COLOR 4

static char* prop_order[] = {
WSNname,
WSNuserString,
WSNuserValue,
WSNx,
WSNy,
WSNwidth,
WSNheight,
WSNshadowType,
WSNshadowThickness,
WSNforeColor,
WSNbackColor,
WSNtopShadowColor,
WSNbottomShadowColor,
WSNlabelString,
WSNtitleString,
WSNfont,
WSNmaxLength,
WSNcolumns,
WSNlabelPixmap,
WSNalignmentV,
WSNalignmentH,
WSNmargin,
WSNmarginTop,
WSNmarginBottom,
WSNmarginLeft,
WSNmarginRight,
WSNblinkColor,
WSNblinkPixmap,
WSNblinkRate,
WSNtwinBlink,
WSNblinkFlag,
WSNblinkRefreshing,
WSNvis,
WSNdet,
WSNanchorTop,
WSNanchorTopFlag,
WSNanchorBottom,
WSNanchorBottomFlag,
WSNanchorLeft,
WSNanchorLeftFlag,
WSNanchorRight,
WSNanchorRightFlag,
WSNseparator,
NULL
};

WSMFguiClassInitialize(WSCpropertyEditor,WSCscrForm);

void (*WSCpropertyEditor::_ch_name_handler)(WSCbase*) = NULL;
void WSCpropertyEditor::_exec_change_name_handler(WSCbase* this_instance){
   if (_ch_name_handler != NULL){
     _ch_name_handler(this_instance);
   }
}

void WSCpropertyEditor::setChangeNameHandler( void(* hd)(WSCbase*) ){
  _ch_name_handler = hd;
}

void WSCpropertyEditor::_if_focus_on(WSCbase* obj){
  if (obj->getFocus() == False){
    obj->execProcedure(WSEV_ACTIVATE);
    return;
  }
  WSCbase* parent = obj->getParent();
  if (parent->existProperty(WSNvbarValue) != False){
    short y;
    obj->getPropertyV(WSNy,&y);
    WSCushort ph;
    WSCushort pv;
    parent->getPropertyV(WSNheight,&ph);
    parent->getPropertyV(WSNvbarValue,&pv);
    if (pv +20> y){
      if (y > 30){
        parent->setPropertyV(WSNvbarValue,(WSCushort)(y -30));
      }else{
        parent->setPropertyV(WSNvbarValue,(WSCushort)(0));
      }
      return;
    }
    if (pv + ph < y+30){
      parent->setPropertyV(WSNvbarValue,(WSCushort)(y -ph +50));
      return;
    }
    return;
  }
}


WSCpropertyEditor::WSCpropertyEditor(WSCbase* base,char* objname):
            WSCscrForm(base,objname){
  _client = NULL;
  _voidp_client = NULL;
  _hbar_visible = False;
  _update_sequence = False;

  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNclient,void*, _voidp_client,WSSclient );
    WSMFpropertyDelete(WSNhbarVisible);
    WSMFaddTrigger(WSEV_VALUE_CH     );
    WSMFaddTrigger(WSEV_ACTIVATE    );
  WSMFpropertyCreateEnd

}

WSMFproperty( WSCpropertyEditor, WSNclient, void*,   _voidp_client,   NULL);

void WSCpropertyEditor::setWorkWSNclient(void* data){
  WSCbase* client = (WSCbase*)data;

//if (client != NULL){
//printf("WSCpropertyEditor::setWorkWSNclient %s\n",client->getInstanceName());
//}else{
//printf("WSCpropertyEditor::setWorkWSNclient NULL\n");
//}

  if (_client != client &&
      (WSGIappObjectList()->existInstance(client) || client== NULL)){
//printf("WSCpropertyEditor::setWorkWSNclient here! cl=0x%x\n",client);
    _update_sequence = True;
    _client = client;
//    execEventProc(WSEV_VALUE_CH,NULL);
    newdial_000->setVisible(False);
    onValueChange();
    updateProperties();
    WSCbase* old = (WSCbase*)getUserData("PCLIENT");
    setUserData("PCLIENT",client);
    if (old != client && old != NULL){
      old->setPropertyEditExecute(False);
    }
  }
}

void WSCpropertyEditor::getWorkWSNclient(void** data){
  *data = (void*)_client;
}

void WSCpropertyEditor::onActivate(){
  execProcedure(WSEV_ACTIVATE);
}
void WSCpropertyEditor::onValueChange(){
  execProcedure(WSEV_VALUE_CH);
}

WSCpropertyEditor::~WSCpropertyEditor(){
}



void WSCpropertyEditor::_set_cbtn_work(WSCbase* obj){
  WSCpropertyEditor* pe = (WSCpropertyEditor*)obj->getUserData("PROP EDIT");
  long val = (long)obj->getUserData("NO");
  long ttype = (long)obj->getUserData("COLOR_TYPE");
  if (ttype == 0){
    WSGIappFileSelect()->setPropertyV(WSNmaskFileName,"");
    WSGIappFileSelect()->setPropertyV(WSNfileName,"");
    long ret = WSGIappFileSelect()->popup();
    if (ret != WS_DIALOG_OK){
      return;
    }
    WSCbase* ifd = (WSCbase*)pe->_if_list[val];
    if (ifd != NULL){
      ifd->setPropertyV(WSNlabelString,WSGIappFileSelect()->getFileName());
      pe->setPropertyDataToClient();
    }
    return;
  }


  long ret = WSGIappColorSelect()->popup();
  if (ret != WS_DIALOG_OK){
    return;
  }


  if (pe != NULL){
    WSClistData* lblist = &pe->_label_list;
    long num = lblist->getNum();
    long i;
    for(i=0; i<num; i++){
      WSCbase* lb = (WSCbase*)(*lblist)[i];
      long type = (long)lb->getUserData("COLOR_TYPE");
      if (type == WS_TOP_SHADOW_COLOR && val != i && ttype == WS_BACK_COLOR){
        WSCbase* ifd = (WSCbase*)pe->_if_list[i];
        WSCbase* cifd = (WSCbase*)pe->_cif_list[i];
        ifd->setPropertyV(WSNlabelString,WSGIappColorSelect()->getSelectTopShadowColor());
        ifd->update();
        cifd->setPropertyV(WSNbackColor,WSGIappColorSelect()->getSelectTopShadowColor());
        cifd->update();
      }else
      if (type == WS_BOTTOM_SHADOW_COLOR && val != i && ttype == WS_BACK_COLOR){
        WSCbase* ifd = (WSCbase*)pe->_if_list[i];
        WSCbase* cifd = (WSCbase*)pe->_cif_list[i];
        ifd->setPropertyV(WSNlabelString,WSGIappColorSelect()->getSelectBottomShadowColor());
        ifd->update();
        cifd->setPropertyV(WSNbackColor,WSGIappColorSelect()->getSelectBottomShadowColor());
        cifd->update();
      }else if (val == i){
        WSCbase* ifd = (WSCbase*)pe->_if_list[i];
        WSCbase* cifd = (WSCbase*)pe->_cif_list[i];
        ifd->setPropertyV(WSNlabelString,WSGIappColorSelect()->getSelectColor());
        ifd->update();
        cifd->setPropertyV(WSNbackColor,WSGIappColorSelect()->getSelectColor());
        cifd->update();
      }
    }
  }
  pe->setPropertyDataToClient();

#if 0
  if (prop_edit->_color_select != NULL){
    prop_edit->_color_select->setPropertyV(WSNreplyHandler,(void*)_color_set_work);
    prop_edit->_color_select->setPropertyV(WSNuserValue,(long)obj);
    prop_edit->_color_select->setVisible(True);
  }
#endif
}
void WSCpropertyEditor::_cset_btn_work(WSCbase* obj){
  long val = (long)obj->getUserData("COLOR_TYPE");
  long no = (long)obj->getUserData("NO");

  if (val != 0){
    WSCpropertyEditor* prop_edit = (WSCpropertyEditor*)obj->getUserData("PROP EDIT");
    WSCbase* cbtn = (WSCbase*)prop_edit->_cif_list[no];
    if (cbtn != NULL){
      WSCstring cname(obj->getProperty(WSNlabelString));
      cname.delTailSpace();
      if (atoi(cname.getString()) != 0){
        cbtn->setPropertyV( WSNbackColor,(short)atoi(cname.getString()) );
        cbtn->update();
      }else{
        cbtn->setPropertyV( WSNbackColor,cname.getString() );
        cbtn->update();
      }

    }
  }
}

void WSCpropertyEditor::_set_btn_work(WSCbase* obj){
//WSMFtrace("WSCpropertyEditor::_set_btn_work  -------------\n");
  WSCpropertyEditor* prop_edit = (WSCpropertyEditor*)obj->getUserData("PROP EDIT");
  prop_edit->setPropertyDataToClient();
}

long WSCpropertyEditor::initialize(){
  WSCscrForm::initialize();
  setProperty(WSNscrollHeight,WS_PELB_T);

  //ٹ
  _msg = new WSCmessageDialog(NULL,(WSCstring)"pe-md" + getInstanceName());
  _msg->initialize();
  _msg->setPropertyV(WSNx,(short)300);
  _msg->setPropertyV(WSNy,(short)300);
  _msg->setPropertyV(WSNwidth,(WSCushort)300);
  _msg->setPropertyV(WSNheight,(WSCushort)100);
  _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
  _msg->setPropertyV(WSNmodal,(WSCbool)True);


    newdial_000 = new  WSCdialog(NULL,"newdial_000");
    newdial_000->initialize();
    newdial_000->setPropertyV(WSNno,(WSCbool)0);
    newdial_000->setPropertyV(WSNname,"newdial_000");
    newdial_000->setPropertyV(WSNtitleString,WSGFgettext("N3:WSSTR PropertyEditor"));
    newdial_000->setPropertyV(WSNx,(short)48);
    newdial_000->setPropertyV(WSNy,(short)460);
    newdial_000->setPropertyV(WSNwidth,(unsigned short)588);
    newdial_000->setPropertyV(WSNheight,(unsigned short)176);
    newdial_000->setPropertyV(WSNlabelPixmap,WS_PIXMAP_DIR "edit2.xpm");
    newdial_000->setUserData("PROP EDIT",(void*)this);

    WSCprocedure* op1 = new WSCprocedure("set_prop",WSEV_ACTIVATE);
    op1->setFunction(_set_prop_work,"_set_prop_work");
    newdial_000->addProcedure(op1);

    newvlab_001 = new  WSCvlabel(newdial_000,"newvlab_001");
    newvlab_001->initialize();
    newvlab_001->setPropertyV(WSNlabelString,WSGFgettext("N3:WSSTR PropertyName:"));
    newvlab_001->setPropertyV(WSNname,"newvlab_001");
    newvlab_001->setPropertyV(WSNvis,(WSCbool)1);
    newvlab_001->setPropertyV(WSNx,(short)5);
    newvlab_001->setPropertyV(WSNy,(short)5);
    newvlab_001->setPropertyV(WSNwidth,(unsigned short)150);
    newvlab_001->setPropertyV(WSNheight,(unsigned short)20);

    newvifi_002 = new  WSCvkslabel(newdial_000,"newvifi_002");
    newvifi_002->initialize();
    newvifi_002->setPropertyV(WSNshadowType,(char)1);
    newvifi_002->setPropertyV(WSNshadowThickness,(unsigned char)1);
    newvifi_002->setPropertyV(WSNbackColor,"DEF13");
    newvifi_002->setPropertyV(WSNname,"newvifi_002");
    newvifi_002->setPropertyV(WSNvis,(WSCbool)1);
//    newvifi_002->setPropertyV(WSNdet,(WSCbool)0);
    newvifi_002->setPropertyV(WSNx,(short)160);
    newvifi_002->setPropertyV(WSNy,(short)5);
    newvifi_002->setPropertyV(WSNwidth,(unsigned short)423);
    newvifi_002->setPropertyV(WSNheight,(unsigned short)20);
    newvifi_002->setPropertyV(WSNanchorLeft,(unsigned short)160);
    newvifi_002->setPropertyV(WSNanchorRight,(unsigned short)5);
    newvifi_002->setPropertyV(WSNanchorLeftFlag,(WSCbool)1);
    newvifi_002->setPropertyV(WSNanchorRightFlag,(WSCbool)1);

    newvlab_004 = new  WSCvlabel(newdial_000,"newvlab_004");
    newvlab_004->initialize();
    newvlab_004->setPropertyV(WSNlabelString,WSGFgettext("N3:WSSTR PropertyType:"));
    newvlab_004->setPropertyV(WSNname,"newvlab_004");
    newvlab_004->setPropertyV(WSNvis,(WSCbool)1);
    newvlab_004->setPropertyV(WSNx,(short)5);
    newvlab_004->setPropertyV(WSNy,(short)30);
    newvlab_004->setPropertyV(WSNwidth,(unsigned short)150);
    newvlab_004->setPropertyV(WSNheight,(unsigned short)20);

    newvifi_005 = new  WSCvkslabel(newdial_000,"newvifi_005");
    newvifi_005->initialize();
    newvifi_005->setPropertyV(WSNshadowType,(char)1);
    newvifi_005->setPropertyV(WSNshadowThickness,(unsigned char)1);
    newvifi_005->setPropertyV(WSNbackColor,"DEF13");
    newvifi_005->setPropertyV(WSNname,"newvifi_005");
    newvifi_005->setPropertyV(WSNvis,(WSCbool)1);
//    newvifi_005->setPropertyV(WSNdet,(WSCbool)0);
    newvifi_005->setPropertyV(WSNx,(short)160);
    newvifi_005->setPropertyV(WSNy,(short)30);
    newvifi_005->setPropertyV(WSNwidth,(unsigned short)423);
    newvifi_005->setPropertyV(WSNheight,(unsigned short)20);
    newvifi_005->setPropertyV(WSNanchorLeft,(unsigned short)160);
    newvifi_005->setPropertyV(WSNanchorRight,(unsigned short)5);
    newvifi_005->setPropertyV(WSNanchorLeftFlag,(WSCbool)1);
    newvifi_005->setPropertyV(WSNanchorRightFlag,(WSCbool)1);

    newvlab_006 = new  WSCvlabel(newdial_000,"newvlab_006");
    newvlab_006->initialize();
    newvlab_006->setPropertyV(WSNlabelString,WSGFgettext("N3:WSSTR PropertyValue:"));
    newvlab_006->setPropertyV(WSNname,"newvlab_006");
    newvlab_006->setPropertyV(WSNvis,(WSCbool)1);
    newvlab_006->setPropertyV(WSNx,(short)5);
    newvlab_006->setPropertyV(WSNy,(short)55);
    newvlab_006->setPropertyV(WSNwidth,(unsigned short)150);
    newvlab_006->setPropertyV(WSNheight,(unsigned short)20);

    newtext_007 = new  WSCtextField(newdial_000,"newtext_007");
    newtext_007->initialize();
    newtext_007->setPropertyV(WSNname,"newtext_007");
    newtext_007->setPropertyV(WSNx,(short)160);
    newtext_007->setPropertyV(WSNy,(short)55);
    newtext_007->setPropertyV(WSNwidth,(unsigned short)423);
    newtext_007->setPropertyV(WSNheight,(unsigned short)71);
    newtext_007->setPropertyV(WSNvis,(WSCbool)1);
    newtext_007->setPropertyV(WSNbackColor,newdial_000->getProperty(WSNbackColor));
    newtext_007->setPropertyV(WSNanchorTop,(unsigned short)55);
    newtext_007->setPropertyV(WSNanchorBottom,(unsigned short)50);
    newtext_007->setPropertyV(WSNanchorLeft,(unsigned short)160);
    newtext_007->setPropertyV(WSNanchorRight,(unsigned short)5);
    newtext_007->setPropertyV(WSNanchorTopFlag,(WSCbool)1);
    newtext_007->setPropertyV(WSNanchorBottomFlag,(WSCbool)1);
    newtext_007->setPropertyV(WSNanchorLeftFlag,(WSCbool)1);
    newtext_007->setPropertyV(WSNanchorRightFlag,(WSCbool)1);

    newopti_008 = new  WSCoption(newdial_000,"newopti_008");
    newopti_008->initialize();
    newopti_008->setPropertyV(WSNshadowThickness,(unsigned char)1);
    newopti_008->setPropertyV(WSNname,"newopti_008");
    newopti_008->setPropertyV(WSNvis,(WSCbool)1);
    newopti_008->setPropertyV(WSNx,(short)160);
    newopti_008->setPropertyV(WSNy,(short)55);
    newopti_008->setPropertyV(WSNwidth,(unsigned short)250);
    newopti_008->setPropertyV(WSNheight,(unsigned short)20);

//  WSGIappObjectList()->addEvent(this,WSEV_GUI_POLICY_CH);

  return WS_NO_ERR;
}
void WSCpropertyEditor::_delay_update_work(WSCuchar clk,void* ptr){
  WSCpropertyEditor* prope = (WSCpropertyEditor*)ptr;
  prope->updateProperties();
  prope->setUserData("lb-update",(void*)0);
}
void WSCpropertyEditor::setWorkWSNwidth(WSCushort data){
  WSCscrForm::setWorkWSNwidth(data);
  if (data > _work_width ){
    setPropertyV(WSNworkWidth,(WSCushort)(data+256));
  }else if (data + 256 < _work_width){
    setPropertyV(WSNworkWidth,(WSCushort)(data));
  }
  long fl = (long)getUserData("lb-update");
  if (fl == 0){
    setUserData("lb-update",(void*)1);
    WSGIappTimer()->addTriggerProc(_delay_update_work,WS250MS,this);
  }
//  updateProperties();
}

void WSCpropertyEditor::setWorkWSNheight(WSCushort data){
  WSCscrForm::setWorkWSNheight(data);
}

void WSCpropertyEditor::_sort_property(WSClistData* dest,WSClistData* src){
   WSClistData  tmp;
   long num = src->getNum();
   long i;
   for(i=0; i<num; i++){
     void* data = (*src)[i];
     tmp.add(data);
   }

   long j=0;
   while(1){
     if (tmp.getNum() == 0){
       break;
     }
     if (prop_order[j] == NULL){
       break;
     }
     num = tmp.getNum();
     for(i=0; i< num; i++){
       WSCproperty* prop = (WSCproperty*)tmp[i];
       if (!strcmp(prop->getPropObjName(),prop_order[j])){
         dest->add((void*)prop);
         tmp.delPos(i);
         break;
       }
     }
     j++;
   }

   num = tmp.getNum();
   for(i=0; i<num; i++){
     void* data = tmp[i];
     dest->add(data);
   }

}

void WSCpropertyEditor::updateProperties(){
  long i;
  long num;
  WSCbase* client = _client;
  if (client == NULL){
    long num = _label_list.getNum();
    for(i = 0; i < num; i++){
      WSCbase* lb = (WSCbase*)_label_list[i];
      WSCbase* ifd = (WSCbase*)_if_list[i];
      WSCbase* cifd = (WSCbase*)_cif_list[i];
      WSCbase* opt = (WSCbase*)_option_list[i];
      lb->setVisible(False);
      ifd->setVisible(False);
      cifd->setVisible(False);
      opt->setVisible(False);
    }
    _scr_area->redraw();
    return;
  }
  _scr_area->setVisible(False);

  if (client->getParent() == NULL){
    client->setUserData(WS_EXT_VAR,(void*)1);
  }

  long prop_count = 0;
  WSCclassInformation* inf = client->getClassInformation();
  WSCclassInformation* inf2 = NULL;
  if (client->getPropertyInheritChild() != NULL){
    inf2 = client->getPropertyInheritChild()->getClassInformation();
  }

  WSCproperty* prop;
  WSCproperty* tmp;
  WSClistData property_list1;
  WSGFgetAllPropertyList(client,&property_list1);

  WSClistData property_list;
  _sort_property(&property_list,&property_list1);

  WSCushort adjustbar =30;
  if (_h > _work_height){
    adjustbar = 0;
  }
  WSCushort lbw = 1;
  short ifdx = 1;
  if (_w > 50){
    lbw = (_w - 30)/2 -5;
  }
  if (_w > 20){
    ifdx = (_w - 30)/2 + 5;
  }

  _update_sequence = True;
  num = property_list.getNum();
  for(i = 0; i < num; i++){
    tmp = (WSCproperty*)property_list[i];
    WSCbool fl = inf->getPropObj(tmp->getPropObjName(),&prop);
    if (fl == False && inf2 != NULL){
      fl = inf2->getPropObj(tmp->getPropObjName(),&prop);
    }

    //is it deleted property?
    if (client->existProperty(tmp->getPropObjName()) == False){
      continue;
    }


    if (fl != False){
      if (tmp->getNotUse() == False && tmp->getBuilderVisible() != False &&
                                         tmp->getDefaultValueChange() == False){
        WSCbase* label = NULL;
        if (_label_list.getNum() > prop_count){
          label = (WSCbase*)_label_list[prop_count];
        }else{
//          WSCbase* newlabel = new WSCvlabel(this,"plb");
          WSCbase* newlabel = new WSCvfbtn(this,"plb");
          newlabel->initialize();
          newlabel->setInternalObject(True);
          _label_list.add(newlabel);
          label = newlabel;
          label->setPropertyV(WSNfont,(WSCuchar)8);
          label->setPropertyV(WSNx,(short)5);
          label->setPropertyV(WSNforeColor,WSGFcolor("black"));
          label->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
          label->setPropertyV(WSNmaxLength,(WSCushort)64);
//          label->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
          label->setProperty(WSNshadowThickness,1);
          label->setProperty(WSNbackColor,_work_back_color);
          label->setPropertyV(WSNheight,(WSCushort)WS_PELB_H );
          WSGFsetMargin(label,0);
          WSGIappBalloonHelp()->registerClient(label,"");
          label->setUserData("PROP EDIT",(void*)this);
          label->setUserData("NO",(void*)prop_count);

          WSCprocedure* op1 = new WSCprocedure("popup_prop",WSEV_ACTIVATE);
          op1->setFunction(_popup_prop_work,"_popup_prop_work");
          label->addProcedure(op1);
        }
        label->setPropertyV(WSNwidth,(WSCushort)lbw);
        label->setPropertyV(WSNy,(short)(WS_PELB_OFY + WS_PELB_T * prop_count));

        if (!strcmp(tmp->getBuilderTitle(),"")){
          label->setPropertyV(WSNlabelString,WSGFgettext("m3:WSSTR No-name"));
        }else{
          label->setPropertyV(WSNlabelString,tmp->getBuilderTitle());
        }
        label->setPropertyV(WSNuserValue,(long)tmp);

        char* bhtitle = (char*)label->getUserData("BH-TITLE");
        if (bhtitle != NULL){
          delete bhtitle;
        }
        char propname[128];
        sprintf(propname,WSGFgettext("n3:WSSTR Name:WSN%s  Type:%s"),
                    tmp->getPropObjName(), tmp->getPropObjTypeName());

        label->setUserData("WSBH-TITLE",(void*)WSGFstrdup(propname));
        label->setVisible(True);
        label->redraw();
        char** labels;
        char** pdata;
        tmp->getBuilderSelectValues(&labels,&pdata);

        WSCbase* ifd = NULL;
        if (_if_list.getNum() > prop_count){
          ifd = (WSCbase*)_if_list[prop_count];
        }else{
          WSCbase* newifd = new WSCvifield(this,"pif");
          newifd->initialize();
          newifd->setInternalObject(True);
          newifd->setVisible(False);
          _if_list.add((void*)newifd);
          ifd = newifd;
          ifd->setPropertyV(WSNfont,(WSCuchar)8);
//          ifd->setPropertyV(WSNforeColor,WSGFcolor("black"));
//          ifd->setPropertyV(WSNbackColor,WSGFcolor("gray85"));
//          ifd->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//          ifd->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray65"));
          ifd->setPropertyV(WSNenableFocusMove,(WSCbool)True);
          ifd->setProperty(WSNreturnKeyFocus,True);
          ifd->setPropertyV(WSNshadowType,WS_SHADOW_IN);
          ifd->setPropertyV(WSNshadowThickness,(WSCuchar)1);
          ifd->setPropertyV(WSNmaxLength,(WSCushort)512);
          ifd->setPropertyV(WSNheight,(WSCushort)WS_PELB_H);
          ifd->setUserData("PROP EDIT",(void*)this);
          ifd->setUserData("NO",(void*)prop_count);
          WSGFsetMargin(ifd,0);

          WSCprocedure* op1 = new WSCprocedure("op1",WSEV_ACTIVATE);
          op1->setFunction(_cset_btn_work,"_cset_btn_work");
          ifd->addProcedure(op1);

          WSCprocedure* op2 = new WSCprocedure("op2",WSEV_ACTIVATE);
          op2->setFunction(_set_btn_work,"_set_btn_work");
          ifd->addProcedure(op2);

          WSCprocedure* opif2 = new WSCprocedure("opif-fon",WSEV_FOCUS_CH);
          opif2->setFunction(_if_focus_on,"_if_focus_on");
          ifd->addProcedure(opif2);
        }

        ifd->setPropertyV(WSNx,(short)ifdx);
        ifd->setPropertyV(WSNcolumns,(WSCushort)0);
        ifd->setPropertyV(WSNwidth,(WSCushort)lbw);
        ifd->setPropertyV(WSNy,(short)(WS_PELB_OFY + WS_PELB_T * prop_count));

        WSCbase* opt = NULL;
        if (_option_list.getNum() > prop_count){
          opt = (WSCbase*)_option_list[prop_count];
        }else{
          WSCbase* newopt = new WSCoption(this,"popt");
          newopt->initialize();
          newopt->setInternalObject(True);
          newopt->setVisible(False);
          _option_list.add((void*)newopt);
          opt = newopt;
          opt->setPropertyV(WSNfont,(WSCuchar)8);
//          opt->setPropertyV(WSNforeColor,WSGFcolor("black"));
//          opt->setPropertyV(WSNbackColor,WSGFcolor("gray85"));
//          opt->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//          opt->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray65"));
//          opt->setPropertyV(WSNshadowType,WS_SHADOW_OUT);
          opt->setPropertyV(WSNshadowThickness,(WSCuchar)1);
          opt->setPropertyV(WSNheight,(WSCushort)WS_PELB_H);
//          opt->setPropertyV(WSNlabelPixmap,WS_BTN2_PIX);
          if (WSGIappDev()->getGuiPolicy() & WS_POLICY_GRADATION){
            opt->setProperty(WSNgradation,WS_GR_LT_RB);
          }else{
            opt->setProperty(WSNgradation,WS_GR_NONE);
          }
          opt->setUserData("PROP EDIT",(void*)this);
          WSCprocedure* op = new WSCprocedure("setvalue",WSEV_ACTIVATE);
          op->setFunction(_set_btn_work,"_set_btn_work");
          opt->addProcedure(op);

        }
        opt->setPropertyV(WSNx,(short)ifdx);
        opt->setPropertyV(WSNy,(short)(WS_PELB_OFY + WS_PELB_T * prop_count));
        opt->setPropertyV(WSNwidth,(WSCushort)lbw);
        WSGFsetMargin(opt,0);

        WSCbase* cifd = NULL;
        if (_cif_list.getNum() > prop_count){
           cifd = (WSCbase*)_cif_list[prop_count];
        }else{
          WSCbase* newbtn = new WSCvbtn(this,"pif");
          newbtn->initialize();
          newbtn->setInternalObject(True);
          newbtn->setVisible(False);
          _cif_list.add((void*)newbtn);
          cifd = newbtn;
          cifd->setPropertyV(WSNfont,(WSCuchar)8);
//          cifd->setPropertyV(WSNforeColor,WSGFcolor("black"));
//          cifd->setPropertyV(WSNbackColor,WSGFcolor("gray85"));
//          cifd->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//          cifd->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray65"));
          cifd->setPropertyV(WSNenableFocusMove,(WSCbool)True);
          cifd->setPropertyV(WSNshadowThickness,(WSCuchar)1);
          cifd->setPropertyV(WSNmaxLength,(WSCushort)512);
          cifd->setPropertyV(WSNheight,(WSCushort)WS_PELB_H);
          cifd->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
          cifd->setUserData("PROP EDIT",(void*)this);
          cifd->setUserData("NO",(void*)prop_count);
          WSGFsetMargin(cifd,0);

          WSCprocedure* cop = new WSCprocedure("cop",WSEV_ACTIVATE);
          cop->setFunction(_set_cbtn_work,"_set_cbtn_work");
          cifd->addProcedure(cop);
        }
        cifd->setPropertyV(WSNy,(short)(WS_PELB_OFY + WS_PELB_T * prop_count));

        if (!strcmp(tmp->getPropObjName(),WSNbackColor)){
          label->setUserData("COLOR_TYPE",(void*)WS_BACK_COLOR);
          ifd->setUserData("COLOR_TYPE",(void*)WS_BACK_COLOR);
          cifd->setUserData("COLOR_TYPE",(void*)WS_BACK_COLOR);
        }else if (!strcmp(tmp->getPropObjName(),WSNtopShadowColor)){
          label->setUserData("COLOR_TYPE",(void*)WS_TOP_SHADOW_COLOR);
          ifd->setUserData("COLOR_TYPE",(void*)WS_TOP_SHADOW_COLOR);
          cifd->setUserData("COLOR_TYPE",(void*)WS_TOP_SHADOW_COLOR);
        }else if (!strcmp(tmp->getPropObjName(),WSNbottomShadowColor)){
          label->setUserData("COLOR_TYPE",(void*)WS_BOTTOM_SHADOW_COLOR);
          ifd->setUserData("COLOR_TYPE",(void*)WS_BOTTOM_SHADOW_COLOR);
          cifd->setUserData("COLOR_TYPE",(void*)WS_BOTTOM_SHADOW_COLOR);
        }else if(tmp->isColorPropObj() != False){
          label->setUserData("COLOR_TYPE",(void*)WS_COLOR_PROP);
          ifd->setUserData("COLOR_TYPE",(void*)WS_COLOR_PROP);
          cifd->setUserData("COLOR_TYPE",(void*)WS_COLOR_PROP);
        }else{
          label->setUserData("COLOR_TYPE",(void*)0);
          ifd->setUserData("COLOR_TYPE",(void*)0);
          cifd->setUserData("COLOR_TYPE",(void*)0);
        }
        if (labels == NULL){
          char* pname = tmp->getPropObjName();
          if ( tmp->isPixmapPropObj() != False || tmp->getFileSelect() != False){
            if (client->getDataSourceType() != WS_DATA_SOURCE_NONE &&
                !strcmp(tmp->getPropObjName(),client->getDataSourcePropertyName())){
              ifd->setPropertyV(WSNlabelString,"");
            }else{
              ifd->setPropertyV(WSNlabelString, client->getProperty( pname) );
            }
#if 0
            ifd->setVisible(True); 
            cifd->setVisible(False); 
            opt->setVisible(False);
#endif
//            cifd->setPropertyV(WSNbackColor,WSGFcolor("gray80"));
            cifd->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
            if (lbw > WS_PELB_H){
              ifd->setPropertyV(WSNwidth,(WSCushort)(lbw - WS_PELB_H));
              cifd->setPropertyV(WSNx,(short)(lbw - WS_PELB_H + ifdx));
            }else{
              ifd->setPropertyV(WSNwidth,(WSCushort)1);
              cifd->setPropertyV(WSNx,(short)(1 + ifdx));
            }
            ifd->setVisible(True); 
            cifd->setPropertyV(WSNlabelString,"..");
            cifd->setPropertyV(WSNwidth,(WSCushort)WS_PELB_H);
            cifd->setVisible(True); 
            opt->setVisible(False);
          }else if ( tmp->isColorPropObj() != False ){
            cifd->setPropertyV(WSNlabelString,"");
            cifd->setPropertyV(WSNbackColor,  client->getProperty(tmp->getPropObjName()));
            ifd->setPropertyV(WSNcolumns,(WSCushort)0);
            ifd->setPropertyV(WSNlabelString, client->getProperty(tmp->getPropObjName()));
            ifd->setPropertyV(WSNwidth,(WSCushort)(lbw/2));
            cifd->setPropertyV(WSNwidth,(WSCushort)(lbw/2));
            cifd->setPropertyV(WSNx,(short)(lbw/2 + ifdx));
            cifd->setVisible(True); 
            ifd->setVisible(True); 
            opt->setVisible(False);
          }else{
            if (tmp->getPropObjType() == WSTcharptr){
              ifd->setPropertyV(WSNfillSpace,(WSCbool)False);
              ifd->setPropertyV(WSNinterCur,(WSCbool)True);
              ifd->setPropertyV(WSNlabelString,"");
            }
            ifd->setPropertyV(WSNlabelString, client->getProperty(tmp->getPropObjName()));
            ifd->setVisible(True); 
            cifd->setVisible(False); 
            opt->setVisible(False);
          }
        }else{
          WSCstring items;
          long n = 0;
          WSCbool  hit = False;
          long  hit_data = 0;
          while( labels[n] != NULL ){
            items << WSGFgettext(labels[n]) << ":";
            char addr[32];
            WSGFultoa((WSCulong)pdata[n],addr);
            items << addr << ":";

            if (n == 0){
              hit_data = (long)pdata[n];
            }
            if (!strcmp(_client->getProperty(tmp->getPropObjName()),pdata[n])){
                hit = True;
                hit_data = (long)pdata[n];
            }

            n++;
            if (labels[n] != NULL){
              items << ",";
            }
          }
          opt->setPropertyV(WSNmenuItems,items.getString());
          opt->setPropertyV(WSNvalue,hit_data);
//printf("pos=%d prop=%s val=%s\n",i,tmp->getPropObjName(),_client->getProperty(tmp->getPropObjName()));
          ifd->setVisible(False); 
          cifd->setVisible(False); 
          opt->setVisible(True);
        }
        prop_count++;
      }
    }
  }
  _update_sequence = False;

  //property name labels
  num = _label_list.getNum();
  for(i=prop_count; i < num; i++){
    WSCbase* label = (WSCbase*)_label_list[i];
    label->setVisible(False);
    label->setUserData("COLOR_TYPE",(void*)0);
  }
  //inputfields
  num = _if_list.getNum();
  for(i=prop_count; i < num; i++){
    WSCbase* ifd = (WSCbase*)_if_list[i];
    ifd->setVisible(False);
//    ifd->setPropertyV(WSNfillSpace,(WSCbool)True);
//    ifd->setPropertyV(WSNinterCur,(WSCbool)False);
    ifd->setUserData("COLOR_TYPE",(void*)0);
  }
  //color inputfields
  num = _cif_list.getNum();
  for(i=prop_count; i < num; i++){
    WSCbase* cifd = (WSCbase*)_cif_list[i];
    cifd->setVisible(False);
    cifd->setUserData("COLOR_TYPE",(void*)0);
  }
  //options
  num = _option_list.getNum();
  for(i=prop_count; i < num; i++){
    WSCbase* option = (WSCbase*)_option_list[i];
    option->setVisible(False);
  }

  if (_h > prop_count * WS_PELB_T + 10){
    setPropertyV(WSNworkHeight,(WSCushort)(_h));
  }else{
    setPropertyV(WSNworkHeight,(WSCushort)(prop_count * WS_PELB_T + 10));
  }

  _scr_area->setVisible(True);
//  _scr_area->redraw();
//  _scr_area->clear();
}
void WSCpropertyEditor::_check_name(char* name){
//printf("WSCpropertyEditor::_check_name...\n");
  WSCbase* client = _client;
  if (strcmp(client->getInstanceName(),name)){
    WSCstring oname_bk( client->getInstanceName() );
    client->setInstanceName("-NO NAME-");

    WSCstring oname;
    long ano;
    char dummy[2048];
    oname.setString(name);
    oname.delHeadSpace();
    oname.delTailSpace();

    _msg->setPropertyV(WSNheight,(WSCushort)135);
    if (WSGFcheckNameString(oname.getString()) == True){
      long ret = WSGFexistName(oname.getString(),client);
      if (ret == 0){
      }else if (ret == WS_PROCEDURE_NAME){
        _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
        _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
        _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
        _msg->setPropertyV(WSNwidth,(WSCushort)400);
        _msg->setPropertyV(WSNlabelString,
           WSGFgettext("o3:WSSTR Invalid instance name.\nAlready used by another function name..."));
        _msg->setVisible(True);
        oname.setString(oname_bk.getString());
      }else if (ret == WS_OBJECT_NAME){
        _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
        _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
        _msg->setPropertyV(WSNwidth,(WSCushort)400);
        _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
        _msg->setPropertyV(WSNlabelString,
           WSGFgettext("p3:WSSTR Invalid instance name.\nAlready used by another instance name..."));
        _msg->setVisible(True);
        oname.setString(oname_bk.getString());
      }else if (ret == WS_OBJECT_ARRAY_NAME || ret == WS_OBJECT_ARRAY_NAME_INVALID){
        _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
        _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
        _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
        _msg->setPropertyV(WSNwidth,(WSCushort)450);
        _msg->setPropertyV(WSNlabelString,
            WSGFgettext("q3:WSSTR Invalid instance name.\nAlready used by another instance array name..."));
        _msg->setVisible(True);
        oname.setString(oname_bk.getString());
      }else if (ret == WS_OTHER_NAME){
        _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
        _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
        _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
        _msg->setPropertyV(WSNwidth,(WSCushort)450);
        _msg->setPropertyV(WSNlabelString,
           WSGFgettext("r3:WSSTR Invalid instance name.\nAlready used by project name or something..."));
        _msg->setVisible(True);
        oname.setString(oname_bk.getString());
      }
      client->setInstanceName( oname.getString() );
    }else if (WSGFcheckArrayName(oname.getString(),&ano,dummy) == True){
      oname.delHeadSpace();
      oname.delTailSpace();
      long ret = WSGFexistName(oname.getString(),client);
//printf("_check_name ret2=%d\n",ret);
      if (client->getParentWindow() == client){
        _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
        _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
        _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
        _msg->setPropertyV(WSNwidth,(WSCushort)400);
        _msg->setPropertyV(WSNlabelString,WSGFgettext("s3:WSSTR Can not use array name for application window."));
        _msg->setVisible(True);
        oname.setString(oname_bk.getString());
      }else if ((long)client->getParentWindow()->getUserData(WS_WIN_CLASS) != 0){
        _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
        _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
        _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
        _msg->setPropertyV(WSNwidth,(WSCushort)400);
        _msg->setPropertyV(WSNlabelString,WSGFgettext("t3:WSSTR Can not use array name for class window."));
        _msg->setVisible(True);
        oname.setString(oname_bk.getString());
      }else if (ret == 0 || ret == WS_OBJECT_ARRAY_NAME){
//      client->setInstanceName( oname.getString() );
      }else if (ret == WS_PROCEDURE_NAME){
        _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
        _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
        _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
        _msg->setPropertyV(WSNwidth,(WSCushort)400);
        _msg->setPropertyV(WSNlabelString,
          WSGFgettext("u3:WSSTR Invalid instance name.\nAlready used by another procedure name..."));
        _msg->setVisible(True);
        oname.setString(oname_bk.getString());
      }else if (ret == WS_OBJECT_NAME){
        _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
        _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
        _msg->setPropertyV(WSNwidth,(WSCushort)400);
        _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
        _msg->setPropertyV(WSNlabelString,
          WSGFgettext("v3:WSSTR Invalid instance name.\nAlready used by another external instance name..."));
        _msg->setVisible(True);
        oname.setString(oname_bk.getString());
      }else if (ret == WS_OBJECT_ARRAY_NAME_INVALID){
        _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
        _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
        _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
        _msg->setPropertyV(WSNwidth,(WSCushort)400);
        _msg->setPropertyV(WSNlabelString,
           WSGFgettext("w3:WSSTR Invalid instance array name.\nAlready used by another window, or invalid type."));
        _msg->setVisible(True);
        oname.setString(oname_bk.getString());
      }else if (ret == WS_OTHER_NAME){
        _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
        _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
        _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
        _msg->setPropertyV(WSNwidth,(WSCushort)450);
        _msg->setPropertyV(WSNlabelString,
          WSGFgettext("x3:WSSTR Invalid instance name.\nAlready used by project name or something..."));
        _msg->setVisible(True);
        oname.setString(oname_bk.getString());
      }
      client->setInstanceName( oname.getString() );
    }else{
      _msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);
      _msg->setPropertyV(WSNtitleString,WS_WARNING_STR);
      _msg->setPropertyV(WSNwidth,(WSCushort)400);
      _msg->setPropertyV(WSNreplyHandler,(void*)NULL);
      _msg->setPropertyV(WSNlabelString,WSGFgettext("y3:WSSTR Invalid instance name."));
      _msg->setVisible(True);
      client->setInstanceName( oname_bk.getString() );
    }
     _exec_change_name_handler(this);
  }
}
void WSCpropertyEditor::setPropertyDataToClient(){
  if (_update_sequence != False){
    return;
  }
  WSCbase* client = _client;
  if (client == NULL){
    return;
  }
  long prop_count = 0;
  WSCclassInformation* inf = client->getClassInformation();
  WSCclassInformation* inf2 = NULL;
  if (client->getPropertyInheritChild() != NULL){
    inf2 = client->getPropertyInheritChild()->getClassInformation();
  }

  WSGFmarkChanged(client);
  client->clear();

  WSCproperty* prop;
  WSCproperty* tmp;
  WSClistData property_list1;
  WSGFgetAllPropertyList(client,&property_list1);

  WSClistData property_list;
  _sort_property(&property_list,&property_list1);

  long i;
  long num = property_list.getNum();
  for(i = 0; i < num; i++){
    tmp = (WSCproperty*)property_list[i];
    WSCbool fl = inf->getPropObj(tmp->getPropObjName(),&prop);
    if (fl == False && inf2 != NULL){
      fl = inf2->getPropObj(tmp->getPropObjName(),&prop);
    }

    if (client->existProperty(tmp->getPropObjName()) == False){
      continue; //ƤΤäʤ
    }

    if (fl != False){
      if (tmp->getNotUse() == False && tmp->getBuilderVisible() != False &&
                                       tmp->getDefaultValueChange() == False){
        char** labels;
        char** pdata;
        tmp->getBuilderSelectValues(&labels,&pdata);
        WSCbase* ifd = (WSCbase*)_if_list[prop_count];
        WSCbase* opt = (WSCbase*)_option_list[prop_count];
        char* pname = tmp->getPropObjName();
        if (!strcmp(pname,WSNname)){
          WSCbase* parent = client->getParentWindow();
          long wtype = (long)parent->getUserData(WS_WIN_CLASS);
          if (wtype == 1){ //It is class window!
            if (parent == client&& strcmp(client->getInstanceName(),
                  (char*)ifd->getProperty(WSNlabelString))){
              _msg->setPropertyV(WSNlabelString,
        WSGFgettext("F3:WSSTR If you change class window name,\n"
        "you have to reject your old source code\n"
        "and change the name of the event procedure.\n"
        "Do you continue?"));
              _msg->setProperty(WSNwidth,600);
              _msg->setProperty(WSNheight,130);
              long ret =  _msg->popup();
              if (ret != WS_DIALOG_OK){
                if (ifd != NULL){
                  ifd->setProperty(WSNlabelString,client->getInstanceName());
                }
                prop_count++;
                continue;
              }
            }
          }
        }
        if (client->getDataSourceType() != WS_DATA_SOURCE_NONE &&
            !strcmp(tmp->getPropObjName(),client->getDataSourcePropertyName())){
           //nothing to do...
        }else
        if (labels == NULL){
          char* pname = tmp->getPropObjName();
          if ( tmp->isPixmapPropObj() != False ){
            WSCstring val(ifd->getProperty(WSNlabelString));
            WSCstring iname( val );
            iname.delTailSpace();
            client->setProperty(pname,iname.getString() );
          }else if ( tmp->isColorPropObj() != False){
            WSCstring cname(ifd->getProperty(WSNlabelString));
            cname.delTailSpace();
            if (atoi(cname.getString()) != 0){
              client->setPropertyV(pname,(short)atoi(cname.getString()) );
            }else{
              client->setProperty(pname,cname.getString() );
            }
          }else if (!strcmp(pname,"name")){
            _check_name(ifd->getProperty(WSNlabelString));
          }else{
            if (tmp->getPropObjType() == WSTcharptr){
              client->setProperty(pname,ifd->getProperty(WSNlabelString));
            }else{
              WSCstring prv(ifd->getProperty(WSNlabelString));
              prv.delTailSpace();
              client->setProperty(pname,prv.getString());
            }
          }
        }else{ 
          long addr;
          opt->getPropertyV(WSNvalue,&addr);
//printf("i=%d prop=%s opt=%s  addr=0x%x\n",i,tmp->getPropObjName(),(char*)opt->getProperty(WSNmenuItems),addr);
          client->setProperty(tmp->getPropObjName(), (char*)addr);
          //bug fix for no calling WSCwindow::setWorkWSNvis()
          if (!strcmp(tmp->getPropObjName(),"vis")){
            client->setUserData(WS_VIS,(void*)atoi((char*)addr));
          }
        }
        prop_count++;
      }
    }
  }

  WSGFmarkChanged(client);
  client->redraw();
  if (client->getPropertyEditMode() != False){
    client->drawGriphand();
  }
//  execEventProc(WSEV_ACTIVATE,NULL);
  onActivate();
}

void WSCpropertyEditor::update(){
  long fl = (long)getUserData(WS_GEOMETRY_UPDATE);
  if (fl == 1){
    updateGeometryProperties();
    setUserData(WS_GEOMETRY_UPDATE,(void*)0);
  }
  WSCscrForm::update();
}
void WSCpropertyEditor::updateGeometryProperties(){

  WSCbase* client = _client;
  if (client == NULL){
    return;
  }

  long prop_count = 0;
  WSCclassInformation* inf = client->getClassInformation();
  WSCclassInformation* inf2 = NULL;
  if (client->getPropertyInheritChild() != NULL){
    inf2 = client->getPropertyInheritChild()->getClassInformation();
  }

  WSCproperty* prop;
  WSCproperty* tmp;
  WSClistData property_list1;
  WSGFgetAllPropertyList(client,&property_list1);

  WSClistData property_list;
  _sort_property(&property_list,&property_list1);

  long i;
  long num = property_list.getNum();
  for(i = 0; i < num; i++){
    tmp = (WSCproperty*)property_list[i];
    WSCbool fl = inf->getPropObj(tmp->getPropObjName(),&prop);
    if (fl == False && inf2 != NULL){
      fl = inf2->getPropObj(tmp->getPropObjName(),&prop);
    }

    if (client->existProperty(tmp->getPropObjName()) == False){
      continue;
    }

    if (fl != False){
      if (tmp->getNotUse() == False && tmp->getBuilderVisible() != False &&
                                       tmp->getDefaultValueChange() == False){
        if (strcmp(tmp->getPropObjName(),WSNx) &&
            strcmp(tmp->getPropObjName(),WSNy) &&
            strcmp(tmp->getPropObjName(),WSNwidth) &&
            strcmp(tmp->getPropObjName(),WSNheight)){
          prop_count++;
          continue;
        }

        char** labels;
        char** pdata;
        tmp->getBuilderSelectValues(&labels,&pdata);

        WSCbase* ifd = (WSCbase*)_if_list[prop_count];
        if (labels == NULL){
          char* pname = tmp->getPropObjName();
          if ( tmp->isPixmapPropObj() != False ){
            WSCstring val(client->getProperty(pname));
            ifd->setProperty(WSNlabelString,val);
          }else if ( tmp->isColorPropObj() != False){
            WSCstring val(client->getProperty(pname));
            ifd->setProperty(WSNlabelString,val );
          }else{
            if (tmp->getPropObjType() == WSTcharptr){
              WSCstring val(client->getProperty(pname));
              ifd->setProperty(WSNlabelString,val);
            }else{
              WSCstring val(client->getProperty(pname));
              ifd->setProperty(WSNlabelString,val);
            }
          }
          ifd->update();
        }else{ 
WSMFtrace("Warring. WSCpropertyEditor::updateGeometryProperties() geometry does not support value list on WSCoption.\n");
        }
        prop_count++;
      }
    }
  }
}
void WSCpropertyEditor::onVisibleChange(WSCbool fl){
  WSCscrForm::onVisibleChange(fl);
  if (fl != False){
    updateProperties();
  }
}
void WSCpropertyEditor::onParentVisibleChange(WSCbool fl){
  WSCscrForm::onParentVisibleChange(fl);
  if (fl != False){
    updateProperties();
  }
}
void WSCpropertyEditor::onGuiPolicyChange(long policy){
  WSCbase* opt = NULL;
  long num = _option_list.getNum();
  long i;
  for(i=0; i<num; i++){
    opt = (WSCbase*)_option_list[i];
    if (policy & WS_POLICY_GRADATION){
      opt->setProperty(WSNgradation,WS_GR_LT_RB);
    }else{
      opt->setProperty(WSNgradation,WS_GR_NONE);
    }
  }
  if (policy & WS_POLICY_GRADATION){
    newopti_008->setProperty(WSNgradation,WS_GR_LT_RB);
  }else{
    newopti_008->setProperty(WSNgradation,WS_GR_NONE);
  }
}
void WSCpropertyEditor::_set_prop_work(WSCbase* ptr){
  WSCdialog* dialog = (WSCdialog*)ptr->cast("WSCdialog");
  WSCpropertyEditor* _this = (WSCpropertyEditor*)ptr->getUserData("PROP EDIT");
  if (dialog == NULL){
    return;
  }
  dialog->setVisible(False);
  if (_this == NULL){
    return;
  }

  if (dialog->getStatus() != WS_DIALOG_OK){
    return;
  }
  if (_this->_client == NULL){
    return;
  }
//  long prop_cnt = (long)dialog->getUserData("NO");
  WSCproperty* prop;
  prop = (WSCproperty*)dialog->getUserData("PROP");
  if (prop == NULL){
    return;
  } 
  char** labels;
  char** pdata;
  prop->getBuilderSelectValues(&labels,&pdata);
  if (_this->_client->getDataSourceType() != WS_DATA_SOURCE_NONE &&
      !strcmp(prop->getPropObjName(),
              _this->_client->getDataSourcePropertyName())){
  }else{
    if (labels == NULL){
      WSCstring tmp;
      tmp = _this->newtext_007->getProperty(WSNlabelString);
      char buf[32];
      buf[0] = '\n';
      buf[1] = 0;
      tmp.replaceString(buf,"\\n",0);
      _this->_client->setProperty(prop->getPropObjName(),tmp.getString());
    }else{
      long addr;
      _this->newopti_008->getPropertyV(WSNvalue,&addr);
      _this->_client->setProperty(prop->getPropObjName(), (char*)addr);
    } 
  }
  _this->updateProperties();
}
void WSCpropertyEditor::_popup_prop_work(WSCbase* lb){
  WSCpropertyEditor* _this = (WSCpropertyEditor*)lb->getUserData("PROP EDIT");
  long prop_cnt = (long)lb->getUserData("NO");
  _this->newdial_000->setUserData("NO",(void*)prop_cnt);

  WSCproperty* prop;
  lb->getPropertyV(WSNuserValue,(long*)&prop);
  if (prop == NULL){
    return;
  }
  _this->newdial_000->setUserData("PROP",(void*)prop);

  char** labels;
  char** pdata;
  prop->getBuilderSelectValues(&labels,&pdata);

  WSCstring str1;
  str1 << "WSN" << prop->getPropObjName();
  _this->newvifi_002->setProperty(WSNlabelString, str1);
  _this->newvifi_005->setProperty(WSNlabelString, prop->getPropObjTypeName());
  if (labels == NULL){

    WSCstring val;
    if (_this->_client != NULL){
      val = _this->_client->getProperty(prop->getPropObjName());
      _this->newtext_007->setProperty(WSNlabelString,val);
      _this->newtext_007->setProperty(WSNvbarValue,0);
      _this->newtext_007->setProperty(WSNhbarValue,0);
    }
    _this->newtext_007->setVisible(True);
    _this->newopti_008->setVisible(False);
  }else{
    WSCstring items;
    long n = 0;
    WSCbool  hit = False;
    long  hit_data = 0;
    while( labels[n] != NULL ){
      items << WSGFgettext(labels[n]) << ":";
      char addr[32];
      WSGFultoa((WSCulong)pdata[n],addr);
      items << addr << ":";
      if (n == 0){
        hit_data = (long)pdata[n];
      }
      if (!strcmp(_this->_client->getProperty(prop->getPropObjName()),pdata[n])){
        hit = True;
        hit_data = (long)pdata[n];
      }

      n++;
      if (labels[n] != NULL){
        items << ",";
      }
    }
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_GRADATION){
      _this->newopti_008->setProperty(WSNgradation,WS_GR_LT_RB);
    }else{
      _this->newopti_008->setProperty(WSNgradation,WS_GR_NONE);
    }
    _this->newopti_008->setPropertyV(WSNmenuItems,items.getString());
    _this->newopti_008->setPropertyV(WSNvalue,hit_data);

    _this->newtext_007->setVisible(False);
    _this->newopti_008->setVisible(True);

  }

  _this->newdial_000->setVisible(True);
}
