//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSClocaleSet.h>
#include <WSCinitializeManager.h>

#ifndef NO_ENGLISH_MSG
void _libwsad_lang_init_proc(){
#ifndef _WSWIN32
#include "English.cpp"
#endif
}
#endif

#ifndef NO_JAPANESE_EUC_MSG
void _libwsad_lang_init_proc1(){
#ifndef _WSWIN32
#include "Japanese.cpp"
#endif
}
#endif
#ifndef NO_JAPANESE_SJIS_MSG
void _libwsad_lang_init_proc2(){
#include "Japanese-sjis.cpp"
}
#endif
#ifndef NO_JAPANESE_UTF8_MSG
void _libwsad_lang_init_proc3(){
#ifndef _WSWIN32
#include "Japanese-utf8.cpp"
#endif
}
#endif
#ifndef NO_KSC5601_MSG
void _libwsad_lang_init_proc4(){
#ifndef _WSWIN32
#include "Korean.cpp"
#endif
}
#endif
#ifndef NO_GB2312_MSG
void _libwsad_lang_init_proc5(){
#ifndef _WSWIN32
#include "Chinese-zh_cn.cpp"
#endif
}
#endif
#ifndef NO_ES_MSG
void _libwsad_lang_init_proc6(){
#ifndef _WSWIN32
#include "Espanol.cpp"
#endif
}
#endif

class _libwsad_lang_init_{
public:
  _libwsad_lang_init_(){
#ifndef NO_ENGLISH_MSG
    WSGIappInitializeManager()->addInitializeProc(_libwsad_lang_init_proc);
#endif
#ifndef NO_JAPANESE_EUC_MSG
    WSGIappInitializeManager()->addInitializeProc(_libwsad_lang_init_proc1);
#endif
#ifndef NO_JAPANESE_SJIS_MSG
    WSGIappInitializeManager()->addInitializeProc(_libwsad_lang_init_proc2);
#endif
#ifndef NO_JAPANESE_UTF8_MSG
    WSGIappInitializeManager()->addInitializeProc(_libwsad_lang_init_proc3);
#endif
#ifndef NO_KSC5601_MSG
    WSGIappInitializeManager()->addInitializeProc(_libwsad_lang_init_proc4);
#endif
#ifndef NO_GB2312_MSG
    WSGIappInitializeManager()->addInitializeProc(_libwsad_lang_init_proc5);
#endif
#ifndef NO_ES_MSG
    WSGIappInitializeManager()->addInitializeProc(_libwsad_lang_init_proc6);
#endif
  };
};

static _libwsad_lang_init_ _run_libwsad_lang_init;

