//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCgripHand.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSDtimer.h>
#include <WSDmouse.h>
#include <WSDprivateTimer.h>

//#define WS_GH_COLOR1  "gray75"
//#define WS_GH_COLOR2  "gray65"
//#define WS_GH_COLOR3  "gray35"
#define WS_GH_COLOR1  WS_DF_TOPSHADOWCOLOR
#define WS_GH_COLOR2  WS_DF_DARKBACKCOLOR
#define WS_GH_COLOR3  WS_DF_BOTTOMSHADOWCOLOR

WSMFguiClassInitialize(WSCgripHand,WSCform);

WSCgripHand::WSCgripHand(WSCbase* base,char* objname):WSCform(base,objname){
  _update_timer = NULL;
}
WSCbase* WSGFgetNewGripHand(WSCbase* parent){
  WSCbase* gh = new WSCgripHand(parent,"gph");
  gh->setUseParentBaseDev(True);
  gh->initialize();
  gh->setInternalObject(True);
  gh->setPropertyV(WSNx,(short)0);
  gh->setPropertyV(WSNy,(short)0);
  gh->setPropertyV(WSNwidth,(WSCushort)(WS_GRIPH_SIZE*2));
  gh->setPropertyV(WSNheight,(WSCushort)(WS_GRIPH_SIZE*2));
  gh->setProperty(WSNtopShadowColor,WS_GH_COLOR1);
  gh->setProperty(WSNbottomShadowColor,WS_GH_COLOR3);
  gh->setProperty(WSNbackColor,WS_GH_COLOR2);
  gh->setProperty(WSNshadowThickness,1);
  gh->setProperty(WSNuserValue,-1);
  return gh;
}
WSCgripHand::~WSCgripHand(){
  if (_update_timer != NULL){
    _update_timer->stopTimer();
    delete _update_timer;
  }
}
long WSCgripHand::_device_initialize(){
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  dev->setEnableEventBit( WSEV_MOUSE_PRESS_BIT | WSEV_MOUSE_RELEASE_BIT );
  WSCform::_device_initialize();
  return WS_NO_ERR;
}
void WSCgripHand::onMousePress(WSCpoint* ){
  if (_update_timer == NULL){
    _update_timer = WSDprivateTimer::getNewInstance();
  }
  _update_timer->setRate(100);
  _update_timer->setCont(True);
  _update_timer->setWorkProc(_grip_hand_update_proc,this);
  _update_timer->startTimer();
}
void WSCgripHand::onMouseRelease(WSCpoint* ){
   if (_update_timer != NULL){
     _update_timer->stopTimer();
     delete _update_timer;
     _update_timer = NULL;
   }
   WSCbase* client = (WSCbase*)getUserData("CLIENT");
   if (client != NULL){
     client->redraw();
   }
}
void WSCgripHand::_grip_hand_update_proc(void* data){
  WSCgripHand* obj = (WSCgripHand*)data;
  short px,py;
  WSGIappMouse()->getMousePosition(&px,&py,obj);

  unsigned short pw,ph;
  obj->getPropertyV(WSNwidth,&pw);
  obj->getPropertyV(WSNheight,&ph);
  short diffx = pw/2 - px;
  short diffy = ph/2 - py;

  void  (*chandler)(WSCbase*,short,short ,short);
  chandler = (void(*)(WSCbase*,short,short,short))obj->getUserData(WS_GRIPH_HANDLER);
  if (chandler != NULL && (diffx != 0 || diffy != 0)){
    WSCbase* client = (WSCbase*)obj->getUserData("CLIENT");
    if (client != NULL){
      long no = (long)obj->getUserData("GH-NO");
      chandler(client,no,diffx,diffy);
    }
  }
  if (!(WSGIappMouse()->getMouseStatus()  & WS_MOUSE_BTN1)){
     if (obj->_update_timer != NULL){
       obj->_update_timer->stopTimer();
     }
  }
}
long WSCgripHand::getObjectType(){
  return (WS_TYPE_MANAGER | WS_TYPE_FORM );
}
