//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCguiPolicy.h>
#include <WSCbaseList.h>
#include <WSCbase.h>
#include <WSDenv.h>


WSCguiPolicy::WSCguiPolicy(){
  _policy = -1;
  _current_policy_fn_list = NULL;
}

WSCguiPolicy::~WSCguiPolicy(){
}

static WSCguiPolicy* the_gui_policy_instance = NULL;

WSCguiPolicy* WSGIappGuiPolicy(){
  if (the_gui_policy_instance == NULL){
    the_gui_policy_instance = new WSCguiPolicy();
  }
  return the_gui_policy_instance;
}

void WSCguiPolicy::setGuiPolicy(long val,WSCbool create_event){
  _policy = val;
  if (!(val & WS_POLICY_ORIGINAL) && 
      !(val & WS_POLICY_WINDOWS)){
    _policy |= WS_POLICY_WINDOWS;
  }
  if ((val & WS_POLICY_ORIGINAL) && 
      (val & WS_POLICY_WINDOWS)){
    long val2 = ~WS_POLICY_ORIGINAL;
    _policy &= val2;
  }
  if (create_event != False){
    WSGIappObjectList()->execEvent(WSEV_GUI_POLICY_CH,(void*)_policy);
  }
}

long WSCguiPolicy::getGuiPolicy(){
  if (_policy == -1){
    return (WS_POLICY_WINDOWS | WS_POLICY_GRADATION);
  }
  return _policy;
}

WSCstring WSCguiPolicy::getExtGuiPolicyName(){
  return _ext_policy_name;
}
WSCbool WSCguiPolicy::getExtGuiPolicySelected(){
  if (_policy & WS_POLICY_OTHER){
    return True;
  }
  return False;
}
void WSCguiPolicy::setExtGuiPolicy(char* pname,WSCbool fl){
  if (pname == NULL || !strcmp(pname,"")){
    _ext_policy_name.setString("");
    _policy &= ~WS_POLICY_OTHER;
    _current_policy_fn_list = NULL;
  }else{
    _ext_policy_name.setString(pname);
    _policy |= WS_POLICY_OTHER;
    _current_policy_fn_list = (WSCindexData*)_ext_policy_list[_ext_policy_name.getString()];
  }
  if (fl != False){
    WSGIappObjectList()->execEvent(WSEV_GUI_POLICY_CH,(void*)_policy);
    WSGIappObjectList()->execUpdate();
  }
}
void WSCguiPolicy::setExtGuiPolicyProc(char* plname,char* pname,void(*fn)(void*)){
  if (plname == NULL || pname == NULL){
    return;
  }

  WSCindexData* plist = (WSCindexData*)_ext_policy_list[plname];
  if (plist == NULL){
    plist = new WSCindexData;
    _ext_policy_list[plname] = (void*)plist;
  }
  if (plist == NULL){
    return;
  }
  (*plist)[pname] = (void*)fn;
}

void* WSCguiPolicy::getExtGuiPolicyProc(char* pname){
  if (getExtGuiPolicySelected() == False){
    return NULL;
  }
  if (_current_policy_fn_list == NULL){
    _current_policy_fn_list = (WSCindexData*)_ext_policy_list[_ext_policy_name.getString()];
  }
  if (_current_policy_fn_list == NULL){
    return NULL;
  }
  return (*_current_policy_fn_list)[pname];
}
WSCindexData* WSCguiPolicy::getExtGuiPolicyList(){
  return &_ext_policy_list;
}
