//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSDcolor.h>

WSMFclassInit(WSDcolor,WSDres);

struct  comcol{
  long  rv;
  long  gv;
  long  bv;
  char  *name;
};

WSDcolor::WSDcolor(){
  _use_private_cell = False;
}

void WSDcolor::setUsePrivateCell(WSCbool fl){
  if (fl != False){
    _use_private_cell = True;
  }else{
    _use_private_cell = False;
  }
}

WSCbool WSDcolor::getUsePrivateCell(){
  return _use_private_cell;
}

long _get_val_(char c){
  long ret =0;
  if (c > '0'-1  && c < '9'+1){
    ret = c - '0';
  }else
  if (c > 'A'-1  && c < 'F'+1){
    ret = c - 'A' + 10;
  }else
  if (c > 'a'-1  && c < 'f'+1){
    ret = c - 'a' + 10;
  }
  return ret;
}


long WSDcolor::setColorName(char* cname){
   long ret = setSrc(cname);
   if (ret == WS_NO_ERR){
     initialize();
   }
   return ret;
}

char* WSDcolor::getColorName(){
  return getSrc();
}
long WSDcolor::getRGB(long* r,long* g,long* b){
  char* cname = getColorName();
  if (cname[0] == '#'){
    if (strlen(cname) == 4){
      *r = _get_val_(cname[1])*16;
      *g = _get_val_(cname[2])*16;
      *b = _get_val_(cname[3])*16;
    }else if (strlen(cname) == 7){
      *r = _get_val_(cname[1])*16 + _get_val_(cname[2]);
      *g = _get_val_(cname[3])*16 + _get_val_(cname[4]);
      *b = _get_val_(cname[5])*16 + _get_val_(cname[6]);
    }else{
      *r =0;
      *g =0;
      *b =0;
    }
  }else{
    return WS_ERR;
  }
  return WS_NO_ERR;
}
long WSDcolor::getAlpha(){
  return 255;
}
