//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSDkeyboard.h>
#include <WSCballoonHelp.h>
#include <WSDmouse.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>

//#include <WSDdev.h>

WSMFclassInit(WSDkeyboard,WSCroot);

WSCballoonHelp* WSDkeyboard::_status_win = NULL;

WSDkeyboard::WSDkeyboard(){
  _normal_proc1 = NULL;
  _normal_proc2 = NULL;
  _normal_ptr = NULL;
  _special_proc = NULL;
  _special_ptr = NULL;
  _global_proc = NULL;
  _with_shift  = False;
  _with_lock  = False;
  _with_cntl  = False;
  _with_alt   = False;
  _is_cursor  = False;
//  _is_modify  = False;
  _is_function  = False;
  _enable_fep = False;
  _is_pressed = False;
  _key = 0;
  _fep_on = 0;
}

void WSDkeyboard::setEnableFep(WSDdev*,WSCbool fl ){
  if (fl != False){
    fl = True;
  }
  _enable_fep = fl;
}

#if 0
void WSDkeyboard::setIsTtyFunction(WSCbool fl){
  _is_tty_function = fl;
}
#endif

WSCbool WSDkeyboard::isTtyFunction(){
  return _is_tty_function;
}

WSCbool WSDkeyboard::getEnableFep(){
  return _enable_fep;
}

WSCbool WSDkeyboard::getFepStatus(){
  return _fep_on;
}

//WSDkeyboard::~WSDkeyboard(){
//}

void WSDkeyboard::setPositionModeWindow(short x,short y){
#ifndef WS_EMBED
   if (_status_win == NULL){
     _status_win = new WSCballoonHelp(NULL,"mode win");
     _status_win->initialize();
     _status_win->setPropertyV(WSNwidth,(WSCushort)100);
     _status_win->setPropertyV(WSNheight,(WSCushort)30);
     _status_win->setPropertyV(WSNbackColor,"lightyellow2");
     WSCprocedure* ac = new WSCprocedure("mode win move",WSEV_MOUSE_MOVE);
     ac->setInternal(True);
     ac->setFunction(_mode_win_move,"_mode_win_move");
     _status_win->addProcedure(ac);
   }

   if (_status_win != NULL){
     _status_win->setPropertyV(WSNx,x);
     _status_win->setPropertyV(WSNy,y);
   }
#endif
}

void WSDkeyboard::_mode_win_move(WSCbase* obj){
  if (WSGIappMouse()->getTargetBtn() == WS_MOUSE_BTN1){
    return;
  }

  short x,y;
  WSGIappMouse()->getMousePosition(&x,&y);
  short dx,dy;
  WSCushort  dw,dh;
  obj->getPropertyV(WSNwidth,&dw);
  obj->getPropertyV(WSNheight,&dh);

  dx = x - dw/2;
  dy = y - dh/2;

  obj->setPropertyV(WSNx,dx);
  obj->setPropertyV(WSNy,dy);

}

void WSDkeyboard::setVisibleModeWindow(WSCbool fl){
#ifndef WS_EMBED
   if (_status_win == NULL){
     _status_win = new WSCballoonHelp(NULL,"mode win");
     _status_win->initialize();
     _status_win->setPropertyV(WSNwidth,(WSCushort)100);
     _status_win->setPropertyV(WSNheight,(WSCushort)30);
     _status_win->setPropertyV(WSNx,(short)0);
     _status_win->setPropertyV(WSNy,(short)0);
     _status_win->setPropertyV(WSNbackColor,"lightyellow2");
     WSCprocedure* ac = new WSCprocedure("mode win move",WSEV_MOUSE_MOVE);
     ac->setInternal(True);
     ac->setFunction(_mode_win_move,"_mode_win_move");
     _status_win->addProcedure(ac);
   }
   _status_win->setVisible(fl);
#endif
}

void WSDkeyboard::setModeString(char* str){
#ifndef WS_EMBED
  if (_status_win != NULL){
    _status_win->setString(str);
    _status_win->redraw();
  }
#endif
}

long WSDkeyboard::initialize(){
  return WS_NO_ERR;
}

long WSDkeyboard::resetFep(WSDdev*){
WSMFtrace("This system have no KANJI FEP.\n");
  return WS_NO_ERR;
}
long WSDkeyboard::setFepPos(WSDdev*,short ,short ,short ,short ,short ){
WSMFtrace("This system have no KANJI FEP.\n");
  return WS_NO_ERR;
}
long WSDkeyboard::startAscii(WSDdev*,short ,short ,short ,short ,short ){
WSMFtrace("This system have no KANJI FEP.\n");
  return WS_NO_ERR;
}
long WSDkeyboard::startKanji(WSDdev*,short ,short ,short ,short ,short ){
WSMFtrace("This system have no KANJI FEP.\n");
  return WS_NO_ERR;
}


WSCbool WSDkeyboard::executeHandler(WSCbool press){
  if (_global_proc != NULL){
    WSCbool fl = _global_proc(getKey(),press);
    if (fl == False){
      return True;
    }
  }

  if (_special_proc != NULL){
    WSCbool fl = _special_proc(_special_ptr,this,press);
    if (fl == False){
      return True;
    }
  }
  if (withAlt() != False){
    WSClistData menulist = WSGIappDev()->getMenuList();
    long num = menulist.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCbase* menu = (WSCbase*)menulist[i];
      if (press == False){
        menu->execEventProc(WSEV_KEY_RELEASE,NULL);
      }else{
        menu->execEventProc(WSEV_KEY_PRESS,NULL);
      }
    }
  }

  long ret = 0;
  if (_normal_proc1 != NULL){
    _normal_proc1(_normal_ptr,this,press);
    ret = True;
  }
  if (getKey() == WSK_Escape && press == True){
     WSCbase* dialog = WSGIappDev()->getFocusDialog();
     if (dialog != NULL){
       dialog->setVisible(False);
     }
  }
  return ret;
}

void WSDkeyboard::setKey(long key){
  _key = key;
  if (_key == 0){
    setText("");
  }
}
long WSDkeyboard::getKey(){
  return _key;
}
#if 0
void WSDkeyboard::setWithLock(WSCbool fl){
  _with_lock = fl;
}

void WSDkeyboard::setWithShift(WSCbool fl){
  _with_shift = fl;
}

void WSDkeyboard::setWithAlt(WSCbool fl){
  _with_alt = fl;
}

void WSDkeyboard::setWithCntl(WSCbool fl){
  _with_cntl = fl;
}
//void WSDkeyboard::setIsModKey(WSCbool fl){
//  _with_modify = fl;
//}
#endif

void WSDkeyboard::setIsFuncKey(WSCbool fl){
  _is_function = fl;
}

void WSDkeyboard::setIsCursorKey(WSCbool fl){
  _is_cursor = fl;
}

void WSDkeyboard::setIsTtyFunction(WSCbool fl){
  _is_tty_function = fl;
}

void WSDkeyboard::setText(char* text,long encode){
  _text.setString(text,encode);
}

WSCbool WSDkeyboard::withShift(){
  return _with_shift;
}

WSCbool WSDkeyboard::withAlt(){
  return _with_alt;
}

WSCbool WSDkeyboard::withCntl(){
  return _with_cntl;
}

WSCbool WSDkeyboard::withLock(){
  return _with_lock;
}
void WSDkeyboard::setWithShift(WSCbool fl){
  _with_shift = fl;
}
void WSDkeyboard::setWithLock(WSCbool fl){
  _with_lock = fl;
}
void WSDkeyboard::setWithCntl(WSCbool fl){
  _with_cntl = fl;
}
void WSDkeyboard::setWithAlt(WSCbool fl){
  _with_cntl = fl;
}

WSCbool WSDkeyboard::isCursorKey(){
  return _is_cursor;
}

WSCbool WSDkeyboard::isFuncKey(){
  return _is_function;
}

WSCstring* WSDkeyboard::getTextString(){
  return &_text;
}

char* WSDkeyboard::getText(long encode){
  char* ret = _text.getString(encode);
  return ret;
}

void WSDkeyboard::resetFocusInputWorkProc(){
  _normal_proc1 = NULL;
  _normal_proc2 = NULL;
  _normal_ptr = NULL;
  setEnableFep(NULL,False);
}

void WSDkeyboard::setFocusInputWorkProc( void (*fin)(void*,WSDkeyboard*,WSCbool),void (*fout)(void*),void* data){
  setEnableFep(NULL,False);
  void (*bk)(void*) = _normal_proc2;
  void *bkptr = _normal_ptr;

  _normal_proc1 = fin;
  _normal_proc2 = fout;
  _normal_ptr = data;

  if (bk != NULL){
    bk(bkptr);
  }

}

void WSDkeyboard::resetSpecialInputWorkProc(){
  _special_proc = NULL;
  _special_ptr = NULL;
}

void WSDkeyboard::setSpecialInputWorkProc( WSCbool (*func)(void*,WSDkeyboard*,WSCbool),void* data){
  _special_proc = func;
  _special_ptr = data;
}

void WSDkeyboard::setGlobalKeyHook( WSCbool (*func)(long,WSCbool) ){
  _global_proc = func;
}

static WSDkeyboard* (*_create_handler)() = NULL;
void WSDkeyboard::setCreateInstanceHandler( WSDkeyboard* (*hd)()){
  _create_handler = hd;
}
static WSDkeyboard* theAppKeyboard = NULL;
WSDkeyboard* WSGIappKeyboard(){
  if (theAppKeyboard == NULL){
    if (_create_handler == NULL){
      return NULL;
WSMFtrace("WSGIappKeyboard() ERROR. cannot create WSDkeyboard class instance.\n");
    }
    theAppKeyboard = _create_handler();
  }
  return theAppKeyboard;
}
void WSDkeyboard::setSelectedString(char* str,long encode){
//printf("WSDkeyboard::setSelectedString #%s#\n",str);
  _select_str.setString(str,encode);
}
char* WSDkeyboard::getSelectedString(long encode){
//printf("WSDkeyboard::getSelectedString #%s#\n",_select_str.getString(encode));
  return _select_str.getString(encode);
}
void WSDkeyboard::setIsPressed(WSCbool fl){
  _is_pressed = fl;
}
WSCbool WSDkeyboard::isPressed(){
  return _is_pressed;
}

