//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCvarc.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <math.h>
#include <WSCblink.h>

WSMFguiClassInitialize(WSCvarc, WSCvpolyAttr);
WSMFversion(WSCvarc, WSCvpolyAttr);

WSCvarc::WSCvarc(WSCbase* base, char* objname):
          WSCvpolyAttr(base, objname){

  _angle1 = 0;
  _angle2 = 360;
  _arc_type = WS_ARC_OPEN;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvarc);

    WSMFpropertyCreate(WSNangle1,  short, _angle1,WSSangle1);
    WSMFpropertyCreate(WSNangle2,  short, _angle2,WSSangle2);
    WSMFpropertyCreate(WSNarcType, char,  _arc_type,WSSarcType);
      WSMFpropertySetSelection(WSRarcType, WSRarcTypeD);

  WSMFpropertyCreateEnd
}

WSMFproperty(WSCvarc, WSNangle1,  short, _angle1,   0  );
WSMFproperty(WSCvarc, WSNangle2,  short, _angle2,   360);
WSMFproperty(WSCvarc, WSNarcType, char,  _arc_type, WS_ARC_OPEN);

void WSCvarc::setWorkWSNangle1(short){
}

void WSCvarc::getWorkWSNangle1(short*){
}

void WSCvarc::setWorkWSNangle2(short){
}

void WSCvarc::getWorkWSNangle2(short*){
}

void WSCvarc::setWorkWSNarcType(char){
}

void WSCvarc::getWorkWSNarcType(char*){
}


long WSCvarc::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }

  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

//  short x, y;
//  WSCushort w, h;
//  getGeometry(&x, &y, &w, &h);
  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == True){
  }else
  if (dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }
  WSCbool blinkfore = WSGIappBlink()->getBlinkFore(_blink_rate);
  if (_bl_fl == True &&
      blinkfore == True &&
      _tw_fl == False){
    return WS_NO_ERR;
  }

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }

  WSCbase::update();
  setAbsoluteDraw(False);

  WSCushort line_w = _lw;

  if (line_w == 1) {
    dev->setLineWidth((WSCushort)0);
  } else {
    dev->setLineWidth((WSCushort)line_w);
  }

  dev->setLineDashType(_lt);

  short xx = (short)(line_w /2.0);
  short yy = (short)(line_w /2.0);
  WSCushort ww = w - line_w;
  WSCushort hh = h - line_w;

  if (_stippled == True) {
    char kind;
    switch (_arc_type) {
    case WS_ARC_PIE:
      // 𷿤ξ٤
      kind = (char)WS_PI;
      break;
    default:
      kind = (char)WS_NOPI;
      break;
    }
    if (_hatch_pattern != (char)0) {
      if (_back_color_flag == True) {
        //֥椫ĥ֥ɽξطʥ֥󥯿...
        if (_blink_type != WS_FORE &&
            _bl_fl == True &&
            blinkfore == True &&
            _tw_fl == True) {
          dev->setForeColor(_back_blink_color);
        } else {
          dev->setForeColor(_back_color);
        }
        //öطʿɤ٤
        dev->setHatchPattern((char)0);
        dev->drawFillArc(xx, yy, ww, hh, _angle1*64, _angle2*64, kind);
      }
    }
    // ꤵ줿ϥåѥɽǱߤɽ
    dev->setHatchPattern(_hatch_pattern);
    if (_blink_type != WS_FORE &&
        _bl_fl == True &&
        blinkfore == True &&
        _tw_fl == True) {
      dev->setForeColor(_hatch_blink_color);
    } else {
      dev->setForeColor(_hatch_color);
    }
    dev->drawFillArc(xx, yy, ww, hh, _angle1*64, _angle2*64, kind);
    dev->setHatchPattern((char)0);
  }

  // ߸̤ɽ...
  if (_bl_fl == True &&
      blinkfore == True &&
      _blink_type != WS_BACK &&
      _tw_fl == True) {
    dev->setForeColor(_blink_color);
  } else {
    dev->setForeColor(_fore_color);
  }

  // ξϲ⤷ʤʳ褹...
  if (line_w != 0) {
    if (_angle2 != (short)360) {
      // ξ...
      double dw = (double)w;
      double dh = (double)h;
      double dx = dw / 2.0;
      double dy = dh / 2.0;
      WSCpoint pt[3];
      WSCpoint pt1, pt2, pt3;
      double pai = 3.141592653;

      pt1.x = (short)(dx);
      pt1.y = (short)(dy);
      pt2.x = (short)(dx + dw/2.0 * cos((double)_angle1/180.0*pai));
      pt2.y = (short)(dy - dh/2.0 * sin((double)_angle1/180.0*pai));
      pt3.x = (short)(dx + dw/2.0 * cos((double)(_angle1+_angle2)/180.0*pai));
      pt3.y = (short)(dy - dh/2.0 * sin((double)(_angle1+_angle2)/180.0*pai));
      switch (_arc_type) {
      case WS_ARC_OPEN:		// ߸
        dev->drawArc(xx, yy, ww, hh, _angle1*64, _angle2*64);
        break;
      case WS_ARC_CLOSE:	// ı߸
        pt[0].x = pt2.x;
        pt[0].y = pt2.y;
        pt[1].x = pt3.x;
        pt[1].y = pt3.y;
        dev->drawLines(pt, 2);
//WSMFtrace("*** WSCvarc::draw drawLines [%d, %d] [%d, %d]\n", pt[0].x, pt[0].y, pt[1].x, pt[1].y);
        dev->drawArc(xx, yy, ww, hh, _angle1*64, _angle2*64);
        break;
      case WS_ARC_PIE:	// 
        pt[1].x = pt1.x;
        pt[1].y = pt1.y;
        pt[0].x = pt2.x;
        pt[0].y = pt2.y;
        pt[2].x = pt3.x;
        pt[2].y = pt3.y;
        dev->drawLines(pt, 3);
//WSMFtrace("*** WSCvarc::draw drawLines [%d, %d] [%d, %d] [%d, %d]\n", pt[0].x, pt[0].y, pt[1].x, pt[1].y, pt[2].x, pt[2].y);
        dev->drawArc(xx, yy, ww, hh, _angle1*64, _angle2*64);
        break;
      }
    }else{
      dev->drawArc(xx, yy, ww, hh, _angle1*64, _angle2*64);
    }
  }

  //轪λ
  dev->endDraw();

  return WS_NO_ERR;
}
WSCvarc::~WSCvarc(){
}
