//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCvfbtn.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCimageSet.h>
#include <WSDkeyboard.h>
#include <WSkeysym.h>
#include <WSDfont.h>
#include <WSCfontSet.h>
#include <WSCbaseList.h>
#include <WSCblink.h>

WSMFguiClassInitialize(WSCvfbtn, WSCvbtn);
WSMFversion(WSCvfbtn, WSCvbtn);

WSCvfbtn::WSCvfbtn(WSCbase* base, char* objname):
			WSCvbtn(base, objname) {

  _mouse_in = 0;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvfbtn);
//   WSMFpropertyCreate(WSNpushPixmap,short, _push_pixmap,WSSpushPixmap);

//    WSMFaddTrigger(WSEV_MOUSE_IN   );

  WSMFpropertyCreateEnd
}

WSCvfbtn::~WSCvfbtn() {
}

void WSCvfbtn::onMouseIn(WSCpoint* pt){
  _mouse_in = 1;
  WSCvbtn::onMouseIn(pt);
//printf("WSCvfbtn::onMouseIn...\n");
  redraw();
}

void WSCvfbtn::onMouseOut() {
  _mouse_in = 0;
  WSCvbtn::onMouseOut();
  redraw();
}

long WSCvfbtn::draw(){
  if (_shadow_thick != 0){
    if (_mouse_in == 0){
      WSCuchar bk = _shadow_thick;
//printf("WSCvfbtn::draw st=%d\n",_shadow_thick);
      _shadow_thick = 0;
      long ret = WSCvbtn::draw();
      _shadow_thick = bk;
      return ret;
    }else{
//printf("WSCvfbtn::draw2 st=%d\n",_shadow_thick);
      return WSCvbtn::draw();
    }
  }else{
    return WSCvbtn::draw();
  }
}
void WSCvfbtn::onFocusChange(WSCbool fl){
//WSMFtrace("WSCvbtn::onFocusChange(%d)\n",fl);
  if (getSensitive() == False && fl != False){
    return;
  }
  if (fl != False){
    WSGIappKeyboard()->setFocusInputWorkProc(_key_handler, NULL, this);
    if (getowndev() != NULL) {
      WSGIappKeyboard()->resetFep(getowndev());
    }
  }else{
    WSGIappKeyboard()->resetFocusInputWorkProc();
  }
  execEventProc(WSEV_FOCUS_CH, NULL);
  setAbsoluteDraw(True);
  draw();
}
void WSCvfbtn::_key_handler(void* ptr, WSDkeyboard* keyboard, WSCbool fl) {
  WSCvfbtn* obj = (WSCvfbtn*)ptr;
  WSCulong key = keyboard->getKey();

  if (obj->getVisible() == False || obj->getSensitive() == False) {
    return;
  }

  if (fl == True && key == WSK_Return) {
    if (obj->_press_state == False) {
      obj->_press_state = True;
      obj->_mouse_in = 1;
      obj->setAbsoluteDraw(True);
      obj->redraw();
    }
  } else
  if (fl == False && key == WSK_Return) {
    if (obj->_press_state == True) {
      obj->_press_state = False;
      obj->_mouse_in = 0;
      obj->setAbsoluteDraw(True);
      obj->redraw();
      if (obj->getSensitive() == True) {
//        obj->execEventProc(WSEV_ACTIVATE, NULL);
        obj->onActivate();
      }
    }
  }else{
    WSCvbtn::_key_handler((void*)((WSCvbtn*)obj),keyboard,fl);
  }
}
