//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCvarrow.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCimageSet.h>
#include <WSDkeyboard.h>
#include <WSkeysym.h>
#include <WSDfont.h>
#include <WSCfontSet.h>
#include <WSCblink.h>

WSMFguiClassInitialize(WSCvarrow, WSCvbtn);
WSCvarrow::WSCvarrow(WSCbase* base, char* objname):WSCvbtn(base, objname){
  _arrow_direction = WS_UP;
  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNarrowDirection, char, _arrow_direction,WSSarrowDirection);
    WSMFpropertySetSelection(WSRarrowDirection, WSRarrowDirectionD);

    WSMFpropertyDelete(WSNshadowType);
    WSMFpropertyDelete(WSNlabelString);
    WSMFpropertyDelete(WSNalignmentH);
    WSMFpropertyDelete(WSNmarginTop);
    WSMFpropertyDelete(WSNmarginBottom);
    WSMFpropertyDelete(WSNalignmentV);
    WSMFpropertyDelete(WSNmarginRight);
    WSMFpropertyDelete(WSNmarginLeft);
    WSMFpropertyDelete(WSNmaxLength);
    WSMFpropertyDelete(WSNfont);
    WSMFpropertyDelete(WSNlabelString);
    WSMFpropertyDelete(WSNlabelPixmap);
    WSMFpropertyDelete(WSNblinkPixmap);
    WSMFpropertyDelete(WSNemboss);
  WSMFpropertyCreateEnd
}
WSMFproperty(WSCvarrow, WSNarrowDirection, char, _arrow_direction, (char)WS_UP);

void WSCvarrow::setWorkWSNarrowDirection(char) {}
void WSCvarrow::getWorkWSNarrowDirection(char*) {}

long WSCvarrow::draw() {
  if (getVisible() == False) {
    return WS_NO_ERR;
  }

  WSDdev* dev = getowndev();
  if (dev == NULL) {
    return WS_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == True) {
  } else
  if (dev->isExposed(x, y, w, h) == False) {
    return WS_NO_ERR;
  }

  WSCushort st = _shadow_thick;
  WSCbool blinkfore = WSGIappBlink()->getBlinkFore(_blink_rate);
  WSCbool bldraw = (_bl_fl != False && blinkfore != False);

  if( _shadow_type == WS_SHADOW_NONE && bldraw && _tw_fl == False){
    return WS_NO_ERR;
  }

  WSCstring str;
  str.setString(_label_string);
  str.replaceString("\\n", "\n", 0);

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }

  WSCbase::update();
  setAbsoluteDraw(False);

  if (_rv_fl == True) {
    if (bldraw && _bl_type != WS_FORE && _tw_fl == True) {
      dev->setForeColor(_blink_color);
    }else{
      dev->setForeColor(_fore_color);
    }
  }else{
    if (bldraw && _bl_type != WS_FORE && _tw_fl == True) {
      dev->setForeColor(_bg_blink_color);
    }else{
      dev->setForeColor(_back_color);
    }
  }
  if (_grad_no == 0){
    dev->drawFillRect(0, 0, w, h);
  }else{
    dev->drawGradation(_grad_no,_ts_color,_back_color,_bs_color,0, 0, w, h,_grad_margin);
  }

  short py = st;
  if (_press_state == True) {
    py = st+1;
  }

  if (_shadow_thick > 0) {
    if (_press_state == False){
      WSGFdrawBtnShadow(dev, WS_SHADOW_OUT, _shadow_thick, _fore_color,
          _ts_color, _bs_color,_back_color, 0, 0, w, h);
    }else{
      WSGFdrawBtnShadow(dev, WS_SHADOW_IN, _shadow_thick, _fore_color,
          _ts_color, _bs_color,_back_color, 0, 0, w, h);
    }
  }

  if (getSensitive() == False ||
      (getPropertyEditMode() != False && (long)getUserData(WS_DET) == 0)){
    dev->setHatchPattern(8);
  }

  if (_rv_fl != False){
    if (bldraw && _bl_type != WS_BACK && _tw_fl == True) {
      dev->setForeColor(_bg_blink_color);
    }else{
      dev->setForeColor(_back_color);
    }
  }else{
    if (bldraw && _bl_type != WS_BACK && _tw_fl == True) {
      dev->setForeColor(_blink_color);
    }else{
      dev->setForeColor(_fore_color);
    }
  }

//  short xx = st * 2;
//  short yy = st * 2;
//  WSCushort ww = w - st * 4 - 1;
//  WSCushort hh = h - st * 4 - 1;

  WSCushort ww = w/2;
  WSCushort hh = h/2;

  if (ww > hh) {
//    xx += (ww - hh) / 2;
    ww = hh;
  } else
  if (ww < hh) {
//    yy += (hh - ww) / 2;
    hh = ww;
  }
  short xx = (w  - ww)/2;
  short yy = (h  - hh)/2;

  if (!(bldraw && _bl_type != WS_BACK && _tw_fl == False)){
    _draw_arrow(dev, _press_state,xx, yy, ww, hh);
    if (getFocus() == True) {
      dev->setLineWidth(0);
      dev->setLineDashType(8);
      if (w > 4 + st*2 && h > 4 + st*2) {
        if (_press_state == True) {
          xx = st + 2;
          yy = st + 3;
          ww = w - st * 2 - 4;
          hh = h - st * 2 - 4;
        }else{
          xx = st + 2;
          yy = st + 2;
          ww = w - st * 2 - 4;
          hh = h - st * 2 - 4;
        }
        dev->drawRect(xx, yy, ww, hh);
      }
    }
  }
  dev->endDraw();
  return WS_NO_ERR;
}

long WSCvarrow::_draw_arrow(WSDdev* dev, WSCbool state, short x, short y, WSCushort w, WSCushort h) {

  WSCbool blinkfore = WSGIappBlink()->getBlinkFore(_blink_rate);
  WSCbool bldraw = (_bl_fl != False && blinkfore != False);

  short back_color, ts_color, bs_color;
  if (_rv_fl == True) {
    if (bldraw && _bl_type != WS_BACK && _tw_fl == True) {
      back_color = _bg_blink_color;
    }else{
      back_color = _back_color;
    }
  }else{
    if (bldraw && _bl_type != WS_BACK && _tw_fl == True) {
      back_color = _blink_color;
    }else{
      back_color = _fore_color;
    }
  }

  if (state == True){
    ts_color = _ts_color;
    bs_color = _bs_color;
  }else{
    ts_color = _bs_color;
    bs_color = _ts_color;
  }
//  long s = _shadow_thick;
  WSGFdrawArrow(dev,True,_shadow_thick,back_color,
               ts_color,bs_color,_arrow_direction,x,y+state,w,h);
#if 0
  long i;
  WSCpoint pt[6];
  char direction = _arrow_direction;
  if (direction == WS_UP){
    i = 0;
    pt[i++].setPoint(x,         y + h    );
    pt[i++].setPoint(x + w / 2, y        );
    pt[i++].setPoint(x + w / 2, y + s    );
    pt[i++].setPoint(x + s,     y + h - s);
    dev->setForeColor(bs_color);
    dev->drawFillPoly(pt, i);

    i = 0;
    pt[i++].setPoint(x,         y + h    );
    pt[i++].setPoint(x + w,     y + h    );
    pt[i++].setPoint(x + w / 2, y        );
    pt[i++].setPoint(x + w / 2, y + s    );
    pt[i++].setPoint(x + w - s, y + h - s);
    pt[i++].setPoint(x + s,     y + h - s);
    dev->setForeColor(ts_color);
    dev->drawFillPoly(pt, i);

    i = 0;
    pt[i++].setPoint(x + s,     y + h - s);
    pt[i++].setPoint(x + w - s, y + h - s);
    pt[i++].setPoint(x + w / 2, y + s    );
    dev->setForeColor(back_color);
    dev->drawFillPoly(pt, i);
  }else if (direction == WS_DOWN){
    i = 0;
    pt[i++].setPoint(x + w / 2, y + h    );
    pt[i++].setPoint(x,         y        );
    pt[i++].setPoint(x + w,     y        );
    pt[i++].setPoint(x + w - s, y + s    );
    pt[i++].setPoint(x     + s, y + s    );
    pt[i++].setPoint(x + w / 2, y + h - s);
    dev->setForeColor(bs_color);
    dev->drawFillPoly(pt, i);

    i = 0;
    pt[i++].setPoint(x + w / 2, y + h    );
    pt[i++].setPoint(x + w,     y        );
    pt[i++].setPoint(x + w - s, y + s    );
    pt[i++].setPoint(x + w / 2, y + h - s);
    dev->setForeColor(ts_color);
    dev->drawFillPoly(pt, i);

    i = 0;
    pt[i++].setPoint(x + w / 2, y + h - s);
    pt[i++].setPoint(x + w - s, y + s    );
    pt[i++].setPoint(x + s,     y + s    );
    dev->setForeColor(back_color);
    dev->drawFillPoly(pt, i);
  }else if (direction == WS_LEFT) {
    i = 0;
    pt[i++].setPoint(x,         y + h / 2);
    pt[i++].setPoint(x + s,     y + h / 2);
    pt[i++].setPoint(x - s + w, y + s    );
    pt[i++].setPoint(x + w,     y        );
    dev->setForeColor(bs_color);
    dev->drawFillPoly(pt, i);

    i = 0;
    pt[i++].setPoint(x,         y + h / 2);
    pt[i++].setPoint(x + s,     y + h / 2);
    pt[i++].setPoint(x - s + w, y - s + h);
    pt[i++].setPoint(x - s + w, y + s    );
    pt[i++].setPoint(x + w,     y        );
    pt[i++].setPoint(x + w,     y + h    );
    dev->setForeColor(ts_color);
    dev->drawFillPoly(pt, i);

    i = 0;
    pt[i++].setPoint(x     + s, y + h / 2);
    pt[i++].setPoint(x + w - s, y + s    );
    pt[i++].setPoint(x + w - s, y + h - s);
    dev->setForeColor(back_color);
    dev->drawFillPoly(pt, i);
  }else if (direction == WS_RIGHT){
    i = 0;
    pt[i++].setPoint(x,         y + h    );
    pt[i++].setPoint(x,         y        );
    pt[i++].setPoint(x + w,     y + h / 2);
    pt[i++].setPoint(x + w - s, y + h / 2);
    pt[i++].setPoint(x + s,     y + s    );
    pt[i++].setPoint(x + s,     y + h - s);
    dev->setForeColor(bs_color);
    dev->drawFillPoly(pt, i);

    i = 0;
    pt[i++].setPoint(x,         y + h    );
    pt[i++].setPoint(x + w,     y + h / 2);
    pt[i++].setPoint(x + w - s, y + h / 2);
    pt[i++].setPoint(x + s,     y + h - s);
    dev->setForeColor(ts_color);
    dev->drawFillPoly(pt, i);

    i = 0;
    pt[i++].setPoint(x + s,     y + h - s);
    pt[i++].setPoint(x + w - s, y + h / 2);
    pt[i++].setPoint(x + s,     y + s    );
    dev->setForeColor(back_color);
    dev->drawFillPoly(pt, i);
  }
#endif
  return WS_NO_ERR;
}
