//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCvdbDataSource.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSCbaseList.h>
#include <WSCdb.h>
#include <WSCvdb.h>
#include <WSClocaleSet.h>

WSMFguiClassInitialize(WSCvdbDataSource, WSCvdb);
WSMFversion(WSCvdbDataSource, WSCvdb);

WSCvdbDataSource::WSCvdbDataSource(WSCbase* base, char* objname):
			WSCvdb(base, objname){
//  _db_inst_name = WSGFstrdup("");
  _table_name = WSGFstrdup("");
  _item = WSGFstrdup("");
  _show_item = WSGFstrdup("");
  _sort_items = WSGFstrdup("");
  _filter = WSGFstrdup("");
  _sort = WSGFstrdup("");
  _filter = WSGFstrdup("");
  _value = WSGFstrdup("");

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvdbDataSource);

//    WSMFpropertyCreate(WSNdataBaseInstance, char*, _db_inst_name,WSSdataBaseInstance);
    WSMFpropertyCreate(WSNdbTableName,      char*,   _table_name,WSSdbTableName);
    WSMFpropertyCreate(WSNitem,    char*,   _item,WSSitem);
    WSMFpropertyCreate(WSNshowItem,  char*, _show_item,WSSshowItem);
    WSMFpropertyCreate(WSNsortItems, char*, _sort_items,WSSsortItems);
    WSMFpropertyCreate(WSNsort,      char*, _sort,WSSsort);
    WSMFpropertyCreate(WSNfilter,    char*, _filter,WSSfilter);
    WSMFpropertyCreate(WSNvalue,     char*, _value,WSSvalue);


    WSMFaddTrigger(WSEV_ACTIVATE  );


  WSMFpropertyCreateEnd

}
//WSMFproperty( WSCvdbDataSource, WSNdataBaseInstance, char*, _db_inst_name, WSGFstrdup(""));
WSMFproperty( WSCvdbDataSource, WSNdbTableName, char*, _table_name, WSGFstrdup(""));
WSMFproperty( WSCvdbDataSource, WSNitem, char*, _item ,WSGFstrdup(""));
WSMFproperty( WSCvdbDataSource, WSNshowItem, char*, _show_item, WSGFstrdup(""));
WSMFproperty( WSCvdbDataSource, WSNsortItems, char*, _sort_items, WSGFstrdup(""));
WSMFproperty( WSCvdbDataSource, WSNsort, char*, _sort, WSGFstrdup(""));
WSMFproperty( WSCvdbDataSource, WSNfilter, char*, _filter, WSGFstrdup(""));
WSMFproperty( WSCvdbDataSource, WSNvalue, char*, _value, WSGFstrdup(""));


//void WSCvdbDataSource::setWorkWSNdataBaseInstance(char*){ };
//void WSCvdbDataSource::getWorkWSNdataBaseInstance(char**){ };
void WSCvdbDataSource::setWorkWSNdbTableName(char*){
};
void WSCvdbDataSource::getWorkWSNdbTableName(char**){
};
void WSCvdbDataSource::setWorkWSNitem(char* val){
  _item_list.clear();
  WSCstring str(val);
  long words = str.getWords(",");
  long i;
  for(i=0; i< words; i++){
    WSCstring* word = new WSCstring(str.getWord(i,","));
    _item_list.add((void*)word);
  }
};
void WSCvdbDataSource::getWorkWSNitem(char**){
};
void WSCvdbDataSource::setWorkWSNshowItem(char* val){
  _show_item_list.clear();
  WSCstring str(val);
  long words = str.getWords(",");
  long i;

  for(i=0; i<words; i++){
    WSCstring* word = new WSCstring(str.getWord(i,","));
    _show_item_list.add((void*)word);
  }
};
void WSCvdbDataSource::getWorkWSNshowItem(char**){
};
void WSCvdbDataSource::setWorkWSNsortItems(char* val){
  _sort_item_list.clear();
  WSCstring str(val);
  long words = str.getWords(",");
  long i;
  for(i=0; i<words; i++){
    WSCstring* word = new WSCstring(str.getWord(i,","));
    _sort_item_list.add((void*)word);
  }
};
void WSCvdbDataSource::getWorkWSNsortItems(char**){
};
void WSCvdbDataSource::setWorkWSNsort(char* val){
  _sort_list.clear();
  WSCstring str(val);
  long words = str.getWords(",");
  long i;
  for(i=0; i<words; i++){
    WSCstring* word = new WSCstring(str.getWord(i,","));
    _sort_list.add((void*)word);
  }
};
void WSCvdbDataSource::getWorkWSNsort(char**){
};
void WSCvdbDataSource::setWorkWSNvalue(char*){
};
void WSCvdbDataSource::getWorkWSNvalue(char** val){
#if 0
  WSCbase* db1 = WSGIappObjectList()->getInstance("WSCbase",_db_inst_name);
  if (db1 == NULL){
    delete _value;
    _value = WSGFstrdup("");
    *val = _value;
    return;
  }
  WSCvdb* db = (WSCvdb*)db1->cast("WSCvdb");
  if (db == NULL){
    delete _value;
    _value = WSGFstrdup("");
    *val = _value;
    return;
  }
#endif
  WSCvdb* db = this;

  if (!strcmp(_table_name,"")){
    delete _value;
    _value = WSGFstrdup("");
    *val = _value;
    return;
  }

  WSCstring str(_item);
  WSCstring sql = "select ";
  sql << str << " from " << _table_name;

  if (strcmp("",_filter)){
    sql << " where " << _filter << " ";
  }

  WSCstring order;
  long num = _sort_item_list.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCstring* sort_item = (WSCstring*)_sort_item_list.getData(i);
    WSCstring* sort = (WSCstring*)_sort_list.getData(i);
    if (strcmp("",sort_item->getString())){
      if (strcmp("",order.getString())){
        order << ",";
      }
      order << *sort_item << " " << *sort;
    }
  }
  order.delHeadSpace();
  if (strcmp("",(char*)order)){
    sql << " order by " << order;
  }
  num = _value_list.getNum();
  for(i=0;i<num; i++){
    char* val =(char*)_value_list[i];
    delete val;
  }
  _value_list.clear();
//printf("sql=#%s#\n",(char*)sql);
  WSCdbRecord rs(db);
  if (db->open() == WS_NO_ERR){
    rs.open(sql);
    WSCstring str;
    long count = 0;
    while(!rs.isEOF()){
      char name[1024];
      str = "";
      long num = rs.getColCount();
      for(count = 0; count < num; count++){
        char* var = new char[rs.getColLength(count)];
        rs.getColName(count,name);
        rs.getColStringValue(count,var);
//        _value_list.add((void*)var);
        if (isShow(name)){
          str << var;
          if (count +1< num){
            str << ",";
          }
        }
        delete var;
      }
      if (strcmp(str.getString(),"")){
        _value_list.add(WSGFstrdup((char*)str));
      }
      rs.moveNext();
    }
    rs.close();
  }
  if (_value != NULL){
    delete _value;
    _value = NULL;
  }
  num =  _value_list.getNum();
  WSCstring tstr;
  for(i=0; i< num; i++){
    char* val = (char*)_value_list[i];
    if ( i != 0){
      tstr << "\n";
    }
    WSCstring s(val,WSGIappLocaleSet()->getSystemLocaleEncoding());
    tstr << s;
  }
  _value = WSGFstrdup((char*)tstr);
  *val = _value;
}
void WSCvdbDataSource::setWorkWSNfilter(char*){
};
void WSCvdbDataSource::getWorkWSNfilter(char**){
};


WSCvdbDataSource::~WSCvdbDataSource() {
  long num = _item_list.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCstring* word = (WSCstring*)_item_list[i];
    delete word;
  }
  _item_list.clear();
  num = _show_item_list.getNum();
  for(i=0; i<num; i++){
    WSCstring* word = (WSCstring*)_show_item_list[i];
    delete word;
  }
  num = _value_list.getNum();
  for(i=0;i<num; i++){
    char* val =(char*)_value_list[i];
    delete val;
  }
  


//  if (_db_inst_name != NULL){
//    delete _db_inst_name;
//    _db_inst_name = NULL;
//  }
  if (_table_name != NULL){
    delete _table_name;
    _table_name = NULL;
  }
  if (_item != NULL){
    delete _item;
    _item = NULL;
  }
  if (_show_item != NULL){
    delete _show_item;
    _show_item = NULL;
  }
  if (_sort_items != NULL){
    delete _sort_items;
    _sort_items = NULL;
  }
  if (_filter != NULL){
    delete _filter;
    _filter = NULL;
  }

}

WSCbool WSCvdbDataSource::isShow(char* name){
  long num = _show_item_list.getNum();
  long i;
  for(i=0; i< num; i++){
    WSCstring* str = (WSCstring*)_show_item_list[i];
    if (str != NULL && WSGFstricmp(name,str->getString()) == 0){
      return True;
    }
  }
  return False;
}
void WSCvdbDataSource::setData(WSCvariant* val,long code){
#if 0
  if (code == WS_EN_DEFAULT){
    WSCstring str;
    str.setString(val->getCharPtr(),code);
    setProperty(WSNvalue,str.getString());
  }else{
    setProperty(WSNvalue,val->getCharPtr());
  }
#endif
}
long WSCvdbDataSource::getDataSourceType(){
  return WS_DATA_SOURCE_INSTANCE;
}
char* WSCvdbDataSource::getDataSourcePropertyName(){
  return WSNvalue;
}
char* WSCvdbDataSource::getDefaultProperty(){
  return WSNvalue;
}

