//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCvimage.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSDappDev.h>
#include <WSClist.h>

WSMFguiClassInitialize(WSCvimage, WSCnwbase);
WSMFversion(WSCvimage, WSCnwbase);

WSCvimage::WSCvimage(WSCbase* base, char* objname):
			WSCnwbase(base, objname){
  _shadow_type = WS_SHADOW_EIN;
  _shadow_thick = 2;
  _back_color =  WS_DF_NWBACKCOLOR;
  _ts_color = WS_DF_NWTOPSHADOWCOLOR;
  _bs_color =  WS_DF_NWBOTTOMSHADOWCOLOR;
  _margin_top = 2;
  _margin_bottom = 2;
  _margin_left = 2;
  _margin_right = 2;
  _label_pixmap = -1;
  _grad_no = 0;
  _grad_margin = 0;
  _fit = False;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvimage);

    WSMFpropertyCreate(WSNshadowType,   char,    _shadow_type,WSSshadowType);
    WSMFpropertySetSelection(WSRshadowType, WSRshadowTypeD);
    WSMFpropertyCreate(WSNshadowThickness,       WSCuchar, _shadow_thick,WSSshadowThickness);
    WSMFpropertyCreate(WSNbackColor,         short,  _back_color,WSSbackColor);
    WSMFpropertyCreate(WSNtopShadowColor,    short,  _ts_color,WSStopShadowColor);
    WSMFpropertyCreate(WSNbottomShadowColor, short,  _bs_color,WSSbottomShadowColor);
    WSMFpropertyCreate(WSNmarginTop,    WSCuchar,  _margin_top,WSSmarginTop );
    WSMFpropertyCreate(WSNmarginBottom, WSCuchar,  _margin_bottom,WSSmarginBottom);
    WSMFpropertyCreate(WSNmarginLeft,   WSCuchar,  _margin_left,WSSmarginLeft );
    WSMFpropertyCreate(WSNmarginRight,  WSCuchar,  _margin_right,WSSmarginRight);
    WSMFpropertyCreate(WSNlabelPixmap,  short,     _label_pixmap,WSSlabelPixmap);

    WSMFpropertyCreate(WSNgradation,   WSCuchar,   _grad_no,WSSgradation);
      WSMFpropertySetSelection( WSRgradation, WSRgradationD);
    WSMFpropertyCreate(WSNgradationMargin,   WSCuchar,   _grad_margin,WSSgradationMargin);
    WSMFpropertyCreate(WSNfit,   WSCbool,    _fit, WSSfit);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);
    
    WSMFpropertyDelete(WSNblinkRate);
    WSMFpropertyDelete(WSNblinkColor);
    WSMFpropertyDelete(WSNtwinBlink);
    WSMFpropertyDelete(WSNblinkRefreshing);
    WSMFpropertyDelete(WSNblinkFlag);

  WSMFpropertyCreateEnd

}

WSMFproperty(WSCvimage, WSNshadowType,        char,           _shadow_type, WS_SHADOW_EIN      );
WSMFproperty(WSCvimage, WSNshadowThickness,   WSCuchar, _shadow_thick, 2                  );
WSMFproperty(WSCvimage, WSNbackColor,         short,        _back_color, WS_DF_NWBACKCOLOR);
WSMFproperty(WSCvimage, WSNtopShadowColor,    short,        _ts_color, WS_DF_NWTOPSHADOWCOLOR);
WSMFproperty(WSCvimage, WSNbottomShadowColor, short,        _bs_color, WS_DF_NWBOTTOMSHADOWCOLOR);
WSMFproperty(WSCvimage, WSNmarginTop,   WSCuchar,_margin_top,    2             );
WSMFproperty(WSCvimage, WSNmarginBottom,WSCuchar,_margin_bottom, 2             );
WSMFproperty(WSCvimage, WSNmarginLeft,  WSCuchar,_margin_left,   2             );
WSMFproperty(WSCvimage, WSNmarginRight, WSCuchar,_margin_right,  2             );
WSMFproperty(WSCvimage, WSNlabelPixmap,  short,   _label_pixmap,  -1  );
WSMFproperty(WSCvimage, WSNgradation,    WSCuchar, _grad_no,  0  );
WSMFproperty(WSCvimage, WSNgradationMargin,    WSCuchar, _grad_margin,  0  );
WSMFproperty(WSCvimage, WSNfit,    WSCbool, _fit,  False  );

void WSCvimage::setWorkWSNshadowThickness(WSCuchar){}
void WSCvimage::getWorkWSNshadowThickness(WSCuchar*){}
void WSCvimage::setWorkWSNshadowType(char stype){}
void WSCvimage::getWorkWSNshadowType(char*){}
void WSCvimage::setWorkWSNbackColor(short){}
void WSCvimage::getWorkWSNbackColor(short*){}
void WSCvimage::setWorkWSNtopShadowColor(short){}
void WSCvimage::getWorkWSNtopShadowColor(short*){}
void WSCvimage::setWorkWSNbottomShadowColor(short){}
void WSCvimage::getWorkWSNbottomShadowColor(short*){}

void WSCvimage::setWorkWSNmarginTop(WSCuchar){}
void WSCvimage::getWorkWSNmarginTop(WSCuchar*){}
void WSCvimage::setWorkWSNmarginBottom(WSCuchar){}
void WSCvimage::getWorkWSNmarginBottom(WSCuchar*){}
void WSCvimage::setWorkWSNmarginLeft(WSCuchar){} 
void WSCvimage::getWorkWSNmarginLeft(WSCuchar*){} 
void WSCvimage::setWorkWSNmarginRight(WSCuchar){} 
void WSCvimage::getWorkWSNmarginRight(WSCuchar*){}
void WSCvimage::setWorkWSNlabelPixmap(short){}
void WSCvimage::getWorkWSNlabelPixmap(short*){}
void WSCvimage::setWorkWSNgradation(WSCuchar no){}
void WSCvimage::getWorkWSNgradation(WSCuchar*){}
void WSCvimage::setWorkWSNgradationMargin(WSCuchar no){}
void WSCvimage::getWorkWSNgradationMargin(WSCuchar*){}
void WSCvimage::setWorkWSNfit(WSCbool fl){}
void WSCvimage::getWorkWSNfit(WSCbool*){}

WSCvimage::~WSCvimage() {
}
void WSCvimage::update(){
  if (isNeedUpdate() == True){
    if (_shadow_type == WS_SHADOW_TRANS){
      redraw();
    }else{
      draw();
    }
    WSCbase::update();
  }
}
long WSCvimage::_device_initialize(){
  WSCnwbase::_device_initialize();

  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  
  return WS_NO_ERR;
}

long WSCvimage::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False && dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }

  WSCushort st       = _shadow_thick;
  long shadowtype    = _shadow_type;
  short bgno         = _back_color;
  short tsno         = _ts_color;
  short bsno         = _bs_color;

  if (shadowtype == WS_SHADOW_NONE){
    st = 0;
  }

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
     return WS_NO_ERR;
  }

  short     xx = st + _margin_left;
  short     yy = st + _margin_top;
  WSCushort ww = w - st*2;
  WSCushort hh = h - st*2;
  WSCushort h_margin = _margin_left + _margin_right;
  WSCushort v_margin = _margin_top + _margin_bottom;

  if (ww < h_margin) {
    ww = 1;
  } else {
    ww = ww - h_margin;
  }
  if (hh < v_margin) {
    hh = 1;
  } else {
    hh = hh - v_margin;
  }

  WSCbase::update();
  setAbsoluteDraw(False);
  if (shadowtype != WS_SHADOW_TRANS) {
    dev->setForeColor(bgno);
    if (_grad_no == 0){
      dev->drawFillRect( 0, 0, w, h);
    }else{
      dev->drawGradation(_grad_no,tsno,bgno,bsno,0, 0, w, h,_grad_margin);
    }
  }

  WSDimage* image;
  if (_label_pixmap != -1 ){
    image = WSGIappImageSet()->getImage(_label_pixmap);
    if (_fit != False){
      dev->drawStretchedImage (xx, yy, ww, hh, image);
    }else{
      WSCushort iw = image->getImageWidth();
      WSCushort ih = image->getImageHeight();
      if ( ((double)iw /(double)ih > (double)ww/(double)hh) ){
        WSCushort nh = (WSCushort)((double)ww * ih / iw);
        dev->drawStretchedImage (xx, yy + (hh - nh)/2, ww, nh, image);

      }else{
        WSCushort nw = (WSCushort)((double)hh * iw / ih);
        dev->drawStretchedImage (xx + (ww - nw)/2, yy, nw, hh, image);
      }
     
    }
  }

  if (shadowtype != WS_SHADOW_TRANS && st > 0){
    WSGFdrawShadow(dev, shadowtype, st, tsno, tsno, bsno, bgno,0, 0, w, h);
  }
 
  dev->endDraw();
  return WS_NO_ERR;
}

char* WSCvimage::getDefaultProperty(){
  return WSNlabelPixmap;
}
