//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <basic.h>
#include <WScom.h>
#ifndef NO_WSDMUTEX
#include <WStcpcom.h>
#include <btron/WSDbtronMutex.h>
#include <stdio.h>
#include <WSClocaleSet.h>
#include <btron/proctask.h>
#include <btron/taskcomm.h>

WSMFclassInit(WSDbtronMutex,WSDmutex);

WSDmutex* _btron_mutex_chandler(){
  return new WSDbtronMutex;
}

void WSGFinitializeUnixMutex(){
    WSDmutex::setCreateInstanceHandler((void*)_btron_mutex_chandler);
}

class _btron_mutex_init {
  public: _btron_mutex_init(){
    WSDmutex::setCreateInstanceHandler((void*)_btron_mutex_chandler);
  };
};
_btron_mutex_init  _btron_mutex_init_execute;

WSDbtronMutex::WSDbtronMutex(){
}

WSDbtronMutex::~WSDbtronMutex(){
}

long WSDbtronMutex::initialize(){
  _mutex = cre_sem(1,SEM_EXCL | DELEXIT);
  return WS_NO_ERR;
}
long WSDbtronMutex::lock(){
  int ret = wai_sem(_mutex,T_FOREVER);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDbtronMutex::trylock(){
#if 0
  int ret = pthread_mutex_trylock(&_mutex);
  if (ret == 0){
    return WS_NO_ERR;
  }
#endif
  return WS_ERR;
}

long WSDbtronMutex::unlock(){
  int ret = sig_sem(_mutex);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDbtronMutex::destroy(){
  int ret = del_sem(_mutex);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}
#endif
