//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <devfb/devfb.h>
#include <devfb/WSDdevfbPrivateTimer.h>
#include <devfb/WSDdevfbAppDev.h>
#ifdef NO_THREAD
#include <devfb/devfb_dep.h>
#endif
WSMFclassInit(WSDdevfbPrivateTimer,WSDprivateTimer);

WSDprivateTimer* _devfbPrivatetimer_create(){
  return new WSDdevfbPrivateTimer;
}

class _devfbPrivatetimer_init {
  public: _devfbPrivatetimer_init(){
    WSDprivateTimer::setCreateInstanceHandler((void*)_devfbPrivatetimer_create);
  };
};

_devfbPrivatetimer_init  _devfbPrivatetimer_init_execute;

void WSDdevfbPrivateTimer::_timer_process(W ptr){
#ifndef NO_THREAD
  WSDdevfbPrivateTimer* _this = (WSDdevfbPrivateTimer*)ptr;
  while(1){

    long rate = _this->_timer_rate;
//printf("WSDdevfbPrivateTimer::_timer_process before sleep!!!!!\n");
//dbprintf("WSDdevfbPrivateTimer::_timer_process before sleep!!!!!\n");
//    slp_tsk(rate);
      wai_prc(rate);

//    wai_prc(rate);
//printf("WSDdevfbPrivateTimer::_timer_process after sleep!!!!!\n");
//dbprintf("WSDdevfbPrivateTimer::_timer_process after sleep!!!!!\n");

    W tid = get_tid();
//printf("WSDdevfbPrivateTimer::_timer_process tid=0x%x this=0x%x\n",tid,_this);
    MESSAGE* msg;
    char buffer[128];
    msg = (MESSAGE*)buffer;
    msg->msg_type = MS_TYPE2;
    msg->msg_size = sizeof(W)*2;
    memcpy(msg->msg_body.ANYMSG.msg_str,&_this,sizeof(W));
    memcpy(&(msg->msg_body.ANYMSG.msg_str[4]),&tid,sizeof(W));
    W ret = snd_msg(0,msg,WAIT);

//printf("WSDdevfbPrivateTimer::_timer_process send done!!!!!\n");
//printf("tid=%d interval_id=%d\n",tid,_this->_interval_id);
//dbprintf("WSDdevfbPrivateTimer::_timer_process done!!!!!\n");
//printf("_cont=%d timer_on=%d\n",_this->_cont,_this->_timer_on);
    if (_this->_cont != False && _this->_timer_on != False){
      if (tid != _this->_interval_id){
        ext_tsk();
      }
    }else{
      ext_tsk();
    }

  }
#endif
  return;
}
WSClistData WSDdevfbPrivateTimer::_instance_list;
WSDdevfbPrivateTimer::WSDdevfbPrivateTimer(){
  _interval_id =0;
  _instance_list.add((void*)this);
}
WSDdevfbPrivateTimer::~WSDdevfbPrivateTimer(){
  stopTimer();
  _instance_list.del((void*)this);
}
WSCbool WSDdevfbPrivateTimer::isValid(WSDdevfbPrivateTimer* inst){
//printf("WSDdevfbPrivateTimer::isValid inst=0x%x\n",inst);
  long i;
  long num = _instance_list.getNum();
  for(i=0; i<num; i++){
    WSDdevfbPrivateTimer* item =(WSDdevfbPrivateTimer*)_instance_list[i];
    if (item == inst){
      return True;
    }
  }
  return False;
}
void WSDdevfbPrivateTimer::startTimer(){
  _timer_on = True;
  _timer_set();
}

void WSDdevfbPrivateTimer::stopTimer(){
  _timer_on = False;
  if (_interval_id != 0){
    _interval_id = 0;
  }
}

void WSDdevfbPrivateTimer::_timer_set(){
#ifndef NO_THREAD
  if (_interval_id == 0){
    int ret = cre_tsk(_timer_process,-1,(int)this);
//printf("WSDdevfbPrivateTimer::_timer_set ret=0x%x\n",ret);
    if (ret < 0){
dbprintf("Error. WSDdevfbPrivateTimer can not create thread...\n");
WSMFtrace("Error. WSDdevfbPrivateTimer can not create thread...\n");
      return;
    }

    _interval_id = (long)ret;
  }
#else
  MESSAGE* msg;
  char buffer[128];
  msg = (MESSAGE*)buffer;
  msg->msg_type = MS_TYPE2;
  msg->msg_size = sizeof(W);
//printf("WSDdevfbPrivateTimer::_timer_set this=0x%x\n",this);
  WSDdevfbPrivateTimer* ptr = this;
  memcpy(msg->msg_body.ANYMSG.msg_str,&ptr,sizeof(W));
  int id;
  int ret = WSGFdeviceSendDelayMessage(msg,_timer_rate,&id);
//printf("WSGFdeviceSendDelayMessage ret=%d\n",ret);
  if (ret < 0){
    _interval_id = 0;
    return;
  }
  _interval_id = id;
#endif

  if ( _interval_id ==  0 ) {
dbprintf("Error. WSDdevfbPrivateTimer is no effective...\n");
WSMFtrace("Error. WSDdevfbPrivateTimer is no effective...\n");
  }
}
void WSDdevfbPrivateTimer::_timer_callback(WSCulong id){
//printf("WSDdevfbPrivateTimer::_timer_callback start!!!!!\n");
//printf("WSDdevfbPrivateTimer::_timer_callback id=0x%x\n",id);
#ifndef NO_THREAD
  if (id != (WSCulong)_interval_id){
    return;
  }
#endif
//  _interval_id = 0;
  if (_work_proc != NULL){
    _work_proc(_data);
  }
  if (_cont != False && _timer_on == True){
//printf("WSDdevfbPrivateTimer::_timer_callback cont!!!!!\n");
//    _timer_set();
#ifdef NO_THREAD
    _timer_set();
#endif
  }else{
    _timer_on = False;
  }
  return;
}
