#include <stdio.h>
#include <WScom.h>
#include <WSCstring.h>
#include <devfb/WSDdeviceFont.h>
#include <devfb/devfb.h>

WSDdeviceFontGryph::WSDdeviceFontGryph(){
  _width = 0;
  _ascent = 0;
  _descent = -1;
  _left_bearing = -1;
  _right_bearing = -1;
  _data = NULL;
  _char_code =-1;
  _width = 0;
}

int WSDdeviceFontGryph::destroy(){
//  if (_data != NULL){
//    delete _data;
//    _data = NULL;
//  }
  return WS_NO_ERR;
}
WSDdeviceFontGryph::~WSDdeviceFontGryph(){
  destroy();
}

WSDdeviceFont::WSDdeviceFont(){
  _type = 0;
  _height = -1;
  _width = -1;
  _ascent = -1;
  _descent = -1;
  _chars = 0;
  _default_char_code = 0;
  _font_encode = WS_FONT_NONE;
  _font_gryph = NULL;
}
WSDdeviceFont::~WSDdeviceFont(){
  destroy();
}
int WSDdeviceFont::destroy(){
  if (_font_gryph != NULL){
    delete[] _font_gryph;
    _font_gryph = NULL;
  }
  if (_gryph_buf != NULL){
    delete _gryph_buf;
    _gryph_buf = NULL;
  }
  return WS_NO_ERR;
}





WSDdeviceFontList::WSDdeviceFontList(){
  int i;
  for(i=0; i<WS_FONT_COUNT;i++){
    _font_order[i] = 0;
  }
dbprintf("WSDdeviceFontList::WSDdeviceFontList this=0x%x\n",this);
}
WSDdeviceFontList::~WSDdeviceFontList(){
  destroy();
}
int WSDdeviceFontList::addFont(WSDdeviceFont* font){
  _list.add((void*)font);
  if (font == NULL){
    return WS_ERR;
  }
  int encode = font->_font_encode;
  int i;
  for(i=0; i<WS_FONT_COUNT;i++){
    if ( _font_order[i] == encode){
      break;
    }
    if ( _font_order[i] == 0){
      _font_order[i] = encode;
      break;
    }
  }
  return WS_NO_ERR;
}
WSDdeviceFont* WSDdeviceFontList::getFont(int fenc){
  int i;
  int num = _list.getNum();
  for(i=0; i<num;i++){
    WSDdeviceFont* f = (WSDdeviceFont*)_list[i];
    if ( f->_font_encode == fenc){
dbprintf("WSDdeviceFontList::getFont(%d) this=0x%x num=%d f=0x%x\n",fenc,this,num,f);
      return f;
    }
  }
  return NULL;
}
int WSDdeviceFontList::destroy(){
  int i;
  int num = _list.getNum();
  for(i=0; i<num; i++){
    WSDdeviceFont* font = (WSDdeviceFont*)_list[i];
    delete font;
  }
  _list.clear();
  return WS_NO_ERR;
}



WSDdeviceFont* WSGFdeviceReadBdfFont(char* file_name,char* fname,int fenc){
#if 0
  WSCstring* fstr = WSGFreadTextFile(file_name);
  if (fstr == NULL){
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
    return NULL;
  }
#endif
  FILE* ffile = fopen(file_name,"r");
  if (ffile == NULL){
    return NULL;
  }

  WSDdeviceFont* font = new WSDdeviceFont();
  if (font == NULL){
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
    return NULL;
  }
  font->_font_name = fname;
  font->_font_encode = fenc;
  long cnt = 0;
  char line[128];
  while(!feof(ffile)){
//    WSCstring line = fstr->gets();
    fgets(line,128,ffile);
    if (!strcmp(line,"")){
      break;
    }
    char* ln = (char*)line;
    if (!strncmp(ln,"STARTCHAR",9)){
      if (cnt < font->_chars){
        WSDdeviceFontGryph* fg = &(font->_font_gryph[cnt]);
        int data = 0;
        int y = 0;
        int row_w = 0;
        while(1){
//          line = fstr->gets();
          fgets(line,128,ffile);
          ln =(char*)line;
          if (data == 1){
            if (ln[0] == 'E' && !strncmp(ln,"ENDCHAR",7)){
              data = 0;
              break;
            }
            unsigned int val = 0;

            int ret = sscanf(ln,"%x",&val);
            if (ret < 1){
              val = 0;
            }
            unsigned char* ptr = (unsigned char*)fg->_data;
            if (row_w == 1){
              ptr[y] = val;
              y++;
            }else
            if (row_w == 2){
              ptr[y] = (val>>8)& 0xff;
              y++;
              ptr[y] = val & 0xff;
              y++;
            }else
            if (row_w == 3){
              ptr[y] = (val>>16) & 0xff;
              y++;
              ptr[y] = (val>>8) & 0xff;
              y++;
              ptr[y] = val & 0xff;
              y++;
            }else
            if (row_w == 4){
              ptr[y] = (val>>24) & 0xff;
              y++;
              ptr[y] = (val>>16) & 0xff;
              y++;
              ptr[y] = (val>>8) & 0xff;
              y++;
              ptr[y] = val & 0xff;
              y++;
            }
          }else
          if (ln[0] == 'E' && !strncmp(ln,"ENCODING",8)){
            int val = 0;
            int ret = sscanf((char*)line,"ENCODING %d",&val);
            if (ret < 1){
              val = 0;
            }
            fg->_char_code = val;
          }
          if (ln[0] == 'B' && !strncmp(ln,"BBX",3)){
            int w=0,h=0,l=0,b=0;
            int ret = sscanf((char*)line,"BBX %d %d %d %d",&w,&h,&l,&b);
            if (ret < 1){
              delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
              return NULL;
            }
            fg->_left_bearing = l;
            fg->_right_bearing = l+w;
            fg->_ascent = h+b;
            fg->_descent = -b;
          }else
          if (ln[0] == 'D' && !strncmp(ln,"DWIDTH",6)){
            int val,val2;
            int ret = sscanf((char*)line,"DWIDTH %d %d",&val,&val2);
            if (ret < 1){
              val = 0;
              val2 = 0;
            }
            fg->_width = val;
//            long size = font->_chars * font->_height * ((fg->_width-1)/8 + 1);
            long pos = font->_height * ((font->_height-1)/8 + 1) * cnt;
            fg->_data = &(font->_gryph_buf[pos]);
            row_w = (fg->_width-1) / 8 +1;
          }else
          if (ln[0] == 'B' && !strncmp(ln,"BITMAP",6)){
            data = 1;
          }
        }
        cnt++;

      }else{
dbprintf("Error. %s:%d font->_chars=%d cnt=%d\n",__FILE__,__LINE__,font->_chars,cnt);
        delete font;
        return NULL;
      }
    }else
    if (!strncmp(ln,"SIZE",4)){
      int size,tmp,tmp2;
      int ret = sscanf((char*)line,"SIZE %d %d %d",&size,&tmp,&tmp2);
      if (ret < 1){
        delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
        return NULL;
      }
      font->_width = size;
    }else
    if (!strncmp(ln,"DEFAULT_CHAR",12)){
      int val;
      int ret = sscanf((char*)line,"DEFAULT_CHAR %d",&val);
      if (ret < 1){
        delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
        return NULL;
      }
      font->_default_char_code = val;
    }else
    if (!strncmp(ln,"FONT_ASCENT",11)){
      int val;
      int ret = sscanf((char*)line,"FONT_ASCENT %d",&val);
      if (ret < 1){
        delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
        return NULL;
      }
      font->_ascent = val;
      font->_height = font->_descent + font->_ascent;
    }else
    if (!strncmp(ln,"FONT_DESCENT",12)){
      int val;
      int ret = sscanf((char*)line,"FONT_DESCENT %d",&val);
      if (ret < 1){
        delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
        return NULL;
      }
      font->_descent = val;
      font->_height = font->_descent + font->_ascent;
    }else
    if (!strncmp(ln,"CHARSET_",8)){
      //do nothing
    }else
    if (!strncmp(ln,"CHARS",5)){
      int val;
      int ret = sscanf((char*)line,"CHARS %d",&val);
      if (ret < 1){
        delete font;
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
        return NULL;
      }
      font->_chars = val;
      font->_font_gryph = new WSDdeviceFontGryph[val];
      long size = font->_height * ((font->_height-1)/8 + 1)*val;
      font->_gryph_buf = new unsigned char[size];
    }
  }
#if 0
  delete fstr;
#endif
  fclose(ffile);
  return font;
}

WSDdeviceFont* WSGFdeviceReadFont(char* file_name,char* fontname,int type,int fenc){
  if (type == WS_FONT_TYPE_BDF){
    return WSGFdeviceReadBdfFont(file_name,fontname,fenc);
  }
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
  return NULL;
}
int* WSDdeviceFontList::getFontOrder(){
  return _font_order;
}

WSDdeviceFontList* WSGFdeviceOpenFont(char* fname,char* path){
  WSCstring* file = WSGFreadTextFile(path);
  if (file == NULL){
    return NULL;
  }
  WSDdeviceFontList* fontl = new WSDdeviceFontList();
  if (fontl == NULL){
    return NULL;
  }

  while(file->eof() == False){
    WSCstring line = file->gets();
    long words = line.getWords(",");
    if (words <4){
      continue;
    }
    WSCstring font_name = line.getWord(0,",");
    if (!strcmp(font_name,"default")){
    }else
    if (strcmp(font_name,fname)){
      continue;
    }
    long type = WS_FONT_TYPE_BDF;
    WSCstring typestr = line.getWord(1,",");
    if (!strcmp((char*)typestr,"BDF")){
      type = WS_FONT_TYPE_BDF;
    }else
    if (!strcmp((char*)typestr,"PCF")){
      type = WS_FONT_TYPE_PCF;
    }else
    if (!strcmp((char*)typestr,"TTF")){
      type = WS_FONT_TYPE_TTF;
    }
    long cnt = 2;
    while(1){
      WSCstring fpath = line.getWord(cnt,",");
      cnt++;
      WSCstring fencode = line.getWord(cnt,",");
      cnt++;
      long encode = WS_FONT_ISO8859(1);
      if (!strcmp((char*)fencode,"ISO8859_1")){
        encode = WS_FONT_ISO8859(1);
      }else
      if (!strcmp((char*)fencode,"ISO8859_2")){
        encode = WS_FONT_ISO8859(2);
      }else
      if (!strcmp((char*)fencode,"ISO8859_3")){
        encode = WS_FONT_ISO8859(3);
      }else
      if (!strcmp((char*)fencode,"ISO8859_4")){
        encode = WS_FONT_ISO8859(4);
      }else
      if (!strcmp((char*)fencode,"ISO8859_5")){
        encode = WS_FONT_ISO8859(5);
      }else
      if (!strcmp((char*)fencode,"ISO8859_6")){
        encode = WS_FONT_ISO8859(6);
      }else
      if (!strcmp((char*)fencode,"ISO8859_7")){
        encode = WS_FONT_ISO8859(7);
      }else
      if (!strcmp((char*)fencode,"ISO8859_8")){
        encode = WS_FONT_ISO8859(8);
      }else
      if (!strcmp((char*)fencode,"ISO8859_9")){
        encode = WS_FONT_ISO8859(9);
      }else
      if (!strcmp((char*)fencode,"ISO8859_10")){
        encode = WS_FONT_ISO8859(10);
      }else
      if (!strcmp((char*)fencode,"ISO8859_11")){
        encode = WS_FONT_ISO8859(11);
      }else
      if (!strcmp((char*)fencode,"ISO8859_12")){
        encode = WS_FONT_ISO8859(12);
      }else
      if (!strcmp((char*)fencode,"ISO8859_13")){
        encode = WS_FONT_ISO8859(13);
      }else
      if (!strcmp((char*)fencode,"ISO8859_14")){
        encode = WS_FONT_ISO8859(14);
      }else
      if (!strcmp((char*)fencode,"ISO8859_15")){
        encode = WS_FONT_ISO8859(15);
      }else
      if (!strcmp((char*)fencode,"UNICODE")){
        encode = WS_FONT_UNICODE;
      }else
      if (!strcmp((char*)fencode,"KOI8R")){
        encode = WS_FONT_KOI8R;
      }else
      if (!strcmp((char*)fencode,"JIS0201")){
        encode = WS_FONT_JIS0201;
      }else
      if (!strcmp((char*)fencode,"JIS0208")){
        encode = WS_FONT_JIS0208;
      }else
      if (!strcmp((char*)fencode,"KSC5601")){
        encode = WS_FONT_GB2312;
      }else
      if (!strcmp((char*)fencode,"BIG5")){
        encode = WS_FONT_BIG5;
      }
      if (!strcmp((char*)fpath,"")){
        continue;
      }
      WSDdeviceFont* font = WSGFdeviceReadFont((char*)fpath,
                                   (char*)fpath,type,encode);
      if (font != NULL){
        fontl->addFont(font);
      }
      if (cnt >= words){
        break;
      }
    }
  }
  delete file;
  return fontl;
}

int WSDdeviceFontList::getStringWidth(WSCushort* str,int nchars,int* w){
  int width =0;
//  int len = 0;
  WSCushort c;
  int code = 0;
  WSDdeviceFont* f;
  *w = 0;

  if(nchars < 0){
    nchars = WSGFstrlenUCS2(str);
  }

  int i;
  for(i = 0; i <= nchars; i++) {
    if(i == nchars) {
      code = WS_FONT_NONE;
    } else {
      c = *str;
extern int WSGFdeviceQueryChar(unsigned short*,int*);
      code = WSGFdeviceQueryChar(&c,_font_order);
    }
    f = getFont(code);
    if(!f){
      f = getFont(WS_FONT_ISO8859(1));
    }
    if (f != NULL){
//        int slen = WSGIappCodeConvert()->decode(NULL,0,sptr,len,WS_EN_UTF8);
//        char* utf8 = new char[slen+1];
//        WSGIappCodeConvert()->decode(utf8,slen+1,sptr,-1,WS_EN_UTF8);
//
      f->getStringWidth(str,1,&width);
      *w += width;
    }
    str++;
  }
  return WS_NO_ERR;
}

WSDdeviceFontGryph* WSDdeviceFont::getFontGryph(WSCushort c){
  if (_font_gryph == NULL){
    return NULL;
  }
  long center = _chars/2;
//  return _get_font_gryph(c & 0x7f7f,center,center -1,_chars - center);
  return _get_font_gryph(c,center,center -1,_chars - center);
}
WSDdeviceFontGryph* WSDdeviceFont::_get_font_gryph(WSCushort c,int pos,int snum,int lnum){
dbprintf("_get_font_gryph c=%d pos=%d snum=%d lnum=%d\n",c,pos,snum,lnum);
  if (pos < _chars){
    WSDdeviceFontGryph* fg = &(_font_gryph[pos]);
    if (fg->_char_code == c){
      return fg;
    }else
    if (fg->_char_code > c){
      if (snum > 2){
        long center = snum/2;
        long snum2 = center;
        long lnum2 = snum - center;
        return _get_font_gryph(c,center + pos - snum,snum2,lnum2);
      }else if (snum == 2){
        pos--;
        if ( pos > -1){
          WSDdeviceFontGryph* fg = &(_font_gryph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        pos--;
        if ( pos > -1){
          WSDdeviceFontGryph* fg = &(_font_gryph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        return NULL;
      }else if (snum == 1){
        pos--;
        if ( pos > -1){
          WSDdeviceFontGryph* fg = &(_font_gryph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        return NULL;
      }else{
        return NULL;
      }
    }else{
      if (lnum > 2){
        long center = lnum/2;
        long snum2 = center;
        long lnum2 = lnum - center;
        return _get_font_gryph(c,center + pos,snum2,lnum2);
      }else if (lnum == 2){
        pos++;
        if ( pos < _chars){
          WSDdeviceFontGryph* fg = &(_font_gryph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        pos++;
        if ( pos < _chars){
          WSDdeviceFontGryph* fg = &(_font_gryph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        return NULL;
      }else if (lnum == 1){
        pos++;
        if ( pos < _chars){
          WSDdeviceFontGryph* fg = &(_font_gryph[pos]);
          if (fg->_char_code == c){
            return fg;
          }
        }
        return NULL;
      }else{
        return NULL;
      }
    }
  }
  return NULL;
}
int WSDdeviceFont::getStringWidth(WSCushort* str,int len,int* w){
//printf("WSDdeviceFont::getStringWidth here!!\n");
  if (w == NULL){
    return WS_ERR_ADR;
  }
  if (str == NULL){
    return WS_ERR_ADR;
  }
  int i;
  *w = 0;
  for(i=0; i<len; i++){
    WSDdeviceFontGryph* fg = getFontGryph(str[i]);
//printf("str[%d] font gryph=0x%x\n",i,fg);
    if (fg != NULL){
//printf("str[%d] width=%d\n",i,fg->_width);
      *w += fg->_width;
    }else{
      *w += _width;
    }
  }
//printf("WSDdeviceFont::getStringWidth=%d\n",*w);
  return WS_NO_ERR;
}
