//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#include <WScom.h>
#include <devfb/devfb.h>
#include <devfb/devfb_dep.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#ifdef LINUX
#include <sys/time.h>
#endif

void* _context_area = NULL;
int   _sem_id = 0;
int   _event_sem_id = 0;

WSDdeviceWindow* _window_list = NULL;
WSDdeviceGC*     _gc_list = NULL;
WSDdeviceEventList*  _evt_list = NULL;;
unsigned int _default_black_color = 0;
unsigned int _default_white_color = 0;
WSClistData _message_list;
WSClistData _message_time_list;
WSClistData _message_rate_list;
extern int _add_event(WSDdeviceEventList* evt);
extern int _device_check_event_available();

void* get_shared_memory(){
  //TODO: replace returning shared memory function.
  void* ptr =  malloc(WS_MAX_CONTEXT_AREA);
  memset(ptr,0,WS_MAX_CONTEXT_AREA);
  return ptr;
}
unsigned int get_current_time(){
#ifdef LINUX
//TODO: replace ...
  struct timeval  _tmvl;
  struct timezone _tzp;
//  struct tm*      _tm;
  gettimeofday( &_tmvl, &_tzp ) ;
  unsigned int val = _tmvl.tv_sec *1000 + _tmvl.tv_usec /1000;
//printf("get_current_time=%d\n",val);
  return val;
#else
  return 0;
#endif
}

//TODO: replace semaphore...
#ifdef LINUX
#include <pthread.h>
typedef struct pthread_sem_struct{
  int value;
  pthread_mutex_t mutex;
  pthread_cond_t lock_free;
} pthread_sem_t;

int pthread_sem_init_np(pthread_sem_t* semp){
  semp->value = 1;
  pthread_mutex_init(&(semp->mutex),NULL);
  pthread_cond_init(&(semp->lock_free),NULL);
  return 0;
}
int pthread_sem_lock_np(pthread_sem_t* semp){
  pthread_mutex_lock(&(semp->mutex));
  if (--semp->value < 0){
    pthread_cond_wait(&(semp->lock_free),&(semp->mutex));
  }
  pthread_mutex_unlock(&(semp->mutex));
  return 0;
}
int pthread_sem_unlock_np(pthread_sem_t* semp){
  pthread_mutex_lock(&(semp->mutex));
  if (++semp->value < 1){
    pthread_cond_signal(&(semp->lock_free));
  }
  pthread_mutex_unlock(&(semp->mutex));
  return 0;
}
int pthread_sem_destroy_np(pthread_sem_t* semp){
  pthread_cond_destroy(&(semp->lock_free));
  pthread_mutex_destroy(&(semp->mutex));
  return 0;
}

int WSGFdeviceSemCreate(int cnt,unsigned int opt){
  //TODO: initialize sepaphore..
  if (cnt < 0){
    return WS_ERR_PAR;
  }
  pthread_sem_t* sem = (pthread_sem_t*)malloc(sizeof(pthread_sem_t));
  pthread_sem_init_np(sem);
  int ret = (int)sem;
  if (cnt == 0){
    pthread_sem_lock_np(sem);
    return ret;
  }
  if (cnt > 1){
    return WS_ERR_PAR;
  }
  return ret;
}

int WSGFdeviceSemLock(int id){
  //TODO: lock sepaphore..
  pthread_sem_t* sem = (pthread_sem_t*)id;
  pthread_sem_lock_np(sem);
  return WS_NO_ERR;
}

int WSGFdeviceSemUnlock(int id){
  //TODO: unlock sepaphore..
  pthread_sem_t* sem = (pthread_sem_t*)id;
  pthread_sem_unlock_np(sem);
  return WS_NO_ERR;
}

int WSGFdeviceSemDestroy(int id){
  //TODO: destroy sepaphore..
  pthread_sem_t* sem = (pthread_sem_t*)id;
  pthread_sem_destroy_np(sem);
  free(sem);
  return WS_NO_ERR;
}
#endif

int check_wid(int wid){
  if (!(wid > 0)){
    return WS_ERR_WID;
  }
  if (wid > WS_MAX_WINDOW){
    return WS_ERR_WID;
  }

  if (!(_window_list[wid -1]._window_id == wid)){
    return WS_ERR_WID;
  }
  return WS_NO_ERR;
}
int check_gid(int gid){
  if (!(gid > 0)){
    return WS_ERR_GID;
  }
  if (gid > WS_MAX_GC){
    return WS_ERR_GID;
  }

  if (!(_gc_list[gid -1]._gid == gid)){
    return WS_ERR_GID;
  }
  return WS_NO_ERR;
}

WSCbool WSGFinArea(short x,short y,unsigned short w,unsigned short h,short px,short py){
  if (px <x){
    return False;
  }
  if (x + w < px){
    return False;
  }
  if (py <y){
    return False;
  }
  if (y + h < py){
    return False;
  }
  return True;
}

int _search_window(short x,short y){
  int i;
  int stack_no = WS_MAX_WINDOW;
  int wid = 0;
  for(i=0; i<WS_MAX_WINDOW;i++){
    if (_window_list[i]._window_id == 0){
      continue;
    }
    if (_window_list[i]._stack_no < stack_no){
      if (WSGFinArea(_window_list[i]._x,_window_list[i]._y,
                     _window_list[i]._w,_window_list[i]._h,x,y) != False){
        wid = i+1;
        stack_no = _window_list[i]._stack_no;
      }
    }
  }
  return wid;
}


unsigned char* _buffer = NULL;
int _device_width = DEFAULT_DEVICE_WIDTH;
int _device_height = DEFAULT_DEVICE_HEIGHT;
int _device_depth = DEFAULT_DEVICE_DEPTH;
unsigned int _device_start_red =   DEFAULT_DEVICE_RED_SHIFT;
unsigned int _device_start_green = DEFAULT_DEVICE_GREEN_SHIFT;
unsigned int _device_start_blue =  DEFAULT_DEVICE_BLUE_SHIFT;
unsigned int _device_red_bits =    DEFAULT_DEVICE_RED_BIT;
unsigned int _device_green_bits =  DEFAULT_DEVICE_GREEN_BIT;
unsigned int _device_blue_bits =   DEFAULT_DEVICE_BLUE_BIT;

//emuration variables..
#ifdef USE_X11
//#define DOUBLE_SCALE
#include <X11/Xlib.h>
Display* _disp = NULL;
Window   _window = 0;
unsigned char* _xbuffer = NULL;
long _display_depth = 0;
XImage* _ximage = NULL;
Visual* _visual = NULL;
int red_mask, green_mask, blue_mask;
int red_shift, green_shift, blue_shift;
int msb_flag = 0;
GC _xgc = 0;
short _mouse_pos_x = 0;
short _mouse_pos_y = 0;
#ifndef NO_THREAD
pthread_sem_t _event_sem;
#endif
pthread_t _input_thr = 0;
unsigned int _mouse_status = 0;
void _get_mouse_pos(short* x,short* y){
  *x = _mouse_pos_x;
  *y = _mouse_pos_y;
}
void* _x11_input_thread(void*){
  while(1){
  XEvent e;
#ifndef NO_THREAD
  XNextEvent(_disp,&e);
#else
  Bool ret = XCheckWindowEvent(_disp,_window,0xffffffff,&e);
  if (ret == False){
    return NULL;
  }
#endif
//printf("XNextEvent event=%d\n",e.type);
  switch(e.type){
    case ButtonPress:{
//printf("btn press\n");
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int px = e.xbutton.x;
      int py = e.xbutton.y;
#ifdef ROTATE90
      {
         int tmp = px;
         px = _device_height - py-1;
         py = tmp;
      }
#endif
#ifdef DOUBLE_SCALE
      px /= 2;
      py /= 2;
#endif
      int bt = e.xbutton.button;
      int wid = _search_window(px,py);
      if (wid > 0){
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;

        evt->s.stat = 0;
        if (bt == 1){
          _mouse_status |= Button1Mask;
        }
        if (bt == 2){
          _mouse_status |= Button2Mask;
        }
        if (bt == 3){
          _mouse_status |= Button3Mask;
        }
        if (_mouse_status & Button1Mask){
          evt->s.stat |= ES_BUT;
        }
        if (_mouse_status & Button3Mask){
          evt->s.stat |= ES_BUT2;
        }
        _mouse_pos_x = px;
        _mouse_pos_y = py;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
//printf("ButtonRelease wid=%d  p=%d,%d d=%d,%d bt=%d\n",wid,px,py,evt->e.pos.x,evt->e.pos.y);
        evt->s.type = EV_BUTDWN;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
#ifndef NO_THREAD
        WSGFdeviceSemLock(_event_sem_id);
#endif
        _add_event(evtl);
#ifndef NO_THREAD
        WSGFdeviceSemUnlock(_event_sem_id);
        pthread_sem_unlock_np(&_event_sem);
#endif
      }else{
        delete evtl;
      }
      break;
    }
    case ButtonRelease:{
//printf("btn release\n");
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int px = e.xbutton.x;
      int py = e.xbutton.y;
#ifdef ROTATE90
      {
         int tmp = px;
         px = _device_height - py-1;
         py = tmp;
      }
#endif
#ifdef DOUBLE_SCALE
      px /= 2;
      py /= 2;
#endif
      int bt = e.xbutton.button;
      int wid = _search_window(px,py);
      if (wid > 0){
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;

        evt->s.stat = 0;
        if (bt == 1){
          _mouse_status &= ~Button1Mask;
        }
        if (bt == 2){
          _mouse_status &= ~Button2Mask;
        }
        if (bt == 3){
          _mouse_status &= ~Button3Mask;
        }
        if (_mouse_status & Button1Mask){
          evt->s.stat |= ES_BUT;
        }
        if (_mouse_status & Button3Mask){
          evt->s.stat |= ES_BUT2;
        }

        _mouse_pos_x = px;
        _mouse_pos_y = py;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;

//printf("ButtonRelease wid=%d  p=%d,%d d=%d,%d bt=%d\n",wid,px,py,evt->e.pos.x,evt->e.pos.y,bt);
        evt->s.type = EV_BUTUP;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
#ifndef NO_THREAD
        WSGFdeviceSemLock(_event_sem_id);
#endif
        _add_event(evtl);
#ifndef NO_THREAD
        WSGFdeviceSemUnlock(_event_sem_id);
        pthread_sem_unlock_np(&_event_sem);
#endif
      }else{
        delete evtl;
      }
      break;
    }
    case EnterNotify:{
//printf("Enter\n");
      break;
    }
    case LeaveNotify:{
//printf("Leave\n");
      break;
    }
    case MotionNotify:{
//XXZZ todo optimize..
//      if (_evt_list != NULL){
//        continue;
//      }
//printf("mouse move..\n");
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int px = e.xmotion.x;
      int py = e.xmotion.y;
#ifdef ROTATE90
      {
         int tmp = px;
         px = _device_height - py-1;
         py = tmp;
      }
#endif
#ifdef DOUBLE_SCALE
      px /= 2;
      py /= 2;
#endif
      int bt = e.xmotion.state;
      _mouse_pos_x = px;
      _mouse_pos_y = py;
      int wid = _search_window(px,py);
      if (wid > 0){
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
      }else{
        evt->s.wid = 0;
        evt->e.pos.x = px;
        evt->e.pos.y = py;
      }
      evt->s.stat = 0;
      if (bt & Button1Mask){
        evt->s.stat |= ES_BUT;
      }
      if (bt & Button3Mask){
        evt->s.stat |= ES_BUT2;
      }
      evt->e.type = EV_NULL;
//printf("e.xbutton.button=%d ret stat=0x%x move!! %d,%d\n",bt,evt->s.stat,evt->e.pos.x,evt->e.pos.y);
#ifndef NO_THREAD
      WSGFdeviceSemLock(_event_sem_id);
#endif
      _add_event(evtl);
#ifndef NO_THREAD
      WSGFdeviceSemUnlock(_event_sem_id);
      pthread_sem_unlock_np(&_event_sem);
#endif
      break;
    }
    case FocusIn:{
//printf("FocusIn\n");
      break;
    }
    case FocusOut:{
//printf("FocusIn\n");
      break;
    }
    case KeyPress:{
//printf("KeyPress\n");
      break;
    }
    default:{
//printf("other..\n");
      break;
    }
  }
  }
  return NULL;
}

int _init_frame_buffer(){
  //TODO: init frame buffer..
  _disp = XOpenDisplay((char*)NULL);
  if (_disp == NULL){
    return WS_ERR;
  }
  WSCstring* conf = WSGFreadTextFile("wsfbrc");
  if (conf != NULL){
    while(!conf->eof()){
      WSCstring line = conf->gets();
      WSCstring sec = line.getWord(0,":");
      WSCstring value = line.getWord(1,":");
      if (!strcmp(sec,"width")){
        _device_width = atoi((char*)value);
      }
      if (!strcmp(sec,"height")){
        _device_height = atoi((char*)value);
      }
    }
    delete conf;
  }
printf("w,h=%d,%d\n",_device_width,_device_height);
  _window = XCreateSimpleWindow(_disp,DefaultRootWindow(_disp),0,0,
                          _device_width,_device_height,
                          0,BlackPixel(_disp,0),BlackPixel(_disp,0));
  XSelectInput(_disp,_window,ButtonPressMask |
                             ButtonReleaseMask |
                             ExposureMask |
                             KeyPressMask |
                             KeyReleaseMask |
                             EnterWindowMask |
                             LeaveWindowMask |
                             PointerMotionMask |
                             StructureNotifyMask |
                             FocusChangeMask);
  XMapWindow(_disp,_window);

  _display_depth = XDefaultDepth(_disp,XDefaultScreen(_disp));
  _visual = XDefaultVisual(_disp,XDefaultScreen(_disp));

  long buf_size = _device_width * _device_height * _device_depth /8;

  _buffer = (unsigned char*)malloc(buf_size);
  memset(_buffer,0xff,buf_size);

  _xgc = XCreateGC(_disp,_window,0,0);

  if (_display_depth >16){
    _ximage = XCreateImage(_disp,_visual, _display_depth,
                         ZPixmap,0,0, _device_width,_device_height, 32,0);
  }else if (_display_depth >8){
    _ximage = XCreateImage(_disp,_visual, _display_depth,
                         ZPixmap,0,0, _device_width,_device_height, 16,0);
  }else{
    _ximage = XCreateImage(_disp,_visual, _display_depth,
                         ZPixmap,0,0, _device_width,_device_height, 8,0);
  }
  _ximage->data = (char*)malloc(_ximage->bytes_per_line * _device_height);

  int start_shift;
  unsigned int start_mask;
  XWindowAttributes win_attr;

  red_mask = green_mask = blue_mask = 0;
  red_shift = green_shift = blue_shift = 0;
  msb_flag = (ImageByteOrder(_disp) == MSBFirst)?1:0;

  if (XGetWindowAttributes(_disp,
            RootWindow(_disp, DefaultScreen(_disp)), &win_attr) == 0){
    return -1;
  }
  if ((win_attr.depth == 24) || (win_attr.depth == 16)) {
    if (win_attr.depth == 24) {
      start_shift = 24;
      start_mask = 0x80000000;
    }else{
      start_shift = 8;
      start_mask = 0x8000;
    }
    red_mask = win_attr.visual->red_mask;
    red_shift = start_shift;
    unsigned int n = start_mask;
    while (!(n & red_mask)) {
      n >>= 1;
      red_shift--;
    }
    green_mask = win_attr.visual->green_mask;
    green_shift = start_shift;
    n = start_mask;
    while (!(n & green_mask)) {
      n >>= 1;
      green_shift--;
    }
    blue_mask = win_attr.visual->blue_mask;
    blue_shift = start_shift;
    n = start_mask;
    while (!(n & blue_mask)) {
      n >>= 1;
      blue_shift--;
    }
  }
#ifndef NO_THREAD
  pthread_sem_init_np(&_event_sem);
  pthread_sem_lock_np(&_event_sem);
  pthread_create(&_input_thr,NULL,_x11_input_thread,NULL);
#endif
  return WS_NO_ERR;
}

int _update_frame_buffer(){
  //TODO: flush frame buffer..
  unsigned char r=0,g=0,b=0;
//  long ptr = 0;
  long ptr2 = 0;
  long i, j;
  unsigned int udat;

  unsigned int depth =   _device_depth;
  unsigned int start_red =   _device_start_red;
  unsigned int start_green = _device_start_green;
  unsigned int start_blue =  _device_start_blue;
  unsigned int red_bits =    _device_red_bits;
  unsigned int green_bits =  _device_green_bits;
  unsigned int blue_bits =   _device_blue_bits;
  unsigned int row_bytes =   _device_width * _device_depth / 8;

  if (_ximage->bits_per_pixel ==32){
//printf("update_window 32..\n");
    for(i=0; i<_device_height; i++){
      for(j=0; j<_device_width; j++){
        if (depth == 32){
          unsigned int* ptr = (unsigned int*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = *ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }else if (depth == 16){
          unsigned short* ptr = (unsigned short*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = (unsigned int)*ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }
//        r = _buffer[ptr++];
//        g = _buffer[ptr++];
//        b = _buffer[ptr++];
//        a = _buffer[ptr++];
        udat = 0;
        if (red_shift >= 0){
          udat |= (((int)r << red_shift) & red_mask);
        }else{
          udat |= (((int)r >> (-red_shift)) & red_mask);
        }
        if (green_shift >= 0){
          udat |= (((int)g << green_shift) & green_mask);
        }else{
          udat |= (((int)g >> (-green_shift)) & green_mask);
        }
        if (blue_shift >= 0){
          udat |= (((int)b << blue_shift) & blue_mask);
        }else{
          udat |= (((int)b >> (-blue_shift)) & blue_mask);
        }
        if (msb_flag){
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff000000)>>24;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff0000)>>16;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff00)>>8;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
        }else{
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff00)>>8;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff0000)>>16;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff000000)>>24;
        }
      }
    }
  }else if (_ximage->bits_per_pixel ==24){
//printf("update_window 24..\n");
    for(i=0; i<_device_height; i++){
      ptr2 = i * _ximage->bytes_per_line;
      for(j=0; j<_device_width; j++){
        if (depth == 32){
          unsigned int* ptr = (unsigned int*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = *ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }else if (depth == 16){
          unsigned short* ptr = (unsigned short*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = (unsigned int)*ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }

//        r = _buffer[ptr++];
//        g = _buffer[ptr++];
//        b = _buffer[ptr++];
//        a = _buffer[ptr++];

        udat = 0;
        if (red_shift >= 0){
          udat |= (((int)r << red_shift) & red_mask);
        }else{
          udat |= (((int)r >> (-red_shift)) & red_mask);
        }
        if (green_shift >= 0){
          udat |= (((int)g << green_shift) & green_mask);
        }else{
          udat |= (((int)g >> (-green_shift)) & green_mask);
        }
        if (blue_shift >= 0){
          udat |= (((int)b << blue_shift) & blue_mask);
        }else{
          udat |= (((int)b >> (-blue_shift)) & blue_mask);
        }
        if (msb_flag){
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff0000)>>16;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff00)>>8;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
        }else{
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff00)>>8;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff0000)>>16;
        }
      }
    }
  }else if (_ximage->bits_per_pixel ==16){
//printf("update_window 16..\n");
    for(i=0; i<_device_height; i++){
      for(j=0; j<_device_width; j++){
        if (depth == 32){
          unsigned int* ptr = (unsigned int*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = *ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }else if (depth == 16){
          unsigned short* ptr = (unsigned short*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = (unsigned int)*ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }


//        unsigned int rr = _buffer[ptr++];
//        unsigned int gg = _buffer[ptr++];
//        unsigned int bb = _buffer[ptr++];
//        unsigned int aa = _buffer[ptr++];

        udat = 0;
        if (red_shift >= 0){
                udat |= (((int)r << red_shift) & red_mask);
        }else{
          udat |= (((int)r >> (-red_shift)) & red_mask);
        }
        if (green_shift >= 0){
          udat |= (((int)g << green_shift) & green_mask);
        }else{
          udat |= (((int)g >> (-green_shift)) & green_mask);
        }
        if (blue_shift >= 0){
          udat |= (((int)b << blue_shift) & blue_mask);
        }else{
          udat |= (((int)b >> (-blue_shift)) & blue_mask);
        }
        if (msb_flag) {
          ((unsigned char*)_ximage->data)[ptr2++] = (udat >> 8) & 0xff;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
        }else{
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff00)>>8;
        }
      }
    }
  }else if (_ximage->bits_per_pixel == 8){
//printf("update_window 8..\n");
    XColor col[5*5*5];
    Colormap cm = DefaultColormap(_disp,DefaultScreen(_disp));
    long k;
    long cnt=0;
    for(i=0; i<5; i++){
      for(j=0; j<5; j++){
        for(k=0; k<5; k++){
          if (i != 4){
            col[cnt].red = i*64*256;
          }else{
            col[cnt].red = 0xffff;
          }
          if (j != 4){
            col[cnt].green = j*64*256;
          }else{
            col[cnt].green = 0xffff;
          }
          if (k != 4){
            col[cnt].blue = k*64*256;
          }else{
            col[cnt].blue = 0xffff;
          }
          XAllocColor(_disp,cm,&(col[cnt]));
          cnt++;
        }
      }
    }
    long colptr = 0;
    long rr = 0,gg = 0,bb = 0;
//    long tr1,tg1,tb1;
    signed char dr1,dg1,db1;
    for(i=0; i<_device_height; i++){
      dr1 = 0;
      dg1 = 0;
      db1 = 0;
      for(j=0; j< _device_width; j++){
        if (depth == 32){
          unsigned int* ptr = (unsigned int*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = *ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }else if (depth == 16){
          unsigned short* ptr = (unsigned short*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = (unsigned int)*ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }


//        tr1 = _buffer[ptr++];
//        tg1 = _buffer[ptr++];
//        tb1 = _buffer[ptr++];
//        ta1 = _buffer[ptr++];

        if ((0 < r + dr1) && (r + dr1) < 256){
          if ((-32 < dr1) && (dr1 < 32)){
            rr = (r + dr1 + 31) & 0x1c0;
          }else if (dr1 > 31){
            rr = (r + 63) & 0x1c0;
          }else{
            rr = r  & 0x1c0;
          }
        }else if (r + dr1 > 255){
          rr = 0x100;
        }else{
          rr = 0;
        }
        dr1 += (r - rr);
        if (0 < g + dg1  &&g + dg1 < 256){
          if (-32 < dg1 && dg1 < 32 ){
            gg = (g + dg1 + 31) & 0x1c0;
          }else if (dg1 > 31){
            gg = (g + 63) & 0x1c0;
          }else{
            gg = g  & 0x1c0;
          }
        }else if (g + dg1 > 255){
          gg = 0x100;
        }else{
          gg = 0;
        }
        dg1 += (g - gg);
        if (0 < b + db1 && b + db1 < 256){
          if (-32 < db1 && db1 < 32){
            bb = (b + db1 + 31) & 0x1c0;
          }else if (db1 > 31){
            bb = (b + 63) & 0x1c0;
          }else{
            bb = b & 0x1c0;
          }
        }else if (b + db1 > 255){
            bb = 0x100;
        }else{
          bb = 0;
        }
        db1 += (b - bb);
        db1 += (b - bb);
        colptr = (rr>>6)*5*5  + (gg>>6)*5 + (bb>>6);
        _ximage->data[ptr2++] =  col[colptr].pixel;
      }
    }
  }
//printf("put!!!!\n");
  XPutImage(_disp,_window,_xgc,_ximage,0,0,0,0,
            _device_width,_device_height);
  return 0;
}
int _get_event(WSDdeviceEvent* evt,unsigned int mode){
//printf("_get_event start");
#ifdef NO_THREAD
   _x11_input_thread(NULL);
#endif
   if (_evt_list == NULL){
    if ( _device_check_event_available() != False ){
      evt->s.type = EV_MSG;
      return WS_NO_ERR;
    }
    return WS_ERR;
  }
  WSDdeviceEventList* item = _evt_list;
  WSDdeviceEventList* item_bak = NULL;
  while(1){
    if (item == NULL){
      break;
    }
    if ((mode & 0xfff0 ) == DSPEVT){
      if (item->_event.r.type != EV_REQUEST){
        item_bak = item;
        item = item->_next;
        continue;
      }
      if (item->_event.r.cmd != W_REDISP){
        item_bak = item;
        item = item->_next;
        continue;
      }
    }
    if (item_bak == NULL){
      _evt_list = item->_next;
    }else{
      item_bak->_next = item->_next;
    }
    memcpy(evt,&(item->_event),sizeof(WSDdeviceEvent));
    free(item);
    return WS_NO_ERR;
  }
  if ((mode & 0xfff0 ) == DSPEVT){
    return WS_ERR;
  }
  //TODO: get mouse event..
  //TODO: get key event..
  if ( _device_check_event_available() != False ){
    evt->s.type = EV_MSG;
    return WS_NO_ERR;
  }
  return WS_ERR;
}
#endif
//-----------------------------------------------------------------
#ifdef USE_FB
#include <linux/fb.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#define USE_SAME_BUF

int _fb_fd = 0;
struct fb_var_screeninfo var_info;
struct fb_fix_screeninfo fix_info;
int _device_buffer_size = 0;
char* _fb_addr = 0;
#ifndef NO_THREAD
pthread_sem_t _event_sem;
#endif
unsigned int _mouse_status = 0;

int _touch_pannel_x = 0;
int _touch_pannel_y = 0;
void _get_mouse_pos(short* x,short* y){
  *x = _touch_pannel_x;
  *y = _touch_pannel_y;
}

#ifndef ZAURUS
#include <linux/input.h>
#include <errno.h>
pthread_t     _input_mouse_thr=0;
pthread_t     _input_key_thr=0;
int _mouse_dev =0;
int _keyb_dev =0;

void _draw_mouse_cursor(){
static  int _cursor_x = -1;
static  int _cursor_y = -1;
static  unsigned int val_back = 0;
  int dx = _cursor_x;
  int dy = _cursor_y;
  int x = _touch_pannel_x;
  int y = _touch_pannel_y;
  _cursor_x = x;
  _cursor_y = y;
#ifdef ROTATE90
  {
     int tmp = dx;
     dx = dy;
     dy = _device_height - tmp -1;
     tmp = x;
     x = y;
     y = _device_height - tmp -1;
  }
#endif
#ifdef DOUBLE_SCALE
   dx *=2;
   dy *=2;
   x *=2;
   y *=2;
#endif
  if (x < 0 || y < 0){
    return;
  }
  unsigned int depth =   _device_depth;
  unsigned int row_bytes = _device_width * _device_depth/8;
  if (depth == 32){
    if (dx > -1 && dy > -1){
      unsigned int* ptr = (unsigned int*)&_buffer[dy*row_bytes + dx*depth/8];
      *ptr = val_back;
    }
    unsigned int* ptr2 = (unsigned int*)&_buffer[y*row_bytes + x*depth/8];
    val_back = *ptr2;
    *ptr2 = 0xffffffff;
  }else
  if (depth == 16){
    if (dx > -1 && dy > -1){
      unsigned short* ptr = (unsigned short*)&_buffer[dy*row_bytes + dx*depth/8];
      *ptr = val_back;
    }
    unsigned short* ptr2 = (unsigned short*)&_buffer[y*row_bytes + x*depth/8];
    val_back = *ptr2;
    *ptr2 = 0xffff;
  }else
  if (depth == 8){
    if (dx > -1 && dy > -1){
      unsigned char* ptr = (unsigned char*)&_buffer[dy*row_bytes + dx*depth/8];
      *ptr = val_back;
    }
    unsigned char* ptr2 = (unsigned char*)&_buffer[y*row_bytes + x*depth/8];
    val_back = *ptr2;
    *ptr2 = 0xff;
  }
}
#ifndef NO_THREAD
void* _mouse_input_thread(void*){
  int readlen;
  struct input_event event;
//printf("_zaurus_input_thread started..\n");
  while((readlen = read(_mouse_dev,&event,sizeof(struct input_event))) > 0 || errno == EINTR){
    if (readlen != sizeof(struct input_event)){
      continue;
    }
    int px = _touch_pannel_x;
    int py = _touch_pannel_y;

    if (event.type == EV_REL){
      if (event.code == REL_X){
        px += event.value;
        if (px < 0){
          px =0;
        }else if (!(px < _device_width)){
          px = _device_width -1;
        }
      }else
      if (event.code == REL_Y){
        py += event.value;
        if (py < 0){
          py =0;
        }else if (!(py < _device_height)){
          py = _device_height -1;
        }
      }
      if (px != _touch_pannel_x || py != _touch_pannel_y){
        WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
        WSDdeviceEvent* evt = &(evtl->_event);
        int wid = _search_window(px,py);
        if (wid != 0){
          evt->s.type = EV_NULL;
          evt->s.cmd = W_WORK;
          evt->s.wid = wid;
          short wx = _window_list[wid -1]._x;
          short wy = _window_list[wid -1]._y;
          evt->s.wid = wid;
          evt->e.pos.x = px -wx;
          evt->e.pos.y = py -wy;
          evt->s.stat = _mouse_status;
          _touch_pannel_x = px;
          _touch_pannel_y = py;
          _draw_mouse_cursor();
          WSGFdeviceSemLock(_event_sem_id);
          _add_event(evtl);
          WSGFdeviceSemUnlock(_event_sem_id);
#ifndef NO_THREAD
          pthread_sem_unlock_np(&_event_sem);
#endif
        }
        continue;
      }
    }

    if (event.type == EV_KEY){
      if (event.code == BTN_LEFT ||
          event.code == BTN_MIDDLE ||
          event.code == BTN_RIGHT){
        int mouse_status = _mouse_status;
        if (event.value == 1){
          switch(event.code){
            case BTN_LEFT:
              mouse_status |= ES_BUT;
              break;
            case BTN_RIGHT:
              mouse_status |= ES_BUT2;
              break;
          }
        }else{
          switch(event.code){
            case BTN_LEFT:
              mouse_status &= ~ES_BUT;
              break;
            case BTN_RIGHT:
              mouse_status &= ~ES_BUT2;
              break;
          }
        }
        if (mouse_status != _mouse_status){
          _mouse_status = mouse_status;
          WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
          WSDdeviceEvent* evt = &(evtl->_event);
          int wid = _search_window(px,py);
          if (wid != 0){
            if (event.value == 1){
              evt->s.type = EV_BUTDWN;
            }else{
              evt->s.type = EV_BUTUP;
            }
            evt->s.cmd = W_WORK;
            evt->s.wid = wid;
            short wx = _window_list[wid -1]._x;
            short wy = _window_list[wid -1]._y;
            evt->s.wid = wid;
            evt->e.pos.x = px -wx;
            evt->e.pos.y = py -wy;
            evt->s.stat = _mouse_status;
            _touch_pannel_x = px;
            _touch_pannel_y = py;
            _draw_mouse_cursor();
            WSGFdeviceSemLock(_event_sem_id);
            _add_event(evtl);
            WSGFdeviceSemUnlock(_event_sem_id);
#ifndef NO_THREAD
            pthread_sem_unlock_np(&_event_sem);
#endif
          }
          continue;
        }
      }
    }
  }
}
#endif
#if (defined NO_THREAD) && !(defined MB93093)
void _mouse_input_proc(){
  int readlen;
  struct input_event event;
//printf("_zaurus_input_thread started..\n");
  while(1){
    int readlen;
    char buffer[16];
//printf("_mouse_input_proc started..\n");fflush(stdout);
    fd_set read_fds;
    FD_ZERO(&read_fds);
    int width=_mouse_dev+1;
    FD_SET(_mouse_dev,&read_fds);
    struct timeval tm;
    tm.tv_sec = 0;
    tm.tv_usec = 0;
    int ret = select(width,&read_fds,NULL,NULL,&tm);
    if (ret > 0){

      while((readlen = read(_mouse_dev,&event,sizeof(struct input_event))) > 0 || errno == EINTR){
        if (readlen != sizeof(struct input_event)){
          continue;
        }
        int px = _touch_pannel_x;
        int py = _touch_pannel_y;
  
        if (event.type == EV_REL){
          if (event.code == REL_X){
            px += event.value;
            if (px < 0){
              px =0;
            }else if (!(px < _device_width)){
              px = _device_width -1;
            }
          }else
          if (event.code == REL_Y){
            py += event.value;
            if (py < 0){
              py =0;
            }else if (!(py < _device_height)){
              py = _device_height -1;
            }
          }
          if (px != _touch_pannel_x || py != _touch_pannel_y){
            WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
            WSDdeviceEvent* evt = &(evtl->_event);
            int wid = _search_window(px,py);
            if (wid != 0){
              evt->s.type = EV_NULL;
              evt->s.cmd = W_WORK;
              evt->s.wid = wid;
              short wx = _window_list[wid -1]._x;
              short wy = _window_list[wid -1]._y;
              evt->s.wid = wid;
              evt->e.pos.x = px -wx;
              evt->e.pos.y = py -wy;
              evt->s.stat = _mouse_status;
              _touch_pannel_x = px;
              _touch_pannel_y = py;
              _draw_mouse_cursor();
              _add_event(evtl);
            }
            continue;
          }
        }
  
        if (event.type == EV_KEY){
          if (event.code == BTN_LEFT ||
              event.code == BTN_MIDDLE ||
              event.code == BTN_RIGHT){
            int mouse_status = _mouse_status;
            if (event.value == 1){
              switch(event.code){
                case BTN_LEFT:
                  mouse_status |= ES_BUT;
                  break;
                case BTN_RIGHT:
                  mouse_status |= ES_BUT2;
                  break;
              }
            }else{
              switch(event.code){
                case BTN_LEFT:
                  mouse_status &= ~ES_BUT;
                  break;
                case BTN_RIGHT:
                  mouse_status &= ~ES_BUT2;
                  break;
              }
            }
            if (mouse_status != _mouse_status){
              _mouse_status = mouse_status;
              WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
              WSDdeviceEvent* evt = &(evtl->_event);
              int wid = _search_window(px,py);
              if (wid != 0){
                if (event.value == 1){
                  evt->s.type = EV_BUTDWN;
                }else{
                  evt->s.type = EV_BUTUP;
                }
                evt->s.cmd = W_WORK;
                evt->s.wid = wid;
                short wx = _window_list[wid -1]._x;
                short wy = _window_list[wid -1]._y;
                evt->s.wid = wid;
                evt->e.pos.x = px -wx;
                evt->e.pos.y = py -wy;
                evt->s.stat = _mouse_status;
                _touch_pannel_x = px;
                _touch_pannel_y = py;
                _draw_mouse_cursor();
                _add_event(evtl);
              }
              continue;
            }
          }
        }
      }
    }else{
      return;
    }
  }
}
#endif

#ifdef MB93093
int _touch_pannel_pressed = 0;
int _mouse_input_proc(){
  while(1){
  int readlen;
  char buffer[16];
//printf("_mouse_input_proc started..\n");fflush(stdout);
  fd_set read_fds;
  FD_ZERO(&read_fds);
  int width=_mouse_dev+1;
  FD_SET(_mouse_dev,&read_fds);
  struct timeval tm;
  tm.tv_sec = 0;
  tm.tv_usec = 0;
  int ret = select(width,&read_fds,NULL,NULL,&tm);
  if (ret > 0){
    int i;
    for(i=0; i<11; i++){
      char tmp;
      int r = read(_mouse_dev,&tmp,1);
      if (tmp == 0x0d){
        buffer[i] = 0;
        break;
      }
      buffer[i] = tmp;
//printf("0x%x ",tmp);
    }
//printf("\n");
    buffer[11] = 0;
    if (strlen(buffer) != 10){
      return 0;
    }
    int pressed = False;
//printf("buffer[0]=0x%x\n",buffer[0]);
    if (buffer[0] == 0x54){
      pressed = True;
    }else if (buffer[0]== 0x52){
      pressed = False;
    }else{
      return 0;
    }
    int dx=0,dy=0;
    sscanf(&buffer[1],"%d,%d",&dx,&dy);
//printf("press=%d %d,%d\n",pressed,dx,dy);
#define OFFSET_X  40
#define OFFSET_Y  80
#define X_WIDTH  940
#define Y_WIDTH  890
    int px = (X_WIDTH - (dx - OFFSET_X))*_device_width/X_WIDTH;
    int py = (dy - OFFSET_Y)*_device_height/Y_WIDTH;
#ifdef DOUBLE_SCALE
    px /=2;
    py /=2;
#endif
    if (px < 0){
      px = 0;
    }
    if (px > _device_width -1){
      px = _device_width -1;
    }
    if (py < 0){
      py = 0;
    }
    if (py > _device_height -1){
      py = _device_height -1;
    }
#ifdef ROTATE90
    {
       int tmp = px;
       px = _device_height - py -1;
       py = tmp;
    }
#endif


//printf("pressed=%d _t_pressed=%d\n",pressed,_touch_pannel_pressed);
    if (pressed != 0 && _touch_pannel_pressed == 0){
//printf("px,py=%d,%d pressed\n",px,py);
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int wid = _search_window(px,py);
      if (wid != 0){
        evt->s.type = EV_BUTDWN;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
        evt->s.stat = ES_BUT;

        _touch_pannel_x = px;
        _touch_pannel_y = py;
        _touch_pannel_pressed = 1;
        _draw_mouse_cursor();
//        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
//        WSGFdeviceSemUnlock(_event_sem_id);
      }
//      return 0;
      continue;
    }
    if (pressed != 0 ){
      if ( _touch_pannel_x -2 < px && px < _touch_pannel_x +2){
        continue;
//        return 0;
      }
      if ( _touch_pannel_y -2 < py && py < _touch_pannel_y +2){
        continue;
//        return 0;
      }
    }


      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int wid = _search_window(px,py);
      if (wid != 0){
        if (pressed == 0 && _touch_pannel_pressed != 0){
//printf("px,py=%d,%d released\n",px,py);
          evt->s.type = EV_BUTUP;
          _touch_pannel_pressed = 0;
        }else{
//printf("px,py=%d,%d moved\n",px,py);
          evt->s.type = EV_NULL;
        }
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
        evt->s.stat = ES_BUT;
        if (_touch_pannel_pressed == 0){
          evt->s.stat = 0;
        }
        _touch_pannel_x = px;
        _touch_pannel_y = py;
        _draw_mouse_cursor();
//        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
//        WSGFdeviceSemUnlock(_event_sem_id);
      }
//      return 0;


  }else{
    return 0;
  }
  }
  return 0;
}
#endif

#ifdef MB93093
#include        <termios.h>
#endif

int init_mouse_input_dev(){
#ifndef MB93093
  _mouse_dev = open(DEFAULT_LINUX_MOUSE_DEVICE,O_RDONLY | O_NOCTTY);
#else
  _mouse_dev = open("/dev/ttyS1",O_RDWR | O_NOCTTY,0777);
  if (_mouse_dev > -1){
    struct  termios rs_arg;
    int baud = B19200;
    if (tcgetattr(_mouse_dev, &rs_arg) == -1){
      return WS_ERR;
    }
    cfsetospeed(&rs_arg, baud);
    cfsetispeed(&rs_arg, 0);
    rs_arg.c_cflag |= CRTSCTS | CS8 | CREAD;
    rs_arg.c_lflag = 0;
    rs_arg.c_cc[VTIME]    = 0;
    rs_arg.c_cc[VMIN]     = 1;
    rs_arg.c_iflag = IGNPAR;
    rs_arg.c_oflag = 0;
    tcflush(_mouse_dev, TCIFLUSH);
    if (tcsetattr(_mouse_dev, TCSANOW, &rs_arg) == -1){
      return WS_ERR;
    }
  }
#endif
  if (_mouse_dev == -1){
    return WS_ERR;
  }
#ifndef NO_THREAD
  pthread_create(&_input_mouse_thr,NULL,_mouse_input_thread,NULL);
#endif
  return WS_NO_ERR;
}

#else //ZAURUS

#define DOUBLE_SCALE
#include <linux/h3600_ts.h>
#include <errno.h>
pthread_t     _input_thr=0;
int _touch_pannel_dev =0;
int _touched = 0;
void* _zaurus_input_thread(void*){
  int readlen;
  TS_EVENT ts_event;
//printf("_zaurus_input_thread started..\n");
  while((readlen = read(_touch_pannel_dev,&ts_event,sizeof(TS_EVENT))) > 0 || errno == EINTR){
//printf("ts_event.x=%d y=%d p=%d\n",ts_event.x,ts_event.y,ts_event.pressure);
    int px = ts_event.x;
    int py = ts_event.y;
#ifdef ROTATE90
    {
      int tmp = px;
      px = _device_height - py-1;
      py = tmp;
    }
#endif
#ifdef DOUBLE_SCALE
    px /= 2;
    py /= 2;
#endif
    int diffx = _touch_pannel_x - px;
    if (diffx < 0){
      diffx = -diffx;
    }
    int diffy = _touch_pannel_y - py;
    if (diffy < 0){
      diffy = -diffy;
    }
    if (_touched == 0 && ts_event.pressure != 0){
      _touched = 1;
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int wid = _search_window(px,py);
      if (wid != 0){
        evt->s.type = EV_BUTDWN;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
        evt->s.stat = ES_BUT;
        _touch_pannel_x = px;
        _touch_pannel_y = py;
//printf("_input_dev add press event\n");
        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
        WSGFdeviceSemUnlock(_event_sem_id);
//printf("_input_dev add press event done..\n");
#ifndef NO_THREAD
        pthread_sem_unlock_np(&_event_sem);
#endif
      }
      continue;
    }else
    if (_touched == 1 && ts_event.pressure == 0){
      _touched = 0;
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int wid = _search_window(px,py);
      if (wid != 0){
        evt->s.type = EV_BUTUP;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
        evt->s.stat = 0;

        _touch_pannel_x = px;
        _touch_pannel_y = py;
//printf("_input_dev add release event\n");
        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
        WSGFdeviceSemUnlock(_event_sem_id);
//printf("_input_dev add release event done..\n");
#ifndef NO_THREAD
        pthread_sem_unlock_np(&_event_sem);
#endif
      }
      continue;
    }else if (diffx > 0 || diffy >0){
      if (_evt_list != NULL){
        continue;
      }
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int wid = _search_window(px,py);
      evt->s.type = EV_NULL;
      evt->s.wid = 0;
      evt->e.pos.x = px;
      evt->e.pos.y = py;
      evt->s.stat = ES_BUT;
      if (wid != 0){
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
      }
      _touch_pannel_x = px;
      _touch_pannel_y = py;
      WSGFdeviceSemLock(_event_sem_id);
      _add_event(evtl);
      WSGFdeviceSemUnlock(_event_sem_id);
#ifndef NO_THREAD
      pthread_sem_unlock_np(&_event_sem);
#endif
      continue;
    }
  }
  return NULL;
}

int init_zaurus_input_dev(){
  _touch_pannel_dev = open("/dev/sharp_ts",O_RDONLY | O_NOCTTY);
  if (_touch_pannel_dev == -1){
    return WS_ERR;
  }
  pthread_create(&_input_thr,NULL,_zaurus_input_thread,NULL);
  return WS_NO_ERR;
}
#endif

int _init_frame_buffer(){
  _fb_fd = open(DEFAULT_LINUX_FRAME_BUFFER_DEVICE, O_RDWR);
  if (!_fb_fd) {
    fprintf(stderr,"Error: cannot open %s device.\n",DEFAULT_LINUX_FRAME_BUFFER_DEVICE);
    WSGFexit(1);
  }
  if (ioctl(_fb_fd, FBIOGET_FSCREENINFO, &fix_info)) {
    fprintf(stderr,"Error reading the fixed information of the frame buffer.\n");
    WSGFexit(1);
  }
  if (ioctl(_fb_fd, FBIOGET_VSCREENINFO, &var_info)) {
    fprintf(stderr,"Error reading the variable information of the frame buffer.\n");
    WSGFexit(1);
  }
//printf("res=%dx%d, %dbpp\n", var_info.xres, var_info.yres, var_info.bits_per_pixel );
  _device_width = var_info.xres;
  _device_height = var_info.yres;

  _device_buffer_size =
             var_info.xres * var_info.yres * var_info.bits_per_pixel / 8;
  _fb_addr = (char *)mmap(0, _device_buffer_size,
                          PROT_READ | PROT_WRITE, MAP_SHARED,
                          _fb_fd, 0);
  if ((int)_fb_addr == -1){
#ifdef MB93093
    _fb_addr = (char*)fix_info.smem_start;
    memset(_fb_addr,0x00,_device_buffer_size);
    _fb_addr = (char*)fix_info.smem_start+32;
#else
    _fb_addr = (char*)fix_info.smem_start;
#endif
//printf("type=%d type_aux=%d visual=%d panstep=%d,%d wrap=%d\n",fix_info.type,fix_info.type_aux,fix_info.visual,fix_info.xpanstep,fix_info.ypanstep,fix_info.ywrapstep);
//printf("line_len=%d mmio=0x%x buf=0x%x accel=%d\n",fix_info.line_length,fix_info.mmio_start,fix_info.smem_start,fix_info.accel);
  }
#ifdef USE_SAME_BUF
  _device_depth = var_info.bits_per_pixel;
  if (_device_depth == 32){
    _device_start_red = 16;
    _device_start_green = 8;
    _device_start_blue = 0;
    _device_red_bits = 8;
    _device_green_bits = 8;
    _device_blue_bits = 8;
  }else if (_device_depth == 16){
    _device_start_red = 11;
    _device_start_green = 5;
    _device_start_blue = 0;
    _device_red_bits = 5;
    _device_green_bits = 6;
    _device_blue_bits = 5;
  }
  _buffer = (unsigned char*)_fb_addr;
  memset(_buffer,0xff,_device_buffer_size);
#else
  long buf_size = _device_width * _device_height * _device_depth /8;
  _buffer = (unsigned char*)malloc(buf_size);
#endif

#ifndef NO_THREAD
  pthread_sem_init_np(&_event_sem);
  pthread_sem_lock_np(&_event_sem);
#endif

#ifndef ZAURUS
  init_mouse_input_dev();
#else
  init_zaurus_input_dev();
#endif

  if ((int)_fb_addr == -1) {
    fprintf(stderr,"Error: failed to map framebuffer device to memory.\n");
    WSGFexit(1);
  }
  return 0;
}

int _update_frame_buffer(){
//printf("_update_frame_buffer.. started\n");
#ifdef USE_SAME_BUF
#else
  unsigned int depth =   _device_depth;
  unsigned int row_bytes = _device_width * _device_depth/8;
  int x;
  int y;
  for ( y = 0; y < var_info.yres; y++ ){
    int pos = (var_info.xoffset) * (var_info.bits_per_pixel/8) +
                       (y+var_info.yoffset) * fix_info.line_length;
    for ( x = 0; x < var_info.xres; x++ ){
      unsigned int val = 0;

      if (depth == 32){
        unsigned int* ptr = (unsigned int*)&_buffer[y*row_bytes + x*depth/8];
        val = *ptr;
      }else
      if (depth == 16){
        unsigned short* ptr = (unsigned short*)&_buffer[y*row_bytes + x*depth/8];
        val = *ptr;
      }

      unsigned char rr = (val >> _device_start_red) << (8 -_device_red_bits);
      unsigned char gg = (val >> _device_start_green) << (8 -_device_green_bits);
      unsigned char bb = (val >> _device_start_blue) << (8 -_device_blue_bits);
      if ( var_info.bits_per_pixel == 32 ) {
        _fb_addr[pos++] = bb;
        _fb_addr[pos++] = gg;
        _fb_addr[pos++] = rr;
        _fb_addr[pos++] = 0;
      }else if (var_info.bits_per_pixel == 16){
        unsigned short* ptr = (unsigned short*)&_fb_addr[pos++];
        unsigned short int v = (rr>>3)<<11 | (gg>>2) << 5 | (bb>>3);
        *((unsigned short int*)(ptr)) = v;
        pos++;
      }
    }
  }
#endif
//printf("_update_frame_buffer.. done\n");
  return 0;
}
int _get_event(WSDdeviceEvent* evt,unsigned int mode){
#ifdef NO_THREAD
  _mouse_input_proc();
#endif
  if (_evt_list == NULL){
    if ( _device_check_event_available() != False ){
      evt->s.type = EV_MSG;
      return WS_NO_ERR;
    }
    return WS_ERR;
  }

  WSDdeviceEventList* item = _evt_list;
  WSDdeviceEventList* item_bak = NULL;
  while(1){
    if (item == NULL){
      break;
    }
    if ((mode & 0xfff0 ) == DSPEVT){
      if (item->_event.r.type != EV_REQUEST){
        item_bak = item;
        item = item->_next;
        continue;
      }
      if (item->_event.r.cmd != W_REDISP){
        item_bak = item;
        item = item->_next;
        continue;
      }
    }
    if (item_bak == NULL){
      _evt_list = item->_next;
    }else{
      item_bak->_next = item->_next;
    }
    memcpy(evt,&(item->_event),sizeof(WSDdeviceEvent));
    free(item);
    return WS_NO_ERR;
  }
  if ((mode & 0xfff0 ) == DSPEVT){
    return WS_ERR;
  }
  //TODO: get mouse event..
  //TODO: get key event..
  if ( _device_check_event_available() != False ){
    evt->s.type = EV_MSG;
    return WS_NO_ERR;
  }
  return 0;
}
#endif
//-----------------------------------------------------------------

int WSGFdeviceFrameBufferInitialize(){
  //TODO: initialize(or attach) global(or kernel) context area..
  if (_context_area == NULL){
    _context_area = get_shared_memory();
  }
  if (_context_area == NULL){
    return WS_ERR;
  }
  //TODO: initialize colors.
  _default_black_color = 0x000000;
  _default_white_color = 0xffffff;

  char* ptr = (char*)_context_area;
  _window_list = (WSDdeviceWindow*)_context_area;
  _gc_list = (WSDdeviceGC*)&(ptr[WS_MAX_WINDOW_AREA]);
  _sem_id = WSGFdeviceSemCreate(1,0);
  _event_sem_id = WSGFdeviceSemCreate(1,0);
  return _init_frame_buffer();
}
int _device_insert_window(int parent_wid,int wid){
  if (parent_wid < 0 || WS_MAX_WINDOW < parent_wid){
    return WS_ERR_WID;
  }

  if (wid < 1){
    return WS_ERR_WID;
  }

  if (_window_list[wid -1]._window_id != wid){
    return WS_ERR_PAR;
  }

  int i;
  if (parent_wid == 0){
    for(i=0; i<WS_MAX_WINDOW; i++){
      if (_window_list[i]._window_id == wid){
        _window_list[i]._stack_no = 1;
      }else
      if (_window_list[i]._window_id > 0){
        _window_list[i]._stack_no++;
      }
    }
    return WS_NO_ERR;
  }
  int stack_no = _window_list[parent_wid-1]._stack_no;
  for(i=0; i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._stack_no < stack_no){
      //do nothing.
    }else
    if (_window_list[i]._window_id == wid){
      _window_list[i]._stack_no = stack_no + 1;
    }else{
      _window_list[i]._stack_no++;
    }
  }
  return WS_NO_ERR;
}

int _add_event(WSDdeviceEventList* evt){
//printf("_add_event evtl=%d\n",evt);
  if (_evt_list == NULL){
    _evt_list = evt;
    _evt_list->_next = NULL;
    return WS_NO_ERR;
  }
  WSDdeviceEventList* item = _evt_list;
  while(1){
    if (item->_event.e.type == EV_NULL && evt->_event.e.type == EV_NULL){
      memcpy(&(item->_event),&(evt->_event),sizeof(WSDdeviceEvent));
      free(evt);
      break;
    }
    if (item->_next == NULL){
      evt->_next = NULL;
      item->_next = evt;
      return WS_NO_ERR;
    }
    item = item->_next;
  }
  return WS_ERR;
}


int _get_device_screen_size(int* w,int* h){
  *w = _device_width;
  *h = _device_height;
  return WS_NO_ERR;
} 

WSCbool _check_low_point(int gid,short x,short y){
  WSClistData* ex_list = _gc_list[gid-1]._ex_region_list;
  if (ex_list != NULL){
    int i;
    int num = ex_list->getNum();
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)ex_list->getData(i);
      if (r == NULL){
        break;
      }
      if (r->x <= x && x < r->x + (int)r->width &&
          r->y <= y && y < r->y + (int)r->height ){
        return False;
      }
    }
  }

  WSClistData* vis_list = _gc_list[gid-1]._visible_region_list;
  if (vis_list != NULL){
    int i;
    int num = vis_list->getNum();
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)vis_list->getData(i);
      if (r == NULL){
        break;
      }
      if (r->x <= x && x < r->x + (int)r->width &&
          r->y <= y && y < r->y + (int)r->height ){
      }else{
        return False;
      }
    }
  }

  return True;
}
#define LINE_OPTIMIZE
#ifdef LINE_OPTIMIZE
int _check_line_clossed(short x1, short y1, short x2, short y2,
                            short x3, short y3, short x4, short y4,
                            short* ptx,short* pty){

//printf("_check_line_clossed %d,%d-%d,%d %d,%d-%d,%d\n",x1,y1,x2,y2,x3,y3,x4,y4);
  if (x3 == x4){
    if ((x1 < x2) && (x3 < x1 || x2 < x3)){
      return False;
    }else
    if ((x2 < x1) && (x3 < x2 || x1 < x3)){
      return False;
    }else
    if ((x2 == x1) && (x3 < x2 || x2 < x3)){
      return False;
    }
    double a = (double)(y2-y1)/(x2 -x1);
    double b = y1 - a*x1;
    short py = (short)(a*x3 + b);
//printf("_check_line_clossed %d,%d-%d,%d %d,%d-%d,%d py=%d\n",x1,y1,x2,y2,x3,y3,x4,y4,py);
    if (y3 < y4){
      if (py < y3 || y4 < py){
        return False;
      }
    }else{
      if (py < y4 || y3 < py){
        return False;
      }
    }
    *ptx = x3;
    *pty = py;
    return True;
  }else
  if (y3 == y4){
    if ((y1 < y2) && (y3 < y1 || y2 < y3)){
      return False;
    }else
    if ((y2 < y1) && (y3 < y2 || y1 < y3)){
      return False;
    }else
    if ((y2 == y1) && (y3 < y2 || y2 < y3)){
      return False;
    }
    double ad = (double)(x2 -x1)/(y2-y1);
    double bd = x1 - ad*y1;
    short px = (short)(ad*y3 + bd);
//printf("_check_line_clossed %d,%d-%d,%d %d,%d-%d,%d px=%d\n",x1,y1,x2,y2,x3,y3,x4,y4,px);
    if (x3 < x4){
      if (px < x3 || x4 < px){
        return False;
      }
    }else{
      if (px < x4 || x3 < px){
        return False;
      }
    }
    *ptx = px;
    *pty = y3;
    return True;
  }
assert(0);
  //not supported..
  return False;
}

int _get_line_in_rect(short* x1,short* y1,short* x2,short* y2,
                            short x,short y,
                            unsigned short w, unsigned short h){
  WSCpoint pt1[2];
  if (*x1 == *x2){
    if (*y1 < *y2){
      pt1[0].x = *x1;
      pt1[0].y = *y1;
      pt1[1].x = *x2;
      pt1[1].y = *y2;
    }else{
      pt1[0].x = *x2;
      pt1[0].y = *y2;
      pt1[1].x = *x1;
      pt1[1].y = *y1;
    }
  }else
  if (*x1 < *x2){
    pt1[0].x = *x1;
    pt1[0].y = *y1;
    pt1[1].x = *x2;
    pt1[1].y = *y2;
  }else{
    pt1[0].x = *x2;
    pt1[0].y = *y2;
    pt1[1].x = *x1;
    pt1[1].y = *y1;
  }
//TEST
  WSCbool in1 = WSGFinArea(x,y,w-1,h-1,pt1[0].x,pt1[0].y);
  WSCbool in2 = WSGFinArea(x,y,w-1,h-1,pt1[1].x,pt1[1].y);
  if ((in1 != False) && (in2 != False)){
//printf("_get_line_in_rect %d,%d,%d,%d %d,%d-%d,%d\n",x,y,w,h,*x1,*y1,*x2,*y2);
    return True;
  }

  WSCpoint closspt[4];
  int      clossed[4];
  int cnt = 0;
  short tx,ty;

  clossed[0] = _check_line_clossed(*x1,*y1,*x2,*y2,x,y,x+w-1,y,&tx,&ty);
  closspt[0].x = tx;
  closspt[0].y = ty;
  if (clossed[0] != False){
    cnt++;
  }
  clossed[1] = _check_line_clossed(*x1,*y1,*x2,*y2,x,y,x,y+h-1,&tx,&ty);
  closspt[1].x = tx;
  closspt[1].y = ty;
  if (clossed[1] != False){
    cnt++;
  }
  clossed[2] = _check_line_clossed(*x1,*y1,*x2,*y2,x+w-1,y,x+w-1,y+h,&tx,&ty);
  closspt[2].x = tx;
  closspt[2].y = ty;
  if (clossed[2] != False){
    cnt++;
  }
  clossed[3] = _check_line_clossed(*x1,*y1,*x2,*y2,x,y+h-1,x+w-1,y+h-1,&tx,&ty);
  closspt[3].x = tx;
  closspt[3].y = ty;
  if (clossed[3] != False){
    cnt++;
  }
  WSCpoint pt2[4];
  if (cnt > 0){
    int i;
    int c=0;
    for(i=0; i<4; i++){
      if (clossed[i] != False){
        int j;
        int not_add = False;
        for(j=0; j<c; j++){
          if (pt2[j].x == closspt[i].x &&
              pt2[j].y == closspt[i].y){
            not_add = True;
            break;
          }
        }
        if (not_add == False){
          pt2[c].x = closspt[i].x;
          pt2[c].y = closspt[i].y;
          c++;
        }
      }
    }
    cnt = c;
  }


  if (clossed[0] == False &&
      clossed[1] == False &&
      clossed[2] == False &&
      clossed[3] == False){
    return False;
  }
  if (cnt == 2){
    *x1 = pt2[0].x;
    *y1 = pt2[0].y;
    *x2 = pt2[1].x;
    *y2 = pt2[1].y;
//printf("_get_line_in_rect2 %d,%d,%d,%d %d,%d-%d,%d\n",x,y,w,h,*x1,*y1,*x2,*y2);
    return True;
  }

  if (cnt == 1){
    if (in1 == True){
      *x1 = pt1[0].x;
      *y1 = pt1[0].y;
    }else{
      *x1 = pt1[1].x;
      *y1 = pt1[1].y;
    }
    *x2 = pt2[0].x;
    *y2 = pt2[0].y;
//printf("_get_line_in_rect3 %d,%d,%d,%d %d,%d-%d,%d\n",x,y,w,h,*x1,*y1,*x2,*y2);
    return 1;
  }
  return 0;
}
int _get_line_outof_rect(short x1,short y1,short x2,short y2,
                            short x,short y,
                            unsigned short w, unsigned short h,
                            WSCpoint* pt){
//printf("_rect_line_outof_rect %d,%d,%d,%d %d,%d-%d,%d\n",x,y,w,h,x1,y1,x2,y2);
  WSCpoint pt1[2];
  if (x1 == x2){
    if (y1 < y2){
      pt1[0].x = x1;
      pt1[0].y = y1;
      pt1[1].x = x2;
      pt1[1].y = y2;
    }else{
      pt1[0].x = x2;
      pt1[0].y = y2;
      pt1[1].x = x1;
      pt1[1].y = y1;
    }
  }else
  if (x1 < x2){
    pt1[0].x = x1;
    pt1[0].y = y1;
    pt1[1].x = x2;
    pt1[1].y = y2;
  }else{
    pt1[0].x = x2;
    pt1[0].y = y2;
    pt1[1].x = x1;
    pt1[1].y = y1;
  }

  WSCbool in1 = WSGFinArea(x,y,w-1,h-1,pt1[0].x,pt1[0].y);
  WSCbool in2 = WSGFinArea(x,y,w-1,h-1,pt1[1].x,pt1[1].y);

  if ((in1 != False) && (in2 != False)){
    return 0;
  }

  WSCpoint closspt[4];
  int      clossed[4];
  int cnt = 0;
  short tx,ty;
  clossed[0] = _check_line_clossed(x1,y1,x2,y2,x-1,y-1,x+w,y-1,&tx,&ty);
  closspt[0].x = tx;
  closspt[0].y = ty;
  if (clossed[0] != False){
    cnt++;
  }
  clossed[1] = _check_line_clossed(x1,y1,x2,y2,x-1,y-1,x-1,y+h,&tx,&ty);
  closspt[1].x = tx;
  closspt[1].y = ty;
  if (clossed[1] != False){
    cnt++;
  }
  clossed[2] = _check_line_clossed(x1,y1,x2,y2,x+w,y-1,x+w,y+h,&tx,&ty);
  closspt[2].x = tx;
  closspt[2].y = ty;
  if (clossed[2] != False){
    cnt++;
  }
  clossed[3] = _check_line_clossed(x1,y1,x2,y2,x-1,y+h,x+w,y+h,&tx,&ty);
  closspt[3].x = tx;
  closspt[3].y = ty;
  if (clossed[3] != False){
    cnt++;
  }
  WSCpoint pt2[4];
  if (cnt > 0){
    int i;
    int c=0;
    for(i=0; i<4; i++){
      if (clossed[i] != False){
        int j;
        int not_add = False;
        for(j=0; j<c; j++){
          if (pt2[j].x == closspt[i].x &&
              pt2[j].y == closspt[i].y){
            not_add = True;
            break;
          }
        }
        if (not_add == False){
          pt2[c].x = closspt[i].x;
          pt2[c].y = closspt[i].y;
          c++;
        }
      }
    }
    cnt = c;
  }

//printf("clossed=%d\n",cnt);
  if (clossed[0] == False &&
      clossed[1] == False &&
      clossed[2] == False &&
      clossed[3] == False){
    pt[0].x = pt1[0].x;
    pt[0].y = pt1[0].y;
    pt[1].x = pt1[1].x;
    pt[1].y = pt1[1].y;
    return 1;
  }
  if (cnt == 1 && in1 == 0 && in2 == 0){
    pt[0].x = pt1[0].x;
    pt[0].y = pt1[0].y;
    pt[1].x = pt1[1].x;
    pt[1].y = pt1[1].y;
    return 1;
  }
  if (cnt == 2){
    if (pt2[0].x == pt2[1].x){
      if (pt2[0].y < pt2[1].y){
        pt[0].x = pt1[0].x;
        pt[0].y = pt1[0].y;
        pt[1].x = pt2[0].x;
        pt[1].y = pt2[0].y;
        pt[2].x = pt2[1].x;
        pt[2].y = pt2[1].y;
        pt[3].x = pt1[1].x;
        pt[3].y = pt1[1].y;
        return 2;
      }else{
        pt[0].x = pt1[0].x;
        pt[0].y = pt1[0].y;
        pt[1].x = pt2[1].x;
        pt[1].y = pt2[1].y;
        pt[2].x = pt2[0].x;
        pt[2].y = pt2[0].y;
        pt[3].x = pt1[1].x;
        pt[3].y = pt1[1].y;
        return 2;
      }
    }else
    if (pt2[0].x < pt2[1].x){
      pt[0].x = pt1[0].x;
      pt[0].y = pt1[0].y;
      pt[1].x = pt2[0].x;
      pt[1].y = pt2[0].y;
      pt[2].x = pt2[1].x;
      pt[2].y = pt2[1].y;
      pt[3].x = pt1[1].x;
      pt[3].y = pt1[1].y;
      return 2;
    }else{
      pt[0].x = pt1[0].x;
      pt[0].y = pt1[0].y;
      pt[1].x = pt2[1].x;
      pt[1].y = pt2[1].y;
      pt[2].x = pt2[0].x;
      pt[2].y = pt2[0].y;
      pt[3].x = pt1[1].x;
      pt[3].y = pt1[1].y;
      return 2;
    }
  }

  if (in1 == True){
    if (cnt == 1){
      pt[0].x = pt1[1].x;
      pt[0].y = pt1[1].y;
      pt[1].x = pt2[0].x;
      pt[1].y = pt2[0].y;
      return 1;
    }
  }
  if (in2 == True){
    if (cnt == 1){
      pt[0].x = pt1[0].x;
      pt[0].y = pt1[0].y;
      pt[1].x = pt2[0].x;
      pt[1].y = pt2[0].y;
      return 1;
    }
  }
  return 0;
}
int _check_low_line(int gid,short x1,short y1,short x2,short y2,
                    WSCpoint* pt1,WSCpoint* pt2,int pt_num){

//printf("_check_low_line %d,%d-%d,%d\n",x1,y1,x2,y2);
  WSClistData* vis_list = _gc_list[gid-1]._visible_region_list;
  if (vis_list != NULL){
    int i;
    int num = vis_list->getNum();
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)vis_list->getData(i);
      if (r == NULL){
        break;
      }
      if (!_get_line_in_rect(&x1,&y1,&x2,&y2,r->x,r->y,r->width,r->height)){
        return 0;
      }
    }
  }

  WSClistData* ex_list = _gc_list[gid-1]._ex_region_list;
  long ret_num = 1;
  pt1[0].x = x1; 
  pt1[0].y = y1; 
  pt2[0].x = x2; 
  pt2[0].y = y2; 
#if 1
//printf("_get_line_outof_rect ex=0x%x\n",ex_list);
  if (ex_list != NULL){
    int i;
    int num = ex_list->getNum();
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)ex_list->getData(i);
      if (r == NULL){
        break;
      }
      int j;
      int c = 0;
      WSCpoint pt1_new[pt_num];
      WSCpoint pt2_new[pt_num];
      for(j=0; j<ret_num; j++){
        WSCpoint pt[4];
        int lnum = _get_line_outof_rect(pt1[j].x,pt1[j].y,pt2[j].x,pt2[j].y,
                                        r->x,r->y,r->width,r->height,pt);
//printf("_get_line_in_rect ex %d,%d,%d,%d lnum=%d\n",r->x,r->y,r->width,r->height,lnum);
//printf("_get_line_outof_rect lnum=%d\n",lnum);
        if (lnum > 0){
//printf("_get_line_outof_rect pt1=%d,%d-%d,%d\n",pt[0].x,pt[0].y,pt[1].x,pt[1].y);
          pt1_new[c].x = pt[0].x; 
          pt1_new[c].y = pt[0].y; 
          pt2_new[c].x = pt[1].x; 
          pt2_new[c].y = pt[1].y; 
          c++;
        }
        if (lnum > 1){
//printf("_get_line_outof_rect pt2=%d,%d-%d,%d\n",pt[2].x,pt[2].y,pt[3].x,pt[3].y);
          pt1_new[c].x = pt[2].x; 
          pt1_new[c].y = pt[2].y; 
          pt2_new[c].x = pt[3].x; 
          pt2_new[c].y = pt[3].y; 
          c++;
        }
        if (c > pt_num-1){
          break;
        }
      }
      memcpy(pt1,pt1_new,sizeof(WSCpoint)*c);
      memcpy(pt2,pt2_new,sizeof(WSCpoint)*c);
      ret_num = c;
      if (ret_num == 0){
//printf("return 0;\n");
        return 0;
      }
    }
//printf("return %d;\n",ret_num);
//if (ret_num==1){
//printf("_get_line_outof_rect pt1=%d,%d-%d,%d\n",pt1[0].x,pt1[0].y,pt2[0].x,pt2[0].y);
//}
    return ret_num;
  }
#endif
  return 1;
}
#endif
int _draw_low_point(int gid,short x,short y,unsigned int val){
  unsigned char* buf = _gc_list[gid-1]._buf;
  int depth = _gc_list[gid-1]._depth;
  int row_bytes = _gc_list[gid-1]._row_bytes;
  int bytes = depth/8;

  if (buf == NULL){
    buf = _buffer;
  }
  if (depth == 32){
    int ptr = (int)(row_bytes * y + x*bytes);
    unsigned int* bf = (unsigned int*)&buf[ptr];
    *bf = (unsigned int)val;
  }else if (depth == 16){
    int ptr = (int)(row_bytes * y + x*bytes);
    unsigned short* bf = (unsigned short*)&buf[ptr];
    *bf = (unsigned short)val;
  }else if (depth == 8){
    int ptr = (int)(row_bytes * y + x*bytes);
    unsigned char* bf = (unsigned char*)&buf[ptr];
    *bf = (unsigned char)val;
  }else{
    return WS_ERR;
  }
  return WS_NO_ERR;
}
unsigned int _get_col_alpha(int gid,unsigned int fg){
//printf("_get_col_alpha=0x%x\n",(fg & 0xff000000)>>24);
  return (fg & 0xff000000) >> 24;
}
int _get_col_rgb(int gid,unsigned int fg,unsigned char* r,unsigned char* g,unsigned char* b){
  *r = (fg & 0xff0000) >> 16;
  *g = (fg & 0x00ff00) >> 8;
  *b = (fg & 0x0000ff);
  return WS_NO_ERR;
}

inline int _draw_point(int gid,short x,short y,unsigned char r2,
                                               unsigned char g2,
                                               unsigned char b2,
                                               unsigned char alpha){
  unsigned char* buf = _gc_list[gid-1]._buf;
  unsigned int depth =   _gc_list[gid-1]._depth;
  unsigned int start_red =   _gc_list[gid-1]._start_red;
  unsigned int start_green = _gc_list[gid-1]._start_green;
  unsigned int start_blue =  _gc_list[gid-1]._start_blue;
  unsigned int red_bits =    _gc_list[gid-1]._red_bits;
  unsigned int green_bits =  _gc_list[gid-1]._green_bits;
  unsigned int blue_bits =   _gc_list[gid-1]._blue_bits;
  unsigned int row_bytes =   _gc_list[gid-1]._row_bytes;

  unsigned char r,g,b;
//  unsigned char r2 =  (fg & 0xff0000) >> 16;
//  unsigned char g2 =  (fg & 0x00ff00) >> 8;
//  unsigned char b2 =  (fg & 0x0000ff);
//  unsigned char alpha = (fg & 0xff000000)>>24;

  if (buf == NULL){
    buf = _buffer;
  }

  if (depth == 32){
    unsigned int val = 0;
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    val = *ptr;
    r = (val >> start_red) << (8 -red_bits);
    g = (val >> start_green) << (8 -green_bits);
    b = (val >> start_blue) << (8 -blue_bits);
    r = (r*(256 - alpha) + r2*alpha)/256;
    g = (g*(256 - alpha) + g2*alpha)/256;
    b = (b*(256 - alpha) + b2*alpha)/256;
    *ptr = ((r >> (8-red_bits)) << start_red)|
           ((g >> (8-green_bits)) << start_green)|
           ((b >> (8-blue_bits)) << start_blue);
  }else
  if (depth == 24){
//printf("_get_rgb() need implement..\n");
//    long ptr = y*row_bytes + x*depth/8;
//    val = buf[ptr] << 16 | buf[ptr+1] << 8 | buf[ptr+2];
  }else
  if (depth == 16){
    unsigned short val = 0;
    unsigned short* ptr = (unsigned short*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned short)*ptr;
    r = (val >> start_red) << (8 -red_bits);
    g = (val >> start_green) << (8 -green_bits);
    b = (val >> start_blue) << (8 -blue_bits);
    r = (r*(256 - alpha) + r2*alpha)/256;
    g = (g*(256 - alpha) + g2*alpha)/256;
    b = (b*(256 - alpha) + b2*alpha)/256;
    *ptr = ((r >> (8-red_bits)) << start_red)|
           ((g >> (8-green_bits)) << start_green)|
           ((b >> (8-blue_bits)) << start_blue);
  }else{
    unsigned char val = 0;
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned char)*ptr;
    r = (val >> start_red) << (8 -red_bits);
    g = (val >> start_green) << (8 -green_bits);
    b = (val >> start_blue) << (8 -blue_bits);
    r = (r*(256 - alpha) + r2*alpha)/256;
    g = (g*(256 - alpha) + g2*alpha)/256;
    b = (b*(256 - alpha) + b2*alpha)/256;
    *ptr = ((r >> (8-red_bits)) << start_red)|
           ((g >> (8-green_bits)) << start_green)|
           ((b >> (8-blue_bits)) << start_blue);
  }
  return WS_NO_ERR;
}

int _draw_low_hline(int gid,short x,short y,unsigned int w,unsigned int val){
  unsigned char* buf = _gc_list[gid-1]._buf;
  int depth = _gc_list[gid-1]._depth;
  int row_bytes = _gc_list[gid-1]._row_bytes;
  int bytes = depth/8;

  if (buf == NULL){
    buf = _buffer;
  }
#ifdef ROTATE90
  if (buf == _buffer){
    if (depth == 32){
      int i;
      int dx,dy;
      for(i = x; i < x + w; i++){
        dx = y;
        dy = _device_height - i-1;
        unsigned int* ptr = (unsigned int*)&buf[dy*row_bytes + dx*depth/8];
        *ptr = (unsigned int)val;
      }
    }else
    if (depth == 16){
      int i;
      int dx,dy;
      for(i = x; i < x + w; i++){
        dx = y;
        dy = _device_height - i;
        unsigned short* ptr = (unsigned short*)&buf[dy*row_bytes + dx*depth/8];
        *ptr = (unsigned short)val;
      }
    }else
    if (depth == 8){
      int i;
      int dx,dy;
      for(i = x; i < x + w; i++){
        dx = y;
        dy = _device_height - i;
        unsigned char* ptr = (unsigned char*)&buf[dy*row_bytes + dx*depth/8];
        *ptr = (unsigned char)val;
      }
    }else{
      return WS_ERR;
    }
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&buf[y*2*row_bytes + x*2*depth/8];
      unsigned int* ptr2 = (unsigned int*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      int i;
      for(i=0; i<(int)w;i++){
        *ptr++ = (unsigned int)val;
        *ptr++ = (unsigned int)val;
        *ptr2++ = (unsigned int)val;
        *ptr2++ = (unsigned int)val;
      }
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&buf[y*2*row_bytes + x*2*depth/8];
      unsigned short* ptr2 = (unsigned short*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      int i;
      for(i=0; i<(int)w;i++){
        *ptr++ = (unsigned short)val;
        *ptr++ = (unsigned short)val;
        *ptr2++ = (unsigned short)val;
        *ptr2++ = (unsigned short)val;
      }
    }else
    if (depth == 8){
      unsigned char* ptr = (unsigned char*)&buf[y*2*row_bytes + x*2*depth/8];
      unsigned char* ptr2 = (unsigned char*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      int i;
      for(i=0; i<(int)w;i++){
        *ptr++ = (unsigned char)val;
        *ptr++ = (unsigned char)val;
        *ptr2++ = (unsigned char)val;
        *ptr2++ = (unsigned char)val;
      }
    }else{
      return WS_ERR;
    }
    return WS_NO_ERR;
  }
#endif
  if (depth == 32){
    int ptr = (int)(row_bytes * y + x*bytes);
    unsigned int* bf = (unsigned int*)&buf[ptr];
    int i;
    for(i=0; i<(int)w; i++){
      *bf++ = (unsigned int)val;
    }
  }else if (depth == 16){
    int ptr = (int)(row_bytes * y + x*bytes);
    unsigned short* bf = (unsigned short*)&buf[ptr];
    int i;
    for(i=0; i<(int)w; i++){
      *bf++ = (unsigned short)val;
    }
  }else if (depth == 8){
    int ptr = (int)(row_bytes * y + x*bytes);
    unsigned char* bf = (unsigned char*)&buf[ptr];
    memset(bf,val,w);
  }else{
    return WS_ERR;
  }
  return WS_NO_ERR;
}

unsigned int _get_col_value(int gid,unsigned int fg){
  int red_shift = _gc_list[gid-1]._start_red;
  int green_shift = _gc_list[gid-1]._start_green;
  int blue_shift = _gc_list[gid-1]._start_blue;

  int red_bits = _gc_list[gid-1]._red_bits;
  int green_bits = _gc_list[gid-1]._green_bits;
  int blue_bits = _gc_list[gid-1]._blue_bits;

  unsigned char red   = (fg & 0xff0000) >> 16;
  unsigned char green = (fg & 0x00ff00) >> 8;
  unsigned char blue  = (fg & 0x0000ff);
  unsigned int val = ((red >> (8-red_bits)) << red_shift)|
                         ((green >> (8-green_bits)) << green_shift)|
                         ((blue >> (8-blue_bits)) << blue_shift);
  return val;
}

int _draw_line(int gid,short x1,short y1,short x2,short y2,unsigned int fg){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
//  unsigned char* buf = _gc_list[gid-1]._buf;
//  int row_bytes = _gc_list[gid-1]._row_bytes;

//  int depth = _gc_list[gid-1]._depth;
  int gx = _gc_list[gid-1]._x;
  int gy = _gc_list[gid-1]._y;
  int gw = _gc_list[gid-1]._w;
  int gh = _gc_list[gid-1]._h;
  int lw = _gc_list[gid-1]._lw;
//printf("_draw_line lw=%d\n",lw);
#if 0 //develop..
  int in = _get_line_in_rect(&x1,&y1,&x2,&y2,gx,gy,gw,gh);
  if (in == False){
    return WS_NO_ERR;
  }
#endif
  unsigned int val = _get_col_value(gid,fg);
  unsigned int alpha = _get_col_alpha(gid,fg);

  WSCpoint pt1[WS_MAX_POINTS];
  WSCpoint pt2[WS_MAX_POINTS];
  int num = 1;
  int optimize = 0;
#ifdef LINE_OPTIMIZE
  if (y1 == y2 && lw < 2 && alpha == 0xff){
    optimize = 1;
    num = _check_low_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
    if (num == 0){
      return WS_NO_ERR;
    }
    x1 = pt1[0].x;
    y1 = pt1[0].y;
    x2 = pt2[0].x;
    y2 = pt2[0].y;
  }
  pt1[0].x = x1;
  pt1[0].y = y1;
  pt2[0].x = x2;
  pt2[0].y = y2;
#else
  pt1[0].x = x1;
  pt1[0].y = y1;
  pt2[0].x = x2;
  pt2[0].y = y2;
#endif

  int diffx1 = x2 - x1; 
  int diffy1 = y2 - y1; 
  int diffx2 = (diffx1 > 0)?diffx1:-diffx1;
  int diffy2 = (diffy1 > 0)?diffy1:-diffy1;

  double cos_v = diffx1 / sqrt(diffx1*diffx1 + diffy1*diffy1);
  double sin_v = diffy1 / sqrt(diffx1*diffx1 + diffy1*diffy1);
//printf("cos_v=%lf sin_v=%lf lw=%d\n",cos_v,sin_v,lw);
  unsigned char r2 =  (fg & 0xff0000) >> 16;
  unsigned char g2 =  (fg & 0x00ff00) >> 8;
  unsigned char b2 =  (fg & 0x0000ff);

  int i;
  for(i=0; i<num; i++){
//printf("draw_line rowbytes=%d val=0x%x\n",row_bytes,val);
//  int i,j;
    x1 = pt1[i].x;
    y1 = pt1[i].y;
    x2 = pt2[i].x;
    y2 = pt2[i].y;

    if (y1 == y2){
      if (diffx1 > 0){
#ifdef LINE_OPTIMIZE
        if (optimize != 0){
          if (x1 < x2){
            _draw_low_hline(gid,x1,y1,x2-x1+1,val);
          }else{
            _draw_low_hline(gid,x2,y1,x1-x2+1,val);
          }
        }else{
#endif
        int x;
        for(x = x1; x <= x2; x++){
          if (lw < 2){
            if (gx < x && x < gx+gw &&
                gy < y1 && y1 < gy+gh){
              if (_check_low_point(gid,x,y1)){
                if (alpha == 0xff){
                  _draw_low_point(gid,x,y1,val);
                }else{
                  _draw_point(gid,x,y1,r2,g2,b2,alpha);
                }
              }
            }
          }else{
            int y;
            for(y = 0; y < lw; y++){
              int yy = y - lw/2 + y1;
              if (gx < x && x < gx+gw &&
                  gy < yy && yy < gy+gh){
                if (_check_low_point(gid,x,yy)){
                  if (alpha == 0xff){
                    _draw_low_point(gid,x,yy,val);
                  }else{
                    _draw_point(gid,x,yy,r2,g2,b2,alpha);
                  }
                }
              }
            }
          }
        }
#ifdef LINE_OPTIMIZE
        }
#endif
      }else{
#ifdef LINE_OPTIMIZE
        if (optimize != 0){
          if (x2 < x1){
            _draw_low_hline(gid,x2,y2,x1 -x2 +1,val);
          }else{
            _draw_low_hline(gid,x1,y2,x2 -x1 +1,val);
          }
        }else{
#endif
        int x;
        for(x = x2; x <= x1; x++){
          if (lw < 2){
            if (gx < x && x < gx+gw &&
                gy < y1 && y1 < gy+gh){
              if (_check_low_point(gid,x,y1)){
                if (alpha == 0xff){
                  _draw_low_point(gid,x,y1,val);
                }else{
                  _draw_point(gid,x,y1,r2,g2,b2,alpha);
                }
              }
            }
          }else{
            int y;
            for(y = 0; y < lw; y++){
              int yy = y - lw/2 + y1;
              if (gx < x && x < gx+gw &&
                  gy < yy && yy < gy+gh){
                if (_check_low_point(gid,x,yy)){
                  if (alpha == 0xff){
                    _draw_low_point(gid,x,yy,val);
                  }else{
                    _draw_point(gid,x,yy,r2,g2,b2,alpha);
                  }
                }
              }
            }
          }
        }
#ifdef LINE_OPTIMIZE
        }
#endif
      }
    }else if (x1 == x2){
      if (diffy1 > 0){
        int y;
        for(y = y1; y <= y2; y++){
          if (lw < 2){
            if (gx < x1 && x1 < gx+gw &&
                gy < y && y < gy+gh){
              if (_check_low_point(gid,x1,y)){
                if (alpha == 0xff){
                  _draw_low_point(gid,x1,y,val);
                }else{
                  _draw_point(gid,x1,y,r2,g2,b2,alpha);
                }
              }
            }
          }else{
            int x;
            for(x = 0; x < lw; x++){
              int xx = x - lw/2 + x1;
              if (gx < xx && xx < gx+gw &&
                  gy < y && y < gy+gh){
                if (_check_low_point(gid,xx,y)){
                  if (alpha == 0xff){
                    _draw_low_point(gid,xx,y,val);
                  }else{
                    _draw_point(gid,xx,y,r2,g2,b2,alpha);
                  }
                }
              }
            }
          }
        }
      }else{
        int y;
        for(y = y2; y <= y1; y++){
          if (lw < 2){
            if (gx < x1 && x1 < gx+gw &&
                gy < y && y < gy+gh){
              if (_check_low_point(gid,x1,y)){
                if (alpha == 0xff){
                  _draw_low_point(gid,x1,y,val);
                }else{
                  _draw_point(gid,x1,y,r2,g2,b2,alpha);
                }
              }
            }
          }else{
            int x;
            for(x = 0; x < lw; x++){
              int xx = x - lw/2 + x1;
              if (gx < xx && xx < gx+gw &&
                  gy < y && y < gy+gh){
                if (_check_low_point(gid,xx,y)){
                  if (alpha == 0xff){
                    _draw_low_point(gid,xx,y,val);
                  }else{
                    _draw_point(gid,xx,y,r2,g2,b2,alpha);
                  }
                }
              }
            }
          }
        }
      }
    }else{
      if (diffx2 > diffy2){
        if (diffx1 < 0){
          long tmp = x1;
          x1 = x2;
          x2 = tmp;
          tmp = y1;
          y1 = y2;
          y2 = tmp;
          diffx1 = -diffx1;
          diffy1 = -diffy1;
        }
        int x;
        int lwd = (int)(lw/cos_v);
        if (lwd < 0){
          lwd = -lwd;
        }
        for(x = x1; x <= x2; x++){
          if (lw < 2){
            int y = (int)(y1+ (double)diffy1* (x-x1)/diffx2);
            if (gx <= x && x < gx+gw &&
                gy <= y && y < gy+gh){
              if (_check_low_point(gid,x,y)){
                if (alpha == 0xff){
                  _draw_low_point(gid,x,y,val);
                }else{
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
              }
            }
          }else{
            int y3 = (int)(y1+ (double)diffy1* (x-x1)/diffx2);
            int y;
            for(y=0; y<(lwd); y++){
              int yy = (y - (lwd)/2) + y3;
              int xx = x;
//              int yy = (y - lw/2)*sin_v + y3;
//              int xx = (y - lw/2)*cos_v + x;
              if (gx <= xx && xx < gx+gw &&
                  gy <= yy && yy < gy+gh){
                if (_check_low_point(gid,xx,yy)){
                  if (alpha == 0xff){
                    _draw_low_point(gid,xx,yy,val);
                  }else{
                    _draw_point(gid,xx,yy,r2,g2,b2,alpha);
                  }
                }
              }
            }
          }
        }
      }else{
        if (diffy1 < 0){
          long tmp = x1;
          x1 = x2;
          x2 = tmp;
          tmp = y1;
          y1 = y2;
          y2 = tmp;
          diffx1 = -diffx1;
          diffy1 = -diffy1;
        }
        int y;
        int lwd = (int)(lw/sin_v);
        if (lwd < 0){
          lwd = -lwd;
        }
        for(y = y1; y <= y2; y++){
          if (lw < 2){
            int x = (int)(x1+ (double)diffx1* (y-y1)/diffy2);
            if (gx <= x && x < gx+gw &&
                gy <= y && y < gy+gh){
              if (_check_low_point(gid,x,y)){
                if (alpha == 0xff){
                  _draw_low_point(gid,x,y,val);
                }else{
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
              }
            }
          }else{
            int x3 = (int)(x1+ (double)diffx1* (y-y1)/diffy2);
            int x;
            for(x=0; x<lw; x++){
              int xx = (x - (lw)/2) + x3;
              int yy = y;
//              int xx = (x - lw/2)*cos_v + x3;
//              int yy = (x - lw/2)*sin_v + y;
              if (gx <= xx && xx < gx+gw &&
                  gy <= yy && yy < gy+gh){
                if (_check_low_point(gid,xx,yy)){
                  if (alpha == 0xff){
                    _draw_low_point(gid,xx,yy,val);
                  }else{
                    _draw_point(gid,xx,yy,r2,g2,b2,alpha);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return WS_NO_ERR;
}
int _draw_rect(int gid,short dx,short dy,
               unsigned short dw,unsigned short dh,
               unsigned int fg){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  _draw_line(gid,dx,dy,dx + dw-1,dy,fg);
  _draw_line(gid,dx,dy,dx,dy + dh-1,fg);
  _draw_line(gid,dx + dw-1 ,dy,dx + dw-1,dy + dh-1,fg);
  _draw_line(gid,dx ,dy + dh-1,dx + dw-1,dy + dh-1,fg);
  return WS_NO_ERR;
}



int _draw_fill_rect(int gid,short dx,short dy,
               unsigned short dw,unsigned short dh,
               unsigned int bg){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  //TODO: draw rectangle..
//  int row_bytes = _gc_list[gid-1]._row_bytes;

  long dev_x = _gc_list[gid-1]._x;
  long dev_y = _gc_list[gid-1]._x;
  unsigned int dev_w = _gc_list[gid-1]._w;
  unsigned int dev_h = _gc_list[gid-1]._h;

  long x,y;
  unsigned long w,h;
  WSGFandArea(dx,dy,dw,dh,dev_x,dev_y,dev_w,dev_h,
              &x,&y,&w,&h);

//printf("draw_fill_rect x,y,w,h=%d,%d,%d,%d buf=0x%x\n",dx,dy,dw,dh,buf);
//printf("draw_fill_rect 0x%x 0x%x 0x%x depth=%d\n",red,green,blue,depth);
  unsigned int val = _get_col_value(gid,bg);
  unsigned int alpha = _get_col_alpha(gid,bg);

//printf("draw_fill_rect rowbytes=%d val=0x%x\n",row_bytes,val);
  unsigned int lwbk = _gc_list[gid-1]._lw;
  _gc_list[gid-1]._lw = 1;
  unsigned char r2 =  (bg & 0xff0000) >> 16;
  unsigned char g2 =  (bg & 0x00ff00) >> 8;
  unsigned char b2 =  (bg & 0x0000ff);

  int i,j;
  int right = x+w;
  int bottom = y+h;
  for(i=y; i<bottom; i++){
    if (alpha == 0xff){
#ifdef LINE_OPTIMIZE
      WSCpoint pt1[WS_MAX_POINTS];
      WSCpoint pt2[WS_MAX_POINTS];
      int num = _check_low_line(gid,x,i,right-1,i,pt1,pt2,WS_MAX_POINTS);
      for(j=0; j<num; j++){
        int x1 = pt1[j].x;
        int y1 = pt1[j].y;
        int x2 = pt2[j].x;
//        int y2 = pt2[j].y;
        if (x1 < x2){
          _draw_low_hline(gid,x1,y1,x2-x1+1,val);
        }else{
          _draw_low_hline(gid,x2,y1,x1-x2+1,val);
        }
      }
#else
      for(j=x; j<right; j++){
        if (_check_low_point(gid,j,i)){
          _draw_low_point(gid,j,i,val);
        }
      }
#endif
    }else{
      for(j=x; j<right; j++){
        if (_check_low_point(gid,j,i)){
          _draw_point(gid,j,i,r2,g2,b2,alpha);
        }
      }
    }
  }
  _gc_list[gid-1]._lw = lwbk;
  return WS_NO_ERR;
}

struct _poly_data_{
  double no;
  double a;
  double b;
  WSCbool static_x;
  long x1;
  long x2;
  long y1;
  long y2;
  long temp_x;
  long temp_y;
  WSCbool active;
};

int _draw_fill_poly(int gid,WSCpoint* point,int num, unsigned int bg,int rev){
  _poly_data_* poly_data = new _poly_data_[num];
  long lw =  _gc_list[gid-1]._lw;
  _gc_list[gid-1]._lw = 1;
  long i;
#define MAX_CO 1000000
  long min_x = MAX_CO;
  long max_x = -MAX_CO;
  long min_y = MAX_CO;
  long max_y = -MAX_CO;
//printf("WSGFdfbDrawPolygon num=%d\n",num);
  for(i=0; i<num; i++){
    long x1 = point[i].x;
    long y1 = point[i].y;
    long x2 = 0;
    long y2 = 0;
    if (i== num -1){
      x2 = point[0].x;
      y2 = point[0].y;
    }else{
      x2 = point[i+1].x;
      y2 = point[i+1].y;
    }
    if (x1 != x2){
      poly_data[i].a = ((double)(y1 - y2))/(x1 - x2);
      poly_data[i].b = ((double)(x1*y2 - x2*y1))/(x1 - x2);
      poly_data[i].static_x = False;
    }else{
      poly_data[i].a = 0;
      poly_data[i].b = 0;
      poly_data[i].static_x = True;
    }
    poly_data[i].x1 = x1;
    poly_data[i].x2 = x2;
    poly_data[i].y1 = y1;
    poly_data[i].y2 = y2;
    poly_data[i].no = i;
    if (x1 < min_x){
      min_x = x1;
    }
    if (x2 < min_x){
      min_x = x2;
    }
    if (y1 < min_y){
      min_y = y1;
    }
    if (y2 < min_y){
      min_y = y2;
    }
    if (max_x < x1){
      max_x = x1;
    }
    if (max_x < x2){
      max_x = x2;
    }
    if (max_y < y1){
      max_y = y1;
    }
    if (max_y < y2){
      max_y = y2;
    }
  }
  long y;
  for(y = min_y; y < max_y +1; y++){
    long i;
    long actives = 0;
    WSClistData active_list;

    for(i=0; i<num; i++){
      WSCbool active = False;
      if ( poly_data[i].y1 < poly_data[i].y2){
        if ( poly_data[i].y1 <= y && y <= poly_data[i].y2){
//          if (poly_data[i].a != 0){
            active = True;
//          }else if (poly_data[i].static_x != False){
//            active = True;
//          }else{
//            poly_data[i].active = False;
//          }
        }else{
          poly_data[i].active = False;
        }
      }else{
        if ( poly_data[i].y2 <= y && y <= poly_data[i].y1){
//          if (poly_data[i].a != 0){
            active = True;
//          }else if (poly_data[i].static_x != False){
//            active = True;
//          }else{
//            poly_data[i].active = False;
//          }
        }else{
          poly_data[i].active = False;
        }
      }
      if (active != False){
        poly_data[i].active = True;
        if (poly_data[i].static_x == False && poly_data[i].a != 0){
          poly_data[i].temp_x = (long)(((double)y - poly_data[i].b)/poly_data[i].a);
        }else{
          poly_data[i].temp_x = poly_data[i].x1;
        }
        poly_data[i].temp_y = y;
        int j=0;
        if (actives == 0){
          active_list.add((void*)&(poly_data[i]));
        }else{
          for(j=0; j<actives; j++){
            _poly_data_* item =(_poly_data_*)active_list[j];
            if (poly_data[i].temp_x < item->temp_x){
              active_list.add((void*)&(poly_data[i]),j);
              break;
            }
            if (j == actives -1){
              active_list.add((void*)&(poly_data[i]));
              break;
            }
          }
        }
        actives++;
      }
    }

    {
      long direction =0;
      long counts = 1;
      _poly_data_* item =(_poly_data_*)active_list[0];
      if (item->y1 > item->y2){
        direction = 1;
      }
      int j;
      for(j=0; j<actives-1; j++){
        long direction1 =0;
        long direction2 =0;
        _poly_data_* item1 =(_poly_data_*)active_list[j];
        _poly_data_* item2 =(_poly_data_*)active_list[j+1];
        if (item1->y1 > item1->y2){
          direction1 = 1;
        }
        if (item2->y1 > item2->y2){
          direction2 = 1;
        }
        if (item1->a == 0 && item1->static_x == False){
          _draw_line(gid,item1->temp_x,y,item2->temp_x,y,bg);
          continue;
        }
        if (direction == direction2){
          if (item1->no == item2->no + 1 ||
              item2->no == item1->no + 1 ||
              (item1->no == 0 && item2->no == num -1) ||
              (item2->no == 0 && item1->no == num -1) ){
            if (direction1 != direction2){
              counts++;
            }else
            if(item1->temp_x != item2->temp_x){
              counts++;
            }
            // these lines has same point. // ignore countup.
          }else{
            counts++;
          }
        }else{
          if (item1->no == item2->no + 1 ||
              item2->no == item1->no + 1 ||
              (item1->no == 0 && item2->no == num -1) ||
              (item2->no == 0 && item1->no == num -1) ){
            if (direction1 != direction2){
              counts--;
            }else
            if(item1->temp_x != item2->temp_x){
              counts--;
            }
            // these lines has same point. // ignore countup.
          }else{
            counts--;
          }
        }
        if (counts > 1 && rev == True){
          _draw_line(gid,item1->temp_x,y,item2->temp_x,y,bg);
        }else if (counts%2 == 0){
          _draw_line(gid,item1->temp_x,y,item2->temp_x,y,bg);
        }
      }
    }
  }
  delete poly_data;
  _gc_list[gid-1]._lw = lw;
  return WS_NO_ERR;
}
#if (defined NO_DRAW_ARC) && (defined NO_DRAW_FILL_ARC)
#else
void _draw_arc( int gid,int x,int y, int w,int h,
                     long a1,long a2,WSCbool fill,long type,int bg){
//printf("w,h=%d,%d\n",w,h);
  double an1 = (double)a1/64;
  double an2 = (double)a2/64;
  WSCbool circle = False;
  if (an2 - an1 >= 360){
    circle = True;
    an2 = 360;
  }
//#define WS_PT_NUM 36
//#define WS_PT_NUM 360
#define WS_PI_VALUE 3.14159265358979323846
  long points = (long)((w+h)*2 * WS_PI_VALUE * an2 / 360);
//  WSCpoint point[WS_PT_NUM+1];
  WSCpoint point[points+1];

  long cnt = 0;
  int i;
  for(i=0; i<points; i++){
    point[cnt].x = (long)(x + (double)w/2 +
           w * cos(WS_PI_VALUE * (an1 + (an2* i)/(points-1))  / 180)/2 + 0.5);
    point[cnt].y = (long)(y + (double)h/2 -
           h * sin(WS_PI_VALUE * (an1 + (an2* i)/(points-1))  / 180)/2 + 0.5);
    if (cnt > 0){
      if (point[cnt].x == point[cnt-1].x &&
          point[cnt].y == point[cnt-1].y){
        continue;
      }
    }
    cnt++;
  }
//printf("w,h=%d,%d\n",w,h);
  unsigned int val = _get_col_value(gid,bg);
  unsigned int alpha = _get_col_alpha(gid,bg);
  unsigned char r2 =  (bg & 0xff0000) >> 16;
  unsigned char g2 =  (bg & 0x00ff00) >> 8;
  unsigned char b2 =  (bg & 0x0000ff);
  if (fill == False){
    if (alpha == 0xff){
      for(i=0; i<cnt; i++){
        if (_check_low_point(gid,point[i].x,point[i].y)){
          _draw_low_point(gid,point[i].x,point[i].y,val);
        }
      }
    }else{
      for(i=0; i<cnt; i++){
        if (_check_low_point(gid,point[i].x,point[i].y)){
          _draw_point(gid,point[i].x,point[i].y,r2,g2,b2,alpha);
        }
      }
    }
  }else{
    if (circle == False && type == WS_PI){
      point[cnt].x = x + w/2;
      point[cnt].y = y + h/2;
      _draw_fill_poly(gid,point,cnt+1,bg,False);
    }else{
      _draw_fill_poly(gid,point,cnt,bg,False);
    }
  }

}
#endif

int _draw_low_bitmap(int gid,short dx,short dy,
               unsigned short dw,unsigned short dh,
               unsigned int val,unsigned char* bmp){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  int i,j;
  for(i=0; i<dh; i++){
    unsigned char* ptr = &bmp[i*((dw+7)/8)];
    unsigned char b = *ptr;
    for(j=0; j<dw; j++){
      if (_check_low_point(gid,j+dx,i+dy)){
        if (b & 0x80){
          _draw_low_point(gid,j+dx,i+dy,val);
        }
      }
      b <<= 1;
      if (!((j+1) % 8)){
        ptr++;
        b = *ptr;
      }
    }
  }
  return WS_NO_ERR;
}
int _draw_bitmap(int gid,short dx,short dy,
               unsigned short dw,unsigned short dh,
               unsigned int fg,unsigned char* bmp){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  int i,j;
  unsigned char a2 =  (fg & 0xff000000) >> 24;
  unsigned char r2 =  (fg & 0xff0000) >> 16;
  unsigned char g2 =  (fg & 0x00ff00) >> 8;
  unsigned char b2 =  (fg & 0x0000ff);
  for(i=0; i<dh; i++){
    unsigned char* ptr = &bmp[i*((dw+7)/8)];
    unsigned char b = *ptr;
    for(j=0; j<dw; j++){
      if (_check_low_point(gid,j+dx,i+dy)){
        if (b & 0x80){
          _draw_point(gid,j+dx,i+dy,r2,g2,b2,a2);
        }
      }
      b <<= 1;
      if (!((j+1) % 8)){
        ptr++;
        b = *ptr;
      }
    }
  }
  return WS_NO_ERR;
}


int _draw_string(int gid,WSDdeviceFontList* fl, short dx,short dy,
               unsigned int fg,WSCushort* str,int nchars){
  if (fl == NULL){
    return WS_ERR;
  }
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  //TODO: draw rectangle..
//  int row_bytes = _gc_list[gid-1]._row_bytes;

//  long dev_x = _gc_list[gid-1]._x;
//  long dev_y = _gc_list[gid-1]._x;
//  unsigned long dev_w = _gc_list[gid-1]._w;
//  unsigned long dev_h = _gc_list[gid-1]._h;

  long x,y;
//  unsigned long w,h;
//  WSGFandArea(dx,dy,32767,32767,dev_x,dev_y,dev_w,dev_h,
//              &x,&y,&w,&h);
  x = dx;
  y = dy;

//printf("draw_string x,y,w,h=%d,%d nchars=%d\n",dx,dy,nchars);
//printf("draw_fill_rect 0x%x 0x%x 0x%x depth=%d\n",red,green,blue,depth);
  unsigned int val = _get_col_value(gid,fg);
  unsigned int alpha = _get_col_alpha(gid,fg);
  WSCushort* sptr = 0;
  int width = 0;
  int height = 0;
//  int len = 0;
  WSCushort c;
  int code = 0;
  WSDdeviceFont* f;

  if(nchars < 0){
    nchars = WSGFstrlenUCS2(str);
  }
  sptr = str;
  int i;
  int* font_order = fl->getFontOrder();
//printf("_draw_string! nchars=%d\n",nchars);
  for(i = 0; i < nchars; i++) {
    if(i == nchars) {
      code = WS_FONT_NONE;
    } else {
      c = *sptr;
extern int WSGFdeviceQueryChar(unsigned short*,int*);
      code = WSGFdeviceQueryChar(&c,font_order);
    }
//printf("font_order %d,%d,%d\n",font_order[0],font_order[1],font_order[2]);
//printf("code=%d c=0x%x c=#%c# fl=0x%x\n",code,c,c,fl);
//fflush(stdout);
    f = fl->getFont(code);
    if(!f){
      f = fl->getFont(WS_FONT_ISO8859(1));
    }
    height = f->_height;
    if (f != NULL){
      WSDdeviceFontGryph* fgr = f->getFontGryph(c);
//printf("c=%d 0x%x charcode=%d\n",c,c,fgr->_char_code);
      if (fgr != NULL){
        width = fgr->_width;
//printf("width=%d\n",width);
        if (alpha == 0xff){
          _draw_low_bitmap(gid,x,dy - f->_height,width,height,val,fgr->_data);
        }else{
          _draw_bitmap(gid,x,dy - f->_height,width,height,fg,fgr->_data);
        }
      }else{
        width = f->_width;
//printf("_draw_string ->2 _draw_rect! w,h=%d,%d\n",width,height);
        _draw_rect(gid,x,dy - f->_height,width,height,fg);
      }
      x += width+1;
    }
    sptr++;
  }
  long diff = x - dx;
  _gc_list[gid-1]._draw_pt_x += diff;

  return WS_NO_ERR;
}
int _get_string_width(int gid,WSDdeviceFontList* fl,WSCushort* str,int nchars){
  if (fl == NULL){
    return WS_ERR;
  }
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  //TODO: draw rectangle..

  long dx = 0;

  WSCushort* sptr = 0;
  int width = 0;
  int height = 0;
//  int len = 0;
  WSCushort c;
  int code = 0;
  WSDdeviceFont* f;

  if(nchars < 0){
    nchars = WSGFstrlenUCS2(str);
  }
  sptr = str;
  int i;
  int* font_order = fl->getFontOrder();
//printf("_draw_string! nchars=%d\n",nchars);
  for(i = 0; i < nchars; i++) {
    if(i == nchars) {
      code = WS_FONT_NONE;
    } else {
      c = *sptr;
extern int WSGFdeviceQueryChar(unsigned short*,int*);
      code = WSGFdeviceQueryChar(&c,font_order);
    }
    f = fl->getFont(code);
    if(!f){
      f = fl->getFont(WS_FONT_ISO8859(1));
    }
    height = f->_height;
    if (f != NULL){
      WSDdeviceFontGryph* fgr = f->getFontGryph(c);
      if (fgr != NULL){
        width = fgr->_width;
      }else{
        width = f->_width;
      }
      dx += width+1;
    }
    sptr++;
  }

  return dx;
}
int _draw_window(int wid,short x,short y,unsigned short w,unsigned short h){
  if (check_wid(wid) != WS_NO_ERR){
//printf("draw_window err return..\n");
    return WS_ERR_WID;
  }
  int gid = _window_list[wid-1]._gc;
  int dx = x + _window_list[wid-1]._x;
  int dy = y + _window_list[wid-1]._y;
  int bg = _window_list[wid-1]._bg_color;

  return _draw_fill_rect(gid,dx,dy,w,h,bg);
}

int _add_expose_event(int wid,short x,short y,unsigned short w,unsigned short h){
  WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
  WSDdeviceEvent* evt = &(evtl->_event);
  evt->r.type = EV_REQUEST;
  evt->r.r.c.left = x;
  evt->r.r.c.top = y;
  evt->r.r.c.right = x+w;
  evt->r.r.c.bottom = y+h;
  evt->r.cmd = W_REDISP;
  evt->r.wid = wid;
//printf("add_expose_event..\n");
  _draw_window(wid,x,y,w,h);
  _add_event(evtl);
  _update_frame_buffer();
  return WS_NO_ERR;
}
int _create_expose_event(int wid){
  //TODO: optimize!!..
  _add_expose_event(wid,0,0, _window_list[wid-1]._w, _window_list[wid-1]._h);
  return WS_NO_ERR;
}
int WSGFdeviceGetNewWindow(unsigned int attr,unsigned int parent,
                          short x, short y, unsigned short w,unsigned short h,
                          unsigned int bg){
  if ( parent < 0 || WS_MAX_WINDOW < parent){
//printf("WSGFdeviceGetNewWindow(): bad param: parent\n");
    return WS_ERR_WID;
  }
  WSGFdeviceSemLock(_sem_id);
  int i;
  for(i=0; i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id == 0){
      _window_list[i]._window_id = i+1;
      _window_list[i]._attr = attr;
      _window_list[i]._bg_color = bg;
      _window_list[i]._x = x;
      _window_list[i]._y = y;
      _window_list[i]._w = w;
      _window_list[i]._h = h;
      _window_list[i]._user_data = NULL;
      _window_list[i]._title_string = NULL;
      _window_list[i]._stack_no = 1;
      _window_list[i]._parent_window_id = parent; 
      _window_list[i]._status = WS_DEVICE_NEED_EXPOSE;
      _window_list[i]._pid = getpid();
      _device_insert_window(parent,i+1);

      WSGFdeviceSemUnlock(_sem_id);
      int gc = WSGFdeviceGetNewGC(x,y,w,h,_device_depth,
                         _device_width * _device_depth / 8,NULL,
                         _device_start_red,
                         _device_start_green,
                         _device_start_blue,
                         _device_red_bits,
                         _device_green_bits,
                         _device_blue_bits);

      WSGFdeviceSemLock(_sem_id);
      if (check_wid(i+1) != WS_NO_ERR){
        WSGFdeviceSemUnlock(_sem_id);
        return WS_ERR_NOSPC;
      }
      if (check_gid(gc) != WS_NO_ERR){
        WSGFdeviceSemUnlock(_sem_id);
        return WS_ERR_NOSPC;
      }
      _window_list[i]._gc = gc;
      _gc_list[gc-1]._window_id = i+1;
      _add_expose_event(i+1,x,y,w,h);
      WSGFdeviceSemUnlock(_sem_id);

#if defined LINUX || defined USE_X11
#ifndef NO_THREAD
      pthread_sem_unlock_np(&_event_sem);
#endif
#endif
      return i+1;

    }
  }

  WSGFdeviceSemUnlock(_sem_id);
  return WS_ERR_NOSPC;
}

int _destroy_gc(int gid){
//printf("_destroy_gc gid=%d\n",gid);
  if (_gc_list[gid-1]._ex_region_list != NULL){
    int i;
    int num = _gc_list[gid-1]._ex_region_list->getNum();
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)_gc_list[gid-1]._ex_region_list->getData(i);
      delete r;
    }
    delete _gc_list[gid-1]._ex_region_list;
    _gc_list[gid-1]._ex_region_list = NULL;
  }
  if (_gc_list[gid-1]._visible_region_list != NULL){
    int i;
    int num = _gc_list[gid-1]._visible_region_list->getNum();
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)_gc_list[gid-1]._visible_region_list->getData(i);
      delete r;
    }
    delete _gc_list[gid-1]._visible_region_list;
    _gc_list[gid-1]._visible_region_list = NULL;
  }
  _gc_list[gid-1]._gid = 0;
  return WS_NO_ERR;
}

int WSGFdeviceDestroyWindow(int wid){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }

  _window_list[wid -1]._window_id = 0;
  if ( _window_list[wid -1]._title_string != NULL){
    free(_window_list[wid -1]._title_string);
    _window_list[wid -1]._title_string = NULL;
  }
  int stack_no = _window_list[wid-1]._stack_no;

  int gid = _window_list[wid-1]._gc;
  _destroy_gc(gid);
  _window_list[wid-1]._gc = 0;

  int i;
  for(i=0; i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id != 0 &&
        _window_list[i]._stack_no > stack_no){
      _window_list[i]._stack_no--;
    }
  }
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int WSGFdeviceMoveWindow(int wid,short x,short y){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  _window_list[wid-1]._x = x;
  _window_list[wid-1]._y = y;
  long stack_no =  _window_list[wid -1]._stack_no;
  int i;
  int cnt=0;
  for(i=0; i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id != 0 &&
        _window_list[i]._stack_no < stack_no){
      _window_list[i]._status = WS_DEVICE_NEED_EXPOSE;
      _create_expose_event(i+1);
      cnt++;
    }
  } 
  WSGFdeviceSemUnlock(_sem_id);
#if defined LINUX || defined USE_X11
#ifndef NO_THREAD
  for(i=0; i<cnt;i++){
    pthread_sem_unlock_np(&_event_sem);
  }
#endif
#endif
  return WS_NO_ERR;
}
int WSGFdeviceResizeWindow(int wid,unsigned short w,unsigned short h){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  long stack_no =  _window_list[wid -1]._stack_no;
  int cnt = 0;
  if (_window_list[wid -1]._w < w  ||
      _window_list[wid -1]._h < h){
    int i;
    for(i=0; i<WS_MAX_WINDOW; i++){
      if (_window_list[i]._window_id != 0 &&
          _window_list[i]._stack_no < stack_no){
        _window_list[i]._status = WS_DEVICE_NEED_EXPOSE;
        _create_expose_event(i+1);
        cnt++;
      }
    } 
  }else{
    _window_list[wid -1]._status = WS_DEVICE_NEED_EXPOSE;
    _create_expose_event(wid);
    cnt++;
  }
  _window_list[wid -1]._w = w;
  _window_list[wid -1]._h = h;

  WSGFdeviceSemUnlock(_sem_id);
#if defined LINUX || defined USE_X11
#ifndef NO_THREAD
  int i;
  for(i=0; i<cnt;i++){
    pthread_sem_unlock_np(&_event_sem);
  }
#endif
#endif
  return WS_NO_ERR;
}


int WSGFdeviceGetWindowPosition(int wid,short* x,short* y){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  *x = _window_list[wid -1]._x;
  *y = _window_list[wid -1]._y;
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int WSGFdeviceGetWindowSize(int wid,unsigned short* w,unsigned short* h){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  *w = _window_list[wid -1]._w;
  *h = _window_list[wid -1]._h;
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int WSGFdeviceGetWindowStatus(int wid,unsigned int* status){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  *status = _window_list[wid -1]._status;
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int WSGFdeviceSetWindowStatus(int wid,unsigned int status){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  _window_list[wid -1]._status = status;
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int WSGFdeviceSetWindowTitle(int wid,unsigned short* title){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  if ( _window_list[wid -1]._title_string != NULL){
    free(_window_list[wid -1]._title_string);
  }

  _window_list[wid -1]._title_string = WSGFstrdupUCS2(title);
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int WSGFdeviceSetWindowColor(int wid,unsigned int color){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  _window_list[wid -1]._bg_color = color;
  _window_list[wid -1]._status = WS_DEVICE_NEED_EXPOSE;
  _create_expose_event(wid);
  WSGFdeviceSemUnlock(_sem_id);
#if defined LINUX || defined USE_X11
#ifndef NO_THREAD
  pthread_sem_unlock_np(&_event_sem);
#endif
#endif
  return WS_NO_ERR;
}

void _adjust_stack_no(){
  int i;
  int stack_no = 0;
  int stack_wid = 0;
  for(i=0;i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id > 0 &&
        _window_list[i]._stack_no > 0){
      if (stack_no > _window_list[i]._stack_no){
        stack_no = _window_list[i]._stack_no;
        stack_wid = _window_list[i]._window_id;
      }
    }
  }
  int diff = 0;
  if (stack_no > 1){
    diff = stack_no -1;
    for(i=0;i<WS_MAX_WINDOW; i++){
      if (_window_list[i]._window_id > 0 &&
          _window_list[i]._stack_no > 0){
        _window_list[i]._stack_no -= diff;
      }
    }
  }
}

int WSGFdeviceGetActiveWindow(int* wid){
  WSGFdeviceSemLock(_sem_id);
  if (wid == NULL){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_ADR;
  }
  _adjust_stack_no();
  int i;
//  int stack_no = 0;
//  int stack_wid = 0;
  int target = 0;
  for(i=0;i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id > 0 &&
        _window_list[i]._stack_no == 1){
      target = _window_list[i]._window_id;
    }
  }
  WSGFdeviceSemUnlock(_sem_id);
  if (target == 0){
    return WS_ERR_ADR;
  }
  *wid = target;
  return WS_NO_ERR;
}
int WSGFdeviceGetWindowOwner(int wid,int* pid){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  *pid = _window_list[wid -1]._pid;
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int WSGFdeviceSetWindowData(int wid,void* val){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  _window_list[wid -1]._user_data = val;
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int WSGFdeviceGetWindowData(int wid,void** val){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  *val = _window_list[wid -1]._user_data;
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int WSGFdeviceGetNextEvent(WSDdeviceEvent* evt,unsigned int mode){
#if defined LINUX || defined USE_X11 
#ifndef NO_THREAD
  if (mode & WAIT){
    pthread_sem_lock_np(&_event_sem);
  }
#endif
#endif

  WSGFdeviceSemLock(_event_sem_id);
  WSDdeviceEvent wsevt;
  int ret = _get_event(&wsevt,mode);
  if (ret != WS_NO_ERR){
    WSGFdeviceSemUnlock(_event_sem_id);
    return EV_NOMSG;
  }
  memcpy(evt,&wsevt,sizeof(WSDdeviceEvent));
  WSGFdeviceSemUnlock(_event_sem_id);
//printf("WSGFdeviceGetNextEvent ret a msg evt=%d wnd=%d cmd=%d\n",evt->r.type,evt->r.wid,evt->r.cmd);
  return evt->r.type;
}

int WSGFdeviceGetNewGC(short x,short y,
                       unsigned short w, unsigned short h,
                       unsigned int depth, unsigned short row_bytes,
                       unsigned char* buf,
                       unsigned int start_red,
                       unsigned int start_green,
                       unsigned int start_blue,
                       unsigned int red_bits,
                       unsigned int green_bits,
                       unsigned int blue_bits){
//printf("WSGFdeviceGetNewGC %d,%d,%d,%d,%d,%d\n",start_red,start_green,start_blue,red_bits,green_bits,blue_bits);
  WSGFdeviceSemLock(_sem_id);
  int i;
  for(i=0; i<WS_MAX_GC; i++){
    if (_gc_list[i]._gid == 0){
      _gc_list[i]._gid = i+1;
      _gc_list[i]._x = x;
      _gc_list[i]._y = y;
      _gc_list[i]._w = w;
      _gc_list[i]._h = h;
      _gc_list[i]._fg_color = _default_black_color;
      _gc_list[i]._bg_color = _default_white_color;
      _gc_list[i]._lw = 1;
      _gc_list[i]._ld_type = LN_SOLID;
      _gc_list[i]._start_red = start_red;
      _gc_list[i]._start_green = start_green;
      _gc_list[i]._start_blue = start_blue;
      _gc_list[i]._red_bits = red_bits;
      _gc_list[i]._green_bits = green_bits;
      _gc_list[i]._blue_bits = blue_bits;
      _gc_list[i]._buf = buf;
      _gc_list[i]._depth = depth;
      _gc_list[i]._ex_region_list = NULL;
      _gc_list[i]._visible_region_list = NULL;
      _gc_list[i]._window_id = 0;
//printf(">>CreateNewGC gid=%d depth=%d buf=0x%x\n",i+1,depth,buf);
//fflush(stdout);
      _gc_list[i]._row_bytes = row_bytes;
      WSGFdeviceSemUnlock(_sem_id);
      return i+1;
    }
  }
  WSGFdeviceSemUnlock(_sem_id);
  return -1;
}



int WSGFdeviceGetWindowGC(int wid){
  WSGFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  int gid = _window_list[wid-1]._gc;
  WSGFdeviceSemUnlock(_sem_id);
  return gid;
}

int WSGFdeviceGetGCWindow(int gid){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  int wid = _gc_list[gid-1]._window_id;
  WSGFdeviceSemUnlock(_sem_id);
  return wid;
}

//TODO: need optimize for gid...
int WSGFdeviceFlushGC(int gid){
  return  _update_frame_buffer();
}
int WSGFdeviceDrawLine(int gid,short x1,short y1,short x2,short y2,
                       unsigned int fg,int lw,int type){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._lw = lw;
  _gc_list[gid-1]._ld_type = type;
  int dx1 = x1 + _gc_list[gid-1]._x;
  int dy1 = y1 + _gc_list[gid-1]._y;
  int dx2 = x2 + _gc_list[gid-1]._x;
  int dy2 = y2 + _gc_list[gid-1]._y;
  _draw_line(gid,dx1,dy1,dx2,dy2,fg);
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
#ifndef NO_DRAW_RECT
int WSGFdeviceDrawRect(int gid,short x,short y,
                       unsigned short w, unsigned short h,
                       unsigned int bg,int lw,int type){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  int dx = x + _gc_list[gid-1]._x;
  int dy = y + _gc_list[gid-1]._y;
  _gc_list[gid-1]._lw = lw;
  _gc_list[gid-1]._ld_type = type;
//printf("WSGFdeviceDrawRect gid=%d x,y,w,h=%d,%d,%d,%d dx,dy=%d,%d\n",gid,x,y,w,h,dx,dy);
  _draw_rect(gid,dx,dy,w,h,bg);
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
#endif
#ifndef NO_DRAW_POLY
int WSGFdeviceDrawPolygon(int gid,WSCpoint* point,int num, unsigned int fg,int lw,int type){
  if (num < 2){
    return WS_ERR_PAR;
  }
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._lw = lw;
  _gc_list[gid-1]._ld_type = type;
  int i;
  for(i=0; i<num-1; i++){
    short x1 = point[i].x + _gc_list[gid-1]._x;
    short y1 = point[i].y + _gc_list[gid-1]._y;
    short x2 = point[i+1].x + _gc_list[gid-1]._x;
    short y2 = point[i+1].y + _gc_list[gid-1]._y;
    _draw_line(gid,x1,y1,x2,y2,fg);
  }
  if (num > 2){
    short x1 = point[0].x + _gc_list[gid-1]._x;
    short y1 = point[0].y + _gc_list[gid-1]._y;
    short x2 = point[num-1].x + _gc_list[gid-1]._x;
    short y2 = point[num-1].y + _gc_list[gid-1]._y;
    _draw_line(gid,x1,y1,x2,y2,fg);
  }
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
#endif
#ifndef NO_DRAW_ARC
int WSGFdeviceDrawArc( int gid,short x,short y,unsigned short w,unsigned short h,
                int a1,int a2,unsigned int fg,int lw,int type){
  if (a1 == a2){
    return WS_NO_ERR;
  }
  if (w == 0 || h== 0){
    return WS_NO_ERR;
  }
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._lw = lw;
  _gc_list[gid-1]._ld_type = type;
  short x1 = x + _gc_list[gid-1]._x;
  short y1 = y + _gc_list[gid-1]._y;
  int i;
  for(i=0; i < lw; i++){
    if (w -i*2< 1){
      break;
    }
    if (h -i*2< 1){
      break;
    }
    _draw_arc(gid,x1+i,y1+i,w-i*2,h-i*2,a1,a2,False,WS_PI,fg);
  }

  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
#endif
#ifndef  NO_DRAW_FILL_ARC
int WSGFdeviceDrawFillArc( int gid,short x,short y,unsigned short w,unsigned short h,
                int a1,int a2,int arctype,unsigned int bg){
  if (a1 == a2){
    return WS_NO_ERR;
  }
  if (w == 0 || h== 0){
    return WS_NO_ERR;
  }
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  short x1 = x + _gc_list[gid-1]._x;
  short y1 = y + _gc_list[gid-1]._y;
  _draw_arc(gid,x1,y1,w,h,a1,a2,True,arctype,bg);

  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
#endif
#ifndef NO_DRAW_FILL_POLY
int WSGFdeviceDrawFillPolygon(int gid,WSCpoint* point,int num, unsigned int bg,int rev){
  if (num < 2){
    return WS_ERR_PAR;
  }
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  WSCpoint* point2 = new WSCpoint[num];
  int i;
  for(i=0; i<num; i++){
    point2[i].x = point[i].x + _gc_list[gid-1]._x;
    point2[i].y = point[i].y + _gc_list[gid-1]._y;
  }
  _draw_fill_poly(gid,point2,num,bg,rev);
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
#endif

int WSGFdeviceDrawString(int gid,short x,short y,
                       WSDdeviceFontList* fl,
                       unsigned int fg,WSCushort* str,int len){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  int dx = x + _gc_list[gid-1]._x;
  int dy = y + _gc_list[gid-1]._y;
//printf("WSGFdeviceDrawString gid=%d x,y=%d,%d dx,dy=%d,%d\n",gid,x,y,dx,dy);
  _draw_string(gid,fl,dx,dy,fg,str,len);
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int WSGFdeviceGetStringWidth(int gid, WSDdeviceFontList* fl,
                       WSCushort* str,int len){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
//printf("WSGFdeviceDrawString gid=%d x,y=%d,%d dx,dy=%d,%d\n",gid,x,y,dx,dy);
  int ret = _get_string_width(gid,fl,str,len);
  WSGFdeviceSemUnlock(_sem_id);
  return ret;
}

int WSGFdeviceDrawFillRect(int gid,short x,short y,
                       unsigned short w, unsigned short h,
                       unsigned int bg,int htype){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._hatch_type = htype;
  int dx = x + _gc_list[gid-1]._x;
  int dy = y + _gc_list[gid-1]._y;
  _draw_fill_rect(gid,dx,dy,w,h,bg);
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int WSGFdeviceGetDevSpec(int gid,DEV_SPEC* dsp){
  if (dsp == NULL){
    return WS_ERR_PAR;
  }
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  dsp->pixbits = (_gc_list[gid-1]._depth << 8)
                  + _gc_list[gid-1]._red_bits
                  + _gc_list[gid-1]._green_bits
                  + _gc_list[gid-1]._blue_bits;
//printf("gid=%d dsp->pixbits=0x%x\n",gid,dsp->pixbits);
  dsp->planes = 1;
  dsp->hpixels = _gc_list[gid-1]._w;
  dsp->vpixels = _gc_list[gid-1]._h;
  dsp->hres = 0;
  dsp->vres = 0;
  dsp->attr = 0x2001;
  dsp->color[0] = _gc_list[gid-1]._start_red << 8 |
                  _gc_list[gid-1]._red_bits;
  dsp->color[1] = _gc_list[gid-1]._start_green << 8 |
                  _gc_list[gid-1]._green_bits;
  dsp->color[2] = _gc_list[gid-1]._start_blue << 8 |
                  _gc_list[gid-1]._blue_bits;
  dsp->color[3] = 0;
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int WSGFdeviceGetColorSpec(int gid,CSPEC* csp){
  if (csp == NULL){
    return WS_ERR_PAR;
  }
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  csp->attr = 0x01;
  csp->info[0] = _gc_list[gid-1]._start_red << 8 |
                  _gc_list[gid-1]._red_bits;
  csp->info[1] = _gc_list[gid-1]._start_green << 8 |
                  _gc_list[gid-1]._green_bits;
  csp->info[2] = _gc_list[gid-1]._start_blue << 8 |
                  _gc_list[gid-1]._blue_bits;
  csp->info[3] = 0;
  csp->colmap = NULL;
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int _get_rgb(int gid,unsigned char* buf,short x,short y,unsigned char* r,unsigned char* g,unsigned char* b){
  unsigned int depth =   _gc_list[gid-1]._depth;
  unsigned int start_red =   _gc_list[gid-1]._start_red;
  unsigned int start_green = _gc_list[gid-1]._start_green;
  unsigned int start_blue =  _gc_list[gid-1]._start_blue;
  unsigned int red_bits =    _gc_list[gid-1]._red_bits;
  unsigned int green_bits =  _gc_list[gid-1]._green_bits;
  unsigned int blue_bits =   _gc_list[gid-1]._blue_bits;
  unsigned int row_bytes =   _gc_list[gid-1]._row_bytes;

  if (depth == 32){
    unsigned int val = 0;
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    val = *ptr;
    *r = (val >> start_red) << (8 -red_bits);
    *g = (val >> start_green) << (8 -green_bits);
    *b = (val >> start_blue) << (8 -blue_bits);
  }else
  if (depth == 24){
//printf("_get_rgb() need implement..\n");
//    long ptr = y*row_bytes + x*depth/8;
//    val = buf[ptr] << 16 | buf[ptr+1] << 8 | buf[ptr+2];
  }else
  if (depth == 16){
    unsigned short val = 0;
    unsigned short* ptr = (unsigned short*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned short)*ptr;
    *r = (val >> start_red) << (8 -red_bits);
    *g = (val >> start_green) << (8 -green_bits);
    *b = (val >> start_blue) << (8 -blue_bits);
  }else{
    unsigned char val = 0;
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned char)*ptr;
    *r = (val >> start_red) << (8 -red_bits);
    *g = (val >> start_green) << (8 -green_bits);
    *b = (val >> start_blue) << (8 -blue_bits);
  }
  return WS_NO_ERR;
}
int _get_low_rgb(int gid,unsigned char* buf,short x,short y,unsigned int* v){
  unsigned int depth =   _gc_list[gid-1]._depth;
  unsigned int row_bytes =   _gc_list[gid-1]._row_bytes;
  unsigned int val = 0;
  if (depth == 32){
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    val = *ptr;
  }else
  if (depth == 24){
  }else
  if (depth == 16){
    unsigned short* ptr = (unsigned short*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned short)*ptr;
  }else{
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned char)*ptr;
  }
  *v = val;
  return WS_NO_ERR;
}
int _set_rgb(int gid,unsigned char* buf,short x,short y,unsigned char r,unsigned char g,unsigned char b){

  unsigned int depth =   _gc_list[gid-1]._depth;
  unsigned int start_red =   _gc_list[gid-1]._start_red;
  unsigned int start_green = _gc_list[gid-1]._start_green;
  unsigned int start_blue =  _gc_list[gid-1]._start_blue;
  unsigned int red_bits =    _gc_list[gid-1]._red_bits;
  unsigned int green_bits =  _gc_list[gid-1]._green_bits;
  unsigned int blue_bits =   _gc_list[gid-1]._blue_bits;
  unsigned int row_bytes =   _gc_list[gid-1]._row_bytes;

  unsigned int val = 0;
  val |= (r >> (8-red_bits)) << start_red;
  val |= (g >> (8-green_bits)) << start_green;
  val |= (b >> (8-blue_bits)) << start_blue;

#ifdef ROTATE90
  if (buf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&buf[(_device_height-x-1)*row_bytes + y*depth/8];
      *ptr = val;
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&buf[(_device_height-x-1)*row_bytes + y*depth/8];
      *ptr = val;
    }else{
      unsigned char* ptr = (unsigned char*)&buf[(_device_height-x-1)*row_bytes + y*depth/8];
      *ptr = val;
    }
    return WS_NO_ERR;
  }
#endif

#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned int*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned short*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }else{
      unsigned char* ptr = (unsigned char*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned char*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }
    return WS_NO_ERR;
  }
#endif
  if (depth == 32){
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    *ptr = val;
  }else
  if (depth == 24){
  }else
  if (depth == 16){
    unsigned short* ptr = (unsigned short*)&buf[y*row_bytes + x*depth/8];
    *ptr = (unsigned short)val;
  }else{
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    *ptr = (unsigned char)val;
  }
  return WS_NO_ERR;
}

int _set_low_rgb(int gid,unsigned char* buf,short x,short y,unsigned int val){

  unsigned int depth =   _gc_list[gid-1]._depth;
  unsigned int row_bytes =   _gc_list[gid-1]._row_bytes;
//printf("_set_low_rgb start.\n");fflush(stdout);
#ifdef ROTATE90
  if (buf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&buf[(_device_height - x-1)*2*row_bytes + y*depth/8];
      *ptr = val;
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&buf[(_device_height - x-1)*2*row_bytes + y*depth/8];
      *ptr = val;
    }else{
      unsigned char* ptr = (unsigned char*)&buf[(_device_height - x-1)*2*row_bytes + y*depth/8];
      *ptr = val;
    }
    return WS_NO_ERR;
  }
#
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned int*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned short*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }else{
      unsigned char* ptr = (unsigned char*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned char*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }
    return WS_NO_ERR;
  }
#endif
  if (depth == 32){
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    *ptr = val;
  }else
  if (depth == 24){
  }else
  if (depth == 16){
    unsigned short* ptr = (unsigned short*)&buf[y*row_bytes + x*depth/8];
    *ptr = (unsigned short)val;
  }else{
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    *ptr = (unsigned char)val;
  }
//printf("_set_low_rgb done.\n");fflush(stdout);
  return WS_NO_ERR;
}
int _copy_low_rgb(int dgid,int sgid,short dx,short dy,short sx,short sy,unsigned int size){
  unsigned int depth =   _gc_list[sgid-1]._depth;
  unsigned int row_bytes =   _gc_list[sgid-1]._row_bytes;
  unsigned int ddepth =   _gc_list[dgid-1]._depth;
  unsigned int drow_bytes =   _gc_list[dgid-1]._row_bytes;

  unsigned char* sbuf = _gc_list[sgid-1]._buf;
  if (sbuf == NULL){
    sbuf = _buffer;
  }

  unsigned char* dbuf = _gc_list[dgid-1]._buf;
  if (dbuf == NULL){
    dbuf = _buffer;
  }

//printf("_copy_low_rgb start.\n");fflush(stdout);
#ifdef ROTATE90
  if (dbuf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&sbuf[sy*row_bytes + sx*depth/8];
      int i;
      unsigned int* dptr;
      for(i=0; i<size; i++){
        dptr = (unsigned int*)&dbuf[(_device_height - dx - i-1)*drow_bytes + dy*ddepth/8];
        *dptr = *ptr++;
      }
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&sbuf[sy*row_bytes + sx*depth/8];
      unsigned short* dptr;
      int i;
      for(i=0; i<size; i++){
        dptr = (unsigned short*)&dbuf[(_device_height - dx -i-1)*drow_bytes + dy*ddepth/8];
        *dptr = *ptr++;
      }
    }else{
      unsigned char* ptr = (unsigned char*)&sbuf[sy*row_bytes + sx*depth/8];
      unsigned char* dptr;
      int i;
      for(i=0; i<size; i++){
        dptr = (unsigned char*)&dbuf[(_device_height - dx -i-1)*drow_bytes + dy*ddepth/8];
        *dptr = *ptr++;
      }
    }
    return WS_NO_ERR;
  }
#endif

#ifdef DOUBLE_SCALE
  if (dbuf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&sbuf[sy*row_bytes + sx*depth/8];
      unsigned int* dptr = (unsigned int*)&dbuf[dy*2*drow_bytes + dx*2*ddepth/8];
      unsigned int* dptr2 = (unsigned int*)&dbuf[(dy*2+1)*drow_bytes + dx*2*ddepth/8];
      int i;
      for(i=0; i<(int)size; i++){
        *dptr++ = *ptr;
        *dptr++ = *ptr;
        *dptr2++ = *ptr;
        *dptr2++ = *ptr++;
      }
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&sbuf[sy*row_bytes + sx*depth/8];
      unsigned short* dptr = (unsigned short*)&dbuf[dy*2*drow_bytes + dx*2*ddepth/8];
      unsigned short* dptr2 = (unsigned short*)&dbuf[(dy*2+1)*drow_bytes + dx*2*ddepth/8];
      int i;
      for(i=0; i<(int)size; i++){
        *dptr++ = *ptr;
        *dptr++ = *ptr;
        *dptr2++ = *ptr;
        *dptr2++ = *ptr++;
      }
    }else{
      unsigned char* ptr = (unsigned char*)&sbuf[sy*row_bytes + sx*depth/8];
      unsigned char* dptr = (unsigned char*)&dbuf[dy*2*drow_bytes + dx*2*ddepth/8];
      unsigned char* dptr2 = (unsigned char*)&dbuf[(dy*2+1)*drow_bytes + dx*2*ddepth/8];
      int i;
      for(i=0; i<(int)size; i++){
        *dptr++ = *ptr;
        *dptr++ = *ptr;
        *dptr2++ = *ptr;
        *dptr2++ = *ptr++;
      }
    }
    return WS_NO_ERR;
  }
#endif
  if (depth == 32){
    unsigned int* ptr = (unsigned int*)&sbuf[sy*row_bytes + sx*depth/8];
    unsigned int* dptr = (unsigned int*)&dbuf[dy*drow_bytes + dx*ddepth/8];
    memcpy(dptr,ptr,sizeof(unsigned int)*size);
  }else
  if (depth == 24){
  }else
  if (depth == 16){
    unsigned short* ptr = (unsigned short*)&sbuf[sy*row_bytes + sx*depth/8];
    unsigned short* dptr = (unsigned short*)&dbuf[dy*drow_bytes + dx*ddepth/8];
    memcpy(dptr,ptr,sizeof(unsigned short)*size);
  }else{
    unsigned char* ptr = (unsigned char*)&sbuf[sy*row_bytes + sx*depth/8];
    unsigned char* dptr = (unsigned char*)&dbuf[dy*drow_bytes + dx*ddepth/8];
    memcpy(dptr,ptr,sizeof(unsigned char)*size);
  }
//printf("_copy_low_rgb done.\n");fflush(stdout);
  return WS_NO_ERR;
}



int WSGFdeviceBitBuild(int sgid,short x,short y,
                       unsigned short w,unsigned short h,
                       int dgid,short dx,short dy,
                       unsigned int mode){
  mode &= 0xf;
//printf("WSGFdeviceBitBuild sgid=%d dgid=%d\n",sgid,dgid);
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(sgid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  if (check_gid(dgid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  x += _gc_list[sgid-1]._x;
  y += _gc_list[sgid-1]._y;
  dx += _gc_list[dgid-1]._x;
  dy += _gc_list[dgid-1]._y;
  unsigned int s_start_red =   _gc_list[sgid-1]._start_red;
  unsigned int s_start_green = _gc_list[sgid-1]._start_green;
  unsigned int s_start_blue =  _gc_list[sgid-1]._start_blue;
  unsigned int s_red_bits =    _gc_list[sgid-1]._red_bits;
  unsigned int s_green_bits =  _gc_list[sgid-1]._green_bits;
  unsigned int s_blue_bits =   _gc_list[sgid-1]._blue_bits;
  
  unsigned int d_start_red =   _gc_list[dgid-1]._start_red;
  unsigned int d_start_green = _gc_list[dgid-1]._start_green;
  unsigned int d_start_blue =  _gc_list[dgid-1]._start_blue;
  unsigned int d_red_bits =    _gc_list[dgid-1]._red_bits;
  unsigned int d_green_bits =  _gc_list[dgid-1]._green_bits;
  unsigned int d_blue_bits =   _gc_list[dgid-1]._blue_bits;
 
//  unsigned int s_row_bytes =   _gc_list[sgid-1]._row_bytes;
//  unsigned int d_row_bytes =   _gc_list[dgid-1]._row_bytes;
  unsigned int s_depth =   _gc_list[sgid-1]._depth;
  unsigned int d_depth =   _gc_list[dgid-1]._depth;
//  unsigned int s_pix_bytes = s_depth/8;
//  unsigned int d_pix_bytes = d_depth/8;

  unsigned char* sbuf = _gc_list[sgid-1]._buf;
  if (sbuf == NULL){
    sbuf = _buffer;
  }

  unsigned char* dbuf = _gc_list[dgid-1]._buf;
  if (dbuf == NULL){
    dbuf = _buffer;
  }

  long sx,sy;
  unsigned long sw,sh;
  WSGFandArea(x,y,w,h,_gc_list[sgid-1]._x,
                      _gc_list[sgid-1]._y,
                      _gc_list[sgid-1]._w,
                      _gc_list[sgid-1]._h,
                      &sx,&sy,&sw,&sh);
  long px,py;
  unsigned long pw,ph;
  WSGFandArea(sx - x + dx,sy - y + dy,sw,sh,
                      _gc_list[dgid-1]._x,
                      _gc_list[dgid-1]._y,
                      _gc_list[dgid-1]._w,
                      _gc_list[dgid-1]._h,
                      &px,&py,&pw,&ph);

  sx = px - dx + x; 
  sy = py - dy + y; 
//printf("%d,%d,%d,%d -> %d,%d\n",x,y,w,h,dx,dy);
//printf("sdepth=%d ddepth=%d\n",s_depth,d_depth);
//printf("s=%d,%d,%d,%d,%d,%d\n",s_start_red,s_start_green,s_start_blue,
//                               s_red_bits,s_green_bits,s_blue_bits);
//printf("d=%d,%d,%d,%d,%d,%d\n",d_start_red,d_start_green,d_start_blue,
//                               d_red_bits,d_green_bits,d_blue_bits);
//fflush(stdout);

  //TODO: mask with region..
  if (s_start_red == d_start_red && 
      s_start_green == d_start_green && 
      s_start_blue == d_start_blue && 
      s_red_bits == d_red_bits && 
      s_green_bits == d_green_bits && 
      s_blue_bits == d_blue_bits &&
      s_depth == d_depth){
    unsigned int i,j;
    unsigned int val;
    unsigned int val2;
    if (mode == G_AND){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (_check_low_point(sgid,sx+j,sy+i) != False){
            _get_low_rgb(sgid,sbuf,sx+j,sy+i,&val);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_low_rgb(dgid,dbuf,px+j,py+i,&val2);
              _set_low_rgb(dgid,dbuf,px+j,py+i,val2 & val);
            }
          }
        }
      }
    }else if (mode == G_ANDN){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (_check_low_point(sgid,sx+j,sy+i) != False){
            _get_low_rgb(sgid,sbuf,sx+j,sy+i,&val);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_low_rgb(dgid,dbuf,px+j,py+i,&val2);
              _set_low_rgb(dgid,dbuf,px+j,py+i,(val2 & ~val));
            }
          }
        }
      }
    }else if (mode == G_OR){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (_check_low_point(sgid,sx+j,sy+i) != False){
            _get_low_rgb(sgid,sbuf,sx+j,sy+i,&val);
            _get_low_rgb(dgid,dbuf,px+j,py+i,&val2);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _set_low_rgb(dgid,dbuf,px+j,py+i,(val2 | val));
            }
          }
        }
      }
    }else if (mode == G_STORE){
      for(i=0; i< ph; i++){
#ifdef LINE_OPTIMIZE
        WSCpoint pt1[WS_MAX_POINTS];
        WSCpoint pt2[WS_MAX_POINTS];
        int num = _check_low_line(dgid,px,py+i,px+pw-1,py+i,pt1,pt2,WS_MAX_POINTS);
        for(j=0; j<(unsigned int)num; j++){
          int x1 = pt1[j].x;
//          int y1 = pt1[j].y;
          int x2 = pt2[j].x;
//          int y2 = pt2[j].y;
          if (x1 < x2){
//printf("size=%d %d,%d\n",x2-x1+1,x1,x2);
            _copy_low_rgb(dgid,sgid,px,py+i,sx,sy+i,x2 -x1+1);
          }else{
//printf("size=%d %d,%d\n",x1-x2+1,x2,x1);
            _copy_low_rgb(dgid,sgid,px,py+i,sx,sy+i,x1 -x2+1);
          }
        }
#else
        for(j=0; j< pw; j++){
          if (_check_low_point(sgid,sx+j,sy+i) != False){
            _get_low_rgb(sgid,sbuf,sx+j,sy+i,&val);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _set_low_rgb(dgid,dbuf,px+j,py+i,val);
            }
          }
        }
#endif
      }
    }
  }else{
    unsigned int i,j;
    unsigned char r;
    unsigned char g;
    unsigned char b;
    if (mode == G_AND){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (_check_low_point(sgid,sx+j,sy+i) != False){
            _get_rgb(sgid,sbuf,sx+j,sy+i,&r,&g,&b);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,(r2 & r),(g2 & g),(b2 & b));
            }
          }
        }
      }
    }else if (mode == G_ANDN){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (_check_low_point(sgid,sx+j,sy+i) != False){
            _get_rgb(sgid,sbuf,sx+j,sy+i,&r,&g,&b);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,(r2 & ~r),(g2 & ~g),(b2 & ~b));
            }
          }
        }
      }
    }else if (mode == G_OR){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (_check_low_point(sgid,sx+j,sy+i) != False){
            _get_rgb(sgid,sbuf,sx+j,sy+i,&r,&g,&b);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,r2 | r,g2 | g,b2 | b);
            }
          }
        }
      }
    }else{
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (_check_low_point(sgid,sx+j,sy+i) != False){
            _get_rgb(sgid,sbuf,sx+j,sy+i,&r,&g,&b);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _set_rgb(dgid,dbuf,px+j,py+i,r,g,b);
            }
          }
        }
      }
    }
  }
  if (_gc_list[dgid-1]._buf == NULL){
    _update_frame_buffer();
  }
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int WSGFdeviceStretchedBitBuild(int sgid,short x,short y,
                       unsigned short w,unsigned short h,
                       int dgid,short dx,short dy,
                       unsigned short dw,unsigned short dh,
                       unsigned int mode){
  mode &= 0xf;

  double scale_x = (double)dw/w;
  double scale_y = (double)dh/h;
  double x_scale = (double)w/dw;
  double y_scale = (double)h/dh;

//printf("WSGFdeviceBitBuild sgid=%d dgid=%d\n",sgid,dgid);
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(sgid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  if (check_gid(dgid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  x += _gc_list[sgid-1]._x;
  y += _gc_list[sgid-1]._y;
  dx += _gc_list[dgid-1]._x;
  dy += _gc_list[dgid-1]._y;
  unsigned int s_start_red =   _gc_list[sgid-1]._start_red;
  unsigned int s_start_green = _gc_list[sgid-1]._start_green;
  unsigned int s_start_blue =  _gc_list[sgid-1]._start_blue;
  unsigned int s_red_bits =    _gc_list[sgid-1]._red_bits;
  unsigned int s_green_bits =  _gc_list[sgid-1]._green_bits;
  unsigned int s_blue_bits =   _gc_list[sgid-1]._blue_bits;
  
  unsigned int d_start_red =   _gc_list[dgid-1]._start_red;
  unsigned int d_start_green = _gc_list[dgid-1]._start_green;
  unsigned int d_start_blue =  _gc_list[dgid-1]._start_blue;
  unsigned int d_red_bits =    _gc_list[dgid-1]._red_bits;
  unsigned int d_green_bits =  _gc_list[dgid-1]._green_bits;
  unsigned int d_blue_bits =   _gc_list[dgid-1]._blue_bits;
 
//  unsigned int s_row_bytes =   _gc_list[sgid-1]._row_bytes;
//  unsigned int d_row_bytes =   _gc_list[dgid-1]._row_bytes;
  unsigned int s_depth =   _gc_list[sgid-1]._depth;
  unsigned int d_depth =   _gc_list[dgid-1]._depth;
//  unsigned int s_pix_bytes = s_depth/8;
//  unsigned int d_pix_bytes = d_depth/8;

  unsigned char* sbuf = _gc_list[sgid-1]._buf;
  if (sbuf == NULL){
    sbuf = _buffer;
  }

  unsigned char* dbuf = _gc_list[dgid-1]._buf;
  if (dbuf == NULL){
    dbuf = _buffer;
  }

  long sx,sy;
  unsigned long sw,sh;
  WSGFandArea(x,y,w,h,_gc_list[sgid-1]._x,
                      _gc_list[sgid-1]._y,
                      _gc_list[sgid-1]._w,
                      _gc_list[sgid-1]._h,
                      &sx,&sy,&sw,&sh);
  long bx,by;
  unsigned long bw,bh;
  WSGFandArea((long)((_gc_list[sgid-1]._x-x) * scale_x +dx),
              (long)((_gc_list[sgid-1]._y-y) * scale_y +dy),
              (unsigned long)(_gc_list[sgid-1]._w * scale_x),
              (unsigned long)(_gc_list[sgid-1]._h * scale_x),
                      _gc_list[dgid-1]._x,
                      _gc_list[dgid-1]._y,
                      _gc_list[dgid-1]._w,
                      _gc_list[dgid-1]._h,
                      &bx,&by,&bw,&bh);

  long px,py;
  unsigned long pw,ph;
  WSGFandArea(dx,dy,dw,dh,bx,by,bw,bh, &px,&py,&pw,&ph);

  sx = (long)((px-dx)*x_scale + x);
  sy = (long)((py-dy)*y_scale + y);


  //TODO: mask with region..
  if (s_start_red == d_start_red && 
      s_start_green == d_start_green && 
      s_start_blue == d_start_blue && 
      s_red_bits == d_red_bits && 
      s_green_bits == d_green_bits && 
      s_blue_bits == d_blue_bits &&
      s_depth == d_depth){
    unsigned int i,j;
    unsigned int val;
    unsigned int val2;
    if (mode == G_AND){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale);
          short syy = (short)(sy+i*y_scale);
          if (_check_low_point(sgid,sxx,syy) != False){
            _get_low_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&val);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_low_rgb(dgid,dbuf,px+j,py+i,&val2);
              _set_low_rgb(dgid,dbuf,px+j,py+i,val2 & val);
            }
          }
        }
      }
    }else if (mode == G_ANDN){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale);
          short syy = (short)(sy+i*y_scale);
          if (_check_low_point(sgid,sxx,syy) != False){
            _get_low_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&val);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_low_rgb(dgid,dbuf,px+j,py+i,&val2);
              _set_low_rgb(dgid,dbuf,px+j,py+i,(val2 & ~val));
            }
          }
        }
      }
    }else if (mode == G_OR){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale);
          short syy = (short)(sy+i*y_scale);
          if (_check_low_point(sgid,sxx,syy) != False){
            _get_low_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&val);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_low_rgb(dgid,dbuf,px+j,py+i,&val2);
              _set_low_rgb(dgid,dbuf,px+j,py+i,(val2 | val));
            }
          }
        }
      }
    }else if (mode == G_STORE){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale);
          short syy = (short)(sy+i*y_scale);
          if (_check_low_point(sgid,sxx,syy) != False){
            _get_low_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&val);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _set_low_rgb(dgid,dbuf,px+j,py+i,val);
            }
          }
        }
      }
    }
  }else{
    unsigned int i,j;
    unsigned char r;
    unsigned char g;
    unsigned char b;
    if (mode == G_AND){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale);
          short syy = (short)(sy+i*y_scale);
          if (_check_low_point(sgid,sxx,syy) != False){
            _get_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&r,&g,&b);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,(r2 & r),(g2 & g),(b2 & b));
            }
          }
        }
      }
    }else if (mode == G_ANDN){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale);
          short syy = (short)(sy+i*y_scale);
          if (_check_low_point(sgid,sxx,syy) != False){
            _get_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&r,&g,&b);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,(r2 & ~r),(g2 & ~g),(b2 & ~b));
            }
          }
        }
      }
    }else if (mode == G_OR){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale);
          short syy = (short)(sy+i*y_scale);
          if (_check_low_point(sgid,sxx,syy) != False){
            _get_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&r,&g,&b);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,r2 | r,g2 | g,b2 | b);
            }
          }
        }
      }
    }else{
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale);
          short syy = (short)(sy+i*y_scale);
          if (_check_low_point(sgid,sxx,syy) != False){
            _get_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&r,&g,&b);
            if (_check_low_point(dgid,px+j,py+i) != False){
              _set_rgb(dgid,dbuf,px+j,py+i,r,g,b);
            }
          }
        }
      }
    }
  }
  if (_gc_list[dgid-1]._buf == NULL){
    _update_frame_buffer();
  }
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}



int WSGFdeviceSetDrawPoint(int gid,short x,short y){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._draw_pt_x = x;
  _gc_list[gid-1]._draw_pt_y = y;
  WSGFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}
int WSGFdeviceGetDrawPoint(int gid,short* x,short* y){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  *x = _gc_list[gid-1]._draw_pt_x;
  *y = _gc_list[gid-1]._draw_pt_y;
  WSGFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}
int WSGFdeviceSetFont(int gid,WSDdeviceFontList* fl){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._font = fl;
  WSGFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}
int WSGFdeviceGetFont(int gid,WSDdeviceFontList** fl){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  *fl = _gc_list[gid-1]._font;
  WSGFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}
int WSGFdeviceSetForeColor(int gid,unsigned int fg){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._fg_color = fg;
  WSGFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}
int WSGFdeviceGetForeColor(int gid,unsigned int* fg){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  *fg = _gc_list[gid-1]._fg_color;
  WSGFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}
int WSGFdeviceSetBackColor(int gid,unsigned int bg){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._bg_color = bg;
  WSGFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}

int WSGFdeviceGetBackColor(int gid,unsigned int* bg){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  *bg = _gc_list[gid-1]._bg_color;
  WSGFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}

int WSGFdeviceDestroyVisibleRegion(int gid){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  if (_gc_list[gid-1]._visible_region_list != NULL){
    int i;
    int num = _gc_list[gid-1]._visible_region_list->getNum();
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)_gc_list[gid-1]._visible_region_list->getData(i);
      delete r;
    }
    _gc_list[gid-1]._visible_region_list->clear();
  }
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int WSGFdeviceDestroyExclusiveRegion(int gid){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  if (_gc_list[gid-1]._ex_region_list != NULL){
    int i;
    int num = _gc_list[gid-1]._ex_region_list->getNum();
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)_gc_list[gid-1]._ex_region_list->getData(i);
      delete r;
    }
    _gc_list[gid-1]._ex_region_list->clear();
  }
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int WSGFdeviceAddVisibleRegion(int gid,short x,short y,WSCushort w,WSCushort h){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  short bx = _gc_list[gid-1]._x;
  short by = _gc_list[gid-1]._y;
  if (_gc_list[gid-1]._visible_region_list == NULL){
    _gc_list[gid-1]._visible_region_list = new WSClistData();
  }
  WSCrect* r = new WSCrect;
  r->setRect(bx+x,by+y,w,h);
  _gc_list[gid-1]._visible_region_list->add((void*)r);
//printf("WSGFdeviceAddVisibleRegion added %d num=%d %d,%d,%d,%d\n",gid,_gc_list[gid-1]._visible_region_list->getNum(),x,y,w,h);
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
WSClistData* WSGFdeviceGetVisibleRegion(int gid){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return NULL;
  }
  WSClistData* ret = NULL;
  ret = _gc_list[gid-1]._visible_region_list;
  WSGFdeviceSemUnlock(_sem_id);
  return ret;
}

int WSGFdeviceAddExclusiveRegion(int gid,short x,short y,WSCushort w,WSCushort h){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  short bx = _gc_list[gid-1]._x;
  short by = _gc_list[gid-1]._y;
  if (_gc_list[gid-1]._ex_region_list == NULL){
    _gc_list[gid-1]._ex_region_list = new WSClistData();
  }
  WSCrect* r = new WSCrect;
  r->setRect(bx+x,by+y,w,h);
  _gc_list[gid-1]._ex_region_list->add((void*)r);
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

WSClistData* WSGFdeviceGetExclusiveRegion(int gid){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return NULL;
  }
  WSClistData* ret = NULL;
  ret = _gc_list[gid-1]._ex_region_list;
  WSGFdeviceSemUnlock(_sem_id);
  return ret;
}
int WSGFdeviceGetGCPos(int gid,short* x,short* y){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  *x = _gc_list[gid-1]._x;
  *y = _gc_list[gid-1]._y;
  WSGFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}




int WSGFdeviceDestroyGC(int gid){
  WSGFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSGFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  int ret = _destroy_gc(gid);
  WSGFdeviceSemUnlock(_sem_id);
  return ret;
}

int WSGFdeviceGetScreenSize(int* w,int* h){
  return _get_device_screen_size(w,h); 
}

int WSGFdeviceSearchWindow(short x,short y){
  WSGFdeviceSemLock(_sem_id);
  int wid = _search_window(x,y);
  WSGFdeviceSemUnlock(_sem_id);
  return wid;
}

int WSGFdeviceSleep(int time){
  //TODO: call sleep.
  usleep(time*1000);
  return WS_NO_ERR;
}
int WSGFdeviceCreateThread(int* thr,void(*entry)(int),int arg){
  pthread_t thr2;
  int ret = pthread_create(&thr2,NULL,(void*(*)(void*))entry,(void*)arg);
  if (ret != 0){
    return WS_ERR;
  }
  *thr = thr2;
  return WS_NO_ERR;
}
int WSGFdeviceExitThread(){
  //TODO: exit thread..
  pthread_exit(NULL);
  return WS_NO_ERR;
}
int WSGFdeviceTerminateThread(int id){
  //TODO: exit thread..
  pthread_cancel((pthread_t)id);
  return WS_NO_ERR;
}
int WSGFdeviceGetThreadId(){
  //TODO: return thread id..
  return (int)pthread_self();
}

int _device_check_event_available(){
  int num = _message_list.getNum();
  int i;
  unsigned int ctime = get_current_time();
  for(i=0; i<num; i++){
    unsigned int time = (unsigned int)_message_time_list[i];
    unsigned int rate = (unsigned int)_message_rate_list[i];
    if (time == 0){
      return 1;
    }
    if (ctime > time + rate){
      return 1;
    }
  }
  return 0;
}

int WSGFdeviceCheckEventAvailable(){
  WSGFdeviceSemLock(_event_sem_id);
  int ret = _device_check_event_available();
  WSGFdeviceSemUnlock(_event_sem_id);
  return ret;  
}

int WSGFdeviceSendMessage(MESSAGE* msg){
//printf("WSGFdeviceSendMessage..\n");
  WSGFdeviceSemLock(_event_sem_id);
  if (_message_list.getNum() <128){
    int size = msg->msg_size;
    MESSAGE* buf = (MESSAGE*)malloc(size+sizeof(int)*2);
    memcpy(buf,msg,size+sizeof(int)*2);
//printf("WSGFdeviceSendMessage.. type=%x size=%d\n",msg->msg_type,size);
    _message_list.add((void*)buf);
    _message_time_list.add((void*)0);
    _message_rate_list.add((void*)0);
    WSGFdeviceSemUnlock(_event_sem_id);
    return WS_NO_ERR;
  }
  WSGFdeviceSemUnlock(_event_sem_id);
#if defined LINUX || defined USE_X11
#ifndef NO_THREAD
  pthread_sem_unlock_np(&_event_sem);
#endif
#endif
  return WS_ERR_NOSPC;
}

int WSGFdeviceSendDelayMessage(MESSAGE* msg,int rate,int* id){
//printf("WSGFdeviceSendMessage..\n");
  WSGFdeviceSemLock(_event_sem_id);
  unsigned int ctime = get_current_time();
  int ret = 0;
  if (_message_list.getNum() <128){
    int size = msg->msg_size;
    MESSAGE* buf = (MESSAGE*)malloc(size+sizeof(int)*2);
    memcpy(buf,msg,size+sizeof(int)*2);
//printf("WSGFdeviceSendMessage.. type=%x size=%d\n",msg->msg_type,size);
    _message_list.add((void*)buf);
    _message_time_list.add((void*)ctime);
    _message_rate_list.add((void*)rate);
    ret = _message_list.getNum();
    WSGFdeviceSemUnlock(_event_sem_id);
    return ret;
  }
  WSGFdeviceSemUnlock(_event_sem_id);
  return WS_ERR_NOSPC;
}


int WSGFdeviceRecvMessage(int type,MESSAGE* msg,int size){
  WSGFdeviceSemLock(_event_sem_id);
  int num = _message_list.getNum();
//printf("WSGFdeviceRecvMessage..num=%d\n",num);
  int i;
  unsigned int ctime = get_current_time();
  for(i=0; i<num; i++){
    MESSAGE* buf = (MESSAGE*)_message_list[i];
    unsigned int time = (unsigned int)_message_time_list[i];
    unsigned int rate = (unsigned int)_message_rate_list[i];
//printf("WSGFdeviceRecvMessage.. i=%d type=%x type=%x\n",i,buf->msg_type,type);
//printf("WSGFdeviceRecvMessage.. ctime=%d time=%d rate=%d\n",ctime,time,rate);
    if (time > 0 && ctime < time + rate){
      continue;
    }
    if ( ((MM_TYPE1 & type) && buf->msg_type == MS_TYPE1)||
         ((MM_TYPE2 & type) && buf->msg_type == MS_TYPE2)||
         ((MM_TYPE3 & type) && buf->msg_type == MS_TYPE3)||
         ((MM_TYPE4 & type) && buf->msg_type == MS_TYPE4)){
//printf("WSGFdeviceRecvMessage.. find i=%d type=%x type=%x\n",i,buf->msg_type,type);
      if (size < (int)(buf->msg_size+sizeof(int)*2)){
        memcpy(msg,buf,size);
      }else{
        memcpy(msg,buf,buf->msg_size + sizeof(int)*2);
      }
      delete buf;
      _message_list.delPos(i);
      _message_time_list.delPos(i);
      _message_rate_list.delPos(i);
      WSGFdeviceSemUnlock(_event_sem_id);
      return WS_NO_ERR;
    }
  }
//printf("WSGFdeviceRecvMessage.. recv..ERR!\n");
  WSGFdeviceSemUnlock(_event_sem_id);
  return WS_ERR;
}
int WSGFdeviceGetCursorPos(short* x,short* y){
  _get_mouse_pos(x,y);
  return WS_NO_ERR;
}
int WSGFdeviceGetWindowList(int* list,int num){
  if (list == NULL){
    return WS_ERR_ADR;
  }
  if (num < 1){
    return WS_ERR_PAR;
  }
  memset(list,0,num * sizeof(int));
  WSGFdeviceSemLock(_sem_id);
//  int stack_no = 0;
  int i,j;
  int cnt = 0;
  for(i=1;i< WS_MAX_WINDOW+1; i++){
    if (cnt >= num){
      break;
    }
    for(j=0;j< WS_MAX_WINDOW; j++){
      if (_window_list[j]._window_id != 0 ){
//printf("WSGFdeviceGetWindowList return wid=%d stack=%d\n",_window_list[j]._window_id,_window_list[j]._stack_no);
      }
      if (_window_list[j]._window_id != 0 &&
          _window_list[j]._stack_no == i){
        list[cnt] = _window_list[j]._window_id;
        cnt++;
        break;
      }
    }
  }
  WSGFdeviceSemUnlock(_sem_id);
//printf("WSGFdeviceGetWindowList return num=%d\n",cnt);
  return WS_NO_ERR;
}
