//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCj3wform.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSCpulldownMenu.h>
#include <WSCbaseList.h>
#include <j3w/hobj3d.h>
#include <j3w/axis.h>
#include <j3w/j3djob.h>
#include <j3w/j3dproc.h>
#include <j3w/jrlcode.h>
#include <j3w/misc3d.h>
#include <j3w/object3d.h>


#define MAX_PROCESS  500
#define MAX_COMMON  15000

extern "C" {
void libwsj3w_func();
};
void libwsj3w_func(){
}


WSMFguiClassInitialize(WSCj3wform, WSCform);
WSMFversion(WSCj3wform, WSCform);


WSMFpropertyValueChange(WSCj3wform,WSNshadowType,char,WS_SHADOW_NONE);
WSMFpropertyValueChange(WSCj3wform,WSNbackColor,short,WSGFcolor("black"));

WSCj3wform::WSCj3wform(WSCbase* base, char* objname):
			WSCform(base, objname){
  _shadow_type = WS_SHADOW_NONE;
  _back_color = WS_DF_MENUBACKCOLOR;
  _shadow_thick = 0;
  _fname = WSGFstrdup("");
  _sp = NULL;
  _sc = NULL;
  _job = NULL;
  _timer = NULL;
  _pixmap_style = WS_DIRECT_WINDOW;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCj3wform);

    WSMFpropertyCreate(WSNfileName,     char*, _fname,WSSfileName  );

    WSMFpropertyValueChangeDef(WSCj3wform,WSNshadowType,char);
    WSMFpropertyValueChangeDef(WSCj3wform,WSNbackColor,short);
    WSMFpropertyDelete(WSNshadowThickness);
    WSMFpropertyDelete(WSNshadowType);
  WSMFpropertyCreateEnd
}
WSMFproperty( WSCj3wform, WSNfileName, char*, _fname, WSGFstrdup(""));

void WSCj3wform::setWorkWSNfileName(char* data){
//printf("setWorkWSNfileName %s\n",data);
  if (getVisible() != False){
    _j3w_initialize();
    if (_job != NULL){
//printf("load file:%s\n",data);
      _job->LoadObjFile(data);
    }
  }
}

void WSCj3wform::getWorkWSNfileName(char** data){
}
WSCj3wform::~WSCj3wform(){
  if (_fname != NULL){
    delete _fname;
    _fname = NULL;
  }
  if (_sp != NULL){
    delete _sp;
    _sp = NULL;
  }
  if (_sc != NULL){
    delete _sc;
    _sc = NULL;
  }
  if (_job != NULL){
    delete _job;
    _job = NULL;
  }
  if (_timer != NULL){
    delete _timer;
    _timer = NULL;
  }
}

long WSCj3wform::_device_initialize(){
  long ret = WSCform::_device_initialize();
//
  return ret;
}
long WSCj3wform::loadFile(char* fname){
dbprintf("WSCj3wform::loadFile %s %s start\n",getInstanceName(),fname);
//printf("loadfile job=0x%x\n",_job);
  if (_job != NULL){
    delete _job;
    _job = NULL;
  }
  _j3w_initialize();
  if (_job != NULL){
//printf("loadfile=%s\n",_fname);
    if (!strcmp(_fname,"")){
      //do nothing..
    }else if (WSGFcheckExistFile(_fname)!= False){
      _job->LoadObjFile(_fname);
    }
    if (_timer == NULL){
      _timer = WSDprivateTimer::getNewInstance();
      _timer->setWorkProc(_timer_proc,this);
      _timer->setCont(True);
      _timer->setRate(50);
      _timer->startTimer();
dbprintf("WSCj3wform::loadFile %s timer started\n",getInstanceName());
    }

dbprintf("WSCj3wform::loadFile %s %s done1\n",getInstanceName(),fname);
    return WS_NO_ERR;
  }
dbprintf("WSCj3wform::loadFile %s %s done2\n",getInstanceName(),fname);
  return WS_ERR;
}
void WSCj3wform::onVisibleChange(WSCbool fl){
//printf("onVisibleChange %d\n",fl);
  WSCform::onVisibleChange(fl);
  if (fl != False){
    loadFile(_fname);
  }
}
void WSCj3wform::onParentVisibleChange(WSCbool fl){
  WSCform::onParentVisibleChange(fl);
  if (fl != False){
    loadFile(_fname);
  }
}
long WSCj3wform::draw(){
  if (_no_refresh != False){
    WSCbase::update();
    setAbsoluteDraw(False);
    return WS_NO_ERR;
  }
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False  ){
    if ( dev->isExposed(0,0,_w,_h) == False ){
      return WS_NO_ERR;
    }
  }

//printf("_sc=0x%x\n",_sc);
  _sc->setDev(getowndev());
  _sp->display(0);
  _sc->update();

  WSCbase::update();
  setAbsoluteDraw(False);


  return WS_NO_ERR;
}
long WSCj3wform::_j3w_initialize(){
//printf("_j3w_init\n");
  if (_sp != NULL){
    _sp->reset_space(); 
  }else{
    _sp = new TSpaceH3D(6,50,4000000);
    _sc = new ScrnX();
//TEST
    _sc->set_mode(2);
//    _sc->set_mode(1);
    _sc->SetPaletteEntry(255,60<<8,40<<8,90<<8);
    _sp->set_screen(_sc);
  }
  if (_job == NULL){
    _job = new TJob(MAX_COMMON, MAX_PROCESS,_sp,_sc);
//printf("new TJog=0x%x\n",_job);
    long dummy[100];
    long i;
    for(i=0; i<100; i++){
      dummy[i] = 0;
    }
dbprintf("WSCj3wform::_j3w_initialize %s:%d %s init_j3w\n",__FILE__,__LINE__,getInstanceName());
    _job->new_process(100,0,-1,dummy);
  }
  return WS_NO_ERR;
}
void WSCj3wform::_timer_proc(void* ptr){
//printf("here\n");
  WSCj3wform* _this = (WSCj3wform*)ptr;
dbprintf("WSCj3wform::_timer_proc %s:%d %s start\n",__FILE__,__LINE__,_this->getInstanceName());
  if (_this->getVisible() != False){
    if (_this->_job != NULL){
dbprintf("WSCj3wform::_timer_proc %s:%d %s call scheduler\n",__FILE__,__LINE__,_this->getInstanceName());
      if (!strcmp(_this->_fname,"")){
        return;
      }
      _this->_job->job_scheduler();
      WSGIappObjectList()->execUpdate();
    }
  }
dbprintf("WSCj3wform::_timer_proc %s:%d %s done\n",__FILE__,__LINE__,_this->getInstanceName());
}
