//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#include  "hobj3d.h"
#include  "misc3d.h"

THObj3D::THObj3D(int vn, int pn, THObj3D* p):TObject3D(vn,pn),
                           velocity(0,0,0), wvelocity(0,0,0), accele(0,0,0)
{
    gravity  = 0;
    parent   = p;
    brother  = 0;
    child    = 0;
    sx = 1.0;
    sy = 1.0;
    sz = 1.0;
    sf = 0;
}

THObj3D::~THObj3D()
{
    THObj3D *p;
    THObj3D *q;

    if (child) {
        p = child;
        do {
            p->parent = 0;
            p->Axis.set_matrix(p->wm);
            p->Axis.set_origin(p->wp.x, p->wp.y, p->wp.z);
            q = p->brother;
            p->brother = 0;
            p = q;
        } while (p != 0);
    }
    if (parent)
      if (parent->child == this) {
          if (brother == 0) parent->child = 0;
          else parent->child = brother;
      } else {
          p = parent->child;
          while (p->brother != this) p = p->brother;
          if (brother == 0) p->brother = 0;
          else p->brother = brother;
      }
}

void THObj3D::SetWorld()
{
    wp = Axis.get_origin();
    wm = Axis.get_matrix();
}

void THObj3D::SetNodeWorldMatrix(long delta)
{
    Vector lg;
    Vector  d;

    if (!parent) {
        double time = delta / 1000.0;
        double t2 = time*time / 2;
        lg.x = 0; lg.y = 0; lg.z = 0;
        if (gravity != 0)
            lg = ConvCoordinate2(wm, Vector(0,0,gravity));
        d.x = iround(((lg.x  + accele.x) * t2 + velocity.x * time)/1000);
        d.y = iround(((lg.y  + accele.y) * t2 + velocity.y * time)/1000);
        d.z = iround(((lg.z  + accele.z) * t2 + velocity.z * time)/1000);
        velocity.x = iround(double(lg.x + accele.x) * time + velocity.x);
        velocity.y = iround(double(lg.y + accele.y) * time + velocity.y);
        velocity.z = iround(double(lg.z + accele.z) * time + velocity.z);
        Axis.move(d);
        wvelocity = ConvCoordinate(wm, velocity);

        long h = iround(AngleVelocity.x * time);
        long p = iround(AngleVelocity.y * time);
        long b = iround(AngleVelocity.z * time);
        Axis.rotate(h, p, b);
        SetWorld();
    } else {
        wp.x = long(Axis.get_origin().x * parent->sx + 0.5);
        wp.y = long(Axis.get_origin().y * parent->sy + 0.5);
        wp.z = long(Axis.get_origin().z * parent->sz + 0.5);
        wp = ConvCoordinate(parent->wm, wp);
        wp = wp + parent->wp;
        wm = MulMatrix3(parent->wm, Axis.get_matrix());

    }

    if (child) child->SetNodeWorldMatrix(delta);

    if (brother) brother->SetNodeWorldMatrix(delta);
}

void THObj3D::SetVelocity(Vector v)
{
    velocity = v;
    wvelocity = ConvCoordinate(wm, v);
}

void THObj3D::SetWVelocity(Vector wv)
{
    wvelocity = wv;
    velocity = ConvCoordinate2(wm, wv);
}

void THObj3D::show(THObj3D *eye)
{
    Vector v;

    int n =  Polygon.Vertex.GetCount();
#ifdef WS
	int i;
    for (i=0; i<n; i++) {
#else //WS
    for (int i=0; i<n; i++) {
#endif //WS
        Vector w = Polygon.Vertex.vert[i]->local;
        if (sf) {
            w.x = long(w.x * sx + 0.5);
            w.y = long(w.y * sy + 0.5);
            w.z = long(w.z * sz + 0.5);
        }
        v = ConvCoordinate(wm, w);
        Polygon.Vertex.vert[i]->world = v + wp;
    }
    Axis.reset_change();
#ifdef WS
    for (i=0; i<n; i++) {
#else //WS
    for (int i=0; i<n; i++) {
#endif //WS
        v = Polygon.Vertex.vert[i]->world - eye->wp;
        Polygon.Vertex.vert[i]->eye = ConvCoordinate2(eye->wm, v);
    }

    n = Polygon.GetCount();
#ifdef WS
    for (i=0; i<n; i++) { /* convert normal vector */
#else //WS
    for (int i=0; i<n; i++) { /* convert normal vector */
#endif //WS
        if (Polygon.pg[i]->f_normal) {
            Vector_d nv;
            nv = ConvCoordinate_d(wm, Polygon.pg[i]->normal);
            Polygon.pg[i]->enormal = ConvCoordinate2_d(eye->wm, nv);
        }
    }
}

void THObj3D::GetWorldPosition(Vector &pos, long &h, long &p, long &b)
{
    pos = wp;
    b  = DEG( atan2(wm.m8, wm.m9) );
    p  = DEG( - asin(wm.m7) );
    h  = DEG( atan2(wm.m4, wm.m1) );
}

