//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#include    "pal256.h"

int ColNum   = 16;
int ColWidth = 13;

TMyPalette MyPalette[MAXPALETTE];

int DefColor[236][3] = {
  { 80, 80, 77},{ 77, 77, 74},{ 74, 74, 71},{ 71, 71, 68},
  { 68, 68, 65},{ 65, 65, 62},{ 62, 62, 59},{ 58, 58, 56},
  { 55, 55, 53},{ 52, 52, 50},{ 49, 49, 47},{ 46, 46, 44},
  { 43, 43, 41},
  { 60, 60,255},{ 58, 58,245},{ 55, 55,235},{ 53, 53,226},
  { 51, 51,216},{ 48, 48,206},{ 46, 46,196},{ 44, 44,186},
  { 42, 42,177},{ 39, 39,167},{ 37, 37,157},{ 35, 35,147},
  { 32, 32,137},
  { 60,255, 60},{ 58,245, 58},{ 55,235, 55},{ 53,226, 53},
  { 51,216, 51},{ 48,206, 48},{ 46,196, 46},{ 44,186, 44},
  { 42,177, 42},{ 39,167, 39},{ 37,157, 37},{ 35,147, 35},
  { 32,137, 32},
  { 61,255,255},{ 59,245,245},{ 56,235,235},{ 54,226,226},
  { 52,216,216},{ 49,206,206},{ 47,196,196},{ 45,186,186},
  { 42,177,177},{ 40,167,167},{ 38,157,157},{ 35,147,147},
  { 33,137,137},
  {255, 60, 61},{245, 58, 59},{235, 55, 56},{226, 53, 54},
  {216, 51, 52},{206, 48, 49},{196, 46, 47},{186, 44, 45},
  {177, 42, 42},{167, 39, 40},{157, 37, 38},{147, 35, 35},
  {137, 32, 33},
  {255, 60,255},{245, 58,245},{235, 55,235},{226, 53,226},
  {216, 51,216},{206, 48,206},{196, 46,196},{186, 44,186},
  {177, 42,177},{167, 39,167},{157, 37,157},{147, 35,147},
  {137, 32,137},
  {255,255, 60},{245,245, 58},{235,235, 55},{226,226, 53},
  {216,216, 51},{206,206, 48},{196,196, 46},{186,186, 44},
  {177,177, 42},{167,167, 39},{157,157, 37},{147,147, 35},
  {137,137, 32},
  {255,255,255},{245,245,245},{235,235,235},{226,226,226},
  {216,216,216},{206,206,206},{196,196,196},{186,186,186},
  {177,177,177},{167,167,167},{157,157,157},{147,147,147},
  {137,137,137},
  {120,120,120},{115,115,115},{111,111,111},{106,106,106},
  {102,102,102},{ 97, 97, 97},{ 92, 92, 92},{ 88, 88, 88},
  { 83, 83, 83},{ 78, 78, 78},{ 74, 74, 74},{ 69, 69, 69},
  { 65, 65, 65},
  { 60, 60,160},{ 58, 58,154},{ 55, 55,148},{ 53, 53,142},
  { 51, 51,135},{ 48, 48,129},{ 46, 46,123},{ 44, 44,117},
  { 42, 42,111},{ 39, 39,105},{ 37, 37, 98},{ 35, 35, 92},
  { 32, 32, 86},
  { 20,160, 60},{ 19,154, 58},{ 18,148, 55},{ 18,142, 53},
  { 17,135, 51},{ 16,129, 48},{ 15,123, 46},{ 15,117, 44},
  { 14,111, 42},{ 13,105, 39},{ 12, 98, 37},{ 12, 92, 35},
  { 11, 86, 32},
  {160,255,160},{154,245,154},{148,235,148},{142,226,142},
  {135,216,135},{129,206,129},{123,196,123},{117,186,117},
  {111,177,111},{105,167,105},{ 98,157, 98},{ 92,147, 92},
  { 86,137, 86},
  {130, 80, 50},{125, 77, 48},{120, 74, 46},{115, 71, 44},
  {110, 68, 42},{105, 65, 40},{100, 62, 38},{ 95, 58, 37},
  { 90, 55, 35},{ 85, 52, 33},{ 80, 49, 31},{ 75, 46, 29},
  { 70, 43, 27},
  {255,180,180},{245,173,173},{235,166,166},{226,159,159},
  {216,152,152},{206,145,145},{196,138,138},{186,132,132},
  {177,125,125},{167,118,118},{157,111,111},{147,104,104},
  {137, 97, 97},
  {255,140, 16},{245,135, 15},{235,129, 15},{226,124, 14},
  {216,118, 14},{206,113, 13},{196,108, 12},{186,102, 12},
  {177, 97, 11},{167, 92, 10},{157, 86, 10},{147, 81,  9},
  {137, 75,  9},
  {255,255,180},{245,245,173},{235,235,166},{226,226,159},
  {216,216,152},{206,206,145},{196,196,138},{186,186,132},
  {177,177,125},{167,167,118},{157,157,111},{147,147,104},
  {137,137, 97},
  {  0,  0,  0},
  { 60, 60,255},
  { 60,240, 60},
  { 60,240,240},
  {240, 60, 60},
  {240, 60,240},
  {240,240, 60},
  {255,255,255},
  {120,120,120},
  { 10, 10,100},
  { 10,100, 60},
  {120,200,120},
  {130, 80, 50},
  {240,160,160},
  {240,120, 20},
  {240,240,160},
  {  0,  0,  0},{  0,  0,  0},{  0,  0,  0},{  0,  0,  0},
  {  0,  0,  0},{  0,  0,  0},{  0,  0,  0},{  0,  0,  0},
  {  0,  0,  0},{  0,  0,  0},{  0,  0,  0},{  0,  0,  0}
 };

void SetDefaultPalette()
{
    ColNum   = 16;
    ColWidth = 13;
    for(int i=0; i<236; i++) {
        MyPalette[i].r = DefColor[i][0];
        MyPalette[i].g = DefColor[i][1];
        MyPalette[i].b = DefColor[i][2];
    }
}

void SetPaletteColor(int col, int r1, int g1, int b1, int r0, int g0, int b0)
{
    int  r, g, b;
    int  i, n;

    if (col == -1) {
        MyPalette[MAXPALETTE - 1].r = r1;
        MyPalette[MAXPALETTE - 1].g = g1;
        MyPalette[MAXPALETTE - 1].b = b1;
    } else if ((col > 0x100) && (ColNum <= 16)) {
        MyPalette[col].r = r1;
        MyPalette[col].g = g1;
        MyPalette[col].b = b1;
    } else if ((col > 15) && (ColNum <= 16)) {
        if (col < 43) {
            MyPalette[ColNum * ColWidth + col-16].r = r1;
            MyPalette[ColNum * ColWidth + col-16].g = g1;
            MyPalette[ColNum * ColWidth + col-16].b = b1;
        }
    } else {
        for (i=0; i<ColWidth; i++) {
            n = col * ColWidth +  i;
            r = r1 - ((r1 - r0) * i / (ColWidth - 1));
            g = g1 - ((g1 - g0) * i / (ColWidth - 1));
            b = b1 - ((b1 - b0) * i / (ColWidth - 1));
            if (r > 255) r = 255;
            if (g > 255) g = 255;
            if (b > 255) b = 255;
            MyPalette[n].r = r;
            MyPalette[n].g = g;
            MyPalette[n].b = b;
        }
    }
}
