//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#include  "tpolygon.h"

TPolygons::TPolygons(int vn, int pn):Vertex(vn)
{
    Max = pn;
    pg = new Polygon3D*[pn];
    for(int i=0; i<pn; i++) pg[i] = 0;
    reflection = 1.0;
    ambient    = 0.1;
    off_center = 0;

    Count = 0;
}

TPolygons::~TPolygons()
{
    for(int i=0; i<Count; i++)
      if (pg[i] != 0) {
          delete pg[i]->index;
          delete pg[i];
      }
    delete pg;
}

void TPolygons::Add(int n, int color, const int *idx)
{
    int vc = Vertex.GetCount();
    int vo = Vertex.GetOffset();
    int verr = 0;
    Polygon3D * p;
    double x0,y0,z0,x1,y1,z1,x2,y2,z2;

      for(int i=0; i<n; i++)
          if (vc <= idx[i] + vo) verr = 1;

      if ((Count < Max) && (!verr)) {
          p = new Polygon3D;
          pg[Count] = p;
          p->color = color;
          p->reflection = reflection;
          p->f_normal = 0;
          p->ambient = ambient;
          p->off_center = off_center;
          p->n = n;
          p->index = new int[n];

          for(int i=0; i<n; i++)
              p->index[i] = idx[i] + Vertex.GetOffset();
          if (n > 2) {          /* calc normal vector */
              if ((p->index[0] > 0)&&(p->index[1] > 0)&&(p->index[2] > 0)) {
                  Vector v0, v1, v2;
                  /* when parent's vertex is not referred */
                  v0 = Vertex.vert[p->index[0]]->local;
                  v1 = Vertex.vert[p->index[1]]->local;
                  v2 = Vertex.vert[p->index[2]]->local;
                  x0 = v0.x; y0 = v0.y; z0 = v0.z;
                  x1 = v1.x; y1 = v1.y; z1 = v1.z;
                  x2 = v2.x; y2 = v2.y; z2 = v2.z;
                  p->normal.x = (y1-y0)*(z2-z1) - (z1-z0)*(y2-y1);
                  p->normal.y = (z1-z0)*(x2-x1) - (x1-x0)*(z2-z1);
                  p->normal.z = (x1-x0)*(y2-y1) - (y1-y0)*(x2-x1);
                  p->normal.normalize();
                  p->f_normal = 1;
              }
          }
          Count++;
      }
}

void TPolygons::SetPoly(int pos, int color, const int *idx)
{
    if (pos < Count) {
        int n = pg[pos]->n;
        pg[pos]->color = color;
        for(int i=0; i<n; i++) pg[pos]->index[i] = idx[i];
    }
}

void TPolygons::GetPoly(int pos, int &color, int *idx)
{
    if (pos < Count) {
        int n = pg[pos]->n;
        color = pg[pos]->color;
        for(int i=0; i<n; i++) idx[i] = pg[pos]->index[i];
    }
}

int TPolygons::GetVertexCount(int pos)
{
    if (pos < Count) return pg[pos]->n;
    else return -1;
}

