//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#include "xkey.h"

static KeySym XKeySym[256];
static char   key_return[32];
static ScrnX  *pscrn;

int X2WKey(KeySym sym)
{
    int key = 0;
    switch(sym) {
    case XK_Right:     key = 0x27; break;
    case XK_Left:      key = 0x25; break;
    case XK_Up:        key = 0x26; break;
    case XK_Down:      key = 0x28; break;
    case XK_Escape:    key = 0x1B; break;
    case XK_Tab:       key = 0x09; break;
    case XK_space:     key = 0x20; break;
    case XK_Home:      key = 0x24; break;
    case XK_End:       key = 0x23; break;
    case XK_Page_Down: key = 0x22; break;
    case XK_Page_Up:   key = 0x21; break;
    case XK_Insert:    key = 0x2D; break;
    case XK_Delete:    key = 0x2E; break;
    case XK_BackSpace: key = 0x08; break;
    case XK_Return:    key = 0x0D; break;
    case XK_KP_0:  key = 0x60; break;
    case XK_KP_1:  key = 0x61; break;
    case XK_KP_2:  key = 0x62; break;
    case XK_KP_3:  key = 0x63; break;
    case XK_KP_4:  key = 0x64; break;
    case XK_KP_5:  key = 0x65; break;
    case XK_KP_6:  key = 0x66; break;
    case XK_KP_7:  key = 0x67; break;
    case XK_KP_8:  key = 0x68; break;
    case XK_KP_9:  key = 0x69; break;
    case XK_0:     key = int('0'); break;
    case XK_1:     key = int('1'); break;
    case XK_2:     key = int('2'); break;
    case XK_3:     key = int('3'); break;
    case XK_4:     key = int('4'); break;
    case XK_5:     key = int('5'); break;
    case XK_6:     key = int('6'); break;
    case XK_7:     key = int('7'); break;
    case XK_8:     key = int('8'); break;
    case XK_9:     key = int('9'); break;
    case XK_A: case XK_a: key = int('A'); break;
    case XK_B: case XK_b: key = int('B'); break;
    case XK_C: case XK_c: key = int('C'); break;
    case XK_D: case XK_d: key = int('D'); break;
    case XK_E: case XK_e: key = int('E'); break;
    case XK_F: case XK_f: key = int('F'); break;
    case XK_G: case XK_g: key = int('G'); break;
    case XK_H: case XK_h: key = int('H'); break;
    case XK_I: case XK_i: key = int('I'); break;
    case XK_J: case XK_j: key = int('J'); break;
    case XK_K: case XK_k: key = int('K'); break;
    case XK_L: case XK_l: key = int('L'); break;
    case XK_M: case XK_m: key = int('M'); break;
    case XK_N: case XK_n: key = int('N'); break;
    case XK_O: case XK_o: key = int('O'); break;
    case XK_P: case XK_p: key = int('P'); break;
    case XK_Q: case XK_q: key = int('Q'); break;
    case XK_R: case XK_r: key = int('R'); break;
    case XK_S: case XK_s: key = int('S'); break;
    case XK_T: case XK_t: key = int('T'); break;
    case XK_U: case XK_u: key = int('U'); break;
    case XK_V: case XK_v: key = int('V'); break;
    case XK_W: case XK_w: key = int('W'); break;
    case XK_X: case XK_x: key = int('X'); break;
    case XK_Y: case XK_y: key = int('Y'); break;
    case XK_Z: case XK_z: key = int('Z'); break;
    }
    return key;
}

void InitKeyTable(ScrnX *scrn)
{
    int i;

    pscrn = scrn;

    for (i=0; i<256; i++) XKeySym[i] = 0;

    for (i=0; i<=15; i++) XKeySym[int('0') + i] = XK_0 + i;
    for (i=0; i<=31; i++) XKeySym[int('@') + i] = XK_at + i;

    for (i=0; i<=31; i++) XKeySym[int('`') + i] = XK_grave + i;
    for (i=0; i<=25; i++) XKeySym[int('a') + i] = XK_A + i;

    XKeySym[0x27] = XK_Right;
    XKeySym[0x25] = XK_Left;
    XKeySym[0x26] = XK_Up;
    XKeySym[0x28] = XK_Down;
    XKeySym[0x1B] = XK_Escape;
    XKeySym[0x09] = XK_Tab;
    XKeySym[0x20] = XK_space;
    XKeySym[0x24] = XK_Home;
    XKeySym[0x23] = XK_End;
    XKeySym[0x22] = XK_Page_Down;
    XKeySym[0x21] = XK_Page_Up;
    XKeySym[0x2D] = XK_Insert;
    XKeySym[0x2E] = XK_Delete;
    XKeySym[0x08] = XK_BackSpace;
    XKeySym[0x0D] = XK_Return;
}

int GetAsyncKeyState(int key)
{
    KeySym   sym;
    Display *d;

    d = pscrn->GetDisplay();
    if (d==0) return 0;
    XQueryKeymap(d, key_return);
    XFlush(d);
    sym = XKeySym[key];
    if (sym == 0) return 0;
    KeyCode code = XKeysymToKeycode(d, sym);
    if (key_return[ code >> 3] & (1 << (code % 8)))
        return 1;
    else return 0;
}

void MousePointer(int *x, int *y, unsigned int *shift) {
    int root_x, root_y;
    unsigned int mask;
    Display *d;
    Window  *w, root, child;

    if (pscrn == 0) return;
    d = pscrn->GetDisplay();
    w = pscrn->GetWindow();
    XQueryPointer(d, *w, &root, &child, &root_x, &root_y, x, y, &mask);
    *shift = 0;
    if (mask & Button1Mask)  *shift += 16;
    if (mask & Button2Mask)  *shift += 32;
    if (mask & Button3Mask)  *shift += 8;
    if (mask & ShiftMask)    *shift += 1;
    if (mask & Mod1Mask)     *shift += 2;
    if (mask & ControlMask)  *shift += 4;
}
