//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCRfileSelect.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSCfileSelect.h>

WSMFclassInit(WSCRfileSelect,WSCRbaseDialog);
WSMFremoteClassInit(WSCRfileSelect,WSCfileSelect);

WSCRfileSelect::WSCRfileSelect(){
}

WSCRfileSelect::~WSCRfileSelect(){
}

char* WSCRfileSelect::getFileName(){
  if (_local != NULL){
    WSCfileSelect* target = (WSCfileSelect*)_local->cast("WSCfileSelect");
    if (target != NULL){
      return target->getFileName();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCfileSelect");
  rc.setOperationName("getFileName");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }

  char* ret = NULL;
  _db->loadAlloc(WS_DcRString,"ret",(void**)&ret,NULL);
  endRemoteCall();

  if (ret != NULL){
    _fname.setString(ret,WS_EN_UTF8);
    delete ret;
  }
  return _fname.getString();
}


void _WSCfileSelect_remote_call(WSDserialize* db,WSCremoteCall* rc){
  if ( rc->_op[0] == 'g'){
    if (!strcmp(rc->_op,"getFileName")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      if (inst != NULL){
        WSCfileSelect* target = (WSCfileSelect*)inst->cast("WSCfileSelect");
        WSCstring ret;
        if (target != NULL){
          ret = target->getFileName();
        }
        char* ptr = ret.getString(WS_EN_UTF8);
        db->save(WS_DcRString,"ret",(void*)ptr);
      }else{
        char* ptr = "";
        db->save(WS_DcRString,"ret",(void*)ptr);
      }
      return;
    }
  }

extern void _WSCbaseDialog_remote_call(WSDserialize* db,WSCremoteCall* rc);
  _WSCbaseDialog_remote_call(db,rc);
}

WSMFdefineDrNetServer(WSCfileSelect,_WSCfileSelect_remote_call);

