//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCRvtoggle.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSCvtoggle.h>

WSMFclassInit(WSCRvtoggle,WSCRvlabel);
WSMFremoteClassInit(WSCRvtoggle,WSCvtoggle);

WSCRvtoggle::WSCRvtoggle(){
}

WSCRvtoggle::~WSCRvtoggle(){
}

void WSCRvtoggle::onValueChange(WSCbool fl){
  if (_local != NULL){
    WSCvtoggle* item = (WSCvtoggle*)_local->cast("WSCvtoggle");
    if (item != NULL){
      item->onValueChange(fl);
      return;
    }
  }
  WSCremoteCall rc;
  rc.setClassName("WSCvtoggle");
  rc.setOperationName("onValueChange");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return;
  } 
  _db->save(WS_DcRChar,"fl",(void*)&fl);
  endRemoteCall();
}

long WSCRvtoggle::setStatus(WSCbool state,WSCbool create_ev){
  if (_local != NULL){
    WSCvtoggle* target = (WSCvtoggle*)_local->cast("WSCvtoggle");
    if (target != NULL){
      return target->setStatus(state,create_ev);
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCvtoggle");
  rc.setOperationName("getNum");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  _db->save(WS_DcRChar,"st",(void*)&state);
  _db->save(WS_DcRChar,"ev",(void*)&create_ev);
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
WSCbool WSCRvtoggle::getStatus(){
  if (_local != NULL){
    WSCvtoggle* target = (WSCvtoggle*)_local->cast("WSCvtoggle");
    if (target != NULL){
      return target->getStatus();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCvtoggle");
  rc.setOperationName("getStatus");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  WSCbool ret = False;
  _db->load(WS_DcRChar,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}
long WSCRvtoggle::getGroupValue(){
  if (_local != NULL){
    WSCvtoggle* target = (WSCvtoggle*)_local->cast("WSCvtoggle");
    if (target != NULL){
      return target->getGroupValue();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCvtoggle");
  rc.setOperationName("getGroupValue");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

long WSCRvtoggle::setGroupValue(long val){
  if (_local != NULL){
    WSCvtoggle* target = (WSCvtoggle*)_local->cast("WSCvtoggle");
    if (target != NULL){
      return target->setGroupValue(val);
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCvtoggle");
  rc.setOperationName("setGroupValue");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  _db->save(WS_DcRLong,"val",(void*)&val);
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}

long WSCRvtoggle::clearGroupValue(){
  if (_local != NULL){
    WSCvtoggle* target = (WSCvtoggle*)_local->cast("WSCvtoggle");
    if (target != NULL){
      return target->clearGroupValue();
    }
  }

  WSCremoteCall rc;
  rc.setClassName("WSCvtoggle");
  rc.setOperationName("clearGroupValue");
  beginRemoteCall(&rc);
  if (_db == NULL){
    return 0;
  }
  long ret;
  _db->load(WS_DcRLong,"ret",(void*)&ret);
  endRemoteCall();
  return ret;
}






void _WSCvtoggle_remote_call(WSDserialize* db,WSCremoteCall* rc){
//printf("WSCvtoggle_remote_call ...\n");
  if ( rc->_op[0] == 'o'){
    if (!strcmp(rc->_op,"onValueChange")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      WSCbool fl = 0;
      db->load(WS_DcRChar,"fl",(void*)&fl);
      if (inst != NULL){
        WSCvtoggle* item = (WSCvtoggle*)inst->cast("WSCvtoggle");
        if (item != NULL){
          item->onValueChange(fl);
        }
      }
      return;
    }
  }else
  if ( rc->_op[0] == 's'){
    if (!strcmp(rc->_op,"setStatus")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      WSCbool status = 0;
      db->load(WS_DcRChar,"st",(void*)&status);
      WSCbool cr_ev = 0;
      db->load(WS_DcRChar,"ev",(void*)&cr_ev);
      long ret = 0;
      if (inst != NULL){
        WSCvtoggle* item = (WSCvtoggle*)inst->cast("WSCvtoggle");
        if (item != NULL){
          ret = item->setStatus(status,cr_ev);
        }
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
      return;
    }else
    if (!strcmp(rc->_op,"setGroupValue")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long val = 0;
      db->load(WS_DcRLong,"val",(void*)&val);
      long ret = 0;
      if (inst != NULL){
        WSCvtoggle* item = (WSCvtoggle*)inst->cast("WSCvtoggle");
        if (item != NULL){
          ret = item->setGroupValue(val);
        }
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
      return;
    }



  }else
  if ( rc->_op[0] == 'g'){
    if (!strcmp(rc->_op,"getStatus")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      WSCbool ret = 0;
      if (inst != NULL){
        WSCvtoggle* item = (WSCvtoggle*)inst->cast("WSCvtoggle");
        if (item != NULL){
          ret = item->getStatus();
        }
      }
      db->save(WS_DcRChar,"ret",(void*)&ret);
      return;
    }else
    if (!strcmp(rc->_op,"getGroupValue")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = 0;
      if (inst != NULL){
        WSCvtoggle* item = (WSCvtoggle*)inst->cast("WSCvtoggle");
        if (item != NULL){
          ret = item->getGroupValue();
        }
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
      return;
    }
  }else
  if ( rc->_op[0] == 'c'){
    if (!strcmp(rc->_op,"clearGroupValue")){
      WSCbase* inst = WSGIappObjectList()->getInstance(rc->_class,rc->_instance);
      long ret = 0;
      if (inst != NULL){
        WSCvtoggle* item = (WSCvtoggle*)inst->cast("WSCvtoggle");
        if (item != NULL){
          ret = item->clearGroupValue();
        }
      }
      db->save(WS_DcRLong,"ret",(void*)&ret);
      return;
    }
  }


extern void _WSCvlabel_remote_call(WSDserialize* db,WSCremoteCall* rc);
  _WSCvlabel_remote_call(db,rc);
}

WSMFdefineDrNetServer(WSCvtoggle,_WSCvtoggle_remote_call);

