//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCfontSet.h>
#include <nx/WSDnxFont.h>
#include <nx/WSDnxAppDev.h>
#include <WSClocaleSet.h>

#define DEFAULT_FONT_SET  "14 60c6 "

char* dfnames[] = { 
"0 14 name1 ", //No. size code
"1 16 name2 ",
"2 18 name3 ",
"3 20 name4 ",
"4 22 name5 ",
"5 24 name6 ",
"6 24 name7 ",
"7 24 name8 ",
"8 14 name9 ",
NULL
};

WSMFclassInit(WSDnxFont,WSDfont);
WSDfont* _nxFont_chandler(){
  WSDfont* font = new WSDnxFont();
  return font;
};
long _nxFont_setup_handler(WSDfont* font,char* str){
  char str1[128];
  char fname[256];
  str1[0] = 0;
  fname[0] = 0;
  long no;
  long fno;
  sscanf(str,"%d %s %x",&no,str1,&fno);
  sprintf(fname,"%s %x",str1,fno);
  font->setFontName(fname);
  font->setId((short)no);
  return WS_NO_ERR;
};

long _nxFont_default_init_handler(WSCfontSet* fontset){
  long i=0;
  char** _dfnames = dfnames;
//  if (!strcmp(WSGIappLocaleSet()->getDefaultLocaleName(),WS_LOCALE_JAPANESE)){
//    _dfnames = dfnames_j;
//  } 
 
  while(_dfnames[i]){
    WSDfont* font = new WSDnxFont();
    _nxFont_setup_handler(font,_dfnames[i]);
    fontset->addFont(font);
    i++;
  }
  return WS_NO_ERR;
};

void _nxFont_init(){
  WSGIappFontSet()->setCreateHandler(_nxFont_chandler);
  WSGIappFontSet()->setSetupHandler(_nxFont_setup_handler);
  WSGIappFontSet()->setDefaultInitializeHandler(_nxFont_default_init_handler);
  WSGIappFontSet()->initializeDefault();
};



WSDnxFont::WSDnxFont(){
}

WSDnxFont::~WSDnxFont(){
  destroy();
}

long WSDnxFont::initialize(){
  char* fname = getSrc();
  _font_height = 14;
  char buffer[1024];
  sscanf(fname,"%d %s ",&_font_height,buffer);

  // TODO create font resource from font data..
  setValue1((long)0);
  setValue2((long)0);
  setValue3((long)0);

  return WS_NO_ERR;
}
long WSDnxFont::destroy(){
  // TODO destroy font resource..
  return WS_NO_ERR;
}
long WSDnxFont::getStringWidthUCS2(WSCushort* str){
  char* cstr = WSGFgetString(str,WS_EN_UTF8);
  if (cstr == NULL){
    return 0;
  }
  WSCstring s;
  s.setString(cstr,WS_EN_UTF8);
  delete cstr;
  return getStringWidth(&s);
}
long WSDnxFont::getStringHeightUCS2(WSCushort* str){
  getValue1();
  return  _font_height;
}
long WSDnxFont::getStringWidth(WSCstring* str){
  char* tstr = str->getString(WS_EN_UTF8);
  // TODO get string width..
  long width = 0;
  return width;
}
long WSDnxFont::getStringHeight(WSCstring*){
  getValue1();
  return  _font_height;
}
