//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <win/WSDwinCodeConvert.h>
#include <WSDenv.h>
#include <xunicode.h>

WSDcodeConvert* _code_convert_create_handler_(){
  return new WSDwinCodeConvert;
}

int WSDwinCodeConvert::codeConvert(char* str,int max,int codeto,const char* src,int len,int codefrom){
  return XUCodeConv(str,max,codeto,src,len,codefrom);
}
int WSDwinCodeConvert::getSystemEncoding(){
extern int XUGetLocale();
  return XUGetLocale();
}
void WSDwinCodeConvert::initialize(){
  XUInit();
extern char* XUGetLang();
  setSystemLocaleName(XUGetLang(),getSystemEncoding());
}
int WSDwinCodeConvert::utf8CharLen(const char* str,int max){
  return XUutf8CharLen(str,max); 
}
int WSDwinCodeConvert::encode(WSCushort* str,int max,const char* src,int len,int code){
  return XUEncode((XUChar*)str,max,src,len,code);
}
int WSDwinCodeConvert::decode(char* str,int max,const WSCushort* src,int len,int code){
  return XUDecode(str,max,(XUChar*)src,len,code);
}

