//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <win/WSwincom.h>
#include <WSCstring.h>
#include <WSClocaleSet.h>
#ifdef _WSWINCE
#define strdup _strdup
#endif

#ifndef WS_NWIN
extern "C" {
void libwswin_func();
};
void libwswin_func(){
}
#else
extern "C" {
void libwsnwin_func();
};
void libwsnwin_func(){
}
#endif

int _system(char* cmdname){
  int len = strlen(cmdname);
  char* str = strdup(cmdname);
  STARTUPINFO si;
  PROCESS_INFORMATION pi;
  ZeroMemory(&si,sizeof(STARTUPINFO));
  ZeroMemory(&pi,sizeof(PROCESS_INFORMATION));
  si.cb = sizeof(STARTUPINFO);
#ifndef _WSWINCE
  si.dwFlags = STARTF_USESHOWWINDOW;
#else
  si.dwFlags = 0;
#endif
  si.wShowWindow = SW_SHOWNORMAL;
  if (str[len-1] == '&'){
    str[len-1] = ' ';
    WSCstring tmp(str);
    tmp.delHeadSpace();
    tmp.delTailSpace();
WSMFtrace("_system #%s#\n",(char*)tmp);
//    CreateProcess(NULL,(char*)tmp,NULL,NULL,FALSE,DETACHED_PROCESS,NULL,NULL,&si,&pi);
#ifndef _WSWINCE
    CreateProcess(NULL,
       tmp.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
       NULL,NULL,FALSE,0,NULL,NULL,&si,&pi);
#else
    WSCushort* tmpstr = WSGFgetUCS2(tmp,WS_EN_DEFAULT);
    CreateProcess(NULL,tmpstr,
       NULL,NULL,FALSE,0,NULL,NULL,&si,&pi);
    delete tmpstr;
#endif
    free(str);
    if (pi.hProcess == 0){
      return -1;
    }
    return 0;
  }else{
WSMFtrace("_system #%s#\n",(char*)str);
//    CreateProcess(NULL,str,NULL,NULL,FALSE,DETACHED_PROCESS,NULL,NULL,&si,&pi);
    WSCstring tmp(str);
    tmp.delHeadSpace();
    tmp.delTailSpace();
#ifndef _WSWINCE
    CreateProcess(NULL,
       tmp.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
       NULL,NULL,FALSE,0,NULL,NULL,&si,&pi);
#else
    WSCushort* tmpstr = WSGFgetUCS2(tmp,WS_EN_DEFAULT);
    CreateProcess(NULL,tmpstr,
       NULL,NULL,FALSE,0,NULL,NULL,&si,&pi);
#endif
    free(str);
    if (pi.hProcess == 0){
WSMFtrace("_system error\n");
      return -1;
    }
#ifndef _WSWINCE
    WaitForInputIdle(pi.hProcess,INFINITE);
#endif
//    WaitForInputIdle(GetCurrentProcess(),5000);
    DWORD ret = STILL_ACTIVE;
    while(ret == STILL_ACTIVE){
      WaitForSingleObject(pi.hProcess,1000);
      GetExitCodeProcess(pi.hProcess,&ret);
    } 
    return ret;
  }
}
int _system_console(char* cmdname){
  int len = strlen(cmdname);
  char* str = strdup(cmdname);
  STARTUPINFO si;
  PROCESS_INFORMATION pi;
  ZeroMemory(&si,sizeof(STARTUPINFO));
  ZeroMemory(&pi,sizeof(PROCESS_INFORMATION));
  si.cb = sizeof(STARTUPINFO);
#ifndef _WSWINCE
  si.dwFlags = STARTF_USESHOWWINDOW;
#else
  si.dwFlags = 0;
#endif
  si.wShowWindow = SW_SHOWNORMAL;
  if (str[len-1] == '&'){
    str[len-1] = ' ';
    WSCstring tmp(str);
    tmp.delHeadSpace();
    tmp.delTailSpace();
WSMFtrace("_system #%s#\n",(char*)tmp);
#ifndef _WSWINCE
    CreateProcess(NULL,(char*)tmp,NULL,NULL,FALSE,CREATE_NEW_CONSOLE,NULL,NULL,&si,&pi);
#else
    WSCushort* tmpstr = WSGFgetUCS2(tmp,WS_EN_DEFAULT);
    CreateProcess(NULL,tmpstr,NULL,NULL,FALSE,CREATE_NEW_CONSOLE,NULL,NULL,&si,&pi);
    delete tmpstr;
#endif
    free(str);
    if (pi.hProcess == 0){
      return -1;
    }
    return 0;
  }else{
#ifndef _WSWINCE
    CreateProcess(NULL,str,NULL,NULL,FALSE,CREATE_NEW_CONSOLE,NULL,NULL,&si,&pi);
#else
    WSCushort* tmpstr = WSGFgetUCS2(str,WS_EN_DEFAULT);
    CreateProcess(NULL,tmpstr,NULL,NULL,FALSE,CREATE_NEW_CONSOLE,NULL,NULL,&si,&pi);
    delete tmpstr;
#endif
    free(str);
    if (pi.hProcess == 0){
      return -1;
    }
#ifndef _WSWINCE
    WaitForInputIdle(pi.hProcess,INFINITE);
#endif
//    WaitForInputIdle(GetCurrentProcess(),5000);
    DWORD ret = STILL_ACTIVE;
    while(ret == STILL_ACTIVE){
      WaitForSingleObject(pi.hProcess,1000);
      GetExitCodeProcess(pi.hProcess,&ret);
    } 
    return ret;
  }
}
