//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCwizardDialog.h>
#include <WSCvifield.h>
#include <WSCform.h>
#include <WSCvtoggle.h>
#include <WSCcomboBox.h>
#include <WSCvbtn.h>
#include <WSCfileSelect.h>
#include <WSCmessageDialog.h>

extern WSCmessageDialog* message;

extern WSCwizardDialog* searchwz;
WSCvifield* schif1;
WSCcomboBox* schif2;
WSCvifield* schif3;

static void visop(WSCbase*){
  if (searchwz->getVisible() != False){
    searchwz->setPropertyV(WSNvalue,(WSCuchar)0);
    schif1->setPropertyV(WSNlabelString,".");
    schif2->setPropertyV(WSNlabelString,"*.cpp");
    schif3->setPropertyV(WSNlabelString,"");
  }else{
    if (searchwz->getStatus() == WS_DIALOG_DONE){
//    do something...
    }
  }
}
static void _fsop(WSCbase*){
  WSCfileSelect* fs = WSGIappFileSelect();
  fs->setProperty(WSNselectDir,True);
  fs->setProperty(WSNmaskFileName,"");
  fs->setProperty(WSNfileName,".");
  long ret = fs->popup();
  fs->setProperty(WSNselectDir,False);
  if (ret == WS_DIALOG_OK){
    schif1->setProperty(WSNlabelString,fs->getProperty(WSNfileName));
  }

}
void create_searchwz_dialog(){

  searchwz = new WSCwizardDialog(NULL,"searchwz");
  searchwz->initialize();
  WSGFsetGeometry(searchwz,300,300,430,140);
  searchwz->setPropertyV(WSNtitleString,WSGFgettext("v4:WSSTR Find files"));
  searchwz->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/search3.xpm");
  searchwz->setPropertyV(WSNlabelString,WSGFgettext("w4:WSSTR < Back,Find, Find"));
  searchwz->setPropertyV(WSNmenuItems,(WSCuchar)1);
  WSCprocedure* op1 = new WSCprocedure("visop",WSEV_VISIBLE_CH);
  op1->setFunction(visop,"visop");
  searchwz->addProcedure(op1);

  WSCvlabel* sp1 = new WSCvlabel(searchwz,"sp1");
  sp1->initialize();
  WSGFsetGeometry(sp1,0,5,1280,2);
  sp1->setPropertyV(WSNuserValue,(long)1);
  sp1->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  sp1->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  sp1->setVisible(True);



  WSCvlabel* lb11 = new WSCvlabel(searchwz,"lb11");
  lb11->initialize();
  WSGFsetGeometry(lb11,5,12,120,20);
  lb11->setPropertyV(WSNlabelString,WSGFgettext("x4:WSSTR Dir:"));
  lb11->setPropertyV(WSNuserValue,(long)1);
  WSGFsetMargin(lb11,0);
  lb11->setVisible(True); 

  schif1 = new  WSCvifield(searchwz,"nmif1");
  schif1->initialize();
  schif1->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  schif1->setPropertyV(WSNshadowType,(char)1);
  schif1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  schif1->setPropertyV(WSNmaxLength,(WSCushort)0);
  schif1->setPropertyV(WSNuserValue,(long)1);
  WSGFsetGeometry(schif1,130,12,260,20);

  WSCvbtn* bt1 = new  WSCvbtn(searchwz,"nmif1");
  bt1->initialize();
  bt1->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  bt1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  bt1->setPropertyV(WSNlabelString,"..");
  bt1->setPropertyV(WSNuserValue,(long)1);
  WSGFsetGeometry(bt1,395,12,20,20);

  WSCprocedure* op2 = new WSCprocedure("_fsop",WSEV_ACTIVATE);
  op2->setFunction(_fsop,"_fsop");
  bt1->addProcedure(op2);

  WSCvlabel* lb12 = new WSCvlabel(searchwz,"lb12");
  lb12->initialize();
  WSGFsetGeometry(lb12,5,37,120,20);
  lb12->setPropertyV(WSNlabelString,WSGFgettext("y4:WSSTR File type:"));
  lb12->setPropertyV(WSNuserValue,(long)1);
  WSGFsetMargin(lb12,0);
  lb12->setVisible(True); 

  schif2 = new  WSCcomboBox(searchwz,"nmif2");
  schif2->initialize();
  schif2->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  schif2->setPropertyV(WSNshadowType,(char)1);
  schif2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  schif2->setPropertyV(WSNmaxLength,(WSCushort)0);
  schif2->setPropertyV(WSNmenuItems,"*.cpp,*.h,*.win,*.txt,*");
  schif2->setPropertyV(WSNuserValue,(long)1);
  WSGFsetGeometry(schif2,130,37,260,20);

  WSCvlabel* lb21 = new WSCvlabel(searchwz,"lb21");
  lb21->initialize();
  WSGFsetGeometry(lb21,5,63,120,20);
  lb21->setPropertyV(WSNlabelString,WSGFgettext("z4:WSSTR Keyword:"));
  lb21->setPropertyV(WSNuserValue,(long)1);
  WSGFsetMargin(lb21,0);
  lb21->setVisible(True);

  schif3 = new  WSCvifield(searchwz,"nmif2");
  schif3->initialize();
  schif3->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  schif3->setPropertyV(WSNshadowType,(char)1);
  schif3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  schif3->setPropertyV(WSNmaxLength,(WSCushort)0);
  schif3->setPropertyV(WSNuserValue,(long)1);
  WSGFsetGeometry(schif3,130,63,260,20);

}

