//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <x11/WSDxprivateTimer.h>
#include <x11/WSDxappDev.h>

WSMFclassInit(WSDxprivateTimer,WSDprivateTimer);

WSDprivateTimer* _xprivatetimer_create(){
  return new WSDxprivateTimer;
}

class _xprivatetimer_init {
  public: _xprivatetimer_init(){
    WSDprivateTimer::setCreateInstanceHandler((void*)_xprivatetimer_create);
  };
};

_xprivatetimer_init  _xprivatetimer_init_execute;


WSDxprivateTimer::WSDxprivateTimer(){
  _interval_id =0;
}
WSDxprivateTimer::~WSDxprivateTimer(){
  stopTimer();
}

void WSDxprivateTimer::startTimer(){
  _timer_on = True;
  _timer_set();
}

void WSDxprivateTimer::stopTimer(){
  _timer_on = False;
  if (_interval_id != 0){
    XtRemoveTimeOut(_interval_id);
    _interval_id = 0;
  }
}

void WSDxprivateTimer::_timer_set(){
  _interval_id = XtAppAddTimeOut(WSGIxwinAppDev()->appContext(),_timer_rate,
      (XtTimerCallbackProc)_timer_callback,this);
  if ( _interval_id ==  0 ) {
WSMFtrace("Error. WSDxprivateTimer is no effective...\n");
  }
}
void WSDxprivateTimer::_timer_callback(XtPointer ptr,XtIntervalId) {
    WSDxprivateTimer* obj = (WSDxprivateTimer*)ptr;
    obj->_interval_id = 0;
    if (obj->_work_proc != NULL){
      obj->_work_proc(obj->_data);
    }
    if (obj->_cont != False && obj->_timer_on == True){
      obj->_timer_set();
    }else{
      obj->_timer_on = False;
    }
    return;
}
