//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <x11/WSDxappDev.h>
#include <x11/WSDxtimer.h>

WSMFclassInit(WSDxtimer,WSDtimer);

//250 ms 
#define _WS_INTERVAL_     250

WSDtimer* _xtimer_create_handler(){
  return new WSDxtimer();
}

class _xtimer_init{
  public: _xtimer_init(){
    WSDtimer::setCreateInstanceHandler(_xtimer_create_handler);
  };
};

_xtimer_init _xtimer_init_run_constructor;


WSDxtimer::WSDxtimer(){
  _interval_id =0;
  _timer_set();
}
WSDxtimer::~WSDxtimer(){
  if (_interval_id != 0){
    XtRemoveTimeOut(_interval_id);
    _interval_id = 0;
  }
}


void WSDxtimer::_timer_set(){
  _interval_id = XtAppAddTimeOut(WSGIxwinAppDev()->appContext(),_WS_INTERVAL_,
      (XtTimerCallbackProc)_timer_callback,this);
  if ( _interval_id ==  0 ) {
WSMFtrace("Error. WSDxtimer is down.\n");
  }
}

void WSDxtimer::_timer_callback(XtPointer ptr,XtIntervalId) {
    WSDxtimer* obj = (WSDxtimer*)ptr;
    obj->_clock++;
    long i;
    long num = obj->_cproc_list.getNum();

//WSMFtrace("WSDxtimer::_timer_callback timer procs=%d\n",num);
    //execute the timer processes...
    for(i = 0; i < num; i++){
      timerProcRec* proc = (timerProcRec*)obj->_cproc_list.getData(i);
//WSMFtrace("WSDxtimer::_timer_callback clock=%d  proc rate=%d  tm=%d\n",obj->_clock,proc->rate,proc->fclock);
      if ( ( obj->_clock % proc->rate) == proc->fclock ){
//WSMFtrace("WSDxtimer::_timer_callback exec procs=0x%x\n",proc);
dbprintf("WSDxtimer::_timer_callback %s:%d timer proc start\n",__FILE__,__LINE__);
        proc->proc(obj->_clock,proc->data);
dbprintf("WSDxtimer::_timer_callback %s:%d timer proc done.\n",__FILE__,__LINE__);
      }
    }

    num = obj->_proc_list.getNum();
    //execute the trigger processes...
    for(i = 0; i < num; i++){
      triggerProcRec* proc = (triggerProcRec*)obj->_proc_list.getData(i);
      if (( obj->_clock % proc->rate) == proc->fclock ){
        //delete this executed process from the process list
        obj->_proc_list.del(proc); 
        num = obj->_proc_list.getNum();
        i--;
dbprintf("WSDxtimer::_timer_callback %s:%d trigger proc start\n",__FILE__,__LINE__);

        proc->proc(obj->_clock,proc->data);
dbprintf("WSDxtimer::_timer_callback %s:%d trigger proc done.\n",__FILE__,__LINE__);
        proc->executed = False;
        delete proc;
      }
    }
    obj->_timer_set();
    return;
}
