//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE. 
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#ifndef WSCBALLOONHELP_H
#define WSCBALLOONHELP_H

#include <WScom.h>
#include <WSCwindow.h>

class WSCvlabel;

#define WSCballoonHelp_VER  1000

class WSCballoonHelp :public WSCwindow{

  protected:
    WSClistData _client_list;
    WSCvlabel* _bh_label;
    char* _bh_label_string;
    unsigned _font:4;

    WSMFpropertyDef(WSNfont, WSCuchar, _font); 
    WSMFpropertyDef(WSNlabelString, char*, _bh_label_string); 

    WSDLEX32 virtual long _adjust();
    WSDLEX32 virtual long _device_initialize();

    WSDLEX32 static void _balloon_help_popup(WSCbase*);
    WSDLEX32 static void _balloon_help_popdown(WSCbase*);
    WSDLEX32 static void _balloon_help_unregister(WSCbase*);

  public:
    WSDLEX32 WSCballoonHelp(WSCbase*,char*);
    WSDLEX32 virtual ~WSCballoonHelp();
    WSDLEX32 virtual long initialize();

    WSDLEX32 void popup(char*,short x,short y);
    WSDLEX32 void popdown();
    WSDLEX32 void setString(char*);
    WSDLEX32 long registerClient(WSCbase*,char*);
    WSDLEX32 long unregisterClient(WSCbase*);

    WSMFguiClassDef(WSCballoonHelp,WSCwindow);
    WSMFversionDef(WSCballoonHelp);
};

extern WSDLEX WSCballoonHelp* WSGIappBalloonHelp();
#endif //WSCBALLOONHELP_H
