//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCCOMBOBOX_H
#define WSCCOMBOBOX_H

#include <WScom.h>
#include <WSCform.h>
#define WSCcomboBox_VER  1000

class WSCwindow;
class WSClist;
class WSCvarrow;
class WSCvifield;

class WSCcomboBox  :public WSCform{

  protected:
    WSCwindow* _win;
    WSClist*   _list;
    WSCvarrow*  _btn;
    WSCvifield* _if;
    char* _menu_str;
    char* _label_string;
    char*     _upname;
    char*     _dwname;
    char*     _lname;
    char*     _rname;
    char*     _rtname;
    char*     _tbname;
    char*     _btbname;
    long      _cur_pos;
    WSCushort _columns;
    short _label_pixmap;
    short _blink_pixmap;
    WSCushort _max_length;
    WSCushort _max_height;
    short     _bg_blink_color;
    short     _work_back_color;
    short     _item_height;
    unsigned  _margin_top:4;
    unsigned  _margin_bottom:4;
    unsigned  _margin_left:4;
    unsigned  _margin_right:4;
    unsigned  _font:4;
    unsigned  _alignment_v:3;
    unsigned  _rv_fl:1;
    unsigned  _bl_type:2;
    unsigned  _alignment_h:2;
    unsigned  _bit_map:1;
    unsigned  _use_pix:1;
    unsigned  _emboss:1;
    unsigned  _kanji_in:1;
    unsigned  _icursor:1;
    unsigned  _enable_focus_move:1;
    unsigned  _fspace:1;
    unsigned  _cursor_adjust:1;
    unsigned  _skip_mode:1;
    unsigned  _enable_input:1;


    WSMFpropertyDef( WSNmenuItems, char*, _menu_str);
    WSMFpropertyDef( WSNmaxHeight, WSCushort, _max_height);

    WSMFpropertyDef(WSNbackBlinkColor,  short,     _bg_blink_color);
    WSMFpropertyDef(WSNworkBackColor,   short,     _work_back_color);
    WSMFpropertyDef(WSNreverseFlag,     WSCbool,   _rv_fl);
    WSMFpropertyDef(WSNblinkType,       WSCuchar,  _bl_type);
    WSMFpropertyDef(WSNemboss,          WSCbool,   _emboss);
    WSMFpropertyDef(WSNusePixmap,       WSCuchar,  _use_pix);
    WSMFpropertyDef(WSNlabelString,  char*,      _label_string );
    WSMFpropertyDef(WSNalignmentH,   WSCuchar,   _alignment_h  );
    WSMFpropertyDef(WSNalignmentV,   WSCuchar,   _alignment_v  );
    WSMFpropertyDef(WSNmarginTop,    WSCuchar,   _margin_top   );
    WSMFpropertyDef(WSNmarginBottom, WSCuchar,   _margin_bottom);
    WSMFpropertyDef(WSNmarginLeft,   WSCuchar,   _margin_left  );
    WSMFpropertyDef(WSNmarginRight,  WSCuchar,   _margin_right );
    WSMFpropertyDef(WSNmaxLength,    WSCushort,  _max_length   );
    WSMFpropertyDef(WSNfont,         WSCuchar,   _font         );
    WSMFpropertyDef(WSNlabelPixmap,  short,      _label_pixmap );
    WSMFpropertyDef(WSNblinkPixmap,  short,      _blink_pixmap );

    WSMFpropertyDef(WSNcolumns,     WSCushort, _columns);
    WSMFpropertyDef(WSNcursorPos,   short,    _cur_pos);
    WSMFpropertyDef(WSNkanjiIn,     WSCbool,  _kanji_in);
    WSMFpropertyDef(WSNinterCur,    WSCbool,  _icursor);
    WSMFpropertyDef(WSNenableFocusMove,  WSCbool, _enable_focus_move );
    WSMFpropertyDef(WSNupward,    char*,   _upname);
    WSMFpropertyDef(WSNdownward, char*,   _dwname);
    WSMFpropertyDef(WSNleftward,   char*,   _lname);
    WSMFpropertyDef(WSNrightward,  char*,   _rname);
    WSMFpropertyDef(WSNreturn,     char*,   _rtname);
    WSMFpropertyDef(WSNtab,     char*,   _tbname);
    WSMFpropertyDef(WSNbacktab,     char*,   _btbname);
    WSMFpropertyDef(WSNfillSpace,   WSCbool,      _fspace);
    WSMFpropertyDef(WSNcursorAdjust,WSCbool,      _cursor_adjust);
    WSMFpropertyDef(WSNifieldSkipMode,   WSCbool, _skip_mode);
    WSMFpropertyDef(WSNitemHeight,         WSCuchar,   _item_height     );
    WSMFpropertyDef(WSNenableInput,  WSCbool, _enable_input);
 
    WSDLEX32 virtual void setWorkWSNdet(WSCbool);
    WSDLEX32 virtual void setWorkWSNwidth(WSCushort);
    WSDLEX32 virtual void setWorkWSNheight(WSCushort);
    WSDLEX32 virtual void setWorkWSNshadowType(char);
    WSDLEX32 virtual void setWorkWSNbackColor(short);
    WSDLEX32 virtual void setWorkWSNforeColor(short);
    WSDLEX32 virtual void setWorkWSNtopShadowColor(short);
    WSDLEX32 virtual void setWorkWSNbottomShadowColor(short);
    WSDLEX32 virtual void setWorkWSNshadowThickness(WSCuchar);

    WSDLEX32 long _menu_popup();
    WSDLEX32 long _menu_popdown();
    WSDLEX32 void _adjust();


    WSDLEX32 static void _modal_proc(WSDdev*);
    WSDLEX32 virtual long _device_initialize(); 
    WSDLEX32 static void _list_work(WSCbase*);
    WSDLEX32 static void _list_ptr_work(WSCbase*);
    WSDLEX32 static void _list_timer_work(void*);
    WSDLEX32 static void _btn_work(WSCbase*);
    WSDLEX32 static void _key_press_work(WSCbase*);
    WSDLEX32 static void _key_release_work(WSCbase*);
    WSDLEX32 static void _key_hook_work(WSCbase*);
    WSDLEX32 static void _value_ch_work(WSCbase*);
    
  public:
    WSDLEX32 WSCcomboBox(WSCbase*,char*);
    WSDLEX32 virtual ~WSCcomboBox();

    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onFocusChange(WSCbool);

    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual char* getDefaultProperty();

    WSMFguiClassDef(WSCcomboBox,WSCform);
    WSMFversionDef(WSCcomboBox);
};

#endif
