//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCIMAGESET_H
#define WSCIMAGESET_H

#include <WScom.h>
#include <WSDimage.h>
#include <WSClistData.h>
#include <WSCindexData.h>

class WSCimageSet{

 protected:
   WSDimage*  _cache_table[WS_MAX_HASH_VALUE];
   WSDimage*  _cache_table2[WS_MAX_HASH_VALUE];
   WSClistData _image_list;
   WSDimage* (*_create_handler)();
   WSCushort  _image_num;
   WSCindexData _default_image_handles;
 public:
   WSDLEX32 WSCimageSet();
   WSDLEX32 virtual ~WSCimageSet();
   WSDLEX32 long  setCreateHandler(WSDimage* (*)());

   WSDLEX32 short     getImageNo(char* iname);
   WSDLEX32 WSDimage* getImage(short);
   WSDLEX32 WSDimage* getImage(char* iname);
   WSDLEX32 char*     getImageName(short);
   WSDLEX32 long  setDefaultImageHandle(char* iname,void*);
   WSDLEX32 void* getDefaultImageHandle(char* iname);

   WSDLEX32 long destroyImage(short);
   WSDLEX32 long destroyImage(char* iname);
   WSDLEX32 long update(char* iname);
   WSDLEX32 long destroyAllImage();
};
extern WSDLEX WSCimageSet*  WSGIappImageSet();
extern WSDLEX short WSGFimage(char*);
extern WSDLEX char* WSGFimageName(short);
#endif
