//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCOPENGLFORM_H
#define WSCOPENGLFORM_H

//#define GL_GLEXT_LEGACY

#include <WScom.h>
#include <WSCform.h>

#define WSCopenglForm_VER  1000

#ifdef MSW
#ifndef _WINGDI_
#define _WINGDI_
#endif  //_WINGDI_
#endif

class WSCopenglForm   :public WSCform{

  protected:
    void*  _opengl_context;
    WSCbool _double_buffer;
    unsigned  _begin_draw_fl:1;
    unsigned  _context_created_fl:1;

//    virtual long _device_initialize();
    WSDLEX32 void _delete_context();
    long (*_create_context_handler)();
    WSDLEX32 long _default_create_context();
    WSDLEX32 long _create_context();

    long (*_update_context_handler)();
    WSDLEX32 long _default_update_context();
    WSDLEX32 long _update_context();
  public:

    WSDLEX32 WSCopenglForm(WSCbase* base, char* name);

    WSDLEX32 virtual ~WSCopenglForm();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual void update();
    WSDLEX32 virtual long execEventProc(long,void*);

    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onResize(WSCrect*);
    WSDLEX32 void* getOpenGLContext();

    WSDLEX32 virtual long beginDraw();
    WSDLEX32 virtual long endDraw();

    WSDLEX32 void setCreateContextHandler(long(*hd)());
    WSDLEX32 void setUpdateContextHandler(long(*hd)());
    WSDLEX32 void makeCurrent();
    WSDLEX32 void noMakeCurrent();

    WSMFguiClassDef(WSCopenglForm,WSCform);
    WSMFversionDef(WSCopenglForm);
};

#endif //WSCOPENGLFORM_H
