//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCPOPUPMENU_H
#define WSCPOPUPMENU_H

#include <WScom.h>
#include <WSCpulldownMenuPopup.h>

class WSCpopupMenu  :public WSCpulldownMenuPopup{

  protected:
    WSClistData   _client_list;
    WSCbase*      _modal_bk;
    void*         _client;
    unsigned      _press_state:1;
    unsigned      _grabed:1;

    WSMFpropertyDef( WSNclient,  void*,          _client );

    WSDLEX32 static void _on_btn_press(WSCbase*);
    WSDLEX32 static void _on_btn_release(WSCbase*);
    WSDLEX32 static void _on_btn_move(WSCbase*);

    WSDLEX32 static void _on_btn_press_recursive(WSCbase*);
    WSDLEX32 static void _on_btn_release_recursive(WSCbase*);
    WSDLEX32 static void _on_btn_move_recursive(WSCbase*);
    WSDLEX32 static void _on_delete(WSCbase*);

    WSDLEX32 long _registerClient(WSCbase*,WSCbool recursive = False);
    WSDLEX32 static WSCpopupMenu* _popuped_instance;

  public:
    WSDLEX32 WSCpopupMenu(WSCbase*,char*);
    WSDLEX32 virtual ~WSCpopupMenu();

    WSDLEX32 virtual void onActivate();

    WSDLEX32 long popup();
    WSDLEX32 long popdown();
    WSDLEX32 long popdownAndExecute();
    WSDLEX32 long registerClient(WSCbase*,WSCbool recursive = False);
    WSDLEX32 long unregisterClient(WSCbase*);
    WSMFguiClassDef(WSCpopupMenu,WSCpulldownMenuPopup);
};
#endif
