//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCSTRING_H
#define WSCSTRING_H
#include <WScom.h>
#include <WSCvariant.h>
#include <WSClistData.h>

#define WS_ASCII 0
#define WS_KANJI 1
#define WS_GAIJI 2
#define WS_HKANA 3

class WSCstring {

  protected:  
    char* _str;
    long _encoding;
    WSClistData _tmp_list;
    WSClistData _tmp_encode;
    long _chars;
    long  _seek_pt;
    WSDLEX32 void _clear_list();
    WSDLEX32 void _add_string_to_list(char*,long);
    WSDLEX32 char* _get_string_from_list(long);
    WSDLEX32 char* _get_utf8_string(char*,long encode);
    WSDLEX32 char* _get_mb_string(char*,long encode);
    WSDLEX32 char* _convert_string(const char*,long from_encode,long to_encode);
    WSDLEX32 long _get_encoding() const;    

  public:
    WSDLEX32 WSCstring();
    WSDLEX32 WSCstring(const char*,long encode = WS_EN_DEFAULT);
    WSDLEX32 WSCstring(WSCstring&);
    WSDLEX32 WSCstring(const WSCstring&);
    WSDLEX32 WSCstring(WSCvariant&,long encode = WS_EN_DEFAULT);
    WSDLEX32 WSCstring(const WSCvariant&,long encode = WS_EN_DEFAULT);
    WSDLEX32 virtual ~WSCstring();

    WSDLEX32 void  setString(const char*,long encode = WS_EN_DEFAULT);
    WSDLEX32 char* getString(long encode = WS_EN_DEFAULT);

    WSDLEX32 long getChars();
    WSDLEX32 long getEncoding();
    WSDLEX32 long setEncoding(long encode);
    WSDLEX32 long    isExist(const char*,long encode = WS_EN_DEFAULT );      //search None -> return -1 , Hit -> return pos

    WSDLEX32 void addString(const WSCstring&);
    WSDLEX32 void addString(const WSCvariant&,long encode = WS_EN_DEFAULT);
    WSDLEX32 void addString(const char*,long encode = WS_EN_DEFAULT);
    WSDLEX32 void cutString(WSCulong char_pos); // char_pos,0=clear,
    WSDLEX32 void insertString(WSCulong char_pos,WSCstring&);
    WSDLEX32 void deleteChar(WSCulong char_pos);             //begin 0, delete a char.
    WSDLEX32 void deleteChars(WSCulong char_pos,WSCulong len);   //begin 0, delete a char.
    WSDLEX32 void clear();
    WSDLEX32 void delLineFeed();
    WSDLEX32 void delString(const char*,long num);
    WSDLEX32 void delString(const char*,long num,long encode);
    WSDLEX32 void delHeadSpace();
    WSDLEX32 void delTailSpace();

    WSDLEX32 void to_upper();    
    WSDLEX32 void to_lower();    
    
    WSDLEX32 long replaceString(const char* srcchar,const char* destchar,long num,long encode = WS_EN_DEFAULT); 
    //num=0 means all of hit words..

    WSDLEX32 long getWords();
    WSDLEX32 long getWords(const char*,long encode = WS_EN_DEFAULT);
    WSDLEX32 long getWordCharPos(long wd); //return bytes. wd > -1
    WSDLEX32 long getWordCharPos(long wd,const char*,long encode = WS_EN_DEFAULT); //ws > -1
    WSDLEX32 WSCstring getWord(long wd); //wd > -1.
    WSDLEX32 WSCstring getWord(long num,const char*,long encode = WS_EN_DEFAULT); //ws > -1

    WSDLEX32 long _seek_next_line();//return getchar of skiped line

    WSDLEX32 long tell();
    WSDLEX32 long seek(long ); //charpos
    WSDLEX32 long seekEnd();
    WSDLEX32 long eof();
    WSDLEX32 long getLines();
    WSDLEX32 WSCstring gets();
    WSDLEX32 WSCstring& operator = (const WSCstring&);
    WSDLEX32 WSCstring& operator = (const char*);
    WSDLEX32 WSCstring& operator = (const WSCvariant&);
    WSDLEX32 operator char*();
    WSDLEX32 operator WSCvariant();
    WSDLEX32 WSCstring operator + (const WSCstring&);
    WSDLEX32 WSCstring operator + (const WSCvariant&);
    WSDLEX32 WSCstring operator + (const char*);
    WSDLEX32 WSCstring& operator += (const WSCstring&);
    WSDLEX32 WSCstring& operator += (const WSCvariant&);
    WSDLEX32 WSCstring& operator += (const char*);
    WSDLEX32 WSCstring& operator << (const WSCstring&);
    WSDLEX32 WSCstring& operator << (const WSCvariant&);
    WSDLEX32 WSCstring& operator << (const char*);
    WSDLEX32 WSCstring& operator << (WSCulong);
    WSDLEX32 WSCstring& operator << (long);
    WSDLEX32 WSCstring& operator << (int);
    WSDLEX32 WSCstring& operator << (WSCuint);
    WSDLEX32 WSCstring& operator << (double);
    WSDLEX32 WSCstring& operator << (float);
    WSDLEX32 long operator == (const WSCstring&);
};
#endif
